/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import java.util.Collections;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.LogoutToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.account.AccountManagement;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.InfinispanTestTimeServiceRule;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;

public class LogoutTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public InfinispanTestTimeServiceRule ispnTestTimeService = new InfinispanTestTimeServiceRule(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountManagement accountManagementPage;
    @Page
    private ErrorPage errorPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
    }

    @Test
    public void logoutRedirect() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        String redirectUri = OAuthClient.APP_AUTH_ROOT + "?logout";
        String logoutUrl = this.oauth.getLogoutUrl().redirectUri(redirectUri).build();
        this.driver.navigate().to(logoutUrl);
        this.events.expectLogout(sessionId).detail("redirect_uri", redirectUri).assertEvent();
        URLAssert.assertCurrentUrlEquals(redirectUri);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId2 = this.events.expectLogin().assertEvent().getSessionId();
        org.junit.Assert.assertNotEquals((Object)sessionId, (Object)sessionId2);
        this.driver.navigate().to(logoutUrl);
        this.events.expectLogout(sessionId2).detail("redirect_uri", redirectUri).assertEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void logoutRedirectWithStarRedirectUriForDirectGrantClient() {
        ClientResource clientRes = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"direct-grant");
        ClientRepresentation clientRepOrig = clientRes.toRepresentation();
        ClientRepresentation clientRep = clientRes.toRepresentation();
        clientRep.setStandardFlowEnabled(Boolean.valueOf(false));
        clientRep.setImplicitFlowEnabled(Boolean.valueOf(false));
        clientRep.setRedirectUris(Collections.singletonList("*"));
        clientRes.update(clientRep);
        try {
            this.loginPage.open();
            this.loginPage.login("test-user@localhost", "password");
            org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
            this.events.expectLogin().assertEvent();
            String invalidRedirectUri = ServerURLs.getAuthServerContextRoot() + "/bar";
            String logoutUrl = this.oauth.getLogoutUrl().redirectUri(invalidRedirectUri).build();
            this.driver.navigate().to(logoutUrl);
            this.events.expectLogoutError("invalid_redirect_uri").assertEvent();
            URLAssert.assertCurrentUrlDoesntStartWith(invalidRedirectUri);
            this.errorPage.assertCurrent();
            Assert.assertEquals((Object)"Invalid redirect uri", (Object)this.errorPage.getError());
        }
        finally {
            clientRes.update(clientRepOrig);
        }
    }

    @Test
    public void logoutSession() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        String logoutUrl = this.oauth.getLogoutUrl().sessionState(sessionId).build();
        this.driver.navigate().to(logoutUrl);
        this.events.expectLogout(sessionId).removeDetail("redirect_uri").assertEvent();
        URLAssert.assertCurrentUrlEquals(logoutUrl);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId2 = this.events.expectLogin().assertEvent().getSessionId();
        org.junit.Assert.assertNotEquals((Object)sessionId, (Object)sessionId2);
    }

    @Test
    public void logoutWithExpiredSession() throws Exception {
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.adminClient.realm("test")).updateWith(r -> r.setSsoSessionMaxLifespan(Integer.valueOf(2)))).update();){
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            this.oauth.clientSessionState("client-session");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            String idTokenString = tokenResponse.getIdToken();
            this.setTimeOffset(9999);
            String logoutUrl = this.oauth.getLogoutUrl().redirectUri(OAuthClient.APP_AUTH_ROOT).idTokenHint(idTokenString).build();
            this.driver.navigate().to(logoutUrl);
            this.appPage.assertCurrent();
            this.driver.navigate().to(this.oauth.getLoginFormUrl());
            WaitUtils.waitForPageToLoad();
            this.loginPage.assertCurrent();
        }
    }

    @Test
    public void logoutMultipleSessions() throws IOException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        this.oauth.openLoginForm();
        this.events.expectLogin().session(sessionId).removeDetail("username").assertEvent();
        this.driver.navigate().to(this.oauth.getLogoutUrl().redirectUri(OAuthClient.APP_AUTH_ROOT).build());
        this.events.expectLogout(sessionId).detail("redirect_uri", OAuthClient.APP_AUTH_ROOT).assertEvent();
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.oauth.doLogin("test-user@localhost", "password");
        String sessionId3 = this.events.expectLogin().assertEvent().getSessionId();
        org.junit.Assert.assertNotEquals((Object)sessionId, (Object)sessionId3);
        this.oauth.openLoginForm();
        this.events.expectLogin().session(sessionId3).removeDetail("username").assertEvent();
        this.driver.navigate().to(this.oauth.getLogoutUrl().redirectUri(OAuthClient.APP_AUTH_ROOT).build());
        this.events.expectLogout(sessionId3).detail("redirect_uri", OAuthClient.APP_AUTH_ROOT).assertEvent();
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void logoutWithRememberMe() {
        this.setRememberMe(true);
        try {
            this.loginPage.open();
            org.junit.Assert.assertFalse((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.setRememberMe(true);
            org.junit.Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.login("test-user@localhost", "password");
            String sessionId = this.events.expectLogin().assertEvent().getSessionId();
            this.testingClient.testing().removeUserSession("test", sessionId);
            this.loginPage.open();
            org.junit.Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginPage.getUsername());
            this.loginPage.login("test-user@localhost", "password");
            this.appPage.openAccount();
            this.accountManagementPage.signOut();
            org.junit.Assert.assertTrue((boolean)this.loginPage.isCurrent());
            org.junit.Assert.assertFalse((boolean)this.loginPage.isRememberMeChecked());
            org.junit.Assert.assertNotEquals((Object)"test-user@localhost", (Object)this.loginPage.getUsername());
        }
        finally {
            this.setRememberMe(false);
        }
    }

    private void setRememberMe(boolean enabled) {
        RealmRepresentation rep = this.adminClient.realm("test").toRepresentation();
        rep.setRememberMe(Boolean.valueOf(enabled));
        this.adminClient.realm("test").update(rep);
    }

    @Test
    public void logoutSessionWhenLoggedOutByAdmin() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        this.adminClient.realm("test").logoutAll();
        String logoutUrl = this.oauth.getLogoutUrl().sessionState(sessionId).build();
        this.driver.navigate().to(logoutUrl);
        URLAssert.assertCurrentUrlEquals(logoutUrl);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId2 = this.events.expectLogin().assertEvent().getSessionId();
        org.junit.Assert.assertNotEquals((Object)sessionId, (Object)sessionId2);
        this.driver.navigate().to(logoutUrl);
        this.events.expectLogout(sessionId2).removeDetail("redirect_uri").assertEvent();
    }

    @Test
    public void logoutUserByAdmin() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        Assert.assertEquals((Object)0, (Object)user.getNotBefore());
        this.adminClient.realm("test").users().get(user.getId()).logout();
        Retry.execute(() -> {
            UserRepresentation u = this.adminClient.realm("test").users().get(user.getId()).toRepresentation();
            Assert.assertTrue((u.getNotBefore() > 0 ? 1 : 0) != 0);
            this.loginPage.open();
            this.loginPage.assertCurrent();
        }, (int)10, (long)200L);
    }

    @Test
    public void testLogoutWhenAccountClientRenamed() throws IOException {
        try (ServerResourceUpdater accountClientUpdater = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"test", (String)"account").setClientId("account-changed").update();){
            this.logoutRedirect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFrontChannelLogoutWithPostLogoutRedirectUri() throws Exception {
        ClientsResource clients = this.adminClient.realm(this.oauth.getRealm()).clients();
        ClientRepresentation rep = (ClientRepresentation)clients.findByClientId(this.oauth.getClientId()).get(0);
        rep.setFrontchannelLogout(Boolean.valueOf(true));
        rep.getAttributes().put("frontchannel.logout.url", OAuthClient.APP_ROOT + "/admin/frontchannelLogout");
        clients.get(rep.getId()).update(rep);
        try {
            this.oauth.clientSessionState("client-session");
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            String idTokenString = tokenResponse.getIdToken();
            String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
            this.driver.navigate().to(logoutUrl);
            LogoutToken logoutToken = this.testingClient.testApp().getFrontChannelLogoutToken();
            Assert.assertNotNull((Object)logoutToken);
            IDToken idToken = (IDToken)new JWSInput(idTokenString).readJsonContent(IDToken.class);
            Assert.assertEquals((Object)logoutToken.getIssuer(), (Object)idToken.getIssuer());
            Assert.assertEquals((Object)logoutToken.getSid(), (Object)idToken.getSessionId());
        }
        finally {
            rep.setFrontchannelLogout(Boolean.valueOf(false));
            rep.getAttributes().put("frontchannel.logout.url", "");
            clients.get(rep.getId()).update(rep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFrontChannelLogout() throws Exception {
        ClientsResource clients = this.adminClient.realm(this.oauth.getRealm()).clients();
        ClientRepresentation rep = (ClientRepresentation)clients.findByClientId(this.oauth.getClientId()).get(0);
        rep.setName("My Testing App");
        rep.setFrontchannelLogout(Boolean.valueOf(true));
        rep.getAttributes().put("frontchannel.logout.url", OAuthClient.APP_ROOT + "/admin/frontchannelLogout");
        clients.get(rep.getId()).update(rep);
        try {
            this.oauth.clientSessionState("client-session");
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            String idTokenString = tokenResponse.getIdToken();
            String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).build();
            this.driver.navigate().to(logoutUrl);
            LogoutToken logoutToken = this.testingClient.testApp().getFrontChannelLogoutToken();
            Assert.assertNotNull((Object)logoutToken);
            IDToken idToken = (IDToken)new JWSInput(idTokenString).readJsonContent(IDToken.class);
            Assert.assertEquals((Object)logoutToken.getIssuer(), (Object)idToken.getIssuer());
            Assert.assertEquals((Object)logoutToken.getSid(), (Object)idToken.getSessionId());
            org.junit.Assert.assertTrue((boolean)this.driver.getTitle().equals("Logging out"));
            org.junit.Assert.assertTrue((boolean)this.driver.getPageSource().contains("You are logging out from following apps"));
            org.junit.Assert.assertTrue((boolean)this.driver.getPageSource().contains("My Testing App"));
        }
        finally {
            rep.setFrontchannelLogout(Boolean.valueOf(false));
            rep.getAttributes().put("frontchannel.logout.url", "");
            clients.get(rep.getId()).update(rep);
        }
    }
}

