/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.console.page.AdminConsole;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebDriver;

public class LoginTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    @JavascriptBrowser
    protected AdminConsole jsAdminConsole;
    @Drone
    @JavascriptBrowser
    protected WebDriver jsDriver;
    @Page
    protected LoginPage loginPage;
    @Page
    @JavascriptBrowser
    protected LoginPage jsLoginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    private static String userId;
    private static String user2Id;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test").email("login@test.com").enabled(true).password("password").build();
        userId = user.getId();
        UserRepresentation user2 = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test2").email("login2@test.com").enabled(true).password("password").build();
        user2Id = user2.getId();
        UserRepresentation admin = UserBuilder.create().username("admin").password("admin").enabled(true).build();
        HashMap<String, List<String>> clientRoles = new HashMap<String, List<String>>();
        clientRoles.put("realm-management", Arrays.asList("realm-admin"));
        admin.setClientRoles(clientRoles);
        RealmBuilder.edit(testRealm).user(user).user(user2).user(admin);
    }

    @Test
    public void testBrowserSecurityHeaders() {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        Response response = client.target(this.oauth.getLoginFormUrl()).request().get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        for (BrowserSecurityHeaders header : BrowserSecurityHeaders.values()) {
            String headerValue = response.getHeaderString(header.getHeaderName());
            String expectedValue = header.getDefaultValue();
            if (expectedValue.isEmpty()) {
                Assert.assertNull((Object)headerValue);
                continue;
            }
            Assert.assertNotNull((Object)headerValue);
            Assert.assertThat((Object)headerValue, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)expectedValue)));
        }
        response.close();
        client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentSecurityPolicyReportOnlyBrowserSecurityHeader() {
        String expectedCspReportOnlyValue = "default-src 'none'";
        String cspReportOnlyAttr = "contentSecurityPolicyReportOnly";
        String cspReportOnlyHeader = "Content-Security-Policy-Report-Only";
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        String defaultContentSecurityPolicyReportOnly = (String)realmRep.getBrowserSecurityHeaders().get("contentSecurityPolicyReportOnly");
        realmRep.getBrowserSecurityHeaders().put("contentSecurityPolicyReportOnly", "default-src 'none'");
        this.adminClient.realm("test").update(realmRep);
        try {
            ResteasyClient client = AdminClientUtil.createResteasyClient();
            Response response = client.target(this.oauth.getLoginFormUrl()).request().get();
            String headerValue = response.getHeaderString("Content-Security-Policy-Report-Only");
            Assert.assertThat((Object)headerValue, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"default-src 'none'")));
            response.close();
            client.close();
        }
        finally {
            realmRep.getBrowserSecurityHeaders().put("contentSecurityPolicyReportOnly", defaultContentSecurityPolicyReportOnly);
            this.adminClient.realm("test").update(realmRep);
        }
    }

    @Test
    public void testPOSTAuthenticationRequest() {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder b = OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT));
        Response response = client.target(b.build(new Object[]{this.oauth.getRealm()})).request().post(this.oauth.getLoginEntityForPOST());
        Assert.assertThat((Object)response.getStatus(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        Assert.assertThat((Object)response, (Matcher)Matchers.body((Matcher)org.hamcrest.Matchers.containsString((String)"Sign in")));
        response.close();
        client.close();
    }

    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE}, details="Remote testsuite: max-detail-length is set to zero in standalone.xml, proposed fix - KEYCLOAK-17659")
    @Test
    public void loginWithLongRedirectUri() throws Exception {
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.adminClient.realm("test")).updateWith(r -> r.setEventsEnabled(true))).update();){
            String randomLongString = RandomStringUtils.random((int)2500, (boolean)true, (boolean)true);
            String longRedirectUri = this.oauth.getRedirectUri() + "?longQueryParameterValue=" + randomLongString;
            UriBuilder longLoginUri = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl()).replaceQueryParam("redirect_uri", new Object[]{longRedirectUri});
            DroneUtils.getCurrentDriver().navigate().to(longLoginUri.build(new Object[0]).toString());
            this.loginPage.assertCurrent();
            this.loginPage.login("login-test", "password");
            this.events.expectLogin().user(userId).detail("redirect_uri", longRedirectUri).assertEvent();
        }
    }

    @Test
    public void loginChangeUserAfterInvalidPassword() {
        this.loginPage.open();
        this.loginPage.login("login-test2", "invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"login-test2", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.expectLogin().user(user2Id).session((String)null).error("invalid_user_credentials").detail("username", "login-test2").removeDetail("consent").assertEvent();
        this.loginPage.login("login-test", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginInvalidPassword() {
        this.loginPage.open();
        this.loginPage.login("login-test", "invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "login-test").removeDetail("consent").assertEvent();
    }

    @Test
    public void loginMissingPassword() {
        this.loginPage.open();
        this.loginPage.missingPassword("login-test");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "login-test").removeDetail("consent").assertEvent();
    }

    private void setUserEnabled(String id, boolean enabled) {
        UserRepresentation rep = this.adminClient.realm("test").users().get(id).toRepresentation();
        rep.setEnabled(Boolean.valueOf(enabled));
        this.adminClient.realm("test").users().get(id).update(rep);
    }

    @Test
    public void loginInvalidPasswordDisabledUser() {
        this.setUserEnabled(userId, false);
        try {
            this.loginPage.open();
            this.loginPage.login("login-test", "invalid");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
            Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
            Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
            this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "login-test").removeDetail("consent").assertEvent();
        }
        finally {
            this.setUserEnabled(userId, true);
        }
    }

    @Test
    public void loginDisabledUser() {
        this.setUserEnabled(userId, false);
        try {
            this.loginPage.open();
            this.loginPage.login("login-test", "password");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
            Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
            Assert.assertEquals((Object)"Account is disabled, contact your administrator.", (Object)this.loginPage.getError());
            this.events.expectLogin().user(userId).session((String)null).error("user_disabled").detail("username", "login-test").removeDetail("consent").assertEvent();
        }
        finally {
            this.setUserEnabled(userId, true);
        }
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void loginDifferentUserAfterDisabledUserThrownOut() {
        String userId = ((UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost").get(0)).getId();
        try {
            this.loginPage.open();
            this.loginPage.login("test-user@localhost", "password");
            this.appPage.assertCurrent();
            this.appPage.openAccount();
            this.profilePage.assertCurrent();
            this.setUserEnabled(userId, false);
            this.profilePage.updateUsername("notPermitted");
            WaitUtils.waitForPageToLoad();
            this.loginPage.assertCurrent();
            this.loginPage.login("keycloak-user@localhost", "password");
            this.profilePage.assertCurrent();
        }
        finally {
            this.setUserEnabled(userId, true);
        }
    }

    @Test
    public void loginInvalidUsername() {
        this.loginPage.open();
        this.loginPage.login("invalid", "password");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"invalid", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.expectLogin().user((String)null).session((String)null).error("user_not_found").detail("username", "invalid").removeDetail("consent").assertEvent();
        this.loginPage.login("login-test", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginMissingUsername() {
        this.loginPage.open();
        this.loginPage.missingUsername();
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.expectLogin().user((String)null).session((String)null).error("user_not_found").removeDetail("consent").assertEvent();
    }

    @Test
    public void loginUserWithEmailAsUsername() {
        this.loginPage.open();
        this.loginPage.login("login@test.com", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login@test.com").assertEvent();
    }

    @Test
    public void loginSuccess() {
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginSuccessRealmSigningAlgorithms() throws JWSInputException {
        ContainerAssume.assumeAuthServerSSL();
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
        this.driver.navigate().to(ServerURLs.getAuthServerContextRoot() + "/auth/realms/test/");
        String keycloakIdentity = this.driver.manage().getCookieNamed("KEYCLOAK_IDENTITY").getValue();
        String algorithm = new JWSInput(keycloakIdentity).getHeader().getAlgorithm().name();
        Assert.assertEquals((Object)"HS256", (Object)algorithm);
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"ES256");
            this.oauth.openLoginForm();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            this.driver.navigate().to(ServerURLs.getAuthServerContextRoot() + "/auth/realms/test/");
            keycloakIdentity = this.driver.manage().getCookieNamed("KEYCLOAK_IDENTITY").getValue();
            algorithm = new JWSInput(keycloakIdentity).getHeader().getAlgorithm().name();
            Assert.assertEquals((Object)"HS256", (Object)algorithm);
            this.oauth.openLoginForm();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
        }
    }

    @Test
    public void loginWithWhitespaceSuccess() {
        this.loginPage.open();
        this.loginPage.login(" login-test \t ", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginWithEmailWhitespaceSuccess() {
        this.loginPage.open();
        this.loginPage.login("    login@test.com    ", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).assertEvent();
    }

    private void setPasswordPolicy(String policy) {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        realmRep.setPasswordPolicy(policy);
        this.adminClient.realm("test").update(realmRep);
    }

    @Test
    public void loginWithForcePasswordChangePolicy() {
        this.setPasswordPolicy("forceExpiredPasswordChange(1)");
        try {
            this.setTimeOffset(86405);
            this.loginPage.open();
            this.loginPage.login("login-test", "password");
            this.updatePasswordPage.assertCurrent();
            this.updatePasswordPage.changePassword("updatedPassword", "updatedPassword");
            this.setTimeOffset(0);
            this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(userId).detail("username", "login-test").assertEvent();
            String currentUrl = this.driver.getCurrentUrl();
            String pageSource = this.driver.getPageSource();
            Assert.assertEquals((String)("bad expectation, on page: " + currentUrl), (Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
        }
        finally {
            this.setPasswordPolicy(null);
            UserResource userRsc = this.adminClient.realm("test").users().get(userId);
            ApiUtil.resetUserPassword((UserResource)userRsc, (String)"password", (boolean)false);
        }
    }

    @Test
    public void loginWithoutForcePasswordChangePolicy() {
        this.setPasswordPolicy("forceExpiredPasswordChange(1)");
        try {
            this.setTimeOffset(86205);
            this.loginPage.open();
            this.loginPage.login("login-test", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            this.setTimeOffset(0);
            this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
        }
        finally {
            this.setPasswordPolicy(null);
        }
    }

    @Test
    public void loginNoTimeoutWithLongWait() {
        this.loginPage.open();
        this.setTimeOffset(1700);
        this.loginPage.login("login-test", "password");
        this.setTimeOffset(0);
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent().getSessionId();
    }

    @Test
    public void loginLoginHint() {
        String loginFormUrl = this.oauth.getLoginFormUrl() + "&login_hint=login-test";
        this.driver.navigate().to(loginFormUrl);
        Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
        this.loginPage.login("password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginWithEmailSuccess() {
        this.loginPage.open();
        this.loginPage.login("login@test.com", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).assertEvent();
    }

    private void setRememberMe(boolean enabled) {
        this.setRememberMe(enabled, null, null);
    }

    private void setRememberMe(boolean enabled, Integer idleTimeout, Integer maxLifespan) {
        RealmRepresentation rep = this.adminClient.realm("test").toRepresentation();
        rep.setRememberMe(Boolean.valueOf(enabled));
        rep.setSsoSessionIdleTimeoutRememberMe(idleTimeout);
        rep.setSsoSessionMaxLifespanRememberMe(maxLifespan);
        this.adminClient.realm("test").update(rep);
    }

    @Test
    public void loginWithRememberMe() {
        this.setRememberMe(true);
        try {
            this.loginPage.open();
            Assert.assertFalse((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.setRememberMe(true);
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.login("login-test", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "login-test").detail("remember_me", "true").assertEvent();
            String sessionId = loginEvent.getSessionId();
            this.testingClient.testing().removeUserSession("test", sessionId);
            this.loginPage.open();
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
            this.loginPage.setRememberMe(false);
        }
        finally {
            this.setRememberMe(false);
        }
    }

    @Test
    public void loginAgainWithoutRememberMe() {
        this.setRememberMe(true);
        try {
            this.loginPage.open();
            Assert.assertFalse((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.setRememberMe(true);
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.login("login-test", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "login-test").detail("remember_me", "true").assertEvent();
            String sessionId = loginEvent.getSessionId();
            this.testingClient.testing().removeUserSession("test", sessionId);
            this.loginPage.open();
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
            this.loginPage.setRememberMe(false);
            this.loginPage.login("login-test", "password");
            loginEvent = this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
            sessionId = loginEvent.getSessionId();
            this.testingClient.testing().removeUserSession("test", sessionId);
            this.loginPage.open();
            Assert.assertFalse((boolean)this.loginPage.isRememberMeChecked());
            Assert.assertNotEquals((Object)"login-test", (Object)this.loginPage.getUsername());
        }
        finally {
            this.setRememberMe(false);
        }
    }

    @Test
    public void loginWithEmailUserAndRememberMe() {
        this.setRememberMe(true);
        try {
            this.loginPage.open();
            this.loginPage.setRememberMe(true);
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.login("login@test.com", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "login@test.com").detail("remember_me", "true").assertEvent();
            String sessionId = loginEvent.getSessionId();
            this.testingClient.testing().removeUserSession("test", sessionId);
            this.loginPage.open();
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            Assert.assertEquals((Object)"login@test.com", (Object)this.loginPage.getUsername());
            this.loginPage.setRememberMe(false);
        }
        finally {
            this.setRememberMe(false);
        }
    }

    @Test
    public void loginExpiredCode() {
        this.loginPage.open();
        this.setTimeOffset(5000);
        this.loginPage.login("login@test.com", "password");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Your login attempt timed out. Login will start from the beginning.", (Object)this.loginPage.getError());
        this.setTimeOffset(0);
        this.events.expectLogin().user((String)null).session((String)null).error("expired_code").clearDetails().assertEvent();
    }

    @Test
    public void loginExpiredCodeWithExplicitRemoveExpired() {
        this.getTestingClient().testing().setTestingInfinispanTimeService();
        try {
            this.loginPage.open();
            this.setTimeOffset(5000);
            this.testingClient.testing().removeExpired("test");
            this.loginPage.login("login@test.com", "password");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Your login attempt timed out. Login will start from the beginning.", (Object)this.loginPage.getError());
            this.events.expectLogin().user((String)null).session((String)null).error("expired_code").clearDetails().detail("restart_after_timeout", "true").client((String)null).assertEvent();
        }
        finally {
            this.getTestingClient().testing().revertTestingInfinispanTimeService();
        }
    }

    @Test
    public void loginAfterExpiredTimeout() throws Exception {
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.adminClient.realm("test")).updateWith(r -> r.setSsoSessionMaxLifespan(Integer.valueOf(5)))).update();){
            DroneUtils.addWebDriver((WebDriver)this.jsDriver);
            this.jsAdminConsole.setAdminRealm(this.testRealm().toRepresentation().getRealm());
            this.jsAdminConsole.navigateTo();
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.jsAdminConsole);
            this.jsLoginPage.login("admin", "admin");
            TimeUnit.SECONDS.sleep(5L);
            Retry.execute(() -> this.jsLoginPage.assertCurrent(), (int)20, (long)500L);
            this.jsLoginPage.login("admin", "admin");
            Assert.assertFalse((boolean)this.jsLoginPage.isCurrent());
        }
    }

    @Test
    public void loginExpiredCodeAndExpiredCookies() {
        this.loginPage.open();
        this.driver.manage().deleteAllCookies();
        this.loginPage.login("login@test.com", "password");
        this.errorPage.assertCurrent();
        String link = this.errorPage.getBackToApplicationLink();
        ClientRepresentation thirdParty = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"third-party").toRepresentation();
        Assert.assertNotNull((String)link, (Object)thirdParty.getBaseUrl());
    }

    @Test
    public void loginWithDisabledCookies() {
        String userId = ((UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost").get(0)).getId();
        this.oauth.clientId("test-app");
        this.oauth.openLoginForm();
        this.driver.manage().deleteAllCookies();
        this.loginPage.login("login@test.com", "password");
        this.events.expect(EventType.LOGIN_ERROR).user(new UserRepresentation()).client(new ClientRepresentation()).error("cookie_not_found").assertEvent();
        this.errorPage.assertCurrent();
    }

    @Test
    public void openLoginFormWithDifferentApplication() throws Exception {
        this.oauth.clientId("root-url-client");
        this.oauth.redirectUri(OAuthClient.SERVER_ROOT + "/foo/bar/");
        this.oauth.openLoginForm();
        this.oauth.clientId("test-app");
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.login("test-user@localhost", "password");
        this.appPage.assertCurrent();
        this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void openLoginFormAfterExpiredCode() throws Exception {
        this.oauth.openLoginForm();
        this.setTimeOffset(5000);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        Assert.assertNull((String)"Not expected to have error on loginForm.", (Object)this.loginPage.getError());
        this.loginPage.login("test-user@localhost", "password");
        this.appPage.assertCurrent();
        this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void loginRememberMeExpiredIdle() throws Exception {
        try (ServerResourceUpdater c = new RealmAttributeUpdater(this.adminClient.realm("test")).setSsoSessionIdleTimeoutRememberMe(Integer.valueOf(1)).setRememberMe(Boolean.valueOf(true)).update();){
            this.oauth.clientId("test-app");
            this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth");
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
            this.loginPage.setRememberMe(true);
            this.loginPage.login("test-user@localhost", "password");
            this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
            this.appPage.assertCurrent();
            this.setTimeOffset(122);
            this.appPage.openAccount();
            this.loginPage.assertCurrent();
        }
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void loginRememberMeExpiredMaxLifespan() throws Exception {
        try (ServerResourceUpdater c = new RealmAttributeUpdater(this.adminClient.realm("test")).setSsoSessionMaxLifespanRememberMe(Integer.valueOf(1)).setRememberMe(Boolean.valueOf(true)).update();){
            this.oauth.clientId("test-app");
            this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth");
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
            this.loginPage.setRememberMe(true);
            this.loginPage.login("test-user@localhost", "password");
            this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
            this.appPage.assertCurrent();
            this.setTimeOffset(2);
            this.appPage.openAccount();
            this.loginPage.assertCurrent();
        }
    }
}

