/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.openqa.selenium.NoSuchElementException;

public class HiddenProviderTest
extends AbstractTestRealmKeycloakTest {
    @Page
    protected LoginPage loginPage;

    @Override
    protected RealmResource testRealm() {
        return this.adminClient.realm("realm-with-broker");
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("oidc").alias("visible-oidc").displayName("VisibleOIDC").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("oidc").alias("hidden-oidc").displayName("HiddenOIDC").hideOnLoginPage().build());
    }

    @Test
    public void testVisibleProviderButton() {
        this.loginPage.open();
        Assert.assertNotNull((Object)this.loginPage.findSocialButton("visible-oidc"));
    }

    @Test(expected=NoSuchElementException.class)
    public void testHiddenProviderButton() {
        this.loginPage.open();
        Assert.assertNull((Object)this.loginPage.findSocialButton("hidden-oidc"));
    }
}

