/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.forms.SerializableApplicationData;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.BasicAuthHelper;
import org.openqa.selenium.By;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class FlowOverrideTest
extends AbstractTestRealmKeycloakTest {
    public static final String TEST_APP_DIRECT_OVERRIDE = "test-app-direct-override";
    public static final String TEST_APP_FLOW = "test-app-flow";
    public static final String TEST_APP_HTTP_CHALLENGE = "http-challenge-client";
    public static final String TEST_APP_HTTP_CHALLENGE_OTP = "http-challenge-otp-client";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    private TimeBasedOTP totp = new TimeBasedOTP();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void setupFlows() {
        SerializableApplicationData serializedApplicationData = new SerializableApplicationData(OAuthClient.APP_AUTH_ROOT, OAuthClient.APP_ROOT + "/admin", OAuthClient.APP_AUTH_ROOT + "/*");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientModel client = session.clients().getClientByClientId(realm, TEST_APP_FLOW);
            if (client != null) {
                return;
            }
            client = session.clients().getClientByClientId(realm, "test-app");
            client.setDirectAccessGrantsEnabled(true);
            AuthenticationFlowModel browser = new AuthenticationFlowModel();
            browser.setAlias("parent-flow");
            browser.setDescription("browser based authentication");
            browser.setProviderId("basic-flow");
            browser.setTopLevel(true);
            browser.setBuiltIn(true);
            browser = realm.addAuthenticationFlow(browser);
            AuthenticationFlowModel subflow2 = new AuthenticationFlowModel();
            subflow2.setTopLevel(false);
            subflow2.setBuiltIn(true);
            subflow2.setAlias("subflow-2");
            subflow2.setDescription("username+password AND pushButton");
            subflow2.setProviderId("basic-flow");
            subflow2 = realm.addAuthenticationFlow(subflow2);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setParentFlow(browser.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setFlowId(subflow2.getId());
            execution.setPriority(20);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow2.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("push-button-authenticator");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow2.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("auth-username-password-form");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            client = realm.addClient(TEST_APP_FLOW);
            client.setSecret("password");
            client.setBaseUrl(serializedApplicationData.applicationBaseUrl);
            client.setManagementUrl(serializedApplicationData.applicationManagementUrl);
            client.setEnabled(true);
            client.addRedirectUri(serializedApplicationData.applicationRedirectUrl);
            client.setAuthenticationFlowBindingOverride("browser", browser.getId());
            client.setPublicClient(false);
            AuthenticationFlowModel directGrant = new AuthenticationFlowModel();
            directGrant.setAlias("direct-override-flow");
            directGrant.setDescription("direct grant based authentication");
            directGrant.setProviderId("basic-flow");
            directGrant.setTopLevel(true);
            directGrant.setBuiltIn(true);
            directGrant = realm.addAuthenticationFlow(directGrant);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(directGrant.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("testsuite-username");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            AuthenticationFlowModel challengeOTP = new AuthenticationFlowModel();
            challengeOTP.setAlias("challenge-override-flow");
            challengeOTP.setDescription("challenge grant based authentication");
            challengeOTP.setProviderId("basic-flow");
            challengeOTP.setTopLevel(true);
            challengeOTP.setBuiltIn(true);
            realm.addAuthenticationFlow(challengeOTP);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(challengeOTP.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("basic-auth-otp");
            execution.setPriority(10);
            realm.addAuthenticatorExecution(execution);
            client = realm.addClient(TEST_APP_DIRECT_OVERRIDE);
            client.setSecret("password");
            client.setBaseUrl(serializedApplicationData.applicationBaseUrl);
            client.setManagementUrl(serializedApplicationData.applicationManagementUrl);
            client.setEnabled(true);
            client.addRedirectUri(serializedApplicationData.applicationRedirectUrl);
            client.setPublicClient(false);
            client.setDirectAccessGrantsEnabled(true);
            client.setAuthenticationFlowBindingOverride("browser", browser.getId());
            client.setAuthenticationFlowBindingOverride("direct_grant", directGrant.getId());
            client = realm.addClient(TEST_APP_HTTP_CHALLENGE);
            client.setSecret("password");
            client.setBaseUrl(serializedApplicationData.applicationBaseUrl);
            client.setManagementUrl(serializedApplicationData.applicationManagementUrl);
            client.setEnabled(true);
            client.addRedirectUri(serializedApplicationData.applicationRedirectUrl);
            client.setPublicClient(true);
            client.setDirectAccessGrantsEnabled(true);
            client.setAuthenticationFlowBindingOverride("direct_grant", realm.getFlowByAlias("http challenge").getId());
            client.setAuthenticationFlowBindingOverride("browser", realm.getFlowByAlias("http challenge").getId());
            client = realm.addClient(TEST_APP_HTTP_CHALLENGE_OTP);
            client.setSecret("password");
            client.setBaseUrl("http://localhost:8180/auth/realms/master/app/auth");
            client.setManagementUrl("http://localhost:8180/auth/realms/master/app/admin");
            client.setEnabled(true);
            client.addRedirectUri("http://localhost:8180/auth/realms/master/app/auth/*");
            client.setPublicClient(true);
            client.setDirectAccessGrantsEnabled(true);
            client.setAuthenticationFlowBindingOverride("direct_grant", realm.getFlowByAlias("challenge-override-flow").getId());
            client.setAuthenticationFlowBindingOverride("browser", realm.getFlowByAlias("challenge-override-flow").getId());
        });
    }

    public void testRunConsole() throws Exception {
        Thread.sleep(10000000L);
    }

    @Test
    public void testWithClientBrowserOverride() throws Exception {
        this.oauth.clientId(TEST_APP_FLOW);
        String loginFormUrl = this.oauth.getLoginFormUrl();
        this.log.info((Object)("loginFormUrl: " + loginFormUrl));
        this.driver.navigate().to(loginFormUrl);
        Assert.assertEquals((Object)"PushTheButton", (Object)this.driver.getTitle());
        this.driver.findElement(By.name((String)"submit1")).click();
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.appPage.assertCurrent();
        this.events.expectLogin().client(TEST_APP_FLOW).detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void testNoOverrideBrowser() throws Exception {
        String clientId = "test-app";
        this.testNoOverrideBrowser(clientId);
    }

    private void testNoOverrideBrowser(String clientId) {
        this.oauth.clientId(clientId);
        String loginFormUrl = this.oauth.getLoginFormUrl();
        this.log.info((Object)("loginFormUrl: " + loginFormUrl));
        this.driver.navigate().to(loginFormUrl);
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.appPage.assertCurrent();
        this.events.expectLogin().client(clientId).detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void testGrantAccessTokenNoOverride() throws Exception {
        this.testDirectGrantNoOverride("test-app");
    }

    private void testDirectGrantNoOverride(String clientId) {
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        String grantUri = this.oauth.getResourceOwnerPasswordCredentialGrantUrl();
        WebTarget grantTarget = httpClient.target(grantUri);
        String header = BasicAuthHelper.createHeader((String)clientId, (String)"password");
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        Response response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        header = BasicAuthHelper.createHeader((String)clientId, (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        form.param("password", "invalid");
        response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        header = BasicAuthHelper.createHeader((String)clientId, (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        form.param("password", "password");
        response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        httpClient.close();
        this.events.clear();
    }

    @Test
    public void testGrantAccessTokenWithClientOverride() throws Exception {
        String clientId = TEST_APP_DIRECT_OVERRIDE;
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        String grantUri = this.oauth.getResourceOwnerPasswordCredentialGrantUrl();
        WebTarget grantTarget = httpClient.target(grantUri);
        String header = BasicAuthHelper.createHeader((String)clientId, (String)"password");
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        Response response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        httpClient.close();
        this.events.clear();
    }

    @Test
    public void testClientOverrideFlowUsingDirectGrantHttpChallenge() {
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        String grantUri = this.oauth.getResourceOwnerPasswordCredentialGrantUrl();
        WebTarget grantTarget = httpClient.target(grantUri);
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("client_id", TEST_APP_HTTP_CHALLENGE);
        Response response = grantTarget.request().post(Entity.form((Form)form));
        Assert.assertEquals((Object)"Basic realm=\"test\"", (Object)response.getHeaderString("WWW-Authenticate"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"password")).post(Entity.form((Form)form));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        httpClient.close();
        this.events.clear();
    }

    @Test
    public void testDirectGrantHttpChallengeOTP() {
        UserRepresentation user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost").get(0);
        UserRepresentation userUpdate = UserBuilder.edit(user).totpSecret("totpSecret").otpEnabled().build();
        this.adminClient.realm("test").users().get(user.getId()).update(userUpdate);
        CredentialRepresentation totpCredential = this.adminClient.realm("test").users().get(user.getId()).credentials().stream().filter(c -> "otp".equals(c.getType())).findFirst().get();
        this.setupBruteForce();
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        String grantUri = this.oauth.getResourceOwnerPasswordCredentialGrantUrl();
        WebTarget grantTarget = httpClient.target(grantUri);
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("client_id", TEST_APP_HTTP_CHALLENGE_OTP);
        String totpCode = this.totp.generateTOTP("totpSecret");
        Response response = grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)("password" + totpCode))).post(Entity.form((Form)form));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"password123456")).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response = grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"password123456")).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        totpCode = this.totp.generateTOTP("totpSecret");
        response = grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)("password" + totpCode))).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        this.clearBruteForce();
        this.adminClient.realm("test").users().get(user.getId()).removeCredential(totpCredential.getId());
    }

    @Test
    public void testDirectGrantHttpChallengeUserDisabled() {
        this.setupBruteForce();
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        String grantUri = this.oauth.getResourceOwnerPasswordCredentialGrantUrl();
        WebTarget grantTarget = httpClient.target(grantUri);
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("client_id", TEST_APP_HTTP_CHALLENGE);
        UserRepresentation user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost").get(0);
        user.setEnabled(Boolean.valueOf(false));
        this.adminClient.realm("test").users().get(user.getId()).update(user);
        Response response = grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"password")).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertEquals((Object)"Unauthorized", (Object)response.getStatusInfo().getReasonPhrase());
        response.close();
        user.setEnabled(Boolean.valueOf(true));
        this.adminClient.realm("test").users().get(user.getId()).update(user);
        grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"wrongpassword")).post(Entity.form((Form)form));
        grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"wrongpassword")).post(Entity.form((Form)form));
        response = grantTarget.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"password")).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertEquals((Object)"Unauthorized", (Object)response.getStatusInfo().getReasonPhrase());
        response.close();
        this.clearBruteForce();
        httpClient.close();
        this.events.clear();
    }

    @Test
    public void testClientOverrideFlowUsingBrowserHttpChallenge() {
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        this.oauth.clientId(TEST_APP_HTTP_CHALLENGE);
        String grantUri = this.oauth.getLoginFormUrl();
        WebTarget grantTarget = httpClient.target(grantUri);
        Response response = grantTarget.request().get();
        Assert.assertEquals((long)302L, (long)response.getStatus());
        String location = response.getHeaderString("Location");
        response.close();
        response = httpClient.target(location).request().get();
        Assert.assertEquals((Object)"Basic realm=\"test\"", (Object)response.getHeaderString("WWW-Authenticate"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = httpClient.target(location).request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"test-user@localhost", (String)"password")).post(Entity.form((Form)new Form()));
        Assert.assertEquals((long)302L, (long)response.getStatus());
        location = response.getHeaderString("Location");
        response.close();
        Form form = new Form();
        form.param("grant_type", "authorization_code");
        form.param("client_id", TEST_APP_HTTP_CHALLENGE);
        form.param("redirect_uri", OAuthClient.APP_AUTH_ROOT);
        form.param("code", location.substring(location.indexOf("code") + "code".length() + 1));
        response = httpClient.target(this.oauth.getAccessTokenUrl()).request().post(Entity.form((Form)form));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        httpClient.close();
        this.events.clear();
    }

    @Test
    public void testRestInterface() throws Exception {
        ClientsResource clients = this.adminClient.realm("test").clients();
        List query = clients.findByClientId(TEST_APP_DIRECT_OVERRIDE);
        ClientRepresentation clientRep = (ClientRepresentation)query.get(0);
        String directGrantFlowId = (String)clientRep.getAuthenticationFlowBindingOverrides().get("direct_grant");
        Assert.assertNotNull((Object)directGrantFlowId);
        clientRep.getAuthenticationFlowBindingOverrides().put("direct_grant", "");
        clients.get(clientRep.getId()).update(clientRep);
        this.testDirectGrantNoOverride(TEST_APP_DIRECT_OVERRIDE);
        clientRep.getAuthenticationFlowBindingOverrides().put("direct_grant", directGrantFlowId);
        clients.get(clientRep.getId()).update(clientRep);
        this.testGrantAccessTokenWithClientOverride();
        query = clients.findByClientId(TEST_APP_FLOW);
        clientRep = (ClientRepresentation)query.get(0);
        String browserFlowId = (String)clientRep.getAuthenticationFlowBindingOverrides().get("browser");
        Assert.assertNotNull((Object)browserFlowId);
        clientRep.getAuthenticationFlowBindingOverrides().put("browser", "");
        clients.get(clientRep.getId()).update(clientRep);
        this.testNoOverrideBrowser(TEST_APP_FLOW);
        clientRep.getAuthenticationFlowBindingOverrides().put("browser", browserFlowId);
        clients.get(clientRep.getId()).update(clientRep);
        this.testWithClientBrowserOverride();
    }

    @Test
    @UncaughtServerErrorExpected
    public void testRestInterfaceWithBadId() throws Exception {
        ClientsResource clients = this.adminClient.realm("test").clients();
        List query = clients.findByClientId(TEST_APP_FLOW);
        ClientRepresentation clientRep = (ClientRepresentation)query.get(0);
        String browserFlowId = (String)clientRep.getAuthenticationFlowBindingOverrides().get("browser");
        clientRep.getAuthenticationFlowBindingOverrides().put("browser", "bad-id");
        try {
            clients.get(clientRep.getId()).update(clientRep);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        query = clients.findByClientId(TEST_APP_FLOW);
        clientRep = (ClientRepresentation)query.get(0);
        Assert.assertEquals((Object)browserFlowId, clientRep.getAuthenticationFlowBindingOverrides().get("browser"));
    }

    private void setupBruteForce() {
        RealmRepresentation testRealm = this.adminClient.realm("test").toRepresentation();
        testRealm.setBruteForceProtected(Boolean.valueOf(true));
        testRealm.setFailureFactor(Integer.valueOf(2));
        testRealm.setMaxDeltaTimeSeconds(Integer.valueOf(20));
        testRealm.setMaxFailureWaitSeconds(Integer.valueOf(100));
        testRealm.setWaitIncrementSeconds(Integer.valueOf(5));
        this.adminClient.realm("test").update(testRealm);
    }

    private void clearBruteForce() {
        RealmRepresentation testRealm = this.adminClient.realm("test").toRepresentation();
        testRealm.setBruteForceProtected(Boolean.valueOf(false));
        this.adminClient.realm("test").attackDetection().clearAllBruteForce();
        this.adminClient.realm("test").update(testRealm);
    }
}

