/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.forms.AbstractFlowTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.pages.TermsAndConditionsPage;
import org.keycloak.testsuite.rest.representation.AuthenticatorState;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ExecutionBuilder;
import org.keycloak.testsuite.util.FlowBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class CustomFlowTest
extends AbstractFlowTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected TermsAndConditionsPage termsPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected RegisterPage registerPage;
    private static String userId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).build();
        testRealm.getUsers().add(user);
        ClientRepresentation dummyClient = ClientBuilder.create().clientId("dummy-client").name("dummy-client").authenticatorType("testsuite-client-passthrough").directAccessGrants().build();
        testRealm.getClients().add(dummyClient);
        ClientRepresentation testApp = RealmRepUtil.findClientByClientId(testRealm, "test-app");
        testApp.setClientAuthenticatorType("testsuite-client-passthrough");
        testApp.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
    }

    @Before
    public void configureFlows() {
        userId = this.findUser("login-test").getId();
        if (this.testContext.isInitialized()) {
            return;
        }
        AuthenticationFlowRepresentation flow = FlowBuilder.create().alias("dummy").description("dummy pass through flow").providerId("basic-flow").topLevel(true).builtIn(false).build();
        this.testRealm().flows().createFlow(flow);
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setBrowserFlow(flow.getAlias());
        realm.setDirectGrantFlow(flow.getAlias());
        this.testRealm().update(realm);
        flow = this.findFlowByAlias(flow.getAlias());
        AuthenticationExecutionRepresentation execution = ExecutionBuilder.create().parentFlow(flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-dummy-passthrough").priority(10).authenticatorFlow(false).build();
        this.testRealm().flows().addExecution(execution);
        flow = FlowBuilder.create().alias("dummy registration").description("dummy pass through registration").providerId("basic-flow").topLevel(true).builtIn(false).build();
        this.testRealm().flows().createFlow(flow);
        this.setRegistrationFlow(flow);
        flow = this.findFlowByAlias(flow.getAlias());
        execution = ExecutionBuilder.create().parentFlow(flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-dummy-registration").priority(10).authenticatorFlow(false).build();
        this.testRealm().flows().addExecution(execution);
        AuthenticationFlowRepresentation clientFlow = FlowBuilder.create().alias("client-dummy").description("dummy pass through flow").providerId("client-flow").topLevel(true).builtIn(false).build();
        this.testRealm().flows().createFlow(clientFlow);
        realm = this.testRealm().toRepresentation();
        realm.setClientAuthenticationFlow(clientFlow.getAlias());
        this.testRealm().update(realm);
        clientFlow = this.findFlowByAlias(clientFlow.getAlias());
        execution = ExecutionBuilder.create().parentFlow(clientFlow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-client-passthrough").priority(10).authenticatorFlow(false).build();
        this.testRealm().flows().addExecution(execution);
        this.testContext.setInitialized(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequiredAfterAlternative() {
        AuthenticationManagementResource authMgmtResource = this.testRealm().flows();
        HashMap<String, String> params = new HashMap<String, String>();
        String flowAlias = "Browser Flow With Extra";
        params.put("newName", flowAlias);
        String flowId = null;
        try (Response response = authMgmtResource.copy("browser", params);){
            Assert.assertThat((String)"Copy flow", (Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.CREATED));
            AuthenticationFlowRepresentation newFlow = this.findFlowByAlias(flowAlias);
            flowId = newFlow.getId();
        }
        AuthenticationExecutionRepresentation execution = ExecutionBuilder.create().parentFlow(flowId).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-dummy-click-through").priority(10).authenticatorFlow(false).build();
        RealmRepresentation rep = this.testRealm().toRepresentation();
        try (Response r = this.testRealm().flows().addExecution(execution);){
            rep.setBrowserFlow(flowAlias);
            this.testRealm().update(rep);
            rep = this.testRealm().toRepresentation();
            Assert.assertEquals((Object)flowAlias, (Object)rep.getBrowserFlow());
        }
        this.loginPage.open();
        Assert.assertTrue((boolean)this.termsPage.isCurrent());
        rep.setBrowserFlow("dummy");
        this.testRealm().update(rep);
    }

    @Test
    public void validateX509FlowUpdate() throws Exception {
        String flowAlias = "Browser Flow With Extra 2";
        AuthenticationFlowRepresentation flow = new AuthenticationFlowRepresentation();
        flow.setAlias(flowAlias);
        flow.setDescription("");
        flow.setProviderId("basic-flow");
        flow.setTopLevel(true);
        flow.setBuiltIn(false);
        try (Creator.Flow amr = Creator.create((RealmResource)this.testRealm(), (AuthenticationFlowRepresentation)flow);){
            String acId;
            AuthenticationManagementResource authMgmtResource = (AuthenticationManagementResource)amr.resource();
            AuthenticationExecutionInfoRepresentation execution = amr.addExecution("direct-grant-auth-x509-username");
            String executionId = execution.getId();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("x509-cert-auth.crl-checking-enabled", Boolean.TRUE.toString());
            AuthenticatorConfigRepresentation authConfig = new AuthenticatorConfigRepresentation();
            authConfig.setAlias("Config alias");
            authConfig.setConfig(config);
            try (Response resp = authMgmtResource.newExecutionConfig(executionId, authConfig);){
                Assert.assertThat((Object)resp, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.CREATED));
                acId = ApiUtil.getCreatedId((Response)resp);
            }
            authConfig = authMgmtResource.getAuthenticatorConfig(acId);
            authConfig.getConfig().put("x509-cert-auth.crl-checking-enabled", Boolean.FALSE.toString());
            authConfig.getConfig().put("x509-cert-auth.crl-relative-path", "");
            authMgmtResource.updateAuthenticatorConfig(acId, authConfig);
            authMgmtResource.updateAuthenticatorConfig(acId, authConfig);
        }
    }

    @Test
    public void loginSuccess() {
        AuthenticatorState state = new AuthenticatorState();
        state.setUsername("login-test");
        state.setClientId("test-app");
        this.testingClient.testing().updateAuthenticator(state);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void grantTest() throws Exception {
        AuthenticatorState state = new AuthenticatorState();
        state.setUsername("login-test");
        state.setClientId("test-app");
        this.testingClient.testing().updateAuthenticator(state);
        this.grantAccessToken("test-app", "login-test");
    }

    @Test
    public void clientAuthTest() throws Exception {
        AuthenticatorState state = new AuthenticatorState();
        state.setClientId("dummy-client");
        state.setUsername("login-test");
        this.testingClient.testing().updateAuthenticator(state);
        this.grantAccessToken("dummy-client", "login-test");
        state.setClientId("test-app");
        this.testingClient.testing().updateAuthenticator(state);
        this.grantAccessToken("test-app", "login-test");
        state.setClientId("unknown");
        this.testingClient.testing().updateAuthenticator(state);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user", "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_client", (Object)response.getError());
        this.events.expectLogin().client((String)null).user((String)null).session((String)null).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("invalid_client_credentials").assertEvent();
        state.setClientId("test-app");
        this.testingClient.testing().updateAuthenticator(state);
        this.oauth.addCustomParameter("test_error_param", "Some Random Error");
        try {
            response = this.oauth.doGrantAccessTokenRequest("password", "test-user", "password");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
            Assert.assertEquals((Object)"Unexpected error when authenticating client", (Object)response.getErrorDescription());
        }
        finally {
            this.oauth.removeCustomParameter("test_error_param");
        }
    }

    private void grantAccessToken(String clientId, String login) throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", login, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client(clientId).user(userId).session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", login).detail("client_auth_method", "testsuite-client-passthrough").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshedResponse.getRefreshToken());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client(clientId).detail("client_auth_method", "testsuite-client-passthrough").assertEvent();
    }
}

