/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.auth.page.login.OneTimeCode;
import org.keycloak.testsuite.broker.SocialLoginTest;
import org.keycloak.testsuite.forms.MultiFactorAuthenticationTest;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.LoginUsernameOnlyPage;
import org.keycloak.testsuite.pages.PasswordPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.URLUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@EnableFeature(value=Profile.Feature.WEB_AUTHN, skipRestart=true, onlyForProduct=true)
public class BrowserFlowTest
extends AbstractTestRealmKeycloakTest {
    private static final String INVALID_AUTH_CODE = "Invalid authenticator code.";
    private static final String USER_WITH_ONE_OTP_OTP_SECRET = "DJmQfC73VGFhw7D4QJ8A";
    private static final String USER_WITH_TWO_OTPS_OTP1_SECRET = "DJmQfC73VGFhw7D4QJ8A";
    private static final String USER_WITH_TWO_OTPS_OTP2_SECRET = "ABCQfC73VGFhw7D4QJ8A";
    @ArquillianResource
    protected OAuthClient oauth;
    @Drone
    protected WebDriver driver;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginUsernameOnlyPage loginUsernameOnlyPage;
    @Page
    protected PasswordPage passwordPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected OneTimeCode oneTimeCodePage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    private RealmRepresentation loadTestRealm() {
        RealmRepresentation res = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        res.setBrowserFlow("browser");
        return res;
    }

    private void importTestRealm(Consumer<RealmRepresentation> realmUpdater) {
        RealmRepresentation realm = this.loadTestRealm();
        if (realmUpdater != null) {
            realmUpdater.accept(realm);
        }
        this.importRealm(realm);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.debug((Object)"Adding test realm for import from testrealm.json");
        testRealms.add(this.loadTestRealm());
    }

    private void provideUsernamePassword(String user) {
        this.loginPage.open();
        this.loginPage.assertCurrent();
        this.loginPage.login(user, "invalid");
        this.loginPage.assertCurrent();
        this.loginPage.login(user, "password");
    }

    private String getOtpCode(String key) {
        return new TimeBasedOTP().generateTOTP(key);
    }

    @Test
    public void testUserWithoutAdditionalFactorConnection() {
        this.provideUsernamePassword("test-user@localhost");
        Assert.assertFalse((boolean)this.loginPage.isCurrent());
        Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
        Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.assertOtpCredentialSelectorAvailability(false);
    }

    @Test
    public void testUserWithOneAdditionalFactorOtpFails() {
        this.provideUsernamePassword("user-with-one-configured-otp");
        Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.assertOtpCredentialSelectorAvailability(false);
        this.oneTimeCodePage.sendCode("1234567");
        Assert.assertEquals((Object)INVALID_AUTH_CODE, (Object)this.oneTimeCodePage.getInputError());
        Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
    }

    @Test
    public void testUserWithOneAdditionalFactorOtpSuccess() {
        this.provideUsernamePassword("user-with-one-configured-otp");
        Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.assertOtpCredentialSelectorAvailability(false);
        this.oneTimeCodePage.sendCode(this.getOtpCode("DJmQfC73VGFhw7D4QJ8A"));
        Assert.assertFalse((boolean)this.loginPage.isCurrent());
        Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
    }

    @Test
    public void testUserWithTwoAdditionalFactors() {
        this.provideUsernamePassword("user-with-two-configured-otp");
        Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.assertOtpCredentialSelectorAvailability(true);
        Assert.assertEquals((Object)"first", (Object)this.loginTotpPage.getSelectedOtpCredential());
        this.loginTotpPage.selectOtpCredential("unnamed");
        this.loginTotpPage.login(this.getOtpCode("DJmQfC73VGFhw7D4QJ8A"));
        Assert.assertEquals((Object)INVALID_AUTH_CODE, (Object)this.oneTimeCodePage.getInputError());
        this.loginTotpPage.selectOtpCredential("first");
        this.loginTotpPage.login(this.getOtpCode(USER_WITH_TWO_OTPS_OTP2_SECRET));
        Assert.assertEquals((Object)INVALID_AUTH_CODE, (Object)this.oneTimeCodePage.getInputError());
        this.loginTotpPage.selectOtpCredential("unnamed");
        this.loginTotpPage.login(this.getOtpCode(USER_WITH_TWO_OTPS_OTP2_SECRET));
        Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
    }

    private void testCredentialsOrder(String username, List<String> orderedCredentials) {
        this.provideUsernamePassword(username);
        Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.assertOtpCredentialSelectorAvailability(true);
        Assert.assertEquals((Object)orderedCredentials.get(0), (Object)this.loginTotpPage.getSelectedOtpCredential());
        List creds = this.loginTotpPage.getAvailableOtpCredentials();
        Assert.assertEquals((long)2L, (long)creds.size());
        Assert.assertEquals(orderedCredentials, (Object)creds);
    }

    @Test
    public void testCredentialsOrder() {
        String username = "user-with-two-configured-otp";
        int idxFirst = 0;
        this.testCredentialsOrder(username, Arrays.asList("first", "unnamed"));
        try {
            this.importTestRealm(realmRep -> {
                UserRepresentation user = realmRep.getUsers().stream().filter(u -> username.equals(u.getUsername())).findFirst().get();
                user.getCredentials().add((CredentialRepresentation)user.getCredentials().remove(idxFirst));
            });
            this.testCredentialsOrder(username, Arrays.asList("unnamed", "first"));
        }
        finally {
            this.importTestRealm(null);
        }
    }

    private boolean needsPassword(String username) {
        this.loginUsernameOnlyPage.open();
        this.loginUsernameOnlyPage.login(username);
        return this.passwordPage.isCurrent();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testFlowDisabledWhenConditionalAuthenticatorIsMissing() {
        try {
            this.configureBrowserFlowWithConditionalSubFlowHavingConditionalAuthenticator("browser - non missing conditional authenticator", true);
            Assert.assertTrue((boolean)this.needsPassword("user-with-two-configured-otp"));
            this.configureBrowserFlowWithConditionalSubFlowHavingConditionalAuthenticator("browser - missing conditional authenticator", false);
            Assert.assertFalse((boolean)this.needsPassword("user-with-two-configured-otp"));
        }
        finally {
            this.revertFlows("browser - non missing conditional authenticator");
        }
    }

    private void configureBrowserFlowWithConditionalSubFlowHavingConditionalAuthenticator(String newFlowAlias, boolean conditionFlowHasConditionalAuthenticator) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, subFlow -> {
            if (conditionFlowHasConditionalAuthenticator) {
                subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-configured");
            }
            subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form");
        })).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testFlowDisabledWhenConditionalAuthenticatorIsDisabled() {
        try {
            this.configureBrowserFlowWithConditionalSubFlowHavingDisabledConditionalAuthenticator("browser - disabled conditional authenticator");
            Assert.assertFalse((boolean)this.needsPassword("user-with-two-configured-otp"));
        }
        finally {
            this.revertFlows("browser - disabled conditional authenticator");
        }
    }

    private void configureBrowserFlowWithConditionalSubFlowHavingDisabledConditionalAuthenticator(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, subFlow -> {
            subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.DISABLED, "conditional-user-configured");
            subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form");
        })).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalAuthenticatorInNonConditionalFlow() {
        try {
            this.configureBrowserFlowWithConditionalAuthenticatorInNonConditionalFlow();
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("user-with-two-configured-otp");
            this.passwordPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - nonconditional");
        }
    }

    private void configureBrowserFlowWithConditionalAuthenticatorInNonConditionalFlow() {
        String newFlowAlias = "browser - nonconditional";
        String requiredRole = "non-existing-role";
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, subFlow -> subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-role", config -> config.getConfig().put("condUserRole", requiredRole)).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form"))).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalRoleAuthenticator() {
        String requiredRole = "user";
        this.configureBrowserFlowOTPNeedsRole(requiredRole);
        try {
            this.provideUsernamePassword("user-with-two-configured-otp");
            Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertOtpCredentialSelectorAvailability(true);
            this.provideUsernamePassword("user-with-one-configured-otp");
            Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
        }
        finally {
            this.revertFlows("browser - rule");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalRoleAuthenticatorWithRealmRoleIncludedInCompositeRealmRole() {
        String compositeRealmRoleName = "composite-realm-role-1";
        this.testRealm().roles().create(RoleBuilder.create().name(compositeRealmRoleName).build());
        String childRealmRoleName = "child-realm-role-1";
        this.testRealm().roles().create(RoleBuilder.create().name(childRealmRoleName).build());
        this.testRealm().roles().get(compositeRealmRoleName).addComposites(Collections.singletonList(this.testRealm().roles().get(childRealmRoleName).toRepresentation()));
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"user-with-two-configured-otp");
        userResource.roles().realmLevel().add(Collections.singletonList(this.testRealm().roles().get(compositeRealmRoleName).toRepresentation()));
        this.configureBrowserFlowOTPNeedsRole(childRealmRoleName);
        try {
            this.provideUsernamePassword("user-with-two-configured-otp");
            Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertOtpCredentialSelectorAvailability(true);
            this.provideUsernamePassword("user-with-one-configured-otp");
            Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
        }
        finally {
            this.testRealm().roles().deleteRole(childRealmRoleName);
            this.testRealm().roles().deleteRole(compositeRealmRoleName);
            this.revertFlows("browser - rule");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalRoleAuthenticatorWithClientRoleIncludedInCompositeClientRole() {
        String clientName = "test-app";
        ClientRepresentation testClient = (ClientRepresentation)this.testRealm().clients().findByClientId(clientName).get(0);
        String compositeClientRoleName = "composite-client-role-1";
        this.testRealm().clients().get(testClient.getId()).roles().create(RoleBuilder.create().name(compositeClientRoleName).build());
        String childClientRoleName = "child-client-role-1";
        this.testRealm().clients().get(testClient.getId()).roles().create(RoleBuilder.create().name(childClientRoleName).build());
        this.testRealm().clients().get(testClient.getId()).roles().get(compositeClientRoleName).addComposites(Collections.singletonList(this.testRealm().clients().get(testClient.getId()).roles().get(childClientRoleName).toRepresentation()));
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"user-with-two-configured-otp");
        userResource.roles().clientLevel(testClient.getId()).add(Collections.singletonList(this.testRealm().clients().get(testClient.getId()).roles().get(compositeClientRoleName).toRepresentation()));
        this.configureBrowserFlowOTPNeedsRole(clientName + "." + childClientRoleName);
        try {
            this.provideUsernamePassword("user-with-two-configured-otp");
            Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertOtpCredentialSelectorAvailability(true);
            this.provideUsernamePassword("user-with-one-configured-otp");
            Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
        }
        finally {
            this.testRealm().clients().get(testClient.getId()).roles().deleteRole(childClientRoleName);
            this.testRealm().clients().get(testClient.getId()).roles().deleteRole(compositeClientRoleName);
            this.revertFlows("browser - rule");
        }
    }

    private void configureBrowserFlowWithConditionalSubFlowWithChangingConditionWhileFlowEvaluation() {
        String newFlowAlias = "browser - changing condition";
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow("browser - changing condition"));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("browser - changing condition").inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, subFlow -> {
            subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-attribute", config -> {
                config.getConfig().put("attribute_name", "attribute");
                config.getConfig().put("attribute_expected_value", "value");
                config.getConfig().put("not", Boolean.toString(true));
            });
            subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "set-attribute", config -> {
                config.getConfig().put("attr_name", "attribute");
                config.getConfig().put("attr_value", "value");
            });
            subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form");
            subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-otp-form");
        })).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalAuthenticatorWithConditionalSubFlowWithChangingConditionWhileFlowEvaluation() {
        try {
            this.configureBrowserFlowWithConditionalSubFlowWithChangingConditionWhileFlowEvaluation();
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("user-with-two-configured-otp");
            this.passwordPage.assertCurrent();
            this.passwordPage.login("password");
            Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
        }
        finally {
            this.revertFlows("browser - changing condition");
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void testAlternativeNonInteractiveExecutorInSubflow() {
        String newFlowAlias = "browser - alternative non-interactive executor";
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow("browser - alternative non-interactive executor"));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("browser - alternative non-interactive executor").inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, reqSubFlow -> reqSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "testsuite-dummy-passthrough"))).defineAsBrowserFlow());
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            WebElement aHref = this.driver.findElement(By.tagName((String)"a"));
            this.driver.get(aHref.getAttribute("href"));
            MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.containsString((String)"Account Management"));
        }
        finally {
            this.revertFlows("browser - alternative non-interactive executor");
        }
    }

    private void configureBrowserFlowOTPNeedsRole(String requiredRole) {
        String newFlowAlias = "browser - rule";
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow("browser - rule"));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("browser - rule").inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-password-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, subFlow -> subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-role", config -> config.getConfig().put("condUserRole", requiredRole)).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-otp-form"))).defineAsBrowserFlow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testSwitchExecutionNotAllowedWithRequiredPasswordAndAlternativeOTP() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithRequiredPasswordFormAndAlternativeOTP(newFlowAlias);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("user-with-one-configured-otp");
            this.passwordPage.assertCurrent();
            String otpAuthenticatorExecutionId = this.realmsResouce().realm("test").flows().getExecutions(newFlowAlias).stream().filter(execution -> "auth-otp-form".equals(execution.getProviderId())).findFirst().get().getId();
            String actionURL = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
            String formParameters = "authenticationExecution=" + otpAuthenticatorExecutionId + "&" + "credentialId" + "=";
            URLUtils.sendPOSTRequestWithWebDriver((String)actionURL, (String)formParameters);
            this.errorPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testSocialProvidersPresentOnLoginUsernameOnlyPageIfConfigured() {
        String testRealm = "test";
        this.configureBrowserFlowWithRequiredPasswordFormAndAlternativeOTP("browser - copy 1");
        try {
            SocialLoginTest socialLoginTest = new SocialLoginTest();
            for (SocialLoginTest.Provider provider : Arrays.asList(SocialLoginTest.Provider.GITHUB, SocialLoginTest.Provider.GITLAB, SocialLoginTest.Provider.GOOGLE)) {
                this.adminClient.realm(testRealm).identityProviders().create(socialLoginTest.buildIdp(provider));
                this.loginUsernameOnlyPage.open();
                this.loginUsernameOnlyPage.assertCurrent();
                this.loginUsernameOnlyPage.findSocialButton(provider.id());
            }
        }
        finally {
            for (IdentityProviderRepresentation providerRepresentation : this.adminClient.realm(testRealm).identityProviders().findAll()) {
                this.adminClient.realm(testRealm).identityProviders().get(providerRepresentation.getInternalId()).remove();
            }
            this.revertFlows("browser - copy 1");
        }
    }

    private void configureBrowserFlowWithRequiredPasswordFormAndAlternativeOTP(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-otp-form")).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalFlowWithConditionalAuthenticatorEvaluatingToFalseActsAsDisabled() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithConditionalFlowWithOTP(newFlowAlias);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            this.errorPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalFlowWithConditionalAuthenticatorEvaluatingToTrueActsAsRequired() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithConditionalFlowWithOTP(newFlowAlias);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("user-with-one-configured-otp");
            Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertOtpCredentialSelectorAvailability(false);
            this.loginTotpPage.login(this.getOtpCode("DJmQfC73VGFhw7D4QJ8A"));
            Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
            this.events.expectLogin().user(((UserRepresentation)this.testRealm().users().search("user-with-one-configured-otp").get(0)).getId()).detail("username", "user-with-one-configured-otp").assertEvent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    private void configureBrowserFlowWithConditionalFlowWithOTP(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, sf -> sf.addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, subFlow -> subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-configured").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-otp-form")))).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalFlowWithMultipleConditionalAuthenticatorsWithUserWithRoleAndOTP() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithConditionalFlowWithMultipleConditionalAuthenticators(newFlowAlias);
        try {
            String userId = ((UserRepresentation)this.testRealm().users().search("user-with-two-configured-otp").get(0)).getId();
            this.provideUsernamePassword("user-with-two-configured-otp");
            this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "user-with-two-configured-otp").removeDetail("consent").assertEvent();
            Assert.assertTrue((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertOtpCredentialSelectorAvailability(true);
            this.loginTotpPage.login(this.getOtpCode("DJmQfC73VGFhw7D4QJ8A"));
            Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
            this.events.expectLogin().user(userId).detail("username", "user-with-two-configured-otp").assertEvent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConditionalFlowWithMultipleConditionalAuthenticatorsWithUserWithRoleButNotOTP() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithConditionalFlowWithMultipleConditionalAuthenticators(newFlowAlias);
        try {
            String userId = ((UserRepresentation)this.testRealm().users().search("user-with-one-configured-otp").get(0)).getId();
            this.provideUsernamePassword("user-with-one-configured-otp");
            this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "user-with-one-configured-otp").removeDetail("consent").assertEvent();
            Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
            this.events.expectLogin().user(userId).detail("username", "user-with-one-configured-otp").assertEvent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    private void configureBrowserFlowWithConditionalFlowWithMultipleConditionalAuthenticators(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-password-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, subFlow -> subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-configured").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-role", config -> config.getConfig().put("condUserRole", "user")).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-otp-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, sf -> sf.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.DISABLED, "auth-otp-form")))).defineAsBrowserFlow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoOTPCredentialAndNoRequiredActionProviderRegistered() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithRequiredOTP(newFlowAlias);
        RequiredActionProviderRepresentation otpRequiredAction = this.testRealm().flows().getRequiredAction("CONFIGURE_TOTP");
        this.testRealm().flows().removeRequiredAction("CONFIGURE_TOTP");
        try {
            this.provideUsernamePassword("test-user@localhost");
            this.errorPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
            RequiredActionProviderSimpleRepresentation simpleRepresentation = new RequiredActionProviderSimpleRepresentation();
            simpleRepresentation.setProviderId("CONFIGURE_TOTP");
            simpleRepresentation.setName(otpRequiredAction.getName());
            this.testRealm().flows().registerRequiredAction(simpleRepresentation);
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoOTPCredentialAndRequiredActionProviderDisabled() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithRequiredOTP(newFlowAlias);
        RequiredActionProviderRepresentation otpRequiredAction = this.testRealm().flows().getRequiredAction("CONFIGURE_TOTP");
        otpRequiredAction.setEnabled(false);
        this.testRealm().flows().updateRequiredAction("CONFIGURE_TOTP", otpRequiredAction);
        try {
            this.provideUsernamePassword("test-user@localhost");
            this.errorPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
            otpRequiredAction.setEnabled(true);
            this.testRealm().flows().updateRequiredAction("CONFIGURE_TOTP", otpRequiredAction);
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoOTPCredential() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithRequiredOTP(newFlowAlias);
        try {
            this.provideUsernamePassword("test-user@localhost");
            Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("required-action?execution=CONFIGURE_TOTP"));
        }
        finally {
            this.revertFlows("browser - copy 1");
            UserRepresentation user = (UserRepresentation)this.testRealm().users().search("test-user@localhost").get(0);
            user.setRequiredActions(Collections.emptyList());
            this.testRealm().users().get(user.getId()).update(user);
        }
    }

    private void configureBrowserFlowWithRequiredOTP(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-password-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-otp-form")).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoWebAuthnCredentialAndNoRequiredActionProviderRegistered() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithRequiredWebAuthn(newFlowAlias);
        try {
            this.provideUsernamePassword("test-user@localhost");
            this.errorPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoWebAuthnCredentialAndRequiredActionProviderDisabled() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithRequiredWebAuthn(newFlowAlias);
        RequiredActionProviderSimpleRepresentation requiredActionRepresentation = new RequiredActionProviderSimpleRepresentation();
        requiredActionRepresentation.setName("WebAuthn Required Action");
        requiredActionRepresentation.setProviderId("webauthn-register");
        this.testRealm().flows().registerRequiredAction(requiredActionRepresentation);
        RequiredActionProviderRepresentation rapr = this.testRealm().flows().getRequiredAction("webauthn-register");
        rapr.setEnabled(false);
        this.testRealm().flows().updateRequiredAction("webauthn-register", rapr);
        try {
            this.provideUsernamePassword("test-user@localhost");
            this.errorPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
            this.testRealm().flows().removeRequiredAction("webauthn-register");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoWebAuthnCredential() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithRequiredWebAuthn(newFlowAlias);
        RequiredActionProviderSimpleRepresentation requiredActionRepresentation = new RequiredActionProviderSimpleRepresentation();
        requiredActionRepresentation.setName("WebAuthn Required Action");
        requiredActionRepresentation.setProviderId("webauthn-register");
        this.testRealm().flows().registerRequiredAction(requiredActionRepresentation);
        try {
            this.provideUsernamePassword("test-user@localhost");
            Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("required-action?execution=webauthn-register"));
        }
        finally {
            this.revertFlows("browser - copy 1");
            this.testRealm().flows().removeRequiredAction("webauthn-register");
            UserRepresentation user = (UserRepresentation)this.testRealm().users().search("test-user@localhost").get(0);
            user.setRequiredActions(Collections.emptyList());
            this.testRealm().users().get(user.getId()).update(user);
        }
    }

    private void configureBrowserFlowWithRequiredWebAuthn(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-password-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "webauthn-authenticator")).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoOTPCredentialAndAlternativeActionProvider() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithAlternativeOTPAndPassword(newFlowAlias);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            this.passwordPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    @Test
    public void testLoginWithWrongCredentialsMessage() {
        UserRepresentation user = (UserRepresentation)this.testRealm().users().search("test-user@localhost").get(0);
        Assert.assertNotNull((Object)user);
        this.loginPage.open();
        this.loginPage.assertCurrent();
        this.loginPage.login(user.getUsername(), "wrong_password");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.clear();
        this.loginPage.assertCurrent();
        this.loginPage.login(user.getUsername(), "password");
        Assert.assertFalse((boolean)this.loginPage.isCurrent());
        this.events.expectLogin().user(user).detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginMultiFactorWithWrongCredentialsMessage() {
        UserRepresentation user = (UserRepresentation)this.testRealm().users().search("test-user@localhost").get(0);
        Assert.assertNotNull((Object)user);
        MultiFactorAuthenticationTest.configureBrowserFlowWithAlternativeCredentials(this.testingClient);
        try {
            RealmRepresentation realm = this.testRealm().toRepresentation();
            realm.setLoginWithEmailAllowed(Boolean.valueOf(false));
            this.testRealm().update(realm);
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("non_existing_user");
            Assert.assertEquals((Object)"Invalid username.", (Object)this.loginUsernameOnlyPage.getUsernameError());
            Assert.assertEquals((Object)"Invalid username.", (Object)this.loginUsernameOnlyPage.getUsernameError());
            realm.setLoginWithEmailAllowed(Boolean.valueOf(true));
            this.testRealm().update(realm);
            this.loginUsernameOnlyPage.login("non_existing_user");
            Assert.assertEquals((Object)"Invalid username or email.", (Object)this.loginUsernameOnlyPage.getUsernameError());
            Assert.assertEquals((Object)"Invalid username or email.", (Object)this.loginUsernameOnlyPage.getUsernameError());
            this.loginUsernameOnlyPage.login(user.getUsername());
            this.passwordPage.assertCurrent();
            this.passwordPage.login("wrong_password");
            Assert.assertEquals((Object)"Invalid password.", (Object)this.passwordPage.getPasswordError());
            Assert.assertEquals((Object)"Invalid password.", (Object)this.passwordPage.getPasswordError());
            this.passwordPage.assertCurrent();
            this.events.clear();
            this.passwordPage.login("password");
            Assert.assertFalse((boolean)this.loginUsernameOnlyPage.isCurrent());
            Assert.assertFalse((boolean)this.passwordPage.isCurrent());
            this.events.expectLogin().user(user).detail("username", "test-user@localhost").assertEvent();
        }
        finally {
            this.revertFlows("browser - alternative");
        }
    }

    private void configureBrowserFlowWithAlternativeOTPAndPassword(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, subflow -> subflow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-otp-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, sf -> sf.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-password-form")))).defineAsBrowserFlow());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithWithNoWebAuthnCredentialAndAlternativeActionProvider() {
        String newFlowAlias = "browser - copy 1";
        this.configureBrowserFlowWithAlternativeWebAuthnAndPassword(newFlowAlias);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            this.passwordPage.assertCurrent();
        }
        finally {
            this.revertFlows("browser - copy 1");
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testLoginWithAlternativeOTPAndConditionalPassword() {
        String newFlowAlias = "browser - copy 2";
        this.configureBrowserFlowWithAlternativeOTPAndConditionalPassword(newFlowAlias);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("user-with-one-configured-otp");
            this.passwordPage.assertCurrent();
            this.passwordPage.assertTryAnotherWayLinkAvailability(true);
            this.passwordPage.login("password");
            Assert.assertFalse((boolean)this.loginPage.isCurrent());
            Assert.assertFalse((boolean)this.oneTimeCodePage.isOtpLabelPresent());
            this.events.expectLogin().user(((UserRepresentation)this.testRealm().users().search("user-with-one-configured-otp").get(0)).getId()).detail("username", "user-with-one-configured-otp").assertEvent();
        }
        finally {
            this.revertFlows(newFlowAlias);
        }
    }

    private void configureBrowserFlowWithAlternativeWebAuthnAndPassword(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, subflow -> subflow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "webauthn-authenticator").addSubFlowExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, sf -> sf.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-password-form")))).defineAsBrowserFlow());
    }

    private void configureBrowserFlowWithAlternativeOTPAndConditionalPassword(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, subflow -> subflow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-otp-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, sf -> sf.addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, sf2 -> sf2.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "conditional-user-configured").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form"))))).defineAsBrowserFlow());
    }

    private void revertFlows(String flowToDeleteAlias) {
        BrowserFlowTest.revertFlows(this.testRealm(), flowToDeleteAlias);
    }

    public static void revertFlows(RealmResource realmResource, String flowToDeleteAlias) {
        List flows = realmResource.flows().getFlows();
        RealmRepresentation realm = realmResource.toRepresentation();
        realm.setBrowserFlow("browser");
        realmResource.update(realm);
        AuthenticationFlowRepresentation flowRepresentation = AbstractAuthenticationTest.findFlowByAlias(flowToDeleteAlias, flows);
        if (flowRepresentation == null) {
            throw new IllegalArgumentException("The flow with alias " + flowToDeleteAlias + " did not exist");
        }
        realmResource.flows().deleteFlow(flowRepresentation.getId());
    }
}

