/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginUsernameOnlyPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AltSubflowForCredentialResetTest
extends AbstractTestRealmKeycloakTest {
    private String userID;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMailRule = new GreenMailRule();
    @Page
    LoginPage loginPage;
    @Page
    protected LoginUsernameOnlyPage loginUsernameOnlyPage;
    @Page
    LoginPasswordResetPage loginPasswordResetPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    private RealmRepresentation loadTestRealm() {
        RealmRepresentation res = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        res.setResetCredentialsFlow("reset credentials");
        return res;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.debug((Object)"Adding test realm for import from testrealm.json");
        testRealms.add(this.loadTestRealm());
    }

    @Before
    public void setup() {
        this.log.info((Object)"Adding login-test user");
        UserRepresentation testUser = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).build();
        this.userID = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)testUser, (String)"password");
        this.getCleanup().addUserId(this.userID);
    }

    private void configureAlternativeResetCredentialsFlow() {
        AltSubflowForCredentialResetTest.configureAlternativeResetCredentialsFlow(this.testingClient);
    }

    static void configureAlternativeResetCredentialsFlow(KeycloakTestingClient testingClient) {
        String newFlowAlias = "reset credentials - alternative";
        testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyResetCredentialsFlow("reset credentials - alternative"));
        testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("reset credentials - alternative").clear().addSubFlowExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, altSubFlow -> altSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "reset-credentials-choose-user").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "reset-credential-email").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "reset-password")).defineAsResetCredentialsFlow());
    }

    @Test
    public void alternativeSubflowStaySignedOutTest() {
        this.configureAlternativeResetCredentialsFlow();
        try {
            this.loginPage.open();
            this.loginPage.resetPassword();
            Assert.assertTrue((boolean)this.loginPasswordResetPage.isCurrent());
            this.loginPasswordResetPage.changePassword("login@test.com.com");
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginUsernameOnlyPage.getSuccessMessage());
            this.loginPage.open();
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
        }
        finally {
            this.testRealm().flows().getFlows().clear();
            RealmRepresentation realm = this.testRealm().toRepresentation();
            realm.setResetCredentialsFlow("reset credentials");
            this.testRealm().update(realm);
        }
    }
}

