/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStoreManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.actions.RequiredActionEmailVerificationTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.federation.UserMapStorage;
import org.keycloak.testsuite.federation.UserMapStorageFactory;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.TestCleanup;
import org.keycloak.testsuite.util.URLAssert;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class UserStorageTest
extends AbstractAuthTest {
    private String memProviderId;
    private String propProviderROId;
    private String propProviderRWId;
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected LoginPage loginPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    private static final File CONFIG_DIR = new File(System.getProperty("auth.server.config.dir", ""));

    @Before
    public void addProvidersBeforeTest() throws URISyntaxException, IOException {
        ComponentRepresentation memProvider = new ComponentRepresentation();
        memProvider.setName("memory");
        memProvider.setProviderId("user-password-map-arq");
        memProvider.setProviderType(UserStorageProvider.class.getName());
        memProvider.setConfig(new MultivaluedHashMap());
        memProvider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        memProvider.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(false));
        this.memProviderId = this.addComponent(memProvider);
        File stResDir = new File(this.getClass().getResource("/storage-test").toURI());
        if (stResDir.exists() && stResDir.isDirectory() && CONFIG_DIR.exists() && CONFIG_DIR.isDirectory()) {
            for (File f : stResDir.listFiles()) {
                this.log.infof("Copying %s to %s", (Object)f.getName(), (Object)CONFIG_DIR.getAbsolutePath());
                FileUtils.copyFileToDirectory((File)f, (File)CONFIG_DIR);
            }
        } else {
            throw new RuntimeException("Property `auth.server.config.dir` must be set to run UserStorageTests.");
        }
        ComponentRepresentation propProviderRO = new ComponentRepresentation();
        propProviderRO.setName("read-only-user-props");
        propProviderRO.setProviderId("user-password-props-arq");
        propProviderRO.setProviderType(UserStorageProvider.class.getName());
        propProviderRO.setConfig(new MultivaluedHashMap());
        propProviderRO.getConfig().putSingle((Object)"priority", (Object)Integer.toString(1));
        propProviderRO.getConfig().putSingle((Object)"propertyFile", (Object)(CONFIG_DIR.getAbsolutePath() + File.separator + "read-only-user-password.properties"));
        this.propProviderROId = this.addComponent(propProviderRO);
        this.propProviderRWId = this.addComponent(this.newPropProviderRW());
    }

    @After
    public void afterTestCleanUp() throws URISyntaxException, IOException {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            if (realm == null) {
                return;
            }
            UserModel user = session.users().getUserByUsername(realm, "thor");
            if (user != null) {
                session.userLocalStorage().removeUser(realm, user);
                session.userCache().clear();
            }
            UserMapStorageFactory userMapStorageFactory = (UserMapStorageFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, "user-password-map-arq");
            org.junit.Assert.assertNotNull((Object)userMapStorageFactory);
            userMapStorageFactory.clear();
        });
    }

    protected ComponentRepresentation newPropProviderRW() {
        ComponentRepresentation propProviderRW = new ComponentRepresentation();
        propProviderRW.setName("user-props");
        propProviderRW.setProviderId("user-password-props-arq");
        propProviderRW.setProviderType(UserStorageProvider.class.getName());
        propProviderRW.setConfig(new MultivaluedHashMap());
        propProviderRW.getConfig().putSingle((Object)"priority", (Object)Integer.toString(2));
        propProviderRW.getConfig().putSingle((Object)"propertyFile", (Object)(CONFIG_DIR.getAbsolutePath() + File.separator + "user-password.properties"));
        propProviderRW.getConfig().putSingle((Object)"federatedStorage", (Object)"true");
        return propProviderRW;
    }

    private String addComponent(ComponentRepresentation component) {
        return UserStorageTest.addComponent(this.testRealmResource(), this.getCleanup(), component);
    }

    static String addComponent(RealmResource realmResource, TestCleanup testCleanup, ComponentRepresentation component) {
        Response resp = realmResource.components().add(component);
        resp.close();
        String id = ApiUtil.getCreatedId((Response)resp);
        testCleanup.addComponentId(id);
        return id;
    }

    private void loginSuccessAndLogout(String username, String password) {
        this.testRealmAccountPage.navigateTo();
        this.testRealmLoginPage.form().login(username, password);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountPage);
        this.testRealmAccountPage.logOut();
    }

    public void loginBadPassword(String username) {
        this.testRealmAccountPage.navigateTo();
        this.testRealmLoginPage.form().login(username, "badpassword");
        URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.testRealmAccountPage);
    }

    public void listComponents() {
        this.log.info((Object)"COMPONENTS:");
        this.testRealmResource().components().query().forEach(c -> this.log.infof("%s - %s - %s", (Object)c.getId(), (Object)c.getProviderType(), (Object)c.getName()));
    }

    @Test
    @ModelTest
    public void testCast(KeycloakSession session) throws Exception {
        UserCredentialStoreManager.getCredentialProviders((KeycloakSession)session, CredentialAuthentication.class).collect(Collectors.toList());
    }

    @Test
    public void testLoginSuccess() {
        this.loginSuccessAndLogout("tbrady", "goat");
        this.loginSuccessAndLogout("thor", "hammer");
        this.loginBadPassword("tbrady");
    }

    @Test
    public void testUpdate() {
        UserRepresentation thor = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"thor");
        thor.setFirstName("Stian");
        thor.setLastName("Thorgersen");
        thor.setEmailVerified(Boolean.valueOf(true));
        long thorCreated = System.currentTimeMillis() - 100L;
        thor.setCreatedTimestamp(Long.valueOf(thorCreated));
        thor.setEmail("thor@hammer.com");
        thor.setAttributes(new HashMap());
        thor.getAttributes().put("test-attribute", Arrays.asList("value"));
        thor.setRequiredActions(new ArrayList());
        thor.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PROFILE.name());
        this.testRealmResource().users().get(thor.getId()).update(thor);
        thor = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"thor");
        org.junit.Assert.assertEquals((Object)"Stian", (Object)thor.getFirstName());
        org.junit.Assert.assertEquals((Object)"Thorgersen", (Object)thor.getLastName());
        org.junit.Assert.assertEquals((Object)"thor@hammer.com", (Object)thor.getEmail());
        org.junit.Assert.assertTrue((boolean)thor.getAttributes().containsKey("test-attribute"));
        org.junit.Assert.assertEquals((long)1L, (long)((List)thor.getAttributes().get("test-attribute")).size());
        org.junit.Assert.assertEquals((Object)"value", ((List)thor.getAttributes().get("test-attribute")).get(0));
        org.junit.Assert.assertTrue((boolean)thor.isEmailVerified());
        GroupRepresentation g = new GroupRepresentation();
        g.setName("my-group");
        String gid = ApiUtil.getCreatedId((Response)this.testRealmResource().groups().add(g));
        this.testRealmResource().users().get(thor.getId()).joinGroup(gid);
        boolean foundGroup = false;
        for (GroupRepresentation ug : this.testRealmResource().users().get(thor.getId()).groups()) {
            if (!ug.getId().equals(gid)) continue;
            foundGroup = true;
        }
        org.junit.Assert.assertTrue((boolean)foundGroup);
        org.junit.Assert.assertTrue((boolean)thor.getRequiredActions().contains(UserModel.RequiredAction.UPDATE_PROFILE.name()));
        thor.getRequiredActions().remove(UserModel.RequiredAction.UPDATE_PROFILE.name());
        this.testRealmResource().users().get(thor.getId()).update(thor);
        ApiUtil.resetUserPassword((UserResource)this.testRealmResource().users().get(thor.getId()), (String)"lightning", (boolean)false);
        this.loginSuccessAndLogout("thor", "lightning");
        RoleRepresentation r = new RoleRepresentation("foo-role", "foo role", false);
        this.testRealmResource().roles().create(r);
        ApiUtil.assignRealmRoles((RealmResource)this.testRealmResource(), (String)thor.getId(), (String[])new String[]{"foo-role"});
        boolean foundRole = false;
        for (RoleRepresentation rr : this.user(thor.getId()).roles().getAll().getRealmMappings()) {
            if (!"foo-role".equals(rr.getName())) continue;
            foundRole = true;
            break;
        }
        org.junit.Assert.assertTrue((boolean)foundRole);
        this.testRealmResource().components().component(this.propProviderRWId).remove();
        this.propProviderRWId = this.addComponent(this.newPropProviderRW());
        this.loginSuccessAndLogout("thor", "hammer");
        thor = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"thor");
        org.junit.Assert.assertNull((Object)thor.getFirstName());
        org.junit.Assert.assertNull((Object)thor.getLastName());
        org.junit.Assert.assertNull((Object)thor.getEmail());
        org.junit.Assert.assertNull((Object)thor.getAttributes());
        org.junit.Assert.assertFalse((boolean)thor.isEmailVerified());
        foundGroup = false;
        for (GroupRepresentation ug : this.testRealmResource().users().get(thor.getId()).groups()) {
            if (!ug.getId().equals(gid)) continue;
            foundGroup = true;
        }
        org.junit.Assert.assertFalse((boolean)foundGroup);
        foundRole = false;
        for (RoleRepresentation rr : this.user(thor.getId()).roles().getAll().getRealmMappings()) {
            if (!"foo-role".equals(rr.getName())) continue;
            foundRole = true;
            break;
        }
        org.junit.Assert.assertFalse((boolean)foundRole);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testRegisterWithRequiredEmail() throws Exception {
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.testRealmResource()).updateWith(r -> {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("from", "auto@keycloak.org");
            config.put("host", "localhost");
            config.put("port", "3025");
            r.setSmtpServer(config);
            r.setRegistrationAllowed(Boolean.valueOf(true));
            r.setVerifyEmail(Boolean.valueOf(true));
        })).update();){
            this.testRealmAccountPage.navigateTo();
            this.loginPage.clickRegister();
            this.registerPage.register("firstName", "lastName", "email@mail.com", "verifyEmail", "password", "password");
            this.verifyEmailPage.assertCurrent();
            org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
            this.driver.navigate().to(verificationUrl.trim());
            this.testRealmAccountPage.assertCurrent();
        }
    }

    public UserResource user(String userId) {
        return this.testRealmResource().users().get(userId);
    }

    @Test
    public void testRegistration() {
        UserRepresentation memuser = new UserRepresentation();
        memuser.setUsername("memuser");
        String uid = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealmResource(), (UserRepresentation)memuser, (String)"password");
        this.loginSuccessAndLogout("memuser", "password");
        this.loginSuccessAndLogout("memuser", "password");
        this.loginSuccessAndLogout("memuser", "password");
        memuser = this.user(uid).toRepresentation();
        org.junit.Assert.assertNotNull((Object)memuser);
        org.junit.Assert.assertNotNull((Object)memuser.getOrigin());
        ComponentRepresentation origin = this.testRealmResource().components().component(memuser.getOrigin()).toRepresentation();
        org.junit.Assert.assertEquals((Object)"memory", (Object)origin.getName());
        this.testRealmResource().users().get(memuser.getId()).remove();
        try {
            this.user(uid).toRepresentation();
            org.junit.Assert.fail((String)"`memuser` wasn't removed");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testQuery() {
        HashSet queried = new HashSet();
        int first = 0;
        while (queried.size() < 8) {
            List results = this.testRealmResource().users().search("", Integer.valueOf(first), Integer.valueOf(3));
            this.log.debugf("first=%s, results: %s", first, results.size());
            if (results.isEmpty()) break;
            first += results.size();
            queried.addAll(results);
        }
        HashSet<String> usernames = new HashSet<String>();
        for (UserRepresentation user : queried) {
            usernames.add(user.getUsername());
            this.log.info((Object)user.getUsername());
        }
        org.junit.Assert.assertEquals((long)8L, (long)queried.size());
        org.junit.Assert.assertTrue((boolean)usernames.contains("thor"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("zeus"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("apollo"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("perseus"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("tbrady"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("rob"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("jules"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("danny"));
        List users = this.testRealmResource().users().search("tbrady", Integer.valueOf(0), Integer.valueOf(-1));
        org.junit.Assert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        org.junit.Assert.assertThat((Object)((UserRepresentation)users.get(0)).getUsername(), (Matcher)Matchers.equalTo((Object)"tbrady"));
        GroupRepresentation g = new GroupRepresentation();
        g.setName("gods");
        String gid = ApiUtil.getCreatedId((Response)this.testRealmResource().groups().add(g));
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"apollo");
        this.testRealmResource().users().get(user.getId()).joinGroup(gid);
        user = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"zeus");
        this.testRealmResource().users().get(user.getId()).joinGroup(gid);
        user = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"thor");
        this.testRealmResource().users().get(user.getId()).joinGroup(gid);
        queried.clear();
        usernames.clear();
        first = 0;
        while (queried.size() < 8) {
            List results = this.testRealmResource().groups().group(gid).members(Integer.valueOf(first), Integer.valueOf(1));
            this.log.debugf("first=%s, results: %s", first, results.size());
            if (results.isEmpty()) break;
            first += results.size();
            queried.addAll(results);
        }
        for (UserRepresentation u : queried) {
            usernames.add(u.getUsername());
            this.log.info((Object)u.getUsername());
        }
        org.junit.Assert.assertEquals((long)3L, (long)queried.size());
        org.junit.Assert.assertTrue((boolean)usernames.contains("apollo"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("zeus"));
        org.junit.Assert.assertTrue((boolean)usernames.contains("thor"));
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            System.out.println("search by single attribute");
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel userModel = session.users().getUserByUsername(realm, "thor");
            userModel.setSingleAttribute("weapon", "hammer");
            List userModels = session.users().searchForUserByUserAttributeStream(realm, "weapon", "hammer").peek(System.out::println).collect(Collectors.toList());
            org.junit.Assert.assertEquals((long)1L, (long)userModels.size());
            org.junit.Assert.assertEquals((Object)"thor", (Object)((UserModel)userModels.get(0)).getUsername());
        });
    }

    @Test
    public void testQueryExactMatch() {
        org.junit.Assert.assertThat((Object)this.testRealmResource().users().search("a", Boolean.valueOf(true)), (Matcher)Matchers.hasSize((int)0));
        org.junit.Assert.assertThat((Object)this.testRealmResource().users().search("apollo", Boolean.valueOf(true)), (Matcher)Matchers.hasSize((int)1));
        org.junit.Assert.assertThat((Object)this.testRealmResource().users().search("tbrady", Boolean.valueOf(true)), (Matcher)Matchers.hasSize((int)1));
    }

    private void setDailyEvictionTime(int hour, int minutes) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("hour == " + hour);
        }
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("minutes == " + minutes);
        }
        ComponentRepresentation propProviderRW = this.testRealmResource().components().component(this.propProviderRWId).toRepresentation();
        propProviderRW.getConfig().putSingle((Object)"cachePolicy", (Object)CacheableStorageProviderModel.CachePolicy.EVICT_DAILY.name());
        propProviderRW.getConfig().putSingle((Object)"evictionHour", (Object)String.valueOf(hour));
        propProviderRW.getConfig().putSingle((Object)"evictionMinute", (Object)String.valueOf(minutes));
        this.testRealmResource().components().component(this.propProviderRWId).update(propProviderRW);
    }

    @Test
    public void testDailyEviction() {
        this.setTimeOfDay(23, 30, 0);
        this.setDailyEvictionTime(23, 45);
        this.testingClient.server().run((RunOnServer & Serializable)session -> session.userCache().clear());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 40, 0);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 50, 0);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertFalse((boolean)(user instanceof CachedUserModel));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 55, 0);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(0, 30, 0, 86400);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 30, 0, 86400);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 50, 0, 86400);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertFalse((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 55, 0, 86400);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 40, 0, 172800);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOfDay(23, 50, 0, 172800);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertFalse((boolean)(user instanceof CachedUserModel));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
    }

    @Test
    public void testWeeklyEviction() {
        ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"thor");
        Calendar eviction = Calendar.getInstance();
        eviction.add(10, 96);
        ComponentRepresentation propProviderRW = this.testRealmResource().components().component(this.propProviderRWId).toRepresentation();
        propProviderRW.getConfig().putSingle((Object)"cachePolicy", (Object)CacheableStorageProviderModel.CachePolicy.EVICT_WEEKLY.name());
        propProviderRW.getConfig().putSingle((Object)"evictionDay", (Object)Integer.toString(eviction.get(7)));
        propProviderRW.getConfig().putSingle((Object)"evictionHour", (Object)Integer.toString(eviction.get(11)));
        propProviderRW.getConfig().putSingle((Object)"evictionMinute", (Object)Integer.toString(eviction.get(12)));
        this.testRealmResource().components().component(this.propProviderRWId).update(propProviderRW);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            System.out.println("User class: " + user.getClass());
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOffset(172800);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            System.out.println("User class: " + user.getClass());
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOffset(432000);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            System.out.println("User class: " + user.getClass());
            org.junit.Assert.assertFalse((boolean)(user instanceof CachedUserModel));
        });
    }

    @Test
    public void testMaxLifespan() {
        ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"thor");
        ComponentRepresentation propProviderRW = this.testRealmResource().components().component(this.propProviderRWId).toRepresentation();
        propProviderRW.getConfig().putSingle((Object)"cachePolicy", (Object)CacheableStorageProviderModel.CachePolicy.MAX_LIFESPAN.name());
        propProviderRW.getConfig().putSingle((Object)"maxLifespan", (Object)Long.toString(3600000L));
        this.testRealmResource().components().component(this.propProviderRWId).update(propProviderRW);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            System.out.println("User class: " + user.getClass());
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOffset(0);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            System.out.println("User class: " + user.getClass());
            org.junit.Assert.assertTrue((boolean)(user instanceof CachedUserModel));
        });
        this.setTimeOffset(7200);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            System.out.println("User class: " + user.getClass());
            org.junit.Assert.assertFalse((boolean)(user instanceof CachedUserModel));
        });
    }

    @Test
    public void testNoCache() {
        ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"thor");
        ComponentRepresentation propProviderRW = this.testRealmResource().components().component(this.propProviderRWId).toRepresentation();
        propProviderRW.getConfig().putSingle((Object)"cachePolicy", (Object)CacheableStorageProviderModel.CachePolicy.NO_CACHE.name());
        this.testRealmResource().components().component(this.propProviderRWId).update(propProviderRW);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            System.out.println("User class: " + user.getClass());
            org.junit.Assert.assertFalse((boolean)(user instanceof CachedUserModel));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel thor2 = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertFalse((boolean)(thor2 instanceof CachedUserModel));
        });
        propProviderRW = this.testRealmResource().components().component(this.propProviderRWId).toRepresentation();
        propProviderRW.getConfig().putSingle((Object)"cachePolicy", (Object)CacheableStorageProviderModel.CachePolicy.DEFAULT.name());
        propProviderRW.getConfig().remove((Object)"evictionHour");
        propProviderRW.getConfig().remove((Object)"evictionMinute");
        propProviderRW.getConfig().remove((Object)"evictionDay");
        this.testRealmResource().components().component(this.propProviderRWId).update(propProviderRW);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel thor = session.users().getUserByUsername(realm, "thor");
            System.out.println("Foo");
        });
    }

    @Test
    public void testLifecycle() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            UserMapStorage.allocations.set(0);
            UserMapStorage.closings.set(0);
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().addUser(realm, "memuser");
            org.junit.Assert.assertNotNull((Object)user);
            user = session.users().getUserByUsername(realm, "nonexistent");
            org.junit.Assert.assertNull((Object)user);
            org.junit.Assert.assertEquals((long)1L, (long)UserMapStorage.allocations.get());
            org.junit.Assert.assertEquals((long)0L, (long)UserMapStorage.closings.get());
            session.users().removeUser(realm, session.users().getUserByUsername(realm, "memuser"));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            org.junit.Assert.assertEquals((long)1L, (long)UserMapStorage.allocations.get());
            org.junit.Assert.assertEquals((long)1L, (long)UserMapStorage.closings.get());
        });
    }

    @Test
    public void testEntityRemovalHooks() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            UserMapStorage.realmRemovals.set(0);
            UserMapStorage.groupRemovals.set(0);
            UserMapStorage.roleRemovals.set(0);
        });
        GroupRepresentation g1 = new GroupRepresentation();
        g1.setName("group1");
        GroupRepresentation g2 = new GroupRepresentation();
        g2.setName("group2");
        String gid1 = ApiUtil.getCreatedId((Response)this.testRealmResource().groups().add(g1));
        String gid2 = ApiUtil.getCreatedId((Response)this.testRealmResource().groups().add(g2));
        this.testRealmResource().groups().group(gid1).remove();
        this.testRealmResource().groups().group(gid2).remove();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            org.junit.Assert.assertEquals((long)2L, (long)UserMapStorage.groupRemovals.get());
            UserMapStorage.realmRemovals.set(0);
        });
        RoleRepresentation role1 = new RoleRepresentation();
        role1.setName("role1");
        RoleRepresentation role2 = new RoleRepresentation();
        role2.setName("role2");
        this.testRealmResource().roles().create(role1);
        this.testRealmResource().roles().create(role2);
        this.testRealmResource().roles().get("role1").remove();
        this.testRealmResource().roles().get("role2").remove();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            org.junit.Assert.assertEquals((long)2L, (long)UserMapStorage.roleRemovals.get());
            UserMapStorage.realmRemovals.set(0);
        });
        RealmRepresentation testRealmRepresentation = this.testRealmResource().toRepresentation();
        this.testRealmResource().remove();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            org.junit.Assert.assertEquals((long)1L, (long)UserMapStorage.realmRemovals.get());
            UserMapStorage.realmRemovals.set(0);
        });
        RealmRepresentation repOrig = (RealmRepresentation)this.testContext.getTestRealmReps().get(0);
        this.adminClient.realms().create(repOrig);
    }

    @Test
    @Ignore
    public void testEntityRemovalHooksCascade() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            UserMapStorage.realmRemovals.set(0);
            UserMapStorage.groupRemovals.set(0);
            UserMapStorage.roleRemovals.set(0);
        });
        GroupRepresentation g1 = new GroupRepresentation();
        g1.setName("group1");
        GroupRepresentation g2 = new GroupRepresentation();
        g2.setName("group2");
        String gid1 = ApiUtil.getCreatedId((Response)this.testRealmResource().groups().add(g1));
        String gid2 = ApiUtil.getCreatedId((Response)this.testRealmResource().groups().add(g2));
        RoleRepresentation role1 = new RoleRepresentation();
        role1.setName("role1");
        RoleRepresentation role2 = new RoleRepresentation();
        role2.setName("role2");
        this.testRealmResource().roles().create(role1);
        this.testRealmResource().roles().create(role2);
        this.testRealmResource().remove();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            org.junit.Assert.assertEquals((long)1L, (long)UserMapStorage.realmRemovals.get());
            org.junit.Assert.assertEquals((long)2L, (long)UserMapStorage.groupRemovals.get());
            org.junit.Assert.assertEquals((long)2L, (long)UserMapStorage.roleRemovals.get());
        });
    }

    @Test
    @ModelTest
    public void testCredentialCRUD(KeycloakSession session) throws Exception {
        AtomicReference passwordId = new AtomicReference();
        AtomicReference otp1Id = new AtomicReference();
        AtomicReference otp2Id = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertFalse((boolean)StorageId.isLocalStorage((UserModel)user));
            Stream credentials = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user);
            Assert.assertEquals((long)0L, (long)credentials.count());
            PasswordCredentialModel passwordCred = PasswordCredentialModel.createFromValues((String)"my-algorithm", (byte[])"theSalt".getBytes(), (int)22, (String)"ABC");
            passwordCred = currentSession.userCredentialManager().createCredential(realm, user, (CredentialModel)passwordCred);
            passwordId.set(passwordCred.getId());
            OTPCredentialModel otp1 = OTPCredentialModel.createFromPolicy((RealmModel)realm, (String)"secret1");
            OTPCredentialModel otp2 = OTPCredentialModel.createFromPolicy((RealmModel)realm, (String)"secret2");
            otp1 = currentSession.userCredentialManager().createCredential(realm, user, (CredentialModel)otp1);
            otp2 = currentSession.userCredentialManager().createCredential(realm, user, (CredentialModel)otp2);
            otp1Id.set(otp1.getId());
            otp2Id.set(otp2.getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "thor");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)passwordId.get(), (String)otp1Id.get(), (String)otp2Id.get());
            org.junit.Assert.assertFalse((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)passwordId.get(), "not-known"));
            org.junit.Assert.assertFalse((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, "not-known", (String)otp2Id.get()));
            org.junit.Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)otp2Id.get(), (String)passwordId.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "thor");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)passwordId.get(), (String)otp2Id.get(), (String)otp1Id.get());
            Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)otp2Id.get(), null));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "thor");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp2Id.get(), (String)passwordId.get(), (String)otp1Id.get());
            org.junit.Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)passwordId.get(), (String)otp1Id.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "thor");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp2Id.get(), (String)otp1Id.get(), (String)passwordId.get());
            org.junit.Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)otp2Id.get(), (String)passwordId.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "thor");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp1Id.get(), (String)passwordId.get(), (String)otp2Id.get());
            org.junit.Assert.assertTrue((boolean)currentSession.userCredentialManager().removeStoredCredential(realm, user, (String)passwordId.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "thor");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp1Id.get(), (String)otp2Id.get());
        });
    }

    @Test
    public void testCRUDCredentialsOfDifferentUser() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "thor");
            org.junit.Assert.assertFalse((boolean)StorageId.isLocalStorage((UserModel)user));
            OTPCredentialModel otp1 = OTPCredentialModel.createFromPolicy((RealmModel)realm, (String)"secret1");
            session.userCredentialManager().createCredential(realm, user, (CredentialModel)otp1);
        });
        UserResource user1 = ApiUtil.findUserByUsernameId((RealmResource)this.testRealmResource(), (String)"thor");
        CredentialRepresentation otpCredential = user1.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        UserResource user2 = ApiUtil.findUserByUsernameId((RealmResource)this.testRealmResource(), (String)"tbrady");
        try {
            user2.setCredentialUserLabel(otpCredential.getId(), "new-label");
            org.junit.Assert.fail((String)"Not expected to successfully update user label");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            user2.moveCredentialToFirst(otpCredential.getId());
            org.junit.Assert.fail((String)"Not expected to successfully move credential");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            user2.removeCredential(otpCredential.getId());
            org.junit.Assert.fail((String)"Not expected to successfully remove credential");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        CredentialRepresentation otpCredentialLoaded = user1.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        org.junit.Assert.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)otpCredential.getUserLabel(), (Object)otpCredentialLoaded.getUserLabel()));
        org.junit.Assert.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)otpCredential.getPriority(), (Object)otpCredentialLoaded.getPriority()));
    }

    private void assertOrder(List<CredentialModel> creds, String ... expectedIds) {
        Assert.assertEquals((long)expectedIds.length, (long)creds.size());
        if (creds.size() == 0) {
            return;
        }
        for (int i = 0; i < expectedIds.length; ++i) {
            Assert.assertEquals((Object)creds.get(i).getId(), (Object)expectedIds[i]);
        }
    }
}

