/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;

public class UserStorageProvidersTestUtils {
    private static final Logger logger = Logger.getLogger(UserStorageProvidersTestUtils.class);

    public static boolean isStorageProviderEnabled(RealmModel realm, String providerId) {
        UserStorageProviderModel model = UserStorageProvidersTestUtils.getStorageProviderModel(realm, providerId);
        return model.isEnabled();
    }

    public static Stream<UserStorageProviderModel> getStorageProviders(RealmModel realm) {
        return realm.getUserStorageProvidersStream();
    }

    private static UserStorageProviderFactory getUserStorageProviderFactory(UserStorageProviderModel model, KeycloakSession session) {
        return (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
    }

    public static <T> Stream<T> getEnabledStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        return UserStorageProvidersTestUtils.getStorageProviders(realm, session, type).filter(CacheableStorageProviderModel::isEnabled).map(model -> type.cast(UserStorageProvidersTestUtils.getStorageProviderInstance(session, model, UserStorageProvidersTestUtils.getUserStorageProviderFactory(model, session))));
    }

    public static UserStorageProvider getStorageProviderInstance(KeycloakSession session, UserStorageProviderModel model, UserStorageProviderFactory factory) {
        UserStorageProvider instance = (UserStorageProvider)session.getAttribute(model.getId());
        if (instance != null) {
            return instance;
        }
        instance = factory.create(session, (ComponentModel)model);
        if (instance == null) {
            throw new IllegalStateException("UserStorageProvideFactory (of type " + factory.getClass().getName() + ") produced a null instance");
        }
        session.enlistForClose((Provider)instance);
        session.setAttribute(model.getId(), (Object)instance);
        return instance;
    }

    public static <T> Stream<UserStorageProviderModel> getStorageProviders(RealmModel realm, KeycloakSession session, Class<T> type) {
        return realm.getUserStorageProvidersStream().filter(model -> {
            UserStorageProviderFactory factory = UserStorageProvidersTestUtils.getUserStorageProviderFactory(model, session);
            if (factory == null) {
                logger.warnv("Configured UserStorageProvider {0} of provider id {1} does not exist in realm {2}", (Object)model.getName(), (Object)model.getProviderId(), (Object)realm.getName());
                return false;
            }
            return Types.supports((Class)type, (Object)factory, UserStorageProviderFactory.class);
        });
    }

    public static UserStorageProvider getStorageProvider(KeycloakSession session, RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        UserStorageProviderModel storageModel = new UserStorageProviderModel(model);
        UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
        if (factory == null) {
            throw new ModelException("Could not find UserStorageProviderFactory for: " + model.getProviderId());
        }
        return UserStorageProvidersTestUtils.getStorageProviderInstance(session, storageModel, factory);
    }

    public static <T> Stream<T> getStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        return UserStorageProvidersTestUtils.getStorageProviders(realm, session, type).map(model -> type.cast(UserStorageProvidersTestUtils.getStorageProviderInstance(session, model, UserStorageProvidersTestUtils.getUserStorageProviderFactory(model, session))));
    }

    public static UserStorageProviderModel getStorageProviderModel(RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        return new UserStorageProviderModel(model);
    }
}

