/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.role.RoleStorageProvider;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RoleStorageTest
extends AbstractTestRealmKeycloakTest {
    private String providerId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    protected String addComponent(ComponentRepresentation component) {
        try (Response resp = this.adminClient.realm("test").components().add(component);){
            String id = ApiUtil.getCreatedId((Response)resp);
            this.getCleanup().addComponentId(id);
            String string = id;
            return string;
        }
    }

    @Before
    public void addProvidersBeforeTest() throws URISyntaxException, IOException {
        ComponentRepresentation provider = new ComponentRepresentation();
        provider.setName("role-storage-hardcoded");
        provider.setProviderId("hardcoded-role");
        provider.setProviderType(RoleStorageProvider.class.getName());
        provider.setConfig(new MultivaluedHashMap());
        provider.getConfig().putSingle((Object)"role_name", (Object)"hardcoded-role");
        provider.getConfig().putSingle((Object)"delayed_search", (Object)Boolean.toString(false));
        this.providerId = this.addComponent(provider);
    }

    @Test
    public void testGetRole() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            RoleModel hardcoded = realm.getRole("hardcoded-role");
            Assert.assertNotNull((Object)hardcoded);
        });
    }

    @Test
    public void testGetRoleById() {
        String providerId = this.providerId;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            StorageId storageId = new StorageId(providerId, "hardcoded-role");
            RoleModel hardcoded = realm.getRoleById(storageId.getId());
            Assert.assertNotNull((Object)hardcoded);
        });
    }

    @Test
    public void testSearchTimeout() throws Exception {
        this.runTestWithTimeout(4000L, () -> {
            String hardcodedRole = "hardcoded-role";
            String delayedSearch = "delayed_search";
            String providerId = this.providerId;
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                Assert.assertThat(session.roleStorageManager().searchForRolesStream(realm, "role", null, null).map(RoleModel::getName).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)hardcodedRole), (Matcher)Matchers.hasItem((Object)"sample-realm-role")));
                ComponentModel memoryProvider = realm.getComponent(providerId);
                memoryProvider.getConfig().putSingle((Object)delayedSearch, (Object)Boolean.toString(true));
                realm.updateComponent(memoryProvider);
            });
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                Assert.assertThat(session.roleStorageManager().searchForRolesStream(realm, "role", null, null).map(RoleModel::getName).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)hardcodedRole)), (Matcher)Matchers.hasItem((Object)"sample-realm-role")));
            });
        });
    }
}

