/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.Serializable;
import java.util.List;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class BrokenUserStorageTest
extends AbstractTestRealmKeycloakTest {
    @ArquillianResource
    protected ContainerController controller;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AppPage appPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    private void loginSuccessAndLogout(String username, String password) {
        this.loginPage.open();
        this.loginPage.login(username, password);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.oauth.openLogout();
    }

    @Test
    public void testBootWithBadProviderId() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            System.setProperty("component.provider.exists.disabled", "true");
            RealmModel realm = session.realms().getRealmByName("master");
            UserStorageProviderModel model = new UserStorageProviderModel();
            model.setName("bad-provider-id");
            model.setPriority(2);
            model.setParentId(realm.getId());
            model.setProviderId("error");
            ComponentModel component = realm.importComponentModel((ComponentModel)model);
        });
        this.controller.stop(this.suiteContext.getAuthServerInfo().getQualifier());
        this.controller.start(this.suiteContext.getAuthServerInfo().getQualifier());
        this.reconnectAdminClient();
        this.loginSuccessAndLogout("test-user@localhost", "password");
        RealmResource master = this.adminClient.realms().realm("master");
        String masterId = master.toRepresentation().getId();
        List components = master.components().query(masterId, UserStorageProvider.class.getName());
        ComponentRepresentation found = null;
        for (ComponentRepresentation rep : components) {
            if (!rep.getName().equals("bad-provider-id")) continue;
            found = rep;
        }
        Assert.assertNotNull(found);
        master.components().component(found.getId()).remove();
        List components2 = master.components().query(masterId, UserStorageProvider.class.getName());
        Assert.assertEquals((long)(components.size() - 1), (long)components2.size());
    }

    @After
    public void resetSystemProperty() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> System.getProperties().remove("component.provider.exists.disabled"));
    }
}

