/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.testsuite.util.LDAPRule;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LdapUsernameAttributeTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            appRealm.setEditUsernameAllowed(true);
        });
    }

    @Test
    public void testUsernameChange() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().addUser(appRealm, "johndow");
            john.setEmail("johndow@email.cz");
            john.setFirstName("johndow");
            john.setLastName("johndow");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johndow");
            Assert.assertNotNull((Object)john);
            Assert.assertNotNull((Object)john.getFederationLink());
            Assert.assertEquals((Object)"johndow", (Object)john.getUsername());
            Assert.assertEquals((Object)"johndow@email.cz", (Object)john.getEmail());
            Assert.assertEquals((Object)"johndow", (Object)john.getFirstName());
            Assert.assertEquals((Object)"johndow", (Object)john.getLastName());
            LDAPObject johnLdap = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johndow");
            Assert.assertNotNull((Object)johnLdap);
            LDAPDn.RDN firstRdnEntry = johnLdap.getDn().getFirstRdn();
            Assert.assertEquals((Object)"johndow", (Object)firstRdnEntry.getAttrValue((String)firstRdnEntry.getAllKeys().get(0)));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johndow");
            john.setUsername("johndow2");
            john.setEmail("johndow2@email.cz");
            john.setFirstName("johndow2");
            john.setLastName("johndow2");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            Assert.assertNull((Object)session.users().getUserByUsername(appRealm, "johndow"));
            UserModel john2 = session.users().getUserByUsername(appRealm, "johndow2");
            Assert.assertNotNull((Object)john2);
            Assert.assertNotNull((Object)john2.getFederationLink());
            Assert.assertEquals((Object)"johndow2", (Object)john2.getUsername());
            Assert.assertEquals((Object)"johndow2@email.cz", (Object)john2.getEmail());
            Assert.assertEquals((Object)"johndow2", (Object)john2.getFirstName());
            Assert.assertEquals((Object)"johndow2", (Object)john2.getLastName());
            LDAPObject johnLdap2 = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johndow2");
            Assert.assertNotNull((Object)johnLdap2);
            LDAPDn.RDN firstRdnEntry = johnLdap2.getDn().getFirstRdn();
            Assert.assertEquals((Object)"johndow2", (Object)firstRdnEntry.getAttrValue((String)firstRdnEntry.getAllKeys().get(0)));
            session.users().removeUser(appRealm, john2);
            Assert.assertNull((Object)session.users().getUserByUsername(appRealm, "johndow2"));
        });
    }

    @Test
    public void testUsernameChangeAlreadyExists() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().addUser(appRealm, "johndow");
            john.setEmail("johndow@email.cz");
            john.setFirstName("johndow");
            john.setLastName("johndow");
            UserModel john2 = session.users().addUser(appRealm, "johndow2");
            john.setEmail("johndow2@email.cz");
            john.setFirstName("johndow2");
            john.setLastName("johndow2");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johndow");
            Assert.assertNotNull((Object)john);
            Assert.assertNotNull((Object)john.getFederationLink());
            UserModel john2 = session.users().getUserByUsername(appRealm, "johndow2");
            Assert.assertNotNull((Object)john2);
            Assert.assertNotNull((Object)john2.getFederationLink());
        });
        try {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                UserModel john = session.users().getUserByUsername(appRealm, "johndow");
                john.setUsername("johndow2");
            });
            Assert.assertFalse((String)"Model exception is expected here, so it should not reach this point", (boolean)true);
        }
        catch (RunOnServerException e) {
            Assert.assertTrue((String)"Model exception is expected here but another error found", (boolean)(e.getCause() instanceof ModelDuplicateException));
            Assert.assertEquals((Object)"username", (Object)((ModelDuplicateException)e.getCause()).getDuplicateFieldName());
        }
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johndow");
            Assert.assertNotNull((Object)john);
            UserModel john2 = session.users().getUserByUsername(appRealm, "johndow2");
            Assert.assertNotNull((Object)john2);
            session.users().removeUser(appRealm, john);
            session.users().removeUser(appRealm, john2);
            Assert.assertNull((Object)session.users().getUserByUsername(appRealm, "johndow"));
            Assert.assertNull((Object)session.users().getUserByUsername(appRealm, "johndow2"));
        });
    }
}

