/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestConfiguration;
import org.keycloak.testsuite.util.LDAPTestUtils;

public class LDAPUserPropertiesMappingTest
extends AbstractLDAPTest {
    public static final String USER_EMAIL_VERIFIED_LDAP_ATTRIBUTE = "l";
    public static final String USER_ENABLED_LDAP_ATTRIBUTE = "o";
    public static final String DIETMAR = "dietmar";
    public static final String STEFAN = "stefan";
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(LDAPTestConfiguration::isStartEmbeddedLdapServer);

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel ldapModel = (ComponentModel)appRealm.getComponentsStream(appRealm.getId(), UserStorageProvider.class.getName()).findFirst().get();
            ldapModel.getConfig().putSingle((Object)"importEnabled", (Object)"false");
            appRealm.updateComponent(ldapModel);
            ComponentModel emailVerifiedMapperModel = LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)ldapModel, (String)"customEmailVerifiedMapper", (String)"emailVerified", (String)USER_EMAIL_VERIFIED_LDAP_ATTRIBUTE);
            appRealm.updateComponent(emailVerifiedMapperModel);
            ComponentModel enabledMapperModel = LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)ldapModel, (String)"customEnabledMapper", (String)"enabled", (String)USER_ENABLED_LDAP_ATTRIBUTE);
            appRealm.updateComponent(enabledMapperModel);
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.addLdapUser((KeycloakSession)session, (RealmModel)appRealm, (LDAPStorageProvider)ldapFedProvider, (String)DIETMAR, null, user -> {
                user.setEnabled(true);
                user.setEmailVerified(true);
            });
            LDAPTestUtils.addLdapUser((KeycloakSession)session, (RealmModel)appRealm, (LDAPStorageProvider)ldapFedProvider, (String)STEFAN, null, user -> {
                user.setEnabled(false);
                user.setEmailVerified(false);
            });
        });
    }

    @Test
    public void createAndReadUser() {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> {
            KeycloakContext context = session.getContext();
            RealmModel realm = context.getRealm();
            UserModel test10 = session.users().getUserByUsername(DIETMAR, realm);
            Assert.assertTrue((boolean)test10.isEnabled());
            Assert.assertTrue((boolean)test10.isEmailVerified());
            UserModel test11 = session.users().getUserByUsername(STEFAN, realm);
            Assert.assertFalse((boolean)test11.isEnabled());
            Assert.assertFalse((boolean)test11.isEmailVerified());
            ComponentModel ldapProviderModel = LDAPTestUtils.getLdapProviderModel((RealmModel)realm);
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapProviderModel);
            LDAPObject user10FromLdap = ldapProvider.loadLDAPUserByUsername(realm, DIETMAR);
            Assert.assertTrue((boolean)Boolean.parseBoolean(user10FromLdap.getAttributeAsString(USER_EMAIL_VERIFIED_LDAP_ATTRIBUTE)));
            Assert.assertTrue((boolean)Boolean.parseBoolean(user10FromLdap.getAttributeAsString(USER_ENABLED_LDAP_ATTRIBUTE)));
            LDAPObject user11FromLdap = ldapProvider.loadLDAPUserByUsername(realm, STEFAN);
            Assert.assertFalse((boolean)Boolean.parseBoolean(user11FromLdap.getAttributeAsString(USER_EMAIL_VERIFIED_LDAP_ATTRIBUTE)));
            Assert.assertFalse((boolean)Boolean.parseBoolean(user11FromLdap.getAttributeAsString(USER_ENABLED_LDAP_ATTRIBUTE)));
        });
    }
}

