/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.naming.AuthenticationException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.runners.MethodSorters;
import org.keycloak.events.EventType;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableVault;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@EnableVault
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPUserLoginTest
extends AbstractLDAPTest {
    @Rule
    public LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> ldapConfig.isStartEmbeddedLdapServer());
    @Rule
    public ExternalResource ldapProviderRule = new ExternalResource(){

        protected void after() {
            if (LDAPUserLoginTest.this.getTestingClient() != null) {
                LDAPUserLoginTest.this.getTestContext().getTestRealmReps().clear();
            }
        }
    };
    @Rule
    public AssertEvents events = new AssertEvents(this);
    protected static final Map<String, String> DEFAULT_TEST_USERS = new HashMap<String, String>();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    protected LDAPRule getLDAPRule() {
        return this.ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        try {
            this.getTestingClient().server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
                LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)DEFAULT_TEST_USERS.get("VALID_USER_NAME"), (String)DEFAULT_TEST_USERS.get("VALID_USER_FIRST_NAME"), (String)DEFAULT_TEST_USERS.get("VALID_USER_LAST_NAME"), (String)DEFAULT_TEST_USERS.get("VALID_USER_EMAIL"), (String)DEFAULT_TEST_USERS.get("VALID_USER_STREET"), (String[])new String[]{DEFAULT_TEST_USERS.get("VALID_USER_POSTAL_CODE")});
                LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)john, (String)DEFAULT_TEST_USERS.get("VALID_USER_PASSWORD"));
            });
        }
        catch (RunOnServerException ex) {
            Assume.assumeFalse((String)"Work around JDK-8214440", (ex.getCause() instanceof ModelException && ex.getCause().getCause() instanceof ModelException && ex.getCause().getCause().getCause() instanceof AuthenticationException && Objects.equals(ex.getCause().getCause().getCause().getMessage(), "Could not negotiate TLS") ? 1 : 0) != 0);
        }
    }

    private void verifyLoginSucceededAndLogout(String username, String password) {
        this.loginPage.open();
        this.loginPage.login(username, password);
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.appPage.logout();
    }

    private void verifyLoginFailed(String username, String password) {
        this.events.clear();
        this.loginPage.open();
        this.loginPage.login(username, password);
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        if (username.equals(DEFAULT_TEST_USERS.get("INVALID_USER_EMAIL")) || username.equals(DEFAULT_TEST_USERS.get("INVALID_USER_NAME"))) {
            this.events.expect(EventType.LOGIN_ERROR).user((String)null).error("user_not_found").assertEvent();
        } else if (username.equals(DEFAULT_TEST_USERS.get("VALID_USER_EMAIL")) || username.equals(DEFAULT_TEST_USERS.get("VALID_USER_NAME"))) {
            List knownUsers = this.getAdminClient().realm("test").users().search(DEFAULT_TEST_USERS.get("VALID_USER_NAME"));
            Assert.assertTrue((!knownUsers.isEmpty() ? 1 : 0) != 0);
            String userId = ((UserRepresentation)knownUsers.get(0)).getId();
            this.events.expect(EventType.LOGIN_ERROR).user(userId).error("invalid_user_credentials").assertEvent();
        }
    }

    private void runLDAPLoginTest() {
        String emptyPassword = DEFAULT_TEST_USERS.get("EMPTY_USER_PASSWORD");
        String invalidEmail = DEFAULT_TEST_USERS.get("INVALID_USER_EMAIL");
        String invalidPassword = DEFAULT_TEST_USERS.get("INVALID_USER_PASSWORD");
        String invalidUsername = DEFAULT_TEST_USERS.get("INVALID_USER_NAME");
        String validEmail = DEFAULT_TEST_USERS.get("VALID_USER_EMAIL");
        String validPassword = DEFAULT_TEST_USERS.get("VALID_USER_PASSWORD");
        String validUsername = DEFAULT_TEST_USERS.get("VALID_USER_NAME");
        this.verifyLoginSucceededAndLogout(validUsername, validPassword);
        this.verifyLoginSucceededAndLogout(validEmail, validPassword);
        this.verifyLoginFailed(validUsername, emptyPassword);
        this.verifyLoginFailed(validEmail, emptyPassword);
        this.verifyLoginFailed(validUsername, invalidPassword);
        this.verifyLoginFailed(validEmail, invalidPassword);
        this.verifyLoginFailed(invalidUsername, invalidPassword);
        this.verifyLoginFailed(invalidEmail, invalidPassword);
    }

    private void verifyConnectionUrlProtocolPrefix(String ldapProtocolPrefix) {
        String ldapConnectionUrl = (String)this.ldapRule.getConfig().get("connectionUrl");
        Assert.assertTrue((!ldapConnectionUrl.isEmpty() && ldapConnectionUrl.startsWith(ldapProtocolPrefix) ? 1 : 0) != 0);
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindType=LDAPRule.LDAPConnectionParameters.BindType.SIMPLE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.NONE)
    public void loginLDAPUserAuthenticationSimpleEncryptionNone() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindCredential=LDAPRule.LDAPConnectionParameters.BindCredential.VAULT, bindType=LDAPRule.LDAPConnectionParameters.BindType.SIMPLE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.NONE)
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE}, details="java.io.NotSerializableException: com.sun.jndi.ldap.LdapCtx")
    public void loginLDAPUserCredentialVaultAuthenticationSimpleEncryptionNone() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindType=LDAPRule.LDAPConnectionParameters.BindType.SIMPLE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.SSL)
    public void loginLDAPUserAuthenticationSimpleEncryptionSSL() {
        this.verifyConnectionUrlProtocolPrefix("ldaps://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindCredential=LDAPRule.LDAPConnectionParameters.BindCredential.VAULT, bindType=LDAPRule.LDAPConnectionParameters.BindType.SIMPLE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.SSL)
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE}, details="java.io.NotSerializableException: com.sun.jndi.ldap.LdapCtx")
    public void loginLDAPUserCredentialVaultAuthenticationSimpleEncryptionSSL() {
        this.verifyConnectionUrlProtocolPrefix("ldaps://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindType=LDAPRule.LDAPConnectionParameters.BindType.SIMPLE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.STARTTLS)
    public void loginLDAPUserAuthenticationSimpleEncryptionStartTLS() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindCredential=LDAPRule.LDAPConnectionParameters.BindCredential.VAULT, bindType=LDAPRule.LDAPConnectionParameters.BindType.SIMPLE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.STARTTLS)
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE}, details="java.io.NotSerializableException: com.sun.jndi.ldap.LdapCtx")
    public void loginLDAPUserCredentialVaultAuthenticationSimpleEncryptionStartTLS() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindType=LDAPRule.LDAPConnectionParameters.BindType.NONE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.NONE)
    public void loginLDAPUserAuthenticationNoneEncryptionNone() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindCredential=LDAPRule.LDAPConnectionParameters.BindCredential.VAULT, bindType=LDAPRule.LDAPConnectionParameters.BindType.NONE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.NONE)
    public void loginLDAPUserCredentialVaultAuthenticationNoneEncryptionNone() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindType=LDAPRule.LDAPConnectionParameters.BindType.NONE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.SSL)
    public void loginLDAPUserAuthenticationNoneEncryptionSSL() {
        this.verifyConnectionUrlProtocolPrefix("ldaps://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindCredential=LDAPRule.LDAPConnectionParameters.BindCredential.VAULT, bindType=LDAPRule.LDAPConnectionParameters.BindType.NONE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.SSL)
    public void loginLDAPUserCredentialVaultAuthenticationNoneEncryptionSSL() {
        this.verifyConnectionUrlProtocolPrefix("ldaps://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindType=LDAPRule.LDAPConnectionParameters.BindType.NONE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.STARTTLS)
    public void loginLDAPUserAuthenticationNoneEncryptionStartTLS() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    @Test
    @LDAPRule.LDAPConnectionParameters(bindCredential=LDAPRule.LDAPConnectionParameters.BindCredential.VAULT, bindType=LDAPRule.LDAPConnectionParameters.BindType.NONE, encryption=LDAPRule.LDAPConnectionParameters.Encryption.STARTTLS)
    public void loginLDAPUserCredentialVaultAuthenticationNoneEncryptionStartTLS() {
        this.verifyConnectionUrlProtocolPrefix("ldap://");
        this.runLDAPLoginTest();
    }

    static {
        DEFAULT_TEST_USERS.put("EMPTY_USER_PASSWORD", new String());
        DEFAULT_TEST_USERS.put("INVALID_USER_NAME", "userUnknown");
        DEFAULT_TEST_USERS.put("INVALID_USER_EMAIL", "unknown@keycloak.org");
        DEFAULT_TEST_USERS.put("INVALID_USER_PASSWORD", "1nval!D");
        DEFAULT_TEST_USERS.put("VALID_USER_EMAIL", "jdoe@keycloak.org");
        DEFAULT_TEST_USERS.put("VALID_USER_NAME", "jdoe");
        DEFAULT_TEST_USERS.put("VALID_USER_FIRST_NAME", "John");
        DEFAULT_TEST_USERS.put("VALID_USER_LAST_NAME", "Doe");
        DEFAULT_TEST_USERS.put("VALID_USER_PASSWORD", "P@ssw0rd!");
        DEFAULT_TEST_USERS.put("VALID_USER_POSTAL_CODE", "12345");
        DEFAULT_TEST_USERS.put("VALID_USER_STREET", "1th Avenue");
    }
}

