/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Collections;
import javax.ws.rs.ClientErrorException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.openqa.selenium.By;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPReadOnlyTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();
    @Page
    protected LoginConfigTotpPage totpPage;
    private TimeBasedOTP totp = new TimeBasedOTP();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)john, (String)"Password1");
            LDAPObject existing = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"existing", (String)"Existing", (String)"Foo", (String)"existing@email.org", null, (String[])new String[]{"5678"});
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            ldapFedProvider.getModel().put("editMode", UserStorageProvider.EditMode.READ_ONLY.toString());
            appRealm.updateComponent((ComponentModel)ldapFedProvider.getModel());
        });
    }

    @Test
    public void testReadOnlyWithTOTPEnabled() {
        this.setTotpRequirementExecutionForRealm(AuthenticationExecutionModel.Requirement.REQUIRED);
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        Assert.assertFalse((boolean)this.totpPage.isCancelDisplayed());
        this.driver.findElement(By.id((String)"userLabel"));
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.setTotpRequirementExecutionForRealm(AuthenticationExecutionModel.Requirement.CONDITIONAL);
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"johnkeycloak");
        String totpCredentialId = user.credentials().stream().filter(credentialRep -> credentialRep.getType().equals("otp")).findFirst().get().getId();
        user.removeCredential(totpCredentialId);
    }

    @Test
    public void testReadOnlyUserDoesNotThrowIfUnchanged() {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"johnkeycloak");
        UserRepresentation userRepresentation = user.toRepresentation();
        userRepresentation.setRequiredActions(Collections.singletonList(UserModel.RequiredAction.CONFIGURE_TOTP.toString()));
        user.update(userRepresentation);
        user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"johnkeycloak");
        userRepresentation = user.toRepresentation();
        Assert.assertEquals((long)userRepresentation.getRequiredActions().size(), (long)1L);
        Assert.assertEquals(userRepresentation.getRequiredActions().get(0), (Object)UserModel.RequiredAction.CONFIGURE_TOTP.toString());
        userRepresentation.setRequiredActions(Collections.emptyList());
        user.update(userRepresentation);
    }

    @Test(expected=ClientErrorException.class)
    public void testReadOnlyUserThrowsIfChanged() {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"johnkeycloak");
        UserRepresentation userRepresentation = user.toRepresentation();
        userRepresentation.setFirstName("Jane");
        user.update(userRepresentation);
    }

    private void setTotpRequirementExecutionForRealm(AuthenticationExecutionModel.Requirement requirement) {
        this.adminClient.realm("test").flows().getExecutions("browser").stream().filter(execution -> execution.getDisplayName().equals("Browser - Conditional OTP")).forEach(execution -> {
            execution.setRequirement(requirement.name());
            this.adminClient.realm("test").flows().updateExecutions("browser", execution);
        });
    }

    protected void assertFederatedUserLink(UserRepresentation user) {
        Assert.assertTrue((boolean)StorageId.isLocalStorage((String)user.getId()));
        Assert.assertNotNull((Object)user.getFederationLink());
        Assert.assertEquals((Object)user.getFederationLink(), (Object)ldapModelId);
    }
}

