/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

public class LDAPProvidersFullNameMapperTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
            Assert.assertNull((Object)session.users().getUserByUsername(appRealm, "fullname"));
            ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm);
            ComponentModel firstNameMapper = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ldapModel, (String)"first name");
            String ldapFirstNameAttributeName = (String)firstNameMapper.getConfig().getFirst((Object)"ldap.attribute");
            appRealm.removeComponent(firstNameMapper);
            ComponentModel fullNameMapperModel = KeycloakModelUtils.createComponentModel((String)"full name", (String)ldapModel.getId(), (String)"full-name-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"ldap.full.name.attribute", ldapFirstNameAttributeName, "read.only", "false"});
            appRealm.addComponentModel(fullNameMapperModel);
        });
    }

    @Test
    public void testUpdatingFirstNameAndLastNamePropagatesToFullnameMapper() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"fullname", (String)"James", (String)"Dee", (String)"fullname@email.org", null, (String[])new String[]{"4578"});
            LDAPTestAsserts.assertUserImported(session.users(), appRealm, "fullname", "James", "Dee", "fullname@email.org", "4578");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel fullnameUser = session.users().getUserByUsername(appRealm, "fullname");
            fullnameUser.setFirstName("James2");
            fullnameUser.setLastName("Dee2");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestAsserts.assertUserImported(session.users(), appRealm, "fullname", "James2", "Dee2", "fullname@email.org", "4578");
            UserModel fullnameUser = session.users().getUserByUsername(appRealm, "fullname");
            session.users().removeUser(appRealm, fullnameUser);
        });
    }

    @Test
    public void testUpdatingAttributesWorksEvenWithEmptyAttributes() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"fullname", (String)"James", (String)"Dee", (String)"fullname@email.org", null, (String[])new String[]{"4578"});
            LDAPTestAsserts.assertUserImported(session.users(), appRealm, "fullname", "James", "Dee", "fullname@email.org", "4578");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel fullnameUser = session.users().getUserByUsername(appRealm, "fullname");
            fullnameUser.setAttribute("myAttribute", Collections.singletonList("test"));
            fullnameUser.setAttribute("myEmptyAttribute", new ArrayList());
            fullnameUser.setAttribute("myNullAttribute", null);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestAsserts.assertUserImported(session.users(), appRealm, "fullname", "James", "Dee", "fullname@email.org", "4578");
            UserModel fullnameUser = session.users().getUserByUsername(appRealm, "fullname");
            Assert.assertThat(fullnameUser.getAttributeStream("myAttribute").collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"test"}));
            Assert.assertThat(fullnameUser.getAttributeStream("myEmptyAttribute").collect(Collectors.toList()), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            Assert.assertThat(fullnameUser.getAttributeStream("myNullAttribute").collect(Collectors.toList()), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            session.users().removeUser(appRealm, fullnameUser);
        });
    }
}

