/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPPasswordModifyExtensionTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> ldapConfig.isStartEmbeddedLdapServer());

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserStorageProviderModel model = ctx.getLdapModel();
            model.put("usePasswordModifyExtendedOp", true);
            appRealm.updateComponent((ComponentModel)model);
            ComponentModel randomLDAPPasswordMapper = KeycloakModelUtils.createComponentModel((String)"random initial password", (String)model.getId(), (String)"hardcoded-ldap-attribute-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"ldap.attribute.name", "userpassword", "ldap.attribute.value", "${RANDOM}"});
            appRealm.addComponentModel(randomLDAPPasswordMapper);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)john, (String)"Password1");
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
        });
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void ldapPasswordChangeWithAccountConsole() throws Exception {
        this.changePasswordPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        this.changePasswordPage.changePassword("Password1", "New-password1", "New-password1");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.changePasswordPage.logout();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Bad-password1");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "New-password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.changePasswordPage.open();
        this.changePasswordPage.changePassword("New-password1", "Password1", "Password1");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
    }

    @Test
    public void registerUserLdapSuccess() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "email2@check.cz", "registerUserSuccess2", "Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"registerUserSuccess2");
        Assert.assertNotNull((Object)user);
        this.assertFederatedUserLink(user);
        Assert.assertEquals((Object)"registerusersuccess2", (Object)user.getUsername());
        Assert.assertEquals((Object)"firstName", (Object)user.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)user.getLastName());
        Assert.assertTrue((boolean)user.isEnabled());
    }

    protected void assertFederatedUserLink(UserRepresentation user) {
        Assert.assertTrue((boolean)StorageId.isLocalStorage((String)user.getId()));
        Assert.assertNotNull((Object)user.getFederationLink());
        Assert.assertEquals((Object)user.getFederationLink(), (Object)ldapModelId);
    }
}

