/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPNoMSADTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> {
        String vendor = (String)ldapConfig.getLDAPConfig().get("vendor");
        return !"ad".equals(vendor);
    });

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"marykeycloak", (String)"mary@test.com", (String)"password-app");
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel());
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)john, (String)"Password1");
            LDAPObject existing = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"existing", (String)"Existing", (String)"Foo", (String)"existing@email.org", null, (String[])new String[]{"5678"});
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
        });
    }

    @Test
    public void testUpdateWithUnmappedRdnAttribute() {
        ComponentRepresentation snMapperRep = this.findMapperRepByName("last name");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel snMapper = null;
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPObject john2 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapProvider, (RealmModel)appRealm, (String)"johnkeycloak2", (String)"John2", (String)"Doe2", (String)"john2@email.org", null, (String[])new String[]{"4321"});
            john2.setRdnAttributeName("sn");
            ldapProvider.getLdapIdentityStore().update(john2);
            Assert.assertEquals((Object)"sn=Doe2", (Object)john2.getDn().getFirstRdn().toString());
            snMapper = appRealm.getComponentsStream(ctx.getLdapModel().getId(), LDAPStorageMapper.class.getName()).filter(mapper -> Objects.equals(mapper.getName(), "last name")).findFirst().orElse(null);
            Assert.assertNotNull((Object)snMapper);
            appRealm.removeComponent(snMapper);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel johnkeycloak2 = session.users().getUserByUsername(appRealm, "johnkeycloak2");
            Assert.assertNotNull((Object)johnkeycloak2);
            johnkeycloak2.setFirstName("foo2");
            johnkeycloak2.setLastName("foo");
        });
        snMapperRep.setId(null);
        this.testRealm().components().add(snMapperRep);
    }

    @Test
    public void testMultivaluedRDN() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            Object snMapper = null;
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPObject john2 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapProvider, (RealmModel)appRealm, (String)"johnkeycloak3", (String)"John3", (String)"Doe3", (String)"john3@email.org", null, (String[])new String[]{"4321"});
            john2.addRdnAttributeName("sn");
            ldapProvider.getLdapIdentityStore().update(john2);
            String rdnAttrName = ldapProvider.getLdapIdentityStore().getConfig().getRdnLdapAttribute();
            Assert.assertEquals((Object)(rdnAttrName + "=johnkeycloak3+sn=Doe3"), (Object)john2.getDn().getFirstRdn().toString());
        });
        String userId = ((UserRepresentation)this.testRealm().users().search("johnkeycloak3").get(0)).getId();
        UserResource user = this.testRealm().users().get(userId);
        UserRepresentation userRep = user.toRepresentation();
        this.assertFirstRDNEndsWith(userRep, "johnkeycloak3", "Doe3");
        userRep.setEmail("newemail@email.cz");
        user.update(userRep);
        userRep = user.toRepresentation();
        Assert.assertEquals((Object)"newemail@email.cz", (Object)userRep.getEmail());
        this.assertFirstRDNEndsWith(userRep, "johnkeycloak3", "Doe3");
        userRep.setLastName("Doe3Changed");
        user.update(userRep);
        userRep = user.toRepresentation();
        Assert.assertThat((Object)"Doe3Changed", (Matcher)Matchers.equalToIgnoringCase((String)userRep.getLastName()));
        this.assertFirstRDNEndsWith(userRep, "johnkeycloak3", "Doe3Changed");
        user.remove();
    }

    private void assertFirstRDNEndsWith(UserRepresentation user, String expectedUsernameInDN, String expectedLastNameInDN) {
        String currentDN = (String)((List)user.getAttributes().get("LDAP_ENTRY_DN")).get(0);
        LDAPDn.RDN firstRDN = LDAPDn.fromString((String)currentDN).getFirstRdn();
        List rdnKeys = firstRDN.getAllKeys();
        Assert.assertEquals((long)2L, (long)rdnKeys.size());
        Assert.assertEquals((Object)expectedLastNameInDN, (Object)firstRDN.getAttrValue("sn"));
        rdnKeys.remove("sn");
        Assert.assertEquals((Object)expectedUsernameInDN, (Object)firstRDN.getAttrValue((String)rdnKeys.get(0)));
    }
}

