/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.keycloak.testsuite.util.MailUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPNoCacheTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().setCachePolicy(CacheableStorageProviderModel.CachePolicy.NO_CACHE);
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
            appRealm.getComponentsStream(ctx.getLdapModel().getId()).filter(mapper -> "user-attribute-ldap-mapper".equals(mapper.getProviderId())).forEach(mapper -> {
                mapper.put("always.read.value.from.ldap", true);
                appRealm.updateComponent(mapper);
            });
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john_old@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)john, (String)"Password1");
        });
    }

    @Test
    public void resetPasswordLink() throws IOException, MessagingException {
        this.loginPage.open();
        this.triggerForgetPasswordForUser("john_old@email.org", 1, "john_old@email.org");
        LDAPNoCacheTest.changeEmailAddressInLDAP(this.testingClient, "john_new@email.org");
        try {
            UserRepresentation john = (UserRepresentation)this.testRealm().users().search("johnkeycloak").get(0);
            Assert.assertEquals((Object)"john_new@email.org", (Object)john.getEmail());
            this.triggerForgetPasswordForUser("johnkeycloak", 2, "john_new@email.org");
            this.triggerForgetPasswordForUser("john_old@email.org", 2, "john_new@email.org");
            this.triggerForgetPasswordForUser("john_new@email.org", 3, "john_new@email.org");
        }
        finally {
            LDAPNoCacheTest.changeEmailAddressInLDAP(this.testingClient, "john_old@email.org");
        }
    }

    @Test
    public void resetPasswordLinkCheckOldAddressLast() throws IOException, MessagingException {
        this.loginPage.open();
        this.triggerForgetPasswordForUser("john_old@email.org", 1, "john_old@email.org");
        LDAPNoCacheTest.changeEmailAddressInLDAP(this.testingClient, "john_new@email.org");
        try {
            this.triggerForgetPasswordForUser("johnkeycloak", 2, "john_new@email.org");
            this.triggerForgetPasswordForUser("john_new@email.org", 3, "john_new@email.org");
            this.triggerForgetPasswordForUser("john_old@email.org", 3, "john_new@email.org");
        }
        finally {
            LDAPNoCacheTest.changeEmailAddressInLDAP(this.testingClient, "john_old@email.org");
        }
    }

    private void triggerForgetPasswordForUser(String usernameInput, int expectedCountOfMessages, String expectedEmail) throws MessagingException {
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(usernameInput);
        this.loginPage.assertCurrent();
        org.junit.Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        MimeMessage[] messages = this.greenMail.getReceivedMessages();
        Assert.assertEquals((long)expectedCountOfMessages, (long)messages.length);
        MimeMessage message = this.greenMail.getReceivedMessages()[expectedCountOfMessages - 1];
        String emailAddress = MailUtils.getRecipient((MimeMessage)message);
        Assert.assertEquals((Object)expectedEmail, (Object)emailAddress);
    }

    private static void changeEmailAddressInLDAP(KeycloakTestingClient testingClient, String newEmail) {
        testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            LDAPStorageProvider ldapProvider = ctx.getLdapProvider();
            LDAPObject ldapUser = ldapProvider.loadLDAPUserByUsername(realm, "johnkeycloak");
            ldapUser.setSingleAttribute("mail", newEmail);
            ctx.getLdapProvider().getLdapIdentityStore().update(ldapUser);
        });
    }

    @Test
    public void lookupByAttributeAfterImportWithAttributeValueAlwaysReadFromLdapMustSucceed() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ctx.getLdapModel().setImportEnabled(true);
            realm.updateComponent((ComponentModel)ctx.getLdapModel());
            UserProvider localStorage = session.userLocalStorage();
            LDAPStorageProvider ldapProvider = ctx.getLdapProvider();
            UserModel user = localStorage.getUserByUsername(realm, "johnkeycloak");
            Assume.assumeThat((Object)user, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
            List byEmail = ldapProvider.searchForUserByUserAttributeStream(realm, "email", "john_old@email.org").collect(Collectors.toList());
            Assume.assumeThat(byEmail, (Matcher)Matchers.hasSize((int)1));
            user = localStorage.getUserByUsername(realm, "johnkeycloak");
            Assume.assumeThat((Object)user, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.nullValue())));
            byEmail = ldapProvider.searchForUserByUserAttributeStream(realm, "email", "john_old@email.org").collect(Collectors.toList());
            org.junit.Assert.assertThat(byEmail, (Matcher)Matchers.hasSize((int)1));
        });
    }
}

