/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.mappers.UserAttributeMapper;
import org.keycloak.representations.IDToken;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.keycloak.testsuite.util.OAuthClient;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPMultipleAttributesTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> {
        String vendor = (String)ldapConfig.getLDAPConfig().get("vendor");
        return !"ad".equals(vendor);
    });

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"streetMapper", (String)"street", (String)"street");
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            LDAPObject james = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"jbrown", (String)"James", (String)"Brown", (String)"jbrown@keycloak.org", null, (String[])new String[]{"88441"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)james, (String)"Password1");
            LDAPObject bruce = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"bwilson", (String)"Bruce", (String)"Wilson", (String)"bwilson@keycloak.org", (String)"Elm 5", (String[])new String[]{"88441", "77332"});
            bruce.setAttribute("sn", new LinkedHashSet<String>(Arrays.asList("Wilson", "Schneider")));
            ldapFedProvider.getLdapIdentityStore().update(bruce);
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)bruce, (String)"Password1");
            ClientModel ldapClient = appRealm.addClient("ldap-portal");
            ldapClient.setProtocol("openid-connect");
            ldapClient.addRedirectUri("/ldap-portal");
            ldapClient.addRedirectUri("/ldap-portal/*");
            ldapClient.setManagementUrl("/ldap-portal");
            ldapClient.addProtocolMapper(UserAttributeMapper.createClaimMapper((String)"postalCode", (String)"postal_code", (String)"postal_code", (String)"String", (boolean)true, (boolean)true, (boolean)true));
            ldapClient.addProtocolMapper(UserAttributeMapper.createClaimMapper((String)"street", (String)"street", (String)"street", (String)"String", (boolean)true, (boolean)true, (boolean)false));
            ldapClient.addScopeMapping(appRealm.getRole("user"));
            ldapClient.setSecret("password");
        });
    }

    @Test
    public void testUserImport() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            session.userCache().clear();
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "jbrown");
            org.junit.Assert.assertNotNull((Object)session.userLocalStorage().getUserById(appRealm, user.getId()));
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "jbrown", "James", "Brown", "jbrown@keycloak.org", "88441");
        });
    }

    @Test
    public void testModel() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            session.userCache().clear();
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "bwilson");
            org.junit.Assert.assertEquals((Object)"bwilson@keycloak.org", (Object)user.getEmail());
            org.junit.Assert.assertEquals((Object)"Bruce", (Object)user.getFirstName());
            org.junit.Assert.assertTrue(("Wilson".equals(user.getLastName()) || "Schneider".equals(user.getLastName()) ? 1 : 0) != 0);
            List<String> postalCodes = user.getAttributeStream("postal_code").collect(Collectors.toList());
            LDAPMultipleAttributesTest.assertPostalCodes(postalCodes, "88441", "77332");
            LinkedList<String> tmp = new LinkedList<String>();
            tmp.addAll(postalCodes);
            postalCodes = tmp;
            postalCodes.remove("77332");
            user.setAttribute("postal_code", postalCodes);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "bwilson");
            List<String> postalCodes = user.getAttributeStream("postal_code").collect(Collectors.toList());
            LDAPMultipleAttributesTest.assertPostalCodes(postalCodes, "88441");
            LinkedList<String> tmp = new LinkedList<String>();
            tmp.addAll(postalCodes);
            postalCodes = tmp;
            postalCodes.add("77332");
            user.setAttribute("postal_code", postalCodes);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "bwilson");
            LDAPMultipleAttributesTest.assertPostalCodes(user.getAttributeStream("postal_code").collect(Collectors.toList()), "88441", "77332");
        });
    }

    private static void assertPostalCodes(List<String> postalCodes, String ... expectedPostalCodes) {
        if (expectedPostalCodes == null && postalCodes.isEmpty()) {
            return;
        }
        org.junit.Assert.assertEquals((long)expectedPostalCodes.length, (long)postalCodes.size());
        for (String expected : expectedPostalCodes) {
            if (postalCodes.contains(expected)) continue;
            org.junit.Assert.fail((String)("postalCode '" + expected + "' not in postalCodes: " + postalCodes));
        }
    }

    @Test
    public void ldapPortalEndToEndTest() {
        this.oauth.clientId("ldap-portal");
        this.oauth.redirectUri(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/ldap-portal");
        this.loginPage.open();
        this.loginPage.login("bwilson", "Password1");
        String code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        org.junit.Assert.assertEquals((Object)"Bruce Wilson", (Object)idToken.getName());
        org.junit.Assert.assertEquals((Object)"Elm 5", idToken.getOtherClaims().get("street"));
        Collection postalCodes = (Collection)idToken.getOtherClaims().get("postal_code");
        org.junit.Assert.assertEquals((long)2L, (long)postalCodes.size());
        org.junit.Assert.assertTrue((boolean)postalCodes.contains("88441"));
        org.junit.Assert.assertTrue((boolean)postalCodes.contains("77332"));
        this.oauth.doLogout(response.getRefreshToken(), "password");
        this.loginPage.open();
        this.loginPage.login("jbrown", "Password1");
        code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        idToken = this.oauth.verifyIDToken(response.getIdToken());
        org.junit.Assert.assertEquals((Object)"James Brown", (Object)idToken.getName());
        org.junit.Assert.assertNull(idToken.getOtherClaims().get("street"));
        postalCodes = (Collection)idToken.getOtherClaims().get("postal_code");
        org.junit.Assert.assertEquals((long)1L, (long)postalCodes.size());
        org.junit.Assert.assertTrue((boolean)postalCodes.contains("88441"));
        org.junit.Assert.assertFalse((boolean)postalCodes.contains("77332"));
        this.oauth.doLogout(response.getRefreshToken(), "password");
    }
}

