/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.msad.UserAccountControl;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPMSADMapperTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> {
        String vendor = (String)ldapConfig.getLDAPConfig().get("vendor");
        return "ad".equals(vendor);
    });
    @Page
    protected LoginPasswordUpdatePage passwordUpdatePage;

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"marykeycloak", (String)"mary@test.com", (String)"password-app");
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel());
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)john, (String)"Password1");
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
        });
    }

    @Ignore
    @Test
    public void test01RegisterUserWithWeakPasswordFirst() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "email2@check.cz", "registerUserSuccess2", "password", "password");
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("pass", "pass");
        Assert.assertEquals((Object)"Invalid password: new password doesn't match password policies.", (Object)this.passwordUpdatePage.getError());
        this.passwordUpdatePage.changePassword("Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "registerUserSuccess2");
            Assert.assertNotNull((Object)user);
            Assert.assertNotNull((Object)user.getFederationLink());
            Assert.assertEquals((Object)user.getFederationLink(), (Object)ctx.getLdapModel().getId());
            Assert.assertEquals((Object)"registerusersuccess2", (Object)user.getUsername());
            Assert.assertEquals((Object)"firstName", (Object)user.getFirstName());
            Assert.assertEquals((Object)"lastName", (Object)user.getLastName());
            Assert.assertTrue((boolean)user.isEnabled());
            Assert.assertEquals((long)0L, (long)user.getRequiredActionsStream().count());
        });
    }

    @Test
    public void test02UpdatePasswordTest() {
        UserResource john = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"johnkeycloak");
        UserRepresentation johnRep = john.toRepresentation();
        johnRep.setRequiredActions(Collections.singletonList(UserModel.RequiredAction.UPDATE_PASSWORD.name()));
        john.update(johnRep);
        Assert.assertEquals((long)0L, (long)this.getPwdLastSetOfJohn());
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertThat((Object)this.getPwdLastSetOfJohn(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        johnRep = john.toRepresentation();
        Assert.assertTrue((boolean)johnRep.getRequiredActions().isEmpty());
        john.logout();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void test03UpdatePasswordWithLDAPDirectly() {
        UserResource john = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"johnkeycloak");
        UserRepresentation johnRep = john.toRepresentation();
        johnRep.setRequiredActions(Collections.singletonList(UserModel.RequiredAction.UPDATE_PASSWORD.name()));
        john.update(johnRep);
        Assert.assertEquals((long)0L, (long)this.getPwdLastSetOfJohn());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPObject ldapJohn = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johnkeycloak");
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)ldapJohn, (String)"Password1");
        });
        Assert.assertThat((Object)this.getPwdLastSetOfJohn(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        johnRep = john.toRepresentation();
        Assert.assertTrue((boolean)johnRep.getRequiredActions().isEmpty());
        john.logout();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void test04UpdateLDAPDirectlyToSetUpdatePassword() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPObject ldapJohn = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johnkeycloak");
            ldapJohn.removeReadOnlyAttributeName("pwdLastSet");
            ldapJohn.setSingleAttribute("pwdLastSet", "0");
            ctx.getLdapProvider().getLdapIdentityStore().update(ldapJohn);
        });
        Assert.assertEquals((long)0L, (long)this.getPwdLastSetOfJohn());
        UserResource john = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"johnkeycloak");
        UserRepresentation johnRep = john.toRepresentation();
        Assert.assertEquals((Object)UserModel.RequiredAction.UPDATE_PASSWORD.name(), johnRep.getRequiredActions().get(0));
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertThat((Object)this.getPwdLastSetOfJohn(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        johnRep = john.toRepresentation();
        Assert.assertTrue((boolean)johnRep.getRequiredActions().isEmpty());
        john.logout();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void test05UpdatePasswordUnsyncedMode() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.toString());
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        UserResource john = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"johnkeycloak");
        UserRepresentation johnRep = john.toRepresentation();
        johnRep.setRequiredActions(Collections.singletonList(UserModel.RequiredAction.UPDATE_PASSWORD.name()));
        john.update(johnRep);
        long pwdLastSetFromLDAP = this.getPwdLastSetOfJohn();
        Assert.assertThat((Object)pwdLastSetFromLDAP, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertEquals((long)pwdLastSetFromLDAP, (long)this.getPwdLastSetOfJohn());
        johnRep = john.toRepresentation();
        Assert.assertTrue((boolean)johnRep.getRequiredActions().isEmpty());
        john.logout();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.toString());
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
    }

    @Test
    public void test06RegisterNewUser() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "email3@check.cz", "registeruser3", "Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPObject ldapJohn = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johnkeycloak");
            String pwdLastSet = ldapJohn.getAttributeAsString("pwdLastSet");
            Assert.assertTrue((Long.parseLong(pwdLastSet) > 0L ? 1 : 0) != 0);
            String userAccountControl = ldapJohn.getAttributeAsString("userAccountControl");
            long longValue = userAccountControl == null ? 0L : Long.parseLong(userAccountControl);
            Assert.assertFalse((boolean)new UserAccountControl(longValue).has(2L));
        });
        ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"registeruser3").logout();
        this.loginPage.open();
        this.loginPage.login("registeruser3", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void test07DisabledUserInMSADSwitchedToEnabledInKeycloak() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPObject ldapJohn = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johnkeycloak");
            String userAccountControlStr = ldapJohn.getAttributeAsString("userAccountControl");
            UserAccountControl control = new UserAccountControl(Long.parseLong(userAccountControlStr));
            control.add(2L);
            ldapJohn.setSingleAttribute("userAccountControl", String.valueOf(control.getValue()));
            ctx.getLdapProvider().getLdapIdentityStore().update(ldapJohn);
        });
        UserResource john = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"johnkeycloak");
        UserRepresentation johnRep = john.toRepresentation();
        Assert.assertFalse((boolean)johnRep.isEnabled());
        Assert.assertFalse((boolean)this.isJohnEnabledInMSAD());
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)"Account is disabled, contact your administrator.", (Object)this.loginPage.getError());
        johnRep.setEnabled(Boolean.valueOf(true));
        john.update(johnRep);
        Assert.assertTrue((boolean)this.isJohnEnabledInMSAD());
        john.logout();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void test08DisabledUserUnsyncedMode() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.toString());
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        UserResource john = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"johnkeycloak");
        UserRepresentation johnRep = john.toRepresentation();
        johnRep.setEnabled(Boolean.valueOf(false));
        john.update(johnRep);
        Assert.assertTrue((boolean)this.isJohnEnabledInMSAD());
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)"Account is disabled, contact your administrator.", (Object)this.loginPage.getError());
        johnRep.setEnabled(Boolean.valueOf(true));
        john.update(johnRep);
        Assert.assertTrue((boolean)this.isJohnEnabledInMSAD());
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.toString());
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
    }

    private long getPwdLastSetOfJohn() {
        String pwdLastSett = this.testingClient.server().fetchString((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPObject ldapJohn = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johnkeycloak");
            String pwdLastSet = ldapJohn.getAttributeAsString("pwdLastSet");
            return pwdLastSet;
        });
        if (pwdLastSett == null) {
            Assert.fail((String)"LDAP user johnkeycloak does not have pwdLastSet on him");
        }
        return Long.parseLong(pwdLastSett.replace("\"", ""));
    }

    private boolean isJohnEnabledInMSAD() {
        UserAccountControl acControl;
        String userAccountControls = this.testingClient.server().fetchString((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPObject ldapJohn = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johnkeycloak");
            String userAccountControl = ldapJohn.getAttributeAsString("userAccountControl");
            return userAccountControl;
        });
        if (userAccountControls == null) {
            Assert.fail((String)"LDAP user johnkeycloak does not have userAccountControl attribute on him");
        }
        return !(acControl = new UserAccountControl(Long.parseLong(userAccountControls.replace("\"", "")))).has(2L);
    }
}

