/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupMapperConfig;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPGroupMapperTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.testing().ldap("test").prepareGroupsLDAPTest();
    }

    @Test
    public void test01_ldapOnlyGroupMappings() {
        this.test01_ldapOnlyGroupMappings(true);
    }

    protected void test01_ldapOnlyGroupMappings(boolean importEnabled) {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"mode", LDAPGroupMapperMode.LDAP_ONLY.toString()});
            appRealm.updateComponent(mapperModel);
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            john.joinGroup(group1);
            GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
            mary.joinGroup(group11);
            GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
            john.joinGroup(group12);
            mary.joinGroup(group12);
            GroupModel groupWithSlashesInName = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"Team 2016/2017");
            john.joinGroup(groupWithSlashesInName);
            mary.joinGroup(groupWithSlashesInName);
            GroupModel groupChildWithSlashesInName = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"defaultGroup1/Team Child 2018/2019");
            john.joinGroup(groupChildWithSlashesInName);
            mary.joinGroup(groupChildWithSlashesInName);
            Assert.assertEquals((Object)"Team SubChild 2020/2021", (Object)KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"defaultGroup1/Team Child 2018/2019/Team SubChild 2020/2021").getName());
            Assert.assertEquals((Object)"defaultGroup14", (Object)KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"defaultGroup13/Team SubChild 2022/2023/A/B/C/D/E/defaultGroup14").getName());
            Assert.assertEquals((Object)"Team SubChild 2026/2027", (Object)KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"Team Root 2024/2025/A/B/C/D/defaultGroup15/Team SubChild 2026/2027").getName());
        });
        if (importEnabled) {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                UserModel johnDb = session.userLocalStorage().getUserByUsername(appRealm, "johnkeycloak");
                Assert.assertEquals((long)2L, (long)johnDb.getGroupsStream().count());
                Assert.assertEquals((long)2L, (long)johnDb.getGroupsStream("Gr", Integer.valueOf(0), Integer.valueOf(10)).count());
                Assert.assertEquals((long)1L, (long)johnDb.getGroupsStream("Gr", Integer.valueOf(1), Integer.valueOf(10)).count());
                Assert.assertEquals((long)1L, (long)johnDb.getGroupsStream("Gr", Integer.valueOf(0), Integer.valueOf(1)).count());
                Assert.assertEquals((long)1L, (long)johnDb.getGroupsStream("12", Integer.valueOf(0), Integer.valueOf(10)).count());
                long dbGroupCount = johnDb.getGroupsCount();
                Assert.assertEquals((long)2L, (long)dbGroupCount);
            });
        }
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
            GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
            GroupModel groupTeam20162017 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"Team 2016/2017");
            GroupModel groupTeamChild20182019 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"defaultGroup1/Team Child 2018/2019");
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            Set johnGroups = john.getGroupsStream().collect(Collectors.toSet());
            Assert.assertEquals((long)4L, (long)johnGroups.size());
            long groupCount = john.getGroupsCount();
            Assert.assertEquals((long)4L, (long)groupCount);
            Assert.assertTrue((boolean)johnGroups.contains(group1));
            Assert.assertFalse((boolean)johnGroups.contains(group11));
            Assert.assertTrue((boolean)johnGroups.contains(group12));
            Assert.assertTrue((boolean)johnGroups.contains(groupTeam20162017));
            Assert.assertTrue((boolean)johnGroups.contains(groupTeamChild20182019));
            Assert.assertEquals((long)2L, (long)john.getGroupsStream("gr", Integer.valueOf(0), Integer.valueOf(10)).count());
            Assert.assertEquals((long)1L, (long)john.getGroupsStream("gr", Integer.valueOf(1), Integer.valueOf(10)).count());
            Assert.assertEquals((long)1L, (long)john.getGroupsStream("gr", Integer.valueOf(0), Integer.valueOf(1)).count());
            Assert.assertEquals((long)1L, (long)john.getGroupsStream("12", Integer.valueOf(0), Integer.valueOf(10)).count());
            Assert.assertEquals((long)1L, (long)john.getGroupsStream("2017", Integer.valueOf(0), Integer.valueOf(10)).count());
            Assert.assertEquals((long)1L, (long)john.getGroupsStream("2018", Integer.valueOf(0), Integer.valueOf(10)).count());
            List group1Members = session.users().getGroupMembersStream(appRealm, group1, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            List group11Members = session.users().getGroupMembersStream(appRealm, group11, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Stream group12Members = session.users().getGroupMembersStream(appRealm, group12, Integer.valueOf(0), Integer.valueOf(10));
            Stream groupTeam20162017Members = session.users().getGroupMembersStream(appRealm, groupTeam20162017, Integer.valueOf(0), Integer.valueOf(10));
            Stream groupTeam20182019Members = session.users().getGroupMembersStream(appRealm, groupTeamChild20182019, Integer.valueOf(0), Integer.valueOf(10));
            Assert.assertEquals((long)1L, (long)group1Members.size());
            Assert.assertEquals((Object)"johnkeycloak", (Object)((UserModel)group1Members.get(0)).getUsername());
            Assert.assertEquals((long)1L, (long)group11Members.size());
            Assert.assertEquals((Object)"marykeycloak", (Object)((UserModel)group11Members.get(0)).getUsername());
            Assert.assertEquals((long)2L, (long)group12Members.count());
            Assert.assertEquals((long)2L, (long)groupTeam20162017Members.count());
            Assert.assertEquals((long)2L, (long)groupTeam20182019Members.count());
            john.leaveGroup(group1);
            john.leaveGroup(group12);
            john.leaveGroup(groupTeam20162017);
            john.leaveGroup(groupTeamChild20182019);
            mary.leaveGroup(group1);
            mary.leaveGroup(group11);
            mary.leaveGroup(group12);
            mary.leaveGroup(groupTeam20162017);
            mary.leaveGroup(groupTeamChild20182019);
            Assert.assertEquals((long)0L, (long)john.getGroupsStream().count());
            groupCount = john.getGroupsCount();
            Assert.assertEquals((long)0L, (long)groupCount);
        });
    }

    @Test
    public void test02_readOnlyGroupMappings() {
        this.test02_readOnlyGroupMappings(true);
    }

    protected void test02_readOnlyGroupMappings(boolean importEnabled) {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"mode", LDAPGroupMapperMode.READ_ONLY.toString()});
            appRealm.updateComponent(mapperModel);
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject maryLdap = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "marykeycloak");
            groupMapper.addGroupMappingInLDAP(appRealm, group1, maryLdap);
            groupMapper.addGroupMappingInLDAP(appRealm, group11, maryLdap);
        });
        if (importEnabled) {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
                GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
                GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
                GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
                mary.joinGroup(group12);
                Set maryGroups = mary.getGroupsStream().collect(Collectors.toSet());
                Assert.assertEquals((long)5L, (long)maryGroups.size());
                Assert.assertTrue((boolean)maryGroups.contains(group1));
                Assert.assertTrue((boolean)maryGroups.contains(group11));
                Assert.assertTrue((boolean)maryGroups.contains(group12));
                long groupCount = mary.getGroupsCount();
                Assert.assertEquals((long)5L, (long)groupCount);
                Assert.assertEquals((long)5L, (long)mary.getGroupsStream("gr", Integer.valueOf(0), Integer.valueOf(10)).count());
                Assert.assertEquals((long)4L, (long)mary.getGroupsStream("gr", Integer.valueOf(1), Integer.valueOf(10)).count());
                Assert.assertEquals((long)1L, (long)mary.getGroupsStream("gr", Integer.valueOf(0), Integer.valueOf(1)).count());
                Assert.assertEquals((long)2L, (long)mary.getGroupsStream("12", Integer.valueOf(0), Integer.valueOf(10)).count());
            });
        } else {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
                GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
                try {
                    mary.joinGroup(group12);
                    Assert.fail((String)"Not expected to successfully add group12 in no-import mode and READ_ONLY mode of the group mapper");
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            });
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
                GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
                GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
                GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
                Set maryGroups = mary.getGroupsStream().collect(Collectors.toSet());
                Assert.assertEquals((long)4L, (long)maryGroups.size());
                Assert.assertTrue((boolean)maryGroups.contains(group1));
                Assert.assertTrue((boolean)maryGroups.contains(group11));
                Assert.assertFalse((boolean)maryGroups.contains(group12));
                long groupCount = mary.getGroupsCount();
                Assert.assertEquals((long)4L, (long)groupCount);
                Assert.assertEquals((long)4L, (long)mary.getGroupsStream("gr", Integer.valueOf(0), Integer.valueOf(10)).count());
                Assert.assertEquals((long)3L, (long)mary.getGroupsStream("gr", Integer.valueOf(1), Integer.valueOf(10)).count());
                Assert.assertEquals((long)1L, (long)mary.getGroupsStream("gr", Integer.valueOf(0), Integer.valueOf(1)).count());
                Assert.assertEquals((long)1L, (long)mary.getGroupsStream("12", Integer.valueOf(0), Integer.valueOf(10)).count());
            });
        }
        if (importEnabled) {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
                GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
                GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
                UserModel maryDB = session.userLocalStorage().getUserByUsername(appRealm, "marykeycloak");
                Set maryDBGroups = maryDB.getGroupsStream().collect(Collectors.toSet());
                Assert.assertFalse((boolean)maryDBGroups.contains(group1));
                Assert.assertFalse((boolean)maryDBGroups.contains(group11));
                Assert.assertTrue((boolean)maryDBGroups.contains(group12));
                Assert.assertEquals((long)3L, (long)maryDB.getGroupsStream("Gr", Integer.valueOf(0), Integer.valueOf(10)).count());
                Assert.assertEquals((long)2L, (long)maryDB.getGroupsStream("Gr", Integer.valueOf(1), Integer.valueOf(10)).count());
                Assert.assertEquals((long)1L, (long)maryDB.getGroupsStream("Gr", Integer.valueOf(0), Integer.valueOf(1)).count());
                Assert.assertEquals((long)2L, (long)maryDB.getGroupsStream("12", Integer.valueOf(0), Integer.valueOf(10)).count());
                long dbGroupCount = maryDB.getGroupsCount();
                Assert.assertEquals((long)3L, (long)dbGroupCount);
                List group12Members = session.users().getGroupMembersStream(appRealm, group12, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
                Assert.assertEquals((long)1L, (long)group12Members.size());
                Assert.assertEquals((Object)"marykeycloak", (Object)((UserModel)group12Members.get(0)).getUsername());
                UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
                mary.leaveGroup(group12);
            });
        } else {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                LDAPTestContext ctx = LDAPTestContext.init(session);
                RealmModel appRealm = ctx.getRealm();
                GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
                Stream group12Members = session.users().getGroupMembersStream(appRealm, group12, Integer.valueOf(0), Integer.valueOf(10));
                Assert.assertEquals((long)0L, (long)group12Members.count());
            });
        }
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
            GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject maryLdap = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "marykeycloak");
            List group1Members = session.users().getGroupMembersStream(appRealm, group1, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            List group11Members = session.users().getGroupMembersStream(appRealm, group11, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)group1Members.size());
            Assert.assertEquals((Object)"marykeycloak", (Object)((UserModel)group1Members.get(0)).getUsername());
            Assert.assertEquals((long)1L, (long)group11Members.size());
            Assert.assertEquals((Object)"marykeycloak", (Object)((UserModel)group11Members.get(0)).getUsername());
            try {
                mary.leaveGroup(group1);
                Assert.fail((String)"It wasn't expected to successfully delete LDAP group mappings in READ_ONLY mode");
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            LDAPObject ldapGroup = groupMapper.loadLDAPGroupByName("group1");
            groupMapper.deleteGroupMappingInLDAP(maryLdap, ldapGroup);
            ldapGroup = groupMapper.loadLDAPGroupByName("group11");
            groupMapper.deleteGroupMappingInLDAP(maryLdap, ldapGroup);
        });
    }

    @Test
    public void test03_importGroupMappings() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"mode", LDAPGroupMapperMode.IMPORT.toString()});
            appRealm.updateComponent(mapperModel);
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
            GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
            LDAPObject robLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "robkeycloak");
            groupMapper.addGroupMappingInLDAP(appRealm, group11, robLdap);
            groupMapper.addGroupMappingInLDAP(appRealm, group12, robLdap);
            UserModel rob = session.users().getUserByUsername(appRealm, "robkeycloak");
            Set robGroups = rob.getGroupsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)robGroups.contains(group1));
            Assert.assertTrue((boolean)robGroups.contains(group11));
            Assert.assertTrue((boolean)robGroups.contains(group12));
            Assert.assertEquals((long)4L, (long)rob.getGroupsStream("Gr", Integer.valueOf(0), Integer.valueOf(10)).count());
            Assert.assertEquals((long)3L, (long)rob.getGroupsStream("Gr", Integer.valueOf(1), Integer.valueOf(10)).count());
            Assert.assertEquals((long)1L, (long)rob.getGroupsStream("Gr", Integer.valueOf(0), Integer.valueOf(1)).count());
            Assert.assertEquals((long)2L, (long)rob.getGroupsStream("12", Integer.valueOf(0), Integer.valueOf(10)).count());
            long dbGroupCount = rob.getGroupsCount();
            Assert.assertEquals((long)4L, (long)dbGroupCount);
            Stream group1Members = session.users().getGroupMembersStream(appRealm, group1, Integer.valueOf(0), Integer.valueOf(10));
            List group11Members = session.users().getGroupMembersStream(appRealm, group11, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            List group12Members = session.users().getGroupMembersStream(appRealm, group12, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)group1Members.count());
            Assert.assertEquals((long)1L, (long)group11Members.size());
            Assert.assertEquals((Object)"robkeycloak", (Object)((UserModel)group11Members.get(0)).getUsername());
            Assert.assertEquals((long)1L, (long)group12Members.size());
            Assert.assertEquals((Object)"robkeycloak", (Object)((UserModel)group12Members.get(0)).getUsername());
            LDAPObject ldapGroup = groupMapper.loadLDAPGroupByName("group11");
            groupMapper.deleteGroupMappingInLDAP(robLdap, ldapGroup);
            ldapGroup = groupMapper.loadLDAPGroupByName("group12");
            groupMapper.deleteGroupMappingInLDAP(robLdap, ldapGroup);
            robGroups = rob.getGroupsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)robGroups.contains(group11));
            Assert.assertTrue((boolean)robGroups.contains(group12));
            group1Members = session.users().getGroupMembersStream(appRealm, group1, Integer.valueOf(0), Integer.valueOf(10));
            group11Members = session.users().getGroupMembersStream(appRealm, group11, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            group12Members = session.users().getGroupMembersStream(appRealm, group12, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)group1Members.count());
            Assert.assertEquals((long)1L, (long)group11Members.size());
            Assert.assertEquals((Object)"robkeycloak", (Object)((UserModel)group11Members.get(0)).getUsername());
            Assert.assertEquals((long)1L, (long)group12Members.size());
            Assert.assertEquals((Object)"robkeycloak", (Object)((UserModel)group12Members.get(0)).getUsername());
            rob.leaveGroup(group11);
            rob.leaveGroup(group12);
            Assert.assertEquals((long)2L, (long)rob.getGroupsStream().count());
        });
    }

    @Test
    public void test04_groupReferencingNonExistentMember() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"mode", LDAPGroupMapperMode.LDAP_ONLY.toString()});
            appRealm.updateComponent(mapperModel);
            LDAPConfig config = ctx.getLdapProvider().getLdapIdentityStore().getConfig();
            if (config.isActiveDirectory()) {
                return;
            }
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject group2 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group2", (String[])new String[]{descriptionAttrName, "group2 - description"});
            LDAPObject jamesLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "jameskeycloak");
            LDAPUtils.addMember((LDAPStorageProvider)ldapProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group2, (LDAPObject)jamesLdap);
            LDAPDn nonExistentDn = LDAPDn.fromString((String)ldapProvider.getLdapIdentityStore().getConfig().getUsersDn());
            nonExistentDn.addFirst((String)jamesLdap.getRdnAttributeNames().get(0), "nonexistent");
            LDAPObject nonExistentLdapUser = new LDAPObject();
            nonExistentLdapUser.setDn(nonExistentDn);
            LDAPUtils.addMember((LDAPStorageProvider)ldapProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group2, (LDAPObject)nonExistentLdapUser);
            groupMapper.syncDataFromFederationProviderToKeycloak(appRealm);
            GroupModel kcGroup2 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group2");
            List groupUsers = session.users().getGroupMembersStream(appRealm, kcGroup2, Integer.valueOf(0), Integer.valueOf(5)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)groupUsers.size());
            UserModel rob = (UserModel)groupUsers.get(0);
            Assert.assertEquals((Object)"jameskeycloak", (Object)rob.getUsername());
        });
    }

    @Test
    public void test05_getGroupsFromUserMemberOfStrategyTest() throws Exception {
        ComponentRepresentation groupMapperRep = this.findMapperRepByName("groupsMapper");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"streetMapper", (String)"street", (String)"street");
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject ldapGroup = groupMapper.loadLDAPGroupByName("group1");
            String ldapGroupDN = ldapGroup.getDn().toString();
            LDAPObject carlos = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"carloskeycloak", (String)"Carlos", (String)"Doel", (String)"carlos.doel@email.org", (String)ldapGroupDN, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)carlos, (String)"Password1");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"user.roles.retrieve.strategy", "GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE", "memberof.ldap.attribute", "street"});
            appRealm.updateComponent(mapperModel);
        });
        ComponentRepresentation streetMapperRep = this.findMapperRepByName("streetMapper");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel carlos = session.users().getUserByUsername(appRealm, "carloskeycloak");
            Set carlosGroups = carlos.getGroupsStream().collect(Collectors.toSet());
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group11");
            GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group12");
            Assert.assertTrue((boolean)carlosGroups.contains(group1));
            Assert.assertFalse((boolean)carlosGroups.contains(group11));
            Assert.assertFalse((boolean)carlosGroups.contains(group12));
            Assert.assertEquals((long)1L, (long)carlosGroups.size());
        });
        this.testRealm().components().component(streetMapperRep.getId()).remove();
        groupMapperRep.getConfig().putSingle((Object)"user.roles.retrieve.strategy", (Object)"LOAD_GROUPS_BY_MEMBER_ATTRIBUTE");
        this.testRealm().components().component(groupMapperRep.getId()).update(groupMapperRep);
    }

    @Test
    public void test06_addingUserToNewKeycloakGroup() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel group3 = appRealm.createGroup("group3");
            GroupModel group31 = appRealm.createGroup("group31", group3);
            GroupModel group32 = appRealm.createGroup("group32", group3);
            GroupModel group4 = appRealm.createGroup("group4");
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            GroupModel group14 = appRealm.createGroup("group14", group1);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            GroupModel group4 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group4");
            john.joinGroup(group4);
            GroupModel group31 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group3/group31");
            GroupModel group32 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group3/group32");
            john.joinGroup(group31);
            john.joinGroup(group32);
            GroupModel group14 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group14");
            john.joinGroup(group14);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            GroupModel group14 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1/group14");
            GroupModel group3 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group3");
            GroupModel group31 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group3/group31");
            GroupModel group32 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group3/group32");
            GroupModel group4 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group4");
            Set groups = john.getGroupsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)groups.contains(group14));
            Assert.assertFalse((boolean)groups.contains(group3));
            Assert.assertTrue((boolean)groups.contains(group31));
            Assert.assertTrue((boolean)groups.contains(group32));
            Assert.assertTrue((boolean)groups.contains(group4));
            long groupsCount = john.getGroupsCount();
            Assert.assertEquals((long)4L, (long)groupsCount);
            Assert.assertEquals((long)2L, (long)john.getGroupsStream("3", Integer.valueOf(0), Integer.valueOf(10)).count());
            Assert.assertEquals((long)1L, (long)john.getGroupsStream("3", Integer.valueOf(1), Integer.valueOf(10)).count());
            Assert.assertEquals((long)1L, (long)john.getGroupsStream("3", Integer.valueOf(1), Integer.valueOf(1)).count());
            Assert.assertEquals((long)0L, (long)john.getGroupsStream("3", Integer.valueOf(1), Integer.valueOf(0)).count());
            Assert.assertEquals((long)0L, (long)john.getGroupsStream("Keycloak", Integer.valueOf(0), Integer.valueOf(10)).count());
        });
    }

    @Test
    public void test07_newUserDefaultGroupsImportModeTest() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"mode", LDAPGroupMapperMode.IMPORT.toString()});
            appRealm.updateComponent(mapperModel);
            UserModel david = session.users().addUser(appRealm, "davidkeycloak");
            GroupModel defaultGroup11 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/defaultGroup1/defaultGroup11");
            Assert.assertNotNull((Object)defaultGroup11);
            GroupModel defaultGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/defaultGroup1/defaultGroup12");
            Assert.assertNotNull((Object)defaultGroup12);
            GroupModel group31 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group3/group31");
            Assert.assertNotNull((Object)group31);
            GroupModel group32 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group3/group32");
            Assert.assertNotNull((Object)group32);
            GroupModel group4 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group4");
            Assert.assertNotNull((Object)group4);
            Set groups = david.getGroupsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)groups.contains(defaultGroup11));
            Assert.assertTrue((boolean)groups.contains(defaultGroup12));
            Assert.assertFalse((boolean)groups.contains(group31));
            Assert.assertFalse((boolean)groups.contains(group32));
            Assert.assertFalse((boolean)groups.contains(group4));
        });
    }

    private static LDAPObject searchObjectInBase(LDAPStorageProvider ldapProvider, String dn, String ... attrs) {
        LDAPQuery q = new LDAPQuery(ldapProvider).setSearchDn(dn).setSearchScope(0);
        if (attrs != null) {
            for (String attr : attrs) {
                q.addReturningLdapAttribute(attr);
            }
        }
        return q.getFirstResult();
    }

    @Test
    public void test08_ldapOnlyGroupMappingsRanged() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            int membersToTest = 61;
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"mode", LDAPGroupMapperMode.LDAP_ONLY.toString()});
            appRealm.updateComponent(mapperModel);
            LDAPConfig ldapConfig = ctx.getLdapProvider().getLdapIdentityStore().getConfig();
            if (ldapConfig.isActiveDirectory() || "rhds".equals(ldapConfig.getVendor())) {
                return;
            }
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPObject bigGroup = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"biggroup", (String[])new String[]{descriptionAttrName, "biggroup - description"});
            for (int i = 0; i < membersToTest; ++i) {
                String username = String.format("user%02d", i);
                LDAPObject user = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)username, (String)username, (String)username, (String)(username + "@email.org"), null, (String[])new String[]{"1234"});
                LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)bigGroup, (LDAPObject)user);
            }
            GroupMapperConfig config = new GroupMapperConfig(mapperModel);
            bigGroup = LDAPGroupMapperTest.searchObjectInBase(ctx.getLdapProvider(), bigGroup.getDn().toString(), config.getMembershipLdapAttribute());
            Assert.assertNotNull(bigGroup.getAttributes().get(config.getMembershipLdapAttribute()));
            Assert.assertFalse((boolean)bigGroup.isRangeComplete(config.getMembershipLdapAttribute()));
            Assert.assertTrue((membersToTest > bigGroup.getAttributeAsSet(config.getMembershipLdapAttribute()).size() ? 1 : 0) != 0);
            Assert.assertEquals((long)bigGroup.getCurrentRange(config.getMembershipLdapAttribute()), (long)(bigGroup.getAttributeAsSet(config.getMembershipLdapAttribute()).size() - 1));
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            groupMapper.syncDataFromFederationProviderToKeycloak(appRealm);
            GroupModel kcBigGroup = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/biggroup");
            for (int i = 0; i < membersToTest; ++i) {
                UserModel kcUser = session.users().getUserByUsername(appRealm, String.format("user%02d", i));
                Assert.assertTrue((String)("User contains biggroup " + i), (boolean)kcUser.getGroupsStream().collect(Collectors.toSet()).contains(kcBigGroup));
            }
            List groupMembers = session.users().getGroupMembersStream(appRealm, kcBigGroup, Integer.valueOf(0), Integer.valueOf(membersToTest)).collect(Collectors.toList());
            Assert.assertEquals((long)membersToTest, (long)groupMembers.size());
            Set usernames = groupMembers.stream().map(u -> u.getUsername()).collect(Collectors.toSet());
            for (int i = 0; i < membersToTest; ++i) {
                Assert.assertTrue((String)("Group contains user " + i), (boolean)usernames.contains(String.format("user%02d", i)));
            }
        });
    }

    @Test
    public void test09_emptyMemberOnDeletionWorks() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPConfig ldapConfig = ctx.getLdapProvider().getLdapIdentityStore().getConfig();
            if (ldapConfig.isActiveDirectory() || "rhds".equals(ldapConfig.getVendor())) {
                return;
            }
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPObject deleteGroup = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"deletegroup", (String[])new String[]{descriptionAttrName, "deletegroup - description"});
            LDAPObject maryLdap = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "marykeycloak");
            LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)deleteGroup, (LDAPObject)maryLdap);
            LDAPObject empty = new LDAPObject();
            empty.setDn(LDAPDn.fromString((String)"cn=empty-membership-placeholder"));
            LDAPUtils.deleteMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)descriptionAttrName, (LDAPObject)deleteGroup, (LDAPObject)empty);
            deleteGroup = LDAPGroupMapperTest.searchObjectInBase(ctx.getLdapProvider(), deleteGroup.getDn().toString(), "member");
            Assert.assertNotNull((Object)deleteGroup);
            Assert.assertEquals((long)1L, (long)deleteGroup.getAttributeAsSet("member").size());
            Assert.assertEquals((Object)maryLdap.getDn(), (Object)LDAPDn.fromString((String)deleteGroup.getAttributeAsString("member")));
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            groupMapper.syncDataFromFederationProviderToKeycloak(appRealm);
            GroupModel kcDeleteGroup = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/deletegroup");
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            List groupMembers = session.users().getGroupMembersStream(appRealm, kcDeleteGroup, Integer.valueOf(0), Integer.valueOf(5)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)groupMembers.size());
            Assert.assertEquals((Object)"marykeycloak", (Object)((UserModel)groupMembers.get(0)).getUsername());
            Set maryGroups = mary.getGroupsStream().collect(Collectors.toSet());
            Assert.assertEquals((long)1L, (long)maryGroups.size());
            Assert.assertEquals((Object)"deletegroup", (Object)((GroupModel)maryGroups.iterator().next()).getName());
            mary.leaveGroup(kcDeleteGroup);
            deleteGroup = LDAPGroupMapperTest.searchObjectInBase(ctx.getLdapProvider(), deleteGroup.getDn().toString(), "member");
            Assert.assertNotNull((Object)deleteGroup);
            Assert.assertEquals((long)1L, (long)deleteGroup.getAttributeAsSet("member").size());
            Assert.assertEquals((Object)LDAPDn.fromString((String)"cn=empty-membership-placeholder"), (Object)LDAPDn.fromString((String)deleteGroup.getAttributeAsString("member")));
        });
    }
}

