/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPGroupMapperSyncWithGroupsPathTest
extends AbstractLDAPTest {
    private static final String LDAP_GROUPS_PATH = "/Applications/App1";
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            GroupModel parentGroup = appRealm.createGroup("Applications");
            appRealm.createGroup("App1", parentGroup);
            LDAPTestUtils.addOrUpdateGroupMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY, (String)descriptionAttrName, (String[])new String[]{"groups.path", LDAP_GROUPS_PATH});
            LDAPTestUtils.removeAllLDAPGroups((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPObject group1 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group1", (String[])new String[]{descriptionAttrName, "group1 - description"});
            LDAPObject group11 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group11", (String[])new String[0]);
            LDAPObject group12 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group12", (String[])new String[]{descriptionAttrName, "group12 - description"});
            LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)group11);
            LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)group12);
        });
    }

    @Before
    public void before() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            GroupModel groupsPathGroup = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)LDAP_GROUPS_PATH);
            groupsPathGroup.getSubGroupsStream().collect(Collectors.toSet()).forEach(arg_0 -> ((RealmModel)realm).removeGroup(arg_0));
        });
    }

    @Test
    public void test01_syncWithGroupInheritance() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)realm);
            Assert.assertEquals((Object)mapperModel.getConfig().getFirst((Object)"preserve.group.inheritance"), (Object)"true");
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 3, 0, 0, 0);
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1");
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group11"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group12"));
            GroupModel kcGroup11 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group11");
            GroupModel kcGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group12");
            Assert.assertEquals((long)2L, (long)kcGroup1.getSubGroupsStream().count());
            Assert.assertEquals((Object)"group1 - description", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup11.getFirstAttribute(descriptionAttrName));
            Assert.assertEquals((Object)"group12 - description", (Object)kcGroup12.getFirstAttribute(descriptionAttrName));
            LDAPObject group1 = groupMapper.loadLDAPGroupByName("group1");
            group1.setSingleAttribute(descriptionAttrName, "group1 - changed description");
            ldapProvider.getLdapIdentityStore().update(group1);
            LDAPObject group12 = groupMapper.loadLDAPGroupByName("group12");
            group12.setAttribute(descriptionAttrName, null);
            ldapProvider.getLdapIdentityStore().update(group12);
            syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 0, 3, 0, 0);
            kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1");
            kcGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group12");
            Assert.assertEquals((Object)"group1 - changed description", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup12.getFirstAttribute(descriptionAttrName));
        });
    }

    @Test
    public void test02_syncWithDropNonExistingGroups() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            Assert.assertEquals((Object)mapperModel.getConfig().getFirst((Object)"preserve.group.inheritance"), (Object)"true");
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 3, 0, 0, 0);
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1");
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group11"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group12"));
            Assert.assertEquals((long)2L, (long)kcGroup1.getSubGroupsStream().count());
            GroupModel groupsPathGroup = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)LDAP_GROUPS_PATH);
            realm.createGroup("model1", groupsPathGroup);
            realm.createGroup("model2", kcGroup1);
            realm.createGroup("outside");
            syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 0, 3, 0, 0);
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group11"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group12"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/model1"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/model2"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/outside"));
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"drop.non.existing.groups.during.sync", "true"});
            realm.updateComponent(mapperModel);
            syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            Assert.assertEquals((long)3L, (long)syncResult.getUpdated());
            Assert.assertTrue((syncResult.getRemoved() == 2 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group11"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/group12"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/model1"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/Applications/App1/group1/model2"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/outside"));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test03_createConfigurationWithoutGroupPath() throws Exception {
        ComponentRepresentation groupMapperRep = this.findMapperRepByName("groupsMapper");
        groupMapperRep.setId(null);
        groupMapperRep.setName("different");
        groupMapperRep.getConfig().remove((Object)"groups.path");
        groupMapperRep.getConfig().remove((Object)"groups.path");
        Response response = this.adminClient.realm("test").components().add(groupMapperRep);
        String newMapperId = ApiUtil.getCreatedId((Response)response);
        try {
            response.close();
            ComponentRepresentation newMapper = this.adminClient.realm("test").components().component(newMapperId).toRepresentation();
            Assert.assertEquals((Object)"/", (Object)newMapper.getConfig().getFirst((Object)"groups.path"));
        }
        finally {
            this.adminClient.realm("test").components().component(newMapperId).remove();
        }
    }
}

