/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.SynchronizationResultRepresentation;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.group.GroupMapperConfig;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPGroupMapperSyncTest
extends AbstractLDAPTest {
    private static Logger logger = Logger.getLogger(LDAPGroupMapperSyncTest.class);
    public static final String TEST_LDAP_GROUPS_SYNC_LINEAR_TIME_GROUPS_COUNT = "test.ldap.groups.sync.linear.time.groups.count";
    public static final String TEST_LDAP_GROUPS_SYNC_LINEAR_TIME_TEST_PERIOD = "test.ldap.groups.sync.linear.time.test.period";
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPTestUtils.addOrUpdateGroupMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY, (String)descriptionAttrName, (String[])new String[0]);
            LDAPTestUtils.removeAllLDAPGroups((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPObject group1 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group1", (String[])new String[]{descriptionAttrName, "group1 - description"});
            LDAPObject group11 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group11", (String[])new String[0]);
            LDAPObject group12 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group12", (String[])new String[]{descriptionAttrName, "group12 - description"});
            LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)group11);
            LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)group12);
        });
    }

    @Before
    public void before() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            realm.getTopLevelGroupsStream().forEach(arg_0 -> ((RealmModel)realm).removeGroup(arg_0));
        });
    }

    @Test
    public void test01_syncNoPreserveGroupInheritance() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)realm);
            LDAPObject group1 = groupMapper.loadLDAPGroupByName("group1");
            LDAPObject group12 = groupMapper.loadLDAPGroupByName("group12");
            LDAPUtils.addMember((LDAPStorageProvider)ldapProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group12, (LDAPObject)group1);
            try {
                new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
                Assert.fail((String)"Not expected group sync to pass");
            }
            catch (ModelException expected) {
                Assert.assertTrue((boolean)expected.getMessage().contains("Recursion detected"));
            }
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "false"});
            ctx.getRealm().updateComponent(mapperModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)realm);
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1");
            GroupModel kcGroup11 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group11");
            GroupModel kcGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group12");
            Assert.assertEquals((long)0L, (long)kcGroup1.getSubGroupsStream().count());
            Assert.assertEquals((Object)"group1 - description", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup11.getFirstAttribute(descriptionAttrName));
            Assert.assertEquals((Object)"group12 - description", (Object)kcGroup12.getFirstAttribute(descriptionAttrName));
            LDAPObject group1 = groupMapper.loadLDAPGroupByName("group1");
            LDAPObject group12 = groupMapper.loadLDAPGroupByName("group12");
            LDAPUtils.deleteMember((LDAPStorageProvider)ldapProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group12, (LDAPObject)group1);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "true"});
            ctx.getRealm().updateComponent(mapperModel);
        });
    }

    @Test
    public void test02_syncWithGroupInheritance() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)realm);
            Assert.assertEquals((Object)mapperModel.getConfig().getFirst((Object)"preserve.group.inheritance"), (Object)"true");
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 3, 0, 0, 0);
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1");
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group11"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group12"));
            GroupModel kcGroup11 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group11");
            GroupModel kcGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group12");
            Assert.assertEquals((long)2L, (long)kcGroup1.getSubGroupsStream().count());
            Assert.assertEquals((Object)"group1 - description", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup11.getFirstAttribute(descriptionAttrName));
            Assert.assertEquals((Object)"group12 - description", (Object)kcGroup12.getFirstAttribute(descriptionAttrName));
            LDAPObject group1 = groupMapper.loadLDAPGroupByName("group1");
            group1.setSingleAttribute(descriptionAttrName, "group1 - changed description");
            ldapProvider.getLdapIdentityStore().update(group1);
            LDAPObject group12 = groupMapper.loadLDAPGroupByName("group12");
            group12.setAttribute(descriptionAttrName, null);
            ldapProvider.getLdapIdentityStore().update(group12);
            syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 0, 3, 0, 0);
            kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1");
            kcGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group12");
            Assert.assertEquals((Object)"group1 - changed description", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup12.getFirstAttribute(descriptionAttrName));
        });
    }

    @Test
    public void test03_syncWithDropNonExistingGroups() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            Assert.assertEquals((Object)mapperModel.getConfig().getFirst((Object)"preserve.group.inheritance"), (Object)"true");
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 3, 0, 0, 0);
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1");
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group11"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group12"));
            Assert.assertEquals((long)2L, (long)kcGroup1.getSubGroupsStream().count());
            GroupModel model1 = realm.createGroup("model1");
            GroupModel model2 = realm.createGroup("model2", kcGroup1);
            syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 0, 3, 0, 0);
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group11"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group12"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/model1"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/model2"));
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"drop.non.existing.groups.during.sync", "true"});
            realm.updateComponent(mapperModel);
            syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            Assert.assertEquals((long)3L, (long)syncResult.getUpdated());
            Assert.assertTrue((syncResult.getRemoved() == 2 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group11"));
            Assert.assertNotNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group12"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/model1"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/model2"));
        });
    }

    @Test
    public void test04_syncNoPreserveGroupInheritanceWithLazySync() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "false"});
            ctx.getRealm().updateComponent(mapperModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)realm);
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapProvider, (RealmModel)realm);
            LDAPObject johnLdap = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapProvider, (RealmModel)realm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapProvider, (LDAPObject)johnLdap, (String)"Password1");
            GroupMapperConfig groupMapperConfig = new GroupMapperConfig(mapperModel);
            LDAPObject ldapGroup = groupMapper.loadLDAPGroupByName("group11");
            LDAPUtils.addMember((LDAPStorageProvider)ldapProvider, (MembershipType)groupMapperConfig.getMembershipTypeLdapAttribute(), (String)groupMapperConfig.getMembershipLdapAttribute(), (String)groupMapperConfig.getMembershipUserLdapAttribute(ldapProvider.getLdapIdentityStore().getConfig()), (LDAPObject)ldapGroup, (LDAPObject)johnLdap);
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group11"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group12"));
            UserModel john = session.users().getUserByUsername(realm, "johnkeycloak");
            Set johnGroups = john.getGroupsStream().collect(Collectors.toSet());
            GroupModel group1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1");
            GroupModel group11 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group11");
            GroupModel group12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group12");
            Assert.assertNull((Object)group1);
            Assert.assertNotNull((Object)group11);
            Assert.assertNull((Object)group12);
            Assert.assertEquals((long)1L, (long)johnGroups.size());
            Assert.assertTrue((boolean)johnGroups.contains(group11));
            john.leaveGroup(group11);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "true"});
            ctx.getRealm().updateComponent(mapperModel);
        });
    }

    @Test
    public void test05SyncRestAPI() {
        ComponentRepresentation groupMapperRep = this.findMapperRepByName("groupsMapper");
        try {
            SynchronizationResultRepresentation syncResultRep = this.adminClient.realm("test").userStorage().syncMapperData(ldapModelId, groupMapperRep.getId(), "error");
            Assert.fail((String)"Should throw 400");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
    }

    @Ignore(value="This test is not suitable for regular CI testing due to higher time / performance demand")
    @Test
    public void test06_ldapGroupsSyncHasLinearTimeComplexity() throws Exception {
        int GROUPS_COUNT = System.getProperties().containsKey(TEST_LDAP_GROUPS_SYNC_LINEAR_TIME_GROUPS_COUNT) ? Integer.valueOf(System.getProperty(TEST_LDAP_GROUPS_SYNC_LINEAR_TIME_GROUPS_COUNT)) : 30000;
        int TEST_PERIOD = System.getProperties().containsKey(TEST_LDAP_GROUPS_SYNC_LINEAR_TIME_TEST_PERIOD) ? Integer.valueOf(System.getProperty(TEST_LDAP_GROUPS_SYNC_LINEAR_TIME_TEST_PERIOD)) : 1000;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ctx.getLdapModel().put("batchSizeForSync", Integer.toString(1000));
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "false"});
            ctx.getRealm().updateComponent(mapperModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPTestUtils.removeAllLDAPGroups((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            Long elapsedTime = new Long(0L);
            for (int i = 1; i <= GROUPS_COUNT; ++i) {
                LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)String.format("group-%s", i), (String[])new String[]{descriptionAttrName, String.format("Testing group-%s, created at: %s", i, new Date().toString())});
                if (i == 0 || i % TEST_PERIOD != 0) continue;
                elapsedTime = new Date().getTime();
                groupMapper.syncDataFromFederationProviderToKeycloak(appRealm);
                elapsedTime = new Date().getTime() - elapsedTime;
                logger.debugf("Synced %s LDAP groups in %s ms", (Object)i, (Object)elapsedTime);
            }
        });
    }
}

