/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.federation.ldap.LDAPAdminRestApiTest;
import org.keycloak.testsuite.forms.VerifyProfileTest;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.userprofile.config.UPAttribute;
import org.keycloak.userprofile.config.UPAttributePermissions;
import org.keycloak.userprofile.config.UPConfig;
import org.keycloak.util.JsonSerialization;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPAdminRestApiWithUserProfileTest
extends LDAPAdminRestApiTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateReadOnlyAttributeWhenNotSetToUser() throws Exception {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        this.enableSyncRegistration(realmRep, Boolean.FALSE);
        UserRepresentation newUser = UserBuilder.create().username("admintestuser1").password("userpass").addAttribute("foo", "foo-value").enabled(true).build();
        try (Response response = this.testRealm().users().create(newUser);){
            this.enableDynamicUserProfile(realmRep);
            String newUserId = ApiUtil.getCreatedId((Response)response);
            this.getCleanup().addUserId(newUserId);
            UserResource user = this.testRealm().users().get(newUserId);
            UserRepresentation userRep = user.toRepresentation();
            Assert.assertTrue((boolean)userRep.getAttributes().containsKey("LDAP_ID"));
            Assert.assertTrue((boolean)((List)userRep.getAttributes().get("LDAP_ID")).isEmpty());
            userRep.singleAttribute("LDAP_ID", "");
            user.update(userRep);
            userRep.singleAttribute("LDAP_ID", null);
            user.update(userRep);
            try {
                userRep.singleAttribute("LDAP_ID", "should-fail");
                user.update(userRep);
                Assert.fail((String)"Should fail, attribute is read-only");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
        }
        finally {
            VerifyProfileTest.disableDynamicUserProfile(this.testRealm());
            this.enableSyncRegistration(realmRep, Boolean.TRUE);
        }
    }

    private void enableDynamicUserProfile(RealmRepresentation realmRep) throws IOException {
        VerifyProfileTest.enableDynamicUserProfile(realmRep);
        this.testRealm().update(realmRep);
        UPConfig upConfig = (UPConfig)JsonSerialization.readValue((String)this.testRealm().users().userProfile().getConfiguration(), UPConfig.class);
        UPAttribute attribute = new UPAttribute();
        attribute.setName("LDAP_ID");
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setView(Collections.singleton("admin"));
        attribute.setPermissions(permissions);
        upConfig.addAttribute(attribute);
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), JsonSerialization.writeValueAsString((Object)upConfig));
    }

    private void enableSyncRegistration(RealmRepresentation realmRep, Boolean aFalse) {
        ComponentRepresentation ldapStorage = (ComponentRepresentation)this.testRealm().components().query(realmRep.getRealm(), UserStorageProvider.class.getName()).get(0);
        ldapStorage.getConfig().put((Object)"syncRegistrations", Collections.singletonList(aFalse.toString()));
        this.testRealm().components().component(ldapStorage.getId()).update(ldapStorage);
    }
}

