/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.keycloak.testsuite.util.UserBuilder;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPAdminRestApiTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"marykeycloak", (String)"mary@test.com", (String)"password-app");
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)john, (String)"Password1");
        });
    }

    @Test
    public void createUserWithAdminRest() throws Exception {
        UserRepresentation user1 = UserBuilder.create().username("admintestuser1").password("userpass").enabled(true).build();
        String newUserId1 = this.createUserExpectSuccess(user1);
        this.getCleanup().addUserId(newUserId1);
        UserRepresentation user2 = UserBuilder.create().username("admintestuser2").password("userpass").email("admintestuser2@keycloak.org").firstName("Some").lastName("OtherUser").enabled(true).build();
        String newUserId2 = this.createUserExpectSuccess(user2);
        this.getCleanup().addUserId(newUserId2);
        UserRepresentation user3 = UserBuilder.create().username("admintestuser3").password("userpass").addAttribute("LDAP_ID", "123456").enabled(true).build();
        this.createUserExpectError(user3);
        UserRepresentation user4 = UserBuilder.create().username("admintestuser4").password("userpass").addAttribute("LDAP_ENTRY_DN", "ou=users,dc=foo").enabled(true).build();
        this.createUserExpectError(user4);
    }

    @Test
    public void updateUserWithAdminRest() throws Exception {
        UserResource userRes = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"johnkeycloak");
        UserRepresentation user = userRes.toRepresentation();
        ArrayList origLdapId = new ArrayList((Collection)user.getAttributes().get("LDAP_ID"));
        ArrayList origLdapEntryDn = new ArrayList((Collection)user.getAttributes().get("LDAP_ENTRY_DN"));
        Assert.assertEquals((long)1L, (long)origLdapId.size());
        Assert.assertEquals((long)1L, (long)origLdapEntryDn.size());
        Assert.assertThat(user.getAttributes().keySet(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"KERBEROS_PRINCIPAL"})));
        user.setFirstName("JohnUpdated");
        user.setLastName("DoeUpdated");
        user.singleAttribute("KERBEROS_PRINCIPAL", "foo");
        this.updateUserExpectError(userRes, user);
        user.getAttributes().remove("KERBEROS_PRINCIPAL");
        user.singleAttribute("KERberos_principal", "foo");
        this.updateUserExpectError(userRes, user);
        user.getAttributes().remove("KERberos_principal");
        ((List)user.getAttributes().get("LDAP_ID")).remove(0);
        ((List)user.getAttributes().get("LDAP_ID")).add("123");
        this.updateUserExpectError(userRes, user);
        ((List)user.getAttributes().get("LDAP_ID")).remove(0);
        this.updateUserExpectError(userRes, user);
        user.getAttributes().remove("LDAP_ID");
        userRes.update(user);
        user = userRes.toRepresentation();
        Assert.assertEquals(origLdapId, user.getAttributes().get("LDAP_ID"));
        user.getAttributes().put("LDAP_ID", origLdapId);
        ((List)user.getAttributes().get("LDAP_ENTRY_DN")).remove(0);
        ((List)user.getAttributes().get("LDAP_ENTRY_DN")).add("ou=foo,dc=bar");
        this.updateUserExpectError(userRes, user);
        user.getAttributes().put("LDAP_ENTRY_DN", origLdapEntryDn);
        userRes.update(user);
        user = userRes.toRepresentation();
        Assert.assertEquals((Object)"JohnUpdated", (Object)user.getFirstName());
        Assert.assertEquals((Object)"DoeUpdated", (Object)user.getLastName());
        Assert.assertEquals(origLdapId, user.getAttributes().get("LDAP_ID"));
        Assert.assertEquals(origLdapEntryDn, user.getAttributes().get("LDAP_ENTRY_DN"));
        user.setFirstName("John");
        user.setLastName("Doe");
        userRes.update(user);
    }

    private String createUserExpectSuccess(UserRepresentation user) {
        Response response = this.testRealm().users().create(user);
        String newUserId = ApiUtil.getCreatedId((Response)response);
        response.close();
        UserRepresentation userRep = this.testRealm().users().get(newUserId).toRepresentation();
        userRep.getAttributes().containsKey("LDAP_ID");
        userRep.getAttributes().containsKey("LDAP_ENTRY_DN");
        return newUserId;
    }

    private void createUserExpectError(UserRepresentation user) {
        Response response = this.testRealm().users().create(user);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    private void updateUserExpectError(UserResource userRes, UserRepresentation user) {
        try {
            userRes.update(user);
            Assert.fail((String)"Not expected to successfully update user");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
    }
}

