/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.account.AccountCredentialResource;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.keycloak.testsuite.util.TokenUtil;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPAccountRestApiTest
extends AbstractLDAPTest {
    @Rule
    public TokenUtil tokenUtil = new TokenUtil("johnkeycloak", "Password1");
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();
    protected CloseableHttpClient httpClient;

    @Before
    public void before() {
        this.httpClient = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)john, (String)"Password1");
        });
    }

    @Test
    public void testGetProfile() throws IOException {
        org.keycloak.representations.account.UserRepresentation user = this.getProfile();
        Assert.assertEquals((Object)"John", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)user.getLastName());
        Assert.assertEquals((Object)"john@email.org", (Object)user.getEmail());
        Assert.assertFalse((boolean)user.isEmailVerified());
    }

    @Test
    public void testUpdateProfile() throws IOException {
        org.keycloak.representations.account.UserRepresentation user = this.getProfile();
        ArrayList origLdapId = new ArrayList((Collection)user.getAttributes().get("LDAP_ID"));
        ArrayList origLdapEntryDn = new ArrayList((Collection)user.getAttributes().get("LDAP_ENTRY_DN"));
        Assert.assertEquals((long)1L, (long)origLdapId.size());
        Assert.assertEquals((long)1L, (long)origLdapEntryDn.size());
        Assert.assertThat(user.getAttributes().keySet(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"KERBEROS_PRINCIPAL"})));
        user.setFirstName("JohnUpdated");
        user.setLastName("DoeUpdated");
        user.singleAttribute("KERBEROS_PRINCIPAL", "foo");
        this.updateProfileExpectError(user, 400, "updateReadOnlyAttributesRejectedMessage");
        user.getAttributes().remove("KERBEROS_PRINCIPAL");
        user.singleAttribute("KERberos_principal", "foo");
        this.updateProfileExpectError(user, 400, "updateReadOnlyAttributesRejectedMessage");
        user.getAttributes().remove("KERberos_principal");
        user.setFirstName("JohnUpdated");
        user.setLastName("DoeUpdated");
        ((List)user.getAttributes().get("LDAP_ID")).remove(0);
        ((List)user.getAttributes().get("LDAP_ID")).add("123");
        this.updateProfileExpectError(user, 400, "updateReadOnlyAttributesRejectedMessage");
        ((List)user.getAttributes().get("LDAP_ID")).remove(0);
        this.updateProfileExpectError(user, 400, "updateReadOnlyAttributesRejectedMessage");
        user.getAttributes().remove("LDAP_ID");
        this.updateProfileExpectSuccess(user);
        user = this.getProfile();
        Assert.assertFalse((boolean)((List)user.getAttributes().get("LDAP_ID")).isEmpty());
        user.getAttributes().put("LDAP_ID", origLdapId);
        ((List)user.getAttributes().get("LDAP_ENTRY_DN")).remove(0);
        ((List)user.getAttributes().get("LDAP_ENTRY_DN")).add("ou=foo,dc=bar");
        this.updateProfileExpectError(user, 400, "updateReadOnlyAttributesRejectedMessage");
        user.getAttributes().put("LDAP_ENTRY_DN", origLdapEntryDn);
        this.updateProfileExpectSuccess(user);
        user = this.getProfile();
        Assert.assertEquals((Object)"JohnUpdated", (Object)user.getFirstName());
        Assert.assertEquals((Object)"DoeUpdated", (Object)user.getLastName());
        Assert.assertEquals(origLdapId, user.getAttributes().get("LDAP_ID"));
        Assert.assertEquals(origLdapEntryDn, user.getAttributes().get("LDAP_ENTRY_DN"));
        user.setFirstName("John");
        user.setLastName("Doe");
        this.updateProfileExpectSuccess(user);
    }

    @Test
    public void testGetCredentials() throws IOException {
        List<AccountCredentialResource.CredentialContainer> credentials = this.getCredentials();
        AccountCredentialResource.CredentialContainer password = credentials.get(0);
        Assert.assertEquals((Object)"password", (Object)password.getType());
        Assert.assertEquals((long)1L, (long)password.getUserCredentials().size());
        CredentialRepresentation userPassword = (CredentialRepresentation)password.getUserCredentials().get(0);
        Assert.assertEquals((Object)"password", (Object)userPassword.getType());
        Assert.assertEquals((Object)userPassword.getCreatedDate(), (Object)new Long(-1L));
        Assert.assertNull((Object)userPassword.getCredentialData());
        Assert.assertNull((Object)userPassword.getSecretData());
    }

    @Test
    public void testUpdateProfileSimple() throws IOException {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            appRealm.setEditUsernameAllowed(false);
        });
        org.keycloak.representations.account.UserRepresentation user = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        user.setEmail("john-alias@email.org");
        SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).json((Object)user).auth(this.tokenUtil.getToken()).asStatus();
        org.keycloak.representations.account.UserRepresentation usernew = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        Assert.assertEquals((Object)"johnkeycloak", (Object)usernew.getUsername());
        Assert.assertEquals((Object)"John", (Object)usernew.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)usernew.getLastName());
        Assert.assertEquals((Object)"john-alias@email.org", (Object)usernew.getEmail());
        Assert.assertFalse((boolean)usernew.isEmailVerified());
        usernew.setEmail("john@email.org");
        SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).json((Object)usernew).auth(this.tokenUtil.getToken()).asStatus();
    }

    @Test
    public void testIgnoreReadOnlyAttributes() throws IOException {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            appRealm.setEditUsernameAllowed(false);
        });
        org.keycloak.representations.account.UserRepresentation user = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        user.setEmail("john-alias@email.org");
        SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).json((Object)user).auth(this.tokenUtil.getToken()).asStatus();
        org.keycloak.representations.account.UserRepresentation usernew = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        Assert.assertEquals((Object)"johnkeycloak", (Object)usernew.getUsername());
        Assert.assertEquals((Object)"John", (Object)usernew.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)usernew.getLastName());
        Assert.assertEquals((Object)"john-alias@email.org", (Object)usernew.getEmail());
        Assert.assertFalse((boolean)usernew.isEmailVerified());
        usernew.getAttributes().clear();
        usernew.setEmail("john@email.org");
        int i = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).json((Object)usernew).auth(this.tokenUtil.getToken()).asStatus();
        UserRepresentation userRep = (UserRepresentation)this.testRealm().users().search(usernew.getUsername()).get(0);
        userRep.setAttributes(null);
        this.testRealm().users().get(userRep.getId()).update(userRep);
        usernew = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        Assert.assertTrue((boolean)usernew.getAttributes().containsKey("LDAP_ID"));
        Assert.assertTrue((boolean)usernew.getAttributes().containsKey("LDAP_ENTRY_DN"));
    }

    private String getAccountUrl(String resource) {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/realms/test/account" + (resource != null ? "/" + resource : "");
    }

    private org.keycloak.representations.account.UserRepresentation getProfile() throws IOException {
        return (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
    }

    private void updateProfileExpectSuccess(org.keycloak.representations.account.UserRepresentation user) throws IOException {
        int status = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asStatus();
        Assert.assertEquals((long)204L, (long)status);
    }

    private void updateProfileExpectError(org.keycloak.representations.account.UserRepresentation user, int expectedStatus, String expectedMessage) throws IOException {
        SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        Assert.assertEquals((Object)expectedMessage, (Object)((ErrorRepresentation)response.asJson(ErrorRepresentation.class)).getErrorMessage());
    }

    private List<AccountCredentialResource.CredentialContainer> getCredentials() throws IOException {
        return (List)SimpleHttp.doGet((String)this.getAccountUrl("credentials"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<List<AccountCredentialResource.CredentialContainer>>(){});
    }
}

