/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.util.Map;
import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AccountPasswordPage;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.LDAPRule;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public abstract class AbstractLDAPTest
extends AbstractTestRealmKeycloakTest {
    static final String TEST_REALM_NAME = "test";
    protected static String ldapModelId;
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected AccountPasswordPage changePasswordPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected LoginPasswordUpdatePage requiredActionChangePasswordPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Override
    public void importTestRealms() {
        super.importTestRealms();
        this.log.infof("Test realms imported", new Object[0]);
        this.createLDAPProvider();
        this.afterImportTestRealm();
    }

    protected void createLDAPProvider() {
        Map cfg = this.getLDAPRule().getConfig();
        ldapModelId = this.testingClient.testing().ldap(TEST_REALM_NAME).createLDAPProvider(cfg, this.isImportEnabled());
        this.log.infof("LDAP Provider created", new Object[0]);
    }

    protected boolean isImportEnabled() {
        return true;
    }

    protected abstract void afterImportTestRealm();

    protected abstract LDAPRule getLDAPRule();

    protected ComponentRepresentation findMapperRepByName(String name) {
        return this.testRealm().components().query(ldapModelId, LDAPStorageMapper.class.getName()).stream().filter(mapper -> mapper.getName().equals(name)).findAny().orElse(null);
    }
}

