/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.kerberos;

import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.KerberosConfig;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.federation.kerberos.AbstractKerberosSingleRealmTest;
import org.keycloak.testsuite.util.KerberosRule;

public class KerberosStandaloneTest
extends AbstractKerberosSingleRealmTest {
    private static final String PROVIDER_CONFIG_LOCATION = "classpath:kerberos/kerberos-standalone-connection.properties";
    @ClassRule
    public static KerberosRule kerberosRule = new KerberosRule("classpath:kerberos/kerberos-standalone-connection.properties", "KEYCLOAK.ORG");

    @Override
    protected KerberosRule getKerberosRule() {
        return kerberosRule;
    }

    @Override
    protected CommonKerberosConfig getKerberosConfig() {
        return new KerberosConfig(this.getUserStorageConfiguration());
    }

    @Override
    protected ComponentRepresentation getUserStorageConfiguration() {
        return this.getUserStorageConfiguration("kerberos-standalone", "kerberos");
    }

    @Test
    public void spnegoLoginTest() throws Exception {
        this.assertSuccessfulSpnegoLogin("hnelson", "hnelson", "secret");
        this.assertUser("hnelson", "hnelson@" + ((String)kerberosRule.getConfig().get("kerberosRealm")).toLowerCase(), null, null, false);
    }

    @Test
    public void updateProfileEnabledTest() throws Exception {
        List reps = this.testRealmResource().components().query("test", UserStorageProvider.class.getName());
        Assert.assertEquals((long)1L, (long)reps.size());
        ComponentRepresentation kerberosProvider = (ComponentRepresentation)reps.get(0);
        kerberosProvider.getConfig().putSingle((Object)"updateProfileFirstLogin", (Object)"true");
        this.testRealmResource().components().component(kerberosProvider.getId()).update(kerberosProvider);
        Response spnegoResponse = this.spnegoLogin("hnelson", "secret");
        org.junit.Assert.assertEquals((long)200L, (long)spnegoResponse.getStatus());
        String responseText = (String)spnegoResponse.readEntity(String.class);
        org.junit.Assert.assertTrue((boolean)responseText.contains("You need to update your user profile to activate your account."));
        org.junit.Assert.assertTrue((boolean)responseText.contains("hnelson@" + ((String)kerberosRule.getConfig().get("kerberosRealm")).toLowerCase()));
        spnegoResponse.close();
        this.assertUser("hnelson", "hnelson@" + ((String)kerberosRule.getConfig().get("kerberosRealm")).toLowerCase(), null, null, true);
        kerberosProvider.getConfig().putSingle((Object)"updateProfileFirstLogin", (Object)"false");
        this.testRealmResource().components().component(kerberosProvider.getId()).update(kerberosProvider);
    }

    @Test
    public void noProvider() throws Exception {
        List reps = this.testRealmResource().components().query("test", UserStorageProvider.class.getName());
        Assert.assertEquals((long)1L, (long)reps.size());
        ComponentRepresentation kerberosProvider = (ComponentRepresentation)reps.get(0);
        this.testRealmResource().components().component(kerberosProvider.getId()).remove();
        Response spnegoResponse = this.spnegoLogin("hnelson", "secret");
        String context = (String)spnegoResponse.readEntity(String.class);
        spnegoResponse.close();
        org.junit.Assert.assertTrue((boolean)context.contains("Sign in to test"));
        String url = ActionURIUtils.getActionURIFromPageSource((String)context);
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"username", (Object)"test-user@localhost");
        params.putSingle((Object)"password", (Object)"password");
        Response response = this.client.target(url).request().post(Entity.form((MultivaluedMap)params));
        URI redirectUri = response.getLocation();
        this.assertAuthenticationSuccess(redirectUri.toString());
        this.events.clear();
        this.testRealmResource().components().add(kerberosProvider);
    }

    @Test
    @UncaughtServerErrorExpected
    public void handleUnknownKerberosRealm() throws Exception {
        List reps = this.testRealmResource().components().query("test", UserStorageProvider.class.getName());
        Assert.assertEquals((long)1L, (long)reps.size());
        ComponentRepresentation kerberosProvider = (ComponentRepresentation)reps.get(0);
        kerberosProvider.getConfig().putSingle((Object)"kerberosRealm", (Object)"unavailable");
        this.testRealmResource().components().component(kerberosProvider.getId()).update(kerberosProvider);
        UserRepresentation john = new UserRepresentation();
        john.setUsername("john");
        Response response = this.testRealmResource().users().create(john);
        org.junit.Assert.assertEquals((long)500L, (long)response.getStatus());
        response.close();
    }
}

