/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.kerberos;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.federation.kerberos.AbstractKerberosSingleRealmTest;
import org.keycloak.testsuite.util.KerberosRule;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class KerberosLdapTest
extends AbstractKerberosSingleRealmTest {
    private static final String PROVIDER_CONFIG_LOCATION = "classpath:kerberos/kerberos-ldap-connection.properties";
    @ClassRule
    public static KerberosRule kerberosRule = new KerberosRule("classpath:kerberos/kerberos-ldap-connection.properties", "KEYCLOAK.ORG");

    @Override
    protected KerberosRule getKerberosRule() {
        return kerberosRule;
    }

    @Override
    protected CommonKerberosConfig getKerberosConfig() {
        return new LDAPProviderKerberosConfig(this.getUserStorageConfiguration());
    }

    @Override
    protected ComponentRepresentation getUserStorageConfiguration() {
        return this.getUserStorageConfiguration("kerberos-ldap", "ldap");
    }

    @Test
    public void spnegoLoginTest() throws Exception {
        this.assertSuccessfulSpnegoLogin("hnelson", "hnelson", "secret");
        this.assertUser("hnelson", "hnelson@keycloak.org", "Horatio", "Nelson", false);
    }

    @Test
    public void testClientOverrideFlowUsingBrowserHttpChallenge() throws Exception {
        List executions = this.testRealmResource().flows().getExecutions("http challenge");
        for (AuthenticationExecutionInfoRepresentation execution : executions) {
            if ("basic-auth".equals(execution.getProviderId())) {
                execution.setRequirement("ALTERNATIVE");
                this.testRealmResource().flows().updateExecutions("http challenge", execution);
            }
            if (!"auth-spnego".equals(execution.getProviderId())) continue;
            execution.setRequirement("ALTERNATIVE");
            this.testRealmResource().flows().updateExecutions("http challenge", execution);
        }
        HashMap<String, String> flows = new HashMap<String, String>();
        AuthenticationFlowRepresentation flow = this.testRealmResource().flows().getFlows().stream().filter(flowRep -> flowRep.getAlias().equalsIgnoreCase("http challenge")).findAny().get();
        flows.put("browser", flow.getId());
        ClientRepresentation client = (ClientRepresentation)this.testRealmResource().clients().findByClientId("kerberos-app-challenge").get(0);
        client.setAuthenticationFlowBindingOverrides(flows);
        this.testRealmResource().clients().get(client.getId()).update(client);
        this.assertSuccessfulSpnegoLogin(client.getClientId(), "hnelson", "hnelson", "secret");
    }

    @Test
    public void validatePasswordPolicyTest() throws Exception {
        this.updateProviderEditMode(UserStorageProvider.EditMode.WRITABLE);
        this.changePasswordPage.open();
        this.loginPage.login("jduke", "theduke");
        this.updateProviderValidatePasswordPolicy(true);
        this.changePasswordPage.changePassword("theduke", "jduke", "jduke");
        org.junit.Assert.assertTrue((boolean)this.driver.getPageSource().contains("Invalid"));
        this.updateProviderValidatePasswordPolicy(false);
        this.changePasswordPage.changePassword("theduke", "jduke", "jduke");
        org.junit.Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your password has been updated."));
        this.changePasswordPage.open();
        this.changePasswordPage.changePassword("jduke", "theduke", "theduke");
    }

    @Test
    public void writableEditModeTest() throws Exception {
        this.updateProviderEditMode(UserStorageProvider.EditMode.WRITABLE);
        this.changePasswordPage.open();
        this.loginPage.assertCurrent();
        this.loginPage.login("jduke", "theduke");
        org.junit.Assert.assertTrue((boolean)this.changePasswordPage.isCurrent());
        this.changePasswordPage.changePassword("theduke", "newPass", "newPass");
        org.junit.Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your password has been updated."));
        this.changePasswordPage.logout();
        this.loginPage.login("jduke", "theduke");
        org.junit.Assert.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.login("jduke", "newPass");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.logout();
        this.events.clear();
        Response spnegoResponse = this.spnegoLogin("jduke", "newPass");
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        List users = this.testRealmResource().users().search("jduke", Integer.valueOf(0), Integer.valueOf(1));
        String userId = ((UserRepresentation)users.get(0)).getId();
        this.events.expectLogin().client("kerberos-app").user(userId).detail("username", "jduke").assertEvent();
        String codeUrl = spnegoResponse.getLocation().toString();
        this.assertAuthenticationSuccess(codeUrl);
        this.changePasswordPage.open();
        this.loginPage.login("jduke", "newPass");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.changePassword("newPass", "theduke", "theduke");
    }
}

