/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.kerberos;

import java.net.URI;
import java.security.Principal;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.ws.rs.core.Response;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.ietf.jgss.GSSCredential;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.federation.kerberos.KeycloakSPNegoSchemeFactory;
import org.keycloak.testsuite.pages.AccountPasswordPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.KerberosRule;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public abstract class AbstractKerberosTest
extends AbstractAuthTest {
    protected KeycloakSPNegoSchemeFactory spnegoSchemeFactory;
    protected ResteasyClient client;
    @Page
    protected LoginPage loginPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AccountPasswordPage changePasswordPage;

    protected abstract KerberosRule getKerberosRule();

    protected abstract CommonKerberosConfig getKerberosConfig();

    protected abstract ComponentRepresentation getUserStorageConfiguration();

    protected ComponentRepresentation getUserStorageConfiguration(String providerName, String providerId) {
        Map kerberosConfig = this.getKerberosRule().getConfig();
        MultivaluedHashMap<String, String> config = AbstractKerberosTest.toComponentConfig(kerberosConfig);
        UserStorageProviderModel model = new UserStorageProviderModel();
        model.setLastSync(0);
        model.setChangedSyncPeriod(-1);
        model.setFullSyncPeriod(-1);
        model.setName(providerName);
        model.setPriority(0);
        model.setProviderId(providerId);
        model.setConfig(config);
        ComponentRepresentation rep = ModelToRepresentation.toRepresentationWithoutConfig((ComponentModel)model);
        return rep;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRep = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/kerberos/kerberosrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRep);
    }

    @Override
    public RealmResource testRealmResource() {
        return this.adminClient.realm("test");
    }

    @Override
    @Before
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.testRealmPage.setAuthRealm("test");
        this.changePasswordPage.realm("test");
        this.getKerberosRule().setKrb5ConfPath(this.testingClient.testing());
        this.spnegoSchemeFactory = new KeycloakSPNegoSchemeFactory(this.getKerberosConfig());
        this.initHttpClient(true);
        this.removeAllUsers();
        this.oauth.clientId("kerberos-app");
        ComponentRepresentation rep = this.getUserStorageConfiguration();
        Response resp = this.testRealmResource().components().add(rep);
        this.getCleanup().addComponentId(ApiUtil.getCreatedId((Response)resp));
        resp.close();
    }

    @Override
    @After
    public void afterAbstractKeycloakTest() throws Exception {
        this.cleanupApacheHttpClient();
        super.afterAbstractKeycloakTest();
    }

    private void cleanupApacheHttpClient() {
        this.client.close();
        this.client = null;
    }

    protected AccessToken assertSuccessfulSpnegoLogin(String loginUsername, String expectedUsername, String password) throws Exception {
        return this.assertSuccessfulSpnegoLogin("kerberos-app", loginUsername, expectedUsername, password);
    }

    protected AccessToken assertSuccessfulSpnegoLogin(String clientId, String loginUsername, String expectedUsername, String password) throws Exception {
        this.oauth.clientId(clientId);
        Response spnegoResponse = this.spnegoLogin(loginUsername, password);
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        List users = this.testRealmResource().users().search(expectedUsername, Integer.valueOf(0), Integer.valueOf(1));
        String userId = ((UserRepresentation)users.get(0)).getId();
        this.events.expectLogin().client(clientId).user(userId).detail("username", expectedUsername).assertEvent();
        String codeUrl = spnegoResponse.getLocation().toString();
        OAuthClient.AccessTokenResponse tokenResponse = this.assertAuthenticationSuccess(codeUrl);
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        Assert.assertEquals((Object)userId, (Object)token.getSubject());
        Assert.assertEquals((Object)expectedUsername, (Object)token.getPreferredUsername());
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String invokeLdap(GSSCredential gssCredential, String username) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:10389");
        if (gssCredential != null) {
            env.put("java.naming.security.authentication", "GSSAPI");
            env.put("javax.security.sasl.credentials", gssCredential);
        }
        try (InitialDirContext ctx = new InitialDirContext(env);){
            Attributes attrs = ctx.getAttributes("uid=" + username + ",ou=People,dc=keycloak,dc=org");
            String cn = (String)attrs.get("cn").get();
            String sn = (String)attrs.get("sn").get();
            String string = cn + " " + sn;
            return string;
        }
    }

    protected Response spnegoLogin(String username, String password) {
        String kcLoginPageLocation = this.oauth.getLoginFormUrl();
        this.spnegoSchemeFactory.setCredentials(username, password);
        Response response = this.client.target(kcLoginPageLocation).request().get();
        if (response.getStatus() == 302) {
            if (response.getLocation() == null) {
                return response;
            }
            String uri = response.getLocation().toString();
            if (uri.contains("login-actions/required-action") || uri.contains("auth_session_id")) {
                response = this.client.target(uri).request().get();
            }
        }
        return response;
    }

    protected void initHttpClient(boolean useSpnego) {
        if (this.client != null) {
            this.cleanupApacheHttpClient();
        }
        DefaultHttpClient httpClient = (DefaultHttpClient)new HttpClientBuilder().disableCookieCache(false).build();
        httpClient.getAuthSchemes().register("Negotiate", (AuthSchemeFactory)this.spnegoSchemeFactory);
        if (useSpnego) {
            Credentials fake = new Credentials(){

                public String getPassword() {
                    return null;
                }

                public Principal getUserPrincipal() {
                    return null;
                }
            };
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), fake);
        }
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        this.client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
    }

    protected void removeAllUsers() {
        RealmResource realm = this.testRealmResource();
        List users = realm.users().search("", Integer.valueOf(0), Integer.valueOf(-1));
        for (UserRepresentation user : users) {
            if (user.getUsername().equals("test-user@localhost")) continue;
            realm.users().get(user.getId()).remove();
        }
        Assert.assertEquals((long)1L, (long)realm.users().search("", Integer.valueOf(0), Integer.valueOf(-1)).size());
    }

    protected void assertUser(String expectedUsername, String expectedEmail, String expectedFirstname, String expectedLastname, boolean updateProfileActionExpected) {
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)expectedUsername);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)expectedEmail, (Object)user.getEmail());
        Assert.assertEquals((Object)expectedFirstname, (Object)user.getFirstName());
        Assert.assertEquals((Object)expectedLastname, (Object)user.getLastName());
        if (updateProfileActionExpected) {
            Assert.assertEquals((Object)UserModel.RequiredAction.UPDATE_PROFILE.toString(), user.getRequiredActions().iterator().next());
        } else {
            Assert.assertTrue((boolean)user.getRequiredActions().isEmpty());
        }
    }

    protected OAuthClient.AccessTokenResponse assertAuthenticationSuccess(String codeUrl) throws Exception {
        List pairs = URLEncodedUtils.parse((URI)new URI(codeUrl), (String)"UTF-8");
        String code = null;
        String state = null;
        for (NameValuePair pair : pairs) {
            if (pair.getName().equals("code")) {
                code = pair.getValue();
                continue;
            }
            if (!pair.getName().equals("state")) continue;
            state = pair.getValue();
        }
        Assert.assertNotNull(code);
        Assert.assertNotNull(state);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertNotNull((Object)response.getAccessToken());
        this.events.clear();
        return response;
    }

    protected void updateProviderEditMode(UserStorageProvider.EditMode editMode) {
        this.updateUserStorageProvider(kerberosProvider -> kerberosProvider.getConfig().putSingle((Object)"editMode", (Object)editMode.toString()));
    }

    protected void updateProviderValidatePasswordPolicy(Boolean validatePasswordPolicy) {
        this.updateUserStorageProvider(kerberosProvider -> kerberosProvider.getConfig().putSingle((Object)"validatePasswordPolicy", (Object)validatePasswordPolicy.toString()));
    }

    protected void updateUserStorageProvider(Consumer<ComponentRepresentation> updater) {
        List reps = this.testRealmResource().components().query("test", UserStorageProvider.class.getName());
        Assert.assertEquals((long)1L, (long)reps.size());
        ComponentRepresentation kerberosProvider = (ComponentRepresentation)reps.get(0);
        updater.accept(kerberosProvider);
        this.testRealmResource().components().component(kerberosProvider.getId()).update(kerberosProvider);
    }

    protected AuthenticationExecutionModel.Requirement updateKerberosAuthExecutionRequirement(AuthenticationExecutionModel.Requirement requirement) {
        return AbstractKerberosTest.updateKerberosAuthExecutionRequirement(requirement, this.testRealmResource());
    }

    public static AuthenticationExecutionModel.Requirement updateKerberosAuthExecutionRequirement(AuthenticationExecutionModel.Requirement requirement, RealmResource realmResource) {
        Optional<AuthenticationExecutionInfoRepresentation> kerberosAuthExecutionOpt = realmResource.flows().getExecutions("browser").stream().filter(e -> e.getProviderId().equals("auth-spnego")).findFirst();
        Assert.assertTrue((boolean)kerberosAuthExecutionOpt.isPresent());
        AuthenticationExecutionInfoRepresentation kerberosAuthExecution = kerberosAuthExecutionOpt.get();
        String oldRequirementStr = kerberosAuthExecution.getRequirement();
        AuthenticationExecutionModel.Requirement oldRequirement = AuthenticationExecutionModel.Requirement.valueOf((String)oldRequirementStr);
        kerberosAuthExecution.setRequirement(requirement.name());
        realmResource.flows().updateExecutions("browser", kerberosAuthExecution);
        return oldRequirement;
    }

    private static MultivaluedHashMap<String, String> toComponentConfig(Map<String, String> ldapConfig) {
        MultivaluedHashMap config = new MultivaluedHashMap();
        for (Map.Entry<String, String> entry : ldapConfig.entrySet()) {
            config.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        return config;
    }
}

