/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.error;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.util.JsonSerialization;

public class UncaughtErrorPageTest
extends AbstractKeycloakTest {
    @Page
    private ErrorPage errorPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @Test
    public void invalidResource() throws MalformedURLException {
        this.checkPageNotFound("/auth/nosuch");
    }

    @Test
    public void invalidRealm() throws MalformedURLException {
        this.checkPageNotFound("/auth/realms/nosuch");
    }

    @Test
    public void invalidRealmResource() throws MalformedURLException {
        this.checkPageNotFound("/auth/realms/master/nosuch");
    }

    @Test
    @UncaughtServerErrorExpected
    public void uncaughtErrorJson() throws IOException {
        Response response = this.testingClient.testing().uncaughtError();
        Assert.assertEquals((long)500L, (long)response.getStatus());
        InputStream is = (InputStream)response.getEntity();
        String responseString = StreamUtil.readString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        Assert.assertTrue((boolean)responseString.contains("An internal server error has occurred"));
    }

    @Test
    @UncaughtServerErrorExpected
    public void uncaughtErrorClientRegistration() throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost post = new HttpPost(this.suiteContext.getAuthServerInfo().getUriBuilder().path("/auth/realms/master/clients-registrations/openid-connect").build(new Object[0]));
            post.setEntity((HttpEntity)new StringEntity("{ invalid : invalid }"));
            post.setHeader("Content-Type", "application/json");
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
            OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)JsonSerialization.readValue((InputStream)response.getEntity().getContent(), OAuth2ErrorRepresentation.class);
            Assert.assertEquals((Object)"unknown_error", (Object)error.getError());
            Assert.assertNull((Object)error.getErrorDescription());
        }
    }

    @Test
    @UncaughtServerErrorExpected
    public void uncaughtErrorAdmin() throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            String accessToken = this.adminClient.tokenManager().getAccessTokenString();
            HttpPost post = new HttpPost(this.suiteContext.getAuthServerInfo().getUriBuilder().path("/auth/admin/realms").build(new Object[0]));
            post.setEntity((HttpEntity)new StringEntity("{ invalid : invalid }"));
            post.setHeader("Authorization", "bearer " + accessToken);
            post.setHeader("Content-Type", "application/json");
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
            OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)JsonSerialization.readValue((InputStream)response.getEntity().getContent(), OAuth2ErrorRepresentation.class);
            Assert.assertEquals((Object)"unknown_error", (Object)error.getError());
            Assert.assertNull((Object)error.getErrorDescription());
        }
    }

    @Test
    @UncaughtServerErrorExpected
    public void uncaughtError() throws MalformedURLException {
        URI uri = this.suiteContext.getAuthServerInfo().getUriBuilder().path("/auth/realms/master/testing/uncaught-error").build(new Object[0]);
        this.driver.navigate().to(uri.toURL());
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"An internal server error has occurred", (Object)this.errorPage.getError());
    }

    @Test
    @UncaughtServerErrorExpected
    public void uncaughtErrorHeaders() throws IOException {
        URI uri = this.suiteContext.getAuthServerInfo().getUriBuilder().path("/auth/realms/master/testing/uncaught-error").build(new Object[0]);
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            SimpleHttp.Response response = SimpleHttp.doGet((String)uri.toString(), (HttpClient)client).header("Accept", "text/html; charset=utf-8").asResponse();
            for (BrowserSecurityHeaders header : BrowserSecurityHeaders.values()) {
                String expectedValue = header.getDefaultValue();
                if (expectedValue == null || expectedValue.isEmpty()) {
                    Assert.assertNull((Object)response.getFirstHeader(header.getHeaderName()));
                    continue;
                }
                Assert.assertEquals((Object)expectedValue, (Object)response.getFirstHeader(header.getHeaderName()));
            }
        }
    }

    @Test
    public void errorPageException() {
        this.oauth.realm("master");
        this.oauth.clientId("nosuch");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Client not found.", (Object)this.errorPage.getError());
    }

    @Test
    public void internationalisationEnabled() throws MalformedURLException {
        RealmResource testRealm = this.realmsResouce().realm("master");
        RealmRepresentation rep = testRealm.toRepresentation();
        rep.setInternationalizationEnabled(Boolean.valueOf(true));
        rep.setDefaultLocale("en");
        rep.setSupportedLocales(Collections.singleton("en"));
        testRealm.update(rep);
        try {
            this.checkPageNotFound("/auth/realms/master/nosuch");
            this.checkPageNotFound("/auth/nosuch");
        }
        finally {
            rep.setInternationalizationEnabled(Boolean.valueOf(false));
            testRealm.update(rep);
        }
    }

    private void checkPageNotFound(String path) throws MalformedURLException {
        URI uri = this.suiteContext.getAuthServerInfo().getUriBuilder().path(path).build(new Object[0]);
        this.driver.navigate().to(uri.toURL());
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Page not found", (Object)this.errorPage.getError());
    }
}

