/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.domainextension;

import java.util.HashSet;
import java.util.List;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.resources.TestExampleCompanyResource;
import org.keycloak.testsuite.domainextension.CompanyRepresentation;
import org.keycloak.testsuite.util.RealmBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class CustomExtensionTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation foo = RealmBuilder.create().name("foo").build();
        testRealms.add(foo);
    }

    @Test
    public void testDomainExtension() throws Exception {
        this.companyResource().createCompany("foo", this.buildCompany("foo-company"));
        this.companyResource().createCompany("foo", this.buildCompany("bar-company"));
        this.companyResource().createCompany("master", this.buildCompany("master-company"));
        List fooCompanies = this.companyResource().getCompanies("foo");
        List masterCompanies = this.companyResource().getCompanies("master");
        this.assertCompanyNames(fooCompanies, "foo-company", "bar-company");
        this.assertCompanyNames(masterCompanies, "master-company");
        this.companyResource().deleteAllCompanies("foo");
        this.companyResource().deleteAllCompanies("master");
    }

    private TestExampleCompanyResource companyResource() {
        return this.testingClient.testExampleCompany();
    }

    private CompanyRepresentation buildCompany(String companyName) {
        CompanyRepresentation rep = new CompanyRepresentation();
        rep.setName(companyName);
        return rep;
    }

    private void assertCompanyNames(List<CompanyRepresentation> companies, String ... expectedNames) {
        HashSet<String> names = new HashSet<String>();
        for (CompanyRepresentation comp : companies) {
            names.add(comp.getName());
        }
        Assert.assertEquals((long)expectedNames.length, (long)names.size());
        for (String expectedName : expectedNames) {
            Assert.assertTrue((boolean)names.contains(expectedName));
        }
    }
}

