/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.docker;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class DockerVersion {
    public static final Integer MAJOR_VERSION_INDEX = 0;
    public static final Integer MINOR_VERSION_INDEX = 1;
    public static final Integer PATCH_VERSION_INDEX = 2;
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    public static final Comparator<DockerVersion> COMPARATOR = (lhs, rhs) -> Comparator.comparing(DockerVersion::getMajor).thenComparing(Comparator.comparing(DockerVersion::getMinor).thenComparing(Comparator.comparing(DockerVersion::getPatch))).compare((DockerVersion)lhs, (DockerVersion)rhs);

    public DockerVersion(Integer major, Optional<Integer> minor, Optional<Integer> patch) {
        Objects.requireNonNull(major, "Invalid docker version - no major release number given");
        this.major = major;
        this.minor = minor.orElse(0);
        this.patch = patch.orElse(0);
    }

    public static DockerVersion parseVersionString(String versionString) {
        Objects.requireNonNull(versionString, "Cannot parse null docker version string");
        List versionNumberList = Arrays.stream(DockerVersion.stripDashAndEdition(versionString).trim().split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
        return new DockerVersion((Integer)versionNumberList.get(MAJOR_VERSION_INDEX), Optional.ofNullable((Integer)versionNumberList.get(MINOR_VERSION_INDEX)), Optional.ofNullable((Integer)versionNumberList.get(PATCH_VERSION_INDEX)));
    }

    private static String stripDashAndEdition(String versionString) {
        if (versionString.contains("-")) {
            return versionString.substring(0, versionString.indexOf("-"));
        }
        return versionString;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerVersion that = (DockerVersion)o;
        if (this.major != null ? !this.major.equals(that.major) : that.major != null) {
            return false;
        }
        if (this.minor != null ? !this.minor.equals(that.minor) : that.minor != null) {
            return false;
        }
        return this.patch != null ? this.patch.equals(that.patch) : that.patch == null;
    }

    public int hashCode() {
        int result = this.major != null ? this.major.hashCode() : 0;
        result = 31 * result + (this.minor != null ? this.minor.hashCode() : 0);
        result = 31 * result + (this.patch != null ? this.patch.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DockerVersion{major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + '}';
    }
}

