/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.docker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public final class DockerTestRealmSetup {
    private DockerTestRealmSetup() {
    }

    public static RealmRepresentation createRealm(String realmId) {
        RealmRepresentation createdRealm = new RealmRepresentation();
        createdRealm.setId(UUID.randomUUID().toString());
        createdRealm.setRealm(realmId);
        createdRealm.setEnabled(Boolean.valueOf(true));
        createdRealm.setAuthenticatorConfig(new ArrayList());
        return createdRealm;
    }

    public static void configureDockerRegistryClient(RealmRepresentation dockerRealm, String clientId) {
        ClientRepresentation dockerClient = new ClientRepresentation();
        dockerClient.setClientId(clientId);
        dockerClient.setProtocol("docker-v2");
        dockerClient.setEnabled(Boolean.valueOf(true));
        List clients = Optional.ofNullable(dockerRealm.getClients()).orElse(new ArrayList());
        clients.add(dockerClient);
        dockerRealm.setClients(clients);
    }

    public static void configureUser(RealmRepresentation dockerRealm, String username, String password) {
        UserRepresentation dockerUser = new UserRepresentation();
        dockerUser.setUsername(username);
        dockerUser.setEnabled(Boolean.valueOf(true));
        dockerUser.setEmail("docker-users@localhost.localdomain");
        dockerUser.setFirstName("docker");
        dockerUser.setLastName("user");
        CredentialRepresentation dockerUserCreds = new CredentialRepresentation();
        dockerUserCreds.setType("password");
        dockerUserCreds.setValue(password);
        dockerUser.setCredentials(Collections.singletonList(dockerUserCreds));
        dockerRealm.setUsers(Collections.singletonList(dockerUser));
    }
}

