/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.NotFoundException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.Retry;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.CrossDCTestEnricher;
import org.keycloak.testsuite.arquillian.InfinispanStatistics;
import org.keycloak.testsuite.arquillian.annotation.InitialDcState;
import org.keycloak.testsuite.arquillian.annotation.JmxInfinispanCacheStatistics;
import org.keycloak.testsuite.arquillian.annotation.JmxInfinispanChannelStatistics;
import org.keycloak.testsuite.crossdc.AbstractAdminCrossDCTest;
import org.keycloak.testsuite.crossdc.DC;
import org.keycloak.testsuite.crossdc.ServerSetup;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class SessionExpirationCrossDCTest
extends AbstractAdminCrossDCTest {
    private static final String REALM_NAME = "expiration-test";
    private static final int SESSIONS_COUNT = 20;
    private int sessions01;
    private int sessions02;
    private int clientSessions01;
    private int clientSessions02;
    private int remoteSessions01;
    private int remoteSessions02;
    private int authSessions01;
    private int authSessions02;

    @Before
    public void beforeTest() {
        try {
            this.oauth.removeCachedPublicKeys();
            this.adminClient.realm(REALM_NAME).remove();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        UserRepresentation user = UserBuilder.create().id("login-test").username("login-test").email("login@test.com").enabled(true).password("password").addRoles("offline_access").build();
        ClientRepresentation client = ClientBuilder.create().clientId("test-app").directAccessGrants().redirectUris("http://localhost:8180/auth/realms/master/app/*", "https://localhost:8543/auth/realms/master/app/*").addWebOrigin("http://localhost:8180").addWebOrigin("https://localhost:8543").secret("password").build();
        RealmRepresentation realmRep = RealmBuilder.create().ssoSessionIdleTimeout(300).ssoSessionMaxLifespan(600).offlineSessionIdleTimeout(900).name(REALM_NAME).user(user).client(client).build();
        this.adminClient.realms().create(realmRep);
        this.setInfinispanTestTimeServiceOnAllStartedAuthServers();
    }

    @After
    public void afterTest() {
        this.setTimeOffset(1500);
        this.getTestingClientForStartedNodeInDc(0).testing().cache("sessions").processExpiration();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("clientSessions").processExpiration();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineSessions").processExpiration();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineClientSessions").processExpiration();
        this.resetTimeOffset();
        this.revertInfinispanTestTimeServiceOnAllStartedAuthServers();
    }

    @Test
    public void testRealmRemoveSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="clientSessions") InfinispanStatistics clientCacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="clientSessions") InfinispanStatistics clientCacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, true);
        channelStatisticsCrossDc.reset();
        this.getAdminClient().realm(REALM_NAME).remove();
        this.assertStatisticsExpected("After realm remove", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    private List<OAuthClient.AccessTokenResponse> createInitialSessions(String cacheName, String clientSessionsCacheName, boolean offline, InfinispanStatistics cacheDc1Statistics, InfinispanStatistics cacheDc2Statistics, boolean includeRemoteStats) throws Exception {
        this.enableDcOnLoadBalancer(DC.SECOND);
        this.sessions01 = this.getTestingClientForStartedNodeInDc(0).testing().cache(cacheName).size();
        this.sessions02 = this.getTestingClientForStartedNodeInDc(1).testing().cache(cacheName).size();
        this.clientSessions01 = this.getTestingClientForStartedNodeInDc(0).testing().cache(clientSessionsCacheName).size();
        this.clientSessions02 = this.getTestingClientForStartedNodeInDc(1).testing().cache(clientSessionsCacheName).size();
        this.remoteSessions01 = (Integer)cacheDc1Statistics.getSingleStatistics("numberOfEntries");
        this.remoteSessions02 = (Integer)cacheDc2Statistics.getSingleStatistics("numberOfEntries");
        this.log.infof("Before creating sessions: sessions01: %d, sessions02: %d, remoteSessions01: %d, remoteSessions02: %d, clientSessions01: %d, clientSessions02: %d", new Object[]{this.sessions01, this.sessions02, this.remoteSessions01, this.remoteSessions02, this.clientSessions01, this.clientSessions02});
        this.oauth.realm(REALM_NAME);
        if (offline) {
            this.oauth.scope("offline_access");
        }
        ArrayList<OAuthClient.AccessTokenResponse> responses = new ArrayList<OAuthClient.AccessTokenResponse>();
        for (int i = 0; i < 20; ++i) {
            responses.add(this.oauth.doGrantAccessTokenRequest("password", "login-test", "password"));
        }
        Retry.execute(() -> {
            int sessions11 = this.getTestingClientForStartedNodeInDc(0).testing().cache(cacheName).size();
            int sessions12 = this.getTestingClientForStartedNodeInDc(1).testing().cache(cacheName).size();
            int clientSessions11 = this.getTestingClientForStartedNodeInDc(0).testing().cache(clientSessionsCacheName).size();
            int clientSessions12 = this.getTestingClientForStartedNodeInDc(1).testing().cache(clientSessionsCacheName).size();
            int remoteSessions11 = (Integer)cacheDc1Statistics.getSingleStatistics("numberOfEntries");
            int remoteSessions12 = (Integer)cacheDc2Statistics.getSingleStatistics("numberOfEntries");
            this.log.infof("After creating sessions: sessions11: %d, sessions12: %d, remoteSessions11: %d, remoteSessions12: %d, clientSessions11: %d, clientSessions12: %d", new Object[]{sessions11, sessions12, remoteSessions11, remoteSessions12, clientSessions11, clientSessions12});
            Assert.assertEquals((long)sessions11, (long)(this.sessions01 + 20));
            Assert.assertEquals((long)sessions12, (long)(this.sessions02 + 20));
            if (includeRemoteStats) {
                Assert.assertEquals((long)remoteSessions11, (long)(this.remoteSessions01 + 20));
                Assert.assertEquals((long)remoteSessions12, (long)(this.remoteSessions02 + 20));
            }
        }, (int)50, (long)50L);
        return responses;
    }

    private void assertStatisticsExpected(String messagePrefix, String cacheName, String clientSessionsCacheName, InfinispanStatistics cacheDc1Statistics, InfinispanStatistics cacheDc2Statistics, InfinispanStatistics channelStatisticsCrossDc, int sessions1Expected, int sessions2Expected, int clientSessions1Expected, int clientSessions2Expected, int remoteSessions1Expected, int remoteSessions2Expected, boolean checkSomeMessagesSentBetweenDCs) {
        Retry.execute(() -> {
            int sessions1 = this.getTestingClientForStartedNodeInDc(0).testing().cache(cacheName).size();
            int sessions2 = this.getTestingClientForStartedNodeInDc(1).testing().cache(cacheName).size();
            int clientSessions1 = this.getTestingClientForStartedNodeInDc(0).testing().cache(clientSessionsCacheName).size();
            int clientSessions2 = this.getTestingClientForStartedNodeInDc(1).testing().cache(clientSessionsCacheName).size();
            int remoteSessions1 = (Integer)cacheDc1Statistics.getSingleStatistics("numberOfEntries");
            int remoteSessions2 = (Integer)cacheDc2Statistics.getSingleStatistics("numberOfEntries");
            long messagesCount = (Long)channelStatisticsCrossDc.getSingleStatistics("received_messages");
            this.log.infof(messagePrefix + ": sessions1: %d, sessions2: %d, clientSessions1: %d, clientSessions2: %d, remoteSessions1: %d, remoteSessions2: %d, sentMessages: %d", new Object[]{sessions1, sessions2, clientSessions1, clientSessions2, remoteSessions1, remoteSessions2, messagesCount});
            Assert.assertEquals((long)sessions1, (long)sessions1Expected);
            Assert.assertEquals((long)sessions2, (long)sessions2Expected);
            Assert.assertEquals((long)clientSessions1, (long)clientSessions1Expected);
            Assert.assertEquals((long)clientSessions2, (long)clientSessions2Expected);
            Assert.assertEquals((long)remoteSessions1, (long)remoteSessions1Expected);
            Assert.assertEquals((long)remoteSessions2, (long)remoteSessions2Expected);
            if (checkSomeMessagesSentBetweenDCs) {
                Assert.assertThat((Object)messagesCount, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            }
        }, (int)50, (long)50L);
    }

    @Test
    public void testRealmRemoveOfflineSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialSessions("offlineSessions", "offlineClientSessions", true, cacheDc1Statistics, cacheDc2Statistics, true);
        channelStatisticsCrossDc.reset();
        this.getAdminClient().realm(REALM_NAME).remove();
        this.assertStatisticsExpected("After realm remove", "offlineSessions", "offlineClientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testLogoutAllInRealm(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, true);
        channelStatisticsCrossDc.reset();
        this.getAdminClient().realm(REALM_NAME).logoutAll();
        this.assertStatisticsExpected("After realm logout", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testPeriodicExpirationSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        OAuthClient.AccessTokenResponse lastAccessTokenResponse = this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, true).get(19);
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(lastAccessTokenResponse.getRefreshToken(), "password");
        Assert.assertNotNull((Object)refreshResponse.getRefreshToken());
        Assert.assertNull((Object)refreshResponse.getError());
        channelStatisticsCrossDc.reset();
        this.getTestingClientForStartedNodeInDc(0).testing().removeExpired(REALM_NAME);
        this.assertStatisticsExpected("After remove expired - 1", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01 + 20, this.sessions02 + 20, this.clientSessions01 + 20, this.clientSessions02 + 20, this.remoteSessions01 + 20, this.remoteSessions02 + 20, false);
        this.setTimeOffset(610);
        refreshResponse = this.oauth.doRefreshTokenRequest(lastAccessTokenResponse.getRefreshToken(), "password");
        Assert.assertNull((Object)refreshResponse.getRefreshToken());
        Assert.assertNotNull((Object)refreshResponse.getError());
        channelStatisticsCrossDc.reset();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("sessions").processExpiration();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("clientSessions").processExpiration();
        this.assertStatisticsExpected("After remove expired - 2", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testPeriodicExpirationOfflineSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        OAuthClient.AccessTokenResponse lastAccessTokenResponse = this.createInitialSessions("offlineSessions", "offlineClientSessions", true, cacheDc1Statistics, cacheDc2Statistics, true).get(19);
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(lastAccessTokenResponse.getRefreshToken(), "password");
        Assert.assertNotNull((Object)refreshResponse.getRefreshToken());
        Assert.assertNull((Object)refreshResponse.getError());
        channelStatisticsCrossDc.reset();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineSessions").processExpiration();
        this.assertStatisticsExpected("After remove expired - 1", "offlineSessions", "offlineClientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01 + 20, this.sessions02 + 20, this.clientSessions01 + 20, this.clientSessions02 + 20, this.remoteSessions01 + 20, this.remoteSessions02 + 20, false);
        this.setTimeOffset(1210);
        refreshResponse = this.oauth.doRefreshTokenRequest(lastAccessTokenResponse.getRefreshToken(), "password");
        Assert.assertNull((Object)refreshResponse.getRefreshToken());
        Assert.assertNotNull((Object)refreshResponse.getError());
        channelStatisticsCrossDc.reset();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineSessions").processExpiration();
        this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineClientSessions").processExpiration();
        this.assertStatisticsExpected("After remove expired - 2", "offlineSessions", "offlineClientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testUserRemoveSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, true);
        channelStatisticsCrossDc.reset();
        ApiUtil.findUserByUsernameId((RealmResource)this.getAdminClient().realm(REALM_NAME), (String)"login-test").remove();
        this.assertStatisticsExpected("After user remove", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testUserRemoveOfflineSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialSessions("offlineSessions", "offlineClientSessions", true, cacheDc1Statistics, cacheDc2Statistics, true);
        channelStatisticsCrossDc.reset();
        ApiUtil.findUserByUsernameId((RealmResource)this.getAdminClient().realm(REALM_NAME), (String)"login-test").remove();
        this.assertStatisticsExpected("After user remove", "offlineSessions", "offlineClientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testLogoutUser(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, true);
        channelStatisticsCrossDc.reset();
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.getAdminClient().realm(REALM_NAME), (String)"login-test");
        UserSessionRepresentation userSession = (UserSessionRepresentation)user.getUserSessions().get(0);
        this.getAdminClient().realm(REALM_NAME).deleteSession(userSession.getId());
        this.assertStatisticsExpected("After logout single session", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01 + 20 - 1, this.sessions02 + 20 - 1, this.clientSessions01 + 20 - 1, this.clientSessions02 + 20 - 1, this.remoteSessions01 + 20 - 1, this.remoteSessions02 + 20 - 1, true);
        user.logout();
        this.assertStatisticsExpected("After user logout", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    @InitialDcState(authServers=ServerSetup.ALL_NODES_IN_FIRST_DC_FIRST_NODE_IN_SECOND_DC)
    public void testLogoutUserWithFailover(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        List<OAuthClient.AccessTokenResponse> responses = this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, false);
        CrossDCTestEnricher.stopAuthServerBackendNode((DC)DC.FIRST, (int)1);
        int i1 = 0;
        for (OAuthClient.AccessTokenResponse response : responses) {
            OAuthClient.AccessTokenResponse refreshTokenResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
            Assert.assertNotNull((String)("Failed in iteration " + ++i1), (Object)refreshTokenResponse.getRefreshToken());
            Assert.assertNull((String)("Failed in iteration " + i1), (Object)refreshTokenResponse.getError());
        }
        channelStatisticsCrossDc.reset();
        this.setTimeOffset(10);
        ApiUtil.findUserByUsernameId((RealmResource)this.getAdminClient().realm(REALM_NAME), (String)"login-test").logout();
        this.setTimeOffset(10);
        AtomicInteger i = new AtomicInteger(0);
        Retry.execute(() -> {
            i.incrementAndGet();
            int j = 0;
            for (OAuthClient.AccessTokenResponse response : responses) {
                OAuthClient.AccessTokenResponse refreshTokenResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
                Assert.assertNull((String)("Failed in iteration " + ++j), (Object)refreshTokenResponse.getRefreshToken());
                Assert.assertNotNull((String)("Failed in iteration " + j), (Object)refreshTokenResponse.getError());
            }
            this.log.infof("Passed the testLogoutUserWithFailover in the iteration: %d", (Object)i.get());
        }, (int)50, (long)50L);
    }

    @Test
    @InitialDcState(authServers=ServerSetup.ALL_NODES_IN_EVERY_DC)
    public void testLogoutWithAllStartedNodes(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        List<OAuthClient.AccessTokenResponse> responses = this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, false);
        Retry.execute(() -> this.assertTestAppActiveSessionsCount(20), (int)50, (long)50L);
        this.getAdminClient().realm(REALM_NAME).logoutAll();
        Retry.execute(() -> this.assertTestAppActiveSessionsCount(0), (int)50, (long)50L);
        responses = this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, false);
        Retry.execute(() -> this.assertTestAppActiveSessionsCount(20), (int)50, (long)50L);
        ApiUtil.findUserByUsernameId((RealmResource)this.getAdminClient().realm(REALM_NAME), (String)"login-test").logout();
        Retry.execute(() -> this.assertTestAppActiveSessionsCount(0), (int)50, (long)50L);
        CrossDCTestEnricher.stopAuthServerBackendNode((DC)DC.FIRST, (int)1);
        CrossDCTestEnricher.stopAuthServerBackendNode((DC)DC.SECOND, (int)1);
    }

    private void assertTestAppActiveSessionsCount(int expectedSessionsCount) {
        List sessions = this.getAdminClient().realm(REALM_NAME).getClientSessionStats();
        Optional<Map> optional = sessions.stream().filter(map -> ((String)map.get("clientId")).equals("test-app")).findFirst();
        if (expectedSessionsCount == 0) {
            Assert.assertFalse((boolean)optional.isPresent());
        } else {
            Map testAppSessions = optional.get();
            Assert.assertEquals((long)expectedSessionsCount, (long)Integer.parseInt((String)testAppSessions.get("active")));
        }
        List userSessions = ApiUtil.findClientByClientId((RealmResource)this.getAdminClient().realm(REALM_NAME), (String)"test-app").getUserSessions(Integer.valueOf(0), Integer.valueOf(100));
        Assert.assertEquals((long)expectedSessionsCount, (long)userSessions.size());
    }

    @Test
    public void testClearDetachedClientSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        List<OAuthClient.AccessTokenResponse> responses = this.createInitialSessions("sessions", "clientSessions", false, cacheDc1Statistics, cacheDc2Statistics, true);
        for (OAuthClient.AccessTokenResponse response : responses) {
            String userSessionId = this.oauth.verifyToken(response.getAccessToken()).getSessionState();
            this.getTestingClientForStartedNodeInDc(0).testing().cache("sessions").removeKey(userSessionId);
        }
        this.setTimeOffset(610);
        this.getTestingClientForStartedNodeInDc(0).testing().cache("clientSessions").processExpiration();
        this.assertStatisticsExpected("After remove expired", "sessions", "clientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testClearDetachedOfflineClientSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="offlineSessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        List<OAuthClient.AccessTokenResponse> responses = this.createInitialSessions("offlineSessions", "offlineClientSessions", true, cacheDc1Statistics, cacheDc2Statistics, true);
        for (OAuthClient.AccessTokenResponse response : responses) {
            String userSessionId = this.oauth.verifyToken(response.getAccessToken()).getSessionState();
            this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineSessions").removeKey(userSessionId);
        }
        this.setTimeOffset(1210);
        this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineClientSessions").processExpiration();
        this.assertStatisticsExpected("After remove expired", "offlineSessions", "offlineClientSessions", cacheDc1Statistics, cacheDc2Statistics, channelStatisticsCrossDc, this.sessions01, this.sessions02, this.clientSessions01, this.clientSessions02, this.remoteSessions01, this.remoteSessions02, true);
    }

    @Test
    public void testPeriodicExpirationAuthSessions(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="authenticationSessions") InfinispanStatistics cacheDc1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="authenticationSessions") InfinispanStatistics cacheDc2Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialAuthSessions();
        channelStatisticsCrossDc.reset();
        this.getTestingClientForStartedNodeInDc(0).testing().removeExpired(REALM_NAME);
        this.getTestingClientForStartedNodeInDc(1).testing().removeExpired(REALM_NAME);
        this.assertAuthSessionsStatisticsExpected("After remove expired auth sessions - 1", channelStatisticsCrossDc, 20);
        this.setTimeOffset(10000000);
        channelStatisticsCrossDc.reset();
        this.getTestingClientForStartedNodeInDc(0).testing().removeExpired(REALM_NAME);
        this.getTestingClientForStartedNodeInDc(1).testing().removeExpired(REALM_NAME);
        this.assertAuthSessionsStatisticsExpected("After remove expired auth sessions - 2", channelStatisticsCrossDc, 0);
    }

    private void createInitialAuthSessions() throws Exception {
        this.enableDcOnLoadBalancer(DC.SECOND);
        this.authSessions01 = this.getTestingClientForStartedNodeInDc(0).testing().cache("authenticationSessions").size();
        this.authSessions02 = this.getTestingClientForStartedNodeInDc(1).testing().cache("authenticationSessions").size();
        this.log.infof("Before creating authentication sessions: authSessions01: %d, authSessions02: %d", (Object)this.authSessions01, (Object)this.authSessions02);
        this.oauth.realm(REALM_NAME);
        for (int i = 0; i < 20; ++i) {
            this.oauth.openLoginForm();
            this.driver.manage().deleteAllCookies();
        }
        Retry.execute(() -> {
            int authSessions11 = this.getTestingClientForStartedNodeInDc(0).testing().cache("authenticationSessions").size();
            int authSessions12 = this.getTestingClientForStartedNodeInDc(1).testing().cache("authenticationSessions").size();
            this.log.infof("After creating authentication sessions: sessions11: %d, authSessions12: %d", (Object)authSessions11, (Object)authSessions12);
            int diff1 = authSessions11 - this.authSessions01;
            int diff2 = authSessions12 - this.authSessions02;
            Assert.assertEquals((long)20L, (long)(diff1 + diff2));
        }, (int)50, (long)50L);
    }

    private void assertAuthSessionsStatisticsExpected(String messagePrefix, InfinispanStatistics channelStatisticsCrossDc, int expectedAuthSessionsCountDiff) {
        Retry.execute(() -> {
            int authSessions1 = this.getTestingClientForStartedNodeInDc(0).testing().cache("authenticationSessions").size();
            int authSessions2 = this.getTestingClientForStartedNodeInDc(1).testing().cache("authenticationSessions").size();
            long messagesCount = (Long)channelStatisticsCrossDc.getSingleStatistics("received_messages");
            this.log.infof(messagePrefix + ": authSessions1: %d, authSessions2: %d, sentMessages: %d", (Object)authSessions1, (Object)authSessions2, (Object)messagesCount);
            int diff1 = authSessions1 - this.authSessions01;
            int diff2 = authSessions2 - this.authSessions02;
            Assert.assertEquals((long)expectedAuthSessionsCountDiff, (long)(diff1 + diff2));
        }, (int)50, (long)50L);
    }

    @Test
    public void testRealmRemoveAuthSessions(@JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.createInitialAuthSessions();
        channelStatisticsCrossDc.reset();
        this.getAdminClient().realm(REALM_NAME).remove();
        this.assertAuthSessionsStatisticsExpected("After realm removed", channelStatisticsCrossDc, 0);
    }
}

