/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.testsuite.admin.concurrency.AbstractConcurrencyTest;
import org.keycloak.testsuite.admin.concurrency.ConcurrentLoginTest;
import org.keycloak.testsuite.arquillian.LoadBalancerController;
import org.keycloak.testsuite.arquillian.annotation.InitialDcState;
import org.keycloak.testsuite.arquillian.annotation.LoadBalancer;
import org.keycloak.testsuite.crossdc.ServerSetup;

@InitialDcState(authServers=ServerSetup.ALL_NODES_IN_EVERY_DC)
public class ConcurrentLoginCrossDCTest
extends ConcurrentLoginTest {
    @ArquillianResource
    @LoadBalancer(value="auth-server-balancer-cross-dc")
    protected LoadBalancerController loadBalancerCtrl;
    @ArquillianResource
    protected ContainerController containerController;
    private static final int INVOCATIONS_BEFORE_SIMULATING_DC_FAILURE = 10;
    private static final int LOGIN_TASK_DELAY_MS = 100;
    private static final int LOGIN_TASK_RETRIES = 15;

    @Override
    public void beforeAbstractKeycloakTestRealmImport() {
        this.loadBalancerCtrl.enableAllBackendNodes();
    }

    @Override
    public void postAfterAbstractKeycloak() {
        this.loadBalancerCtrl.disableAllBackendNodes();
        this.testContext.setTestRealmReps(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentLoginWithRandomDcFailures() throws Throwable {
        this.log.info((Object)"*********************************************");
        long start = System.currentTimeMillis();
        AtomicReference<String> userSessionId = new AtomicReference<String>();
        ConcurrentLoginTest.LoginTask loginTask = null;
        try (CloseableHttpClient httpClient = this.getHttpsAwareClient();){
            loginTask = new ConcurrentLoginTest.LoginTask(this, httpClient, userSessionId, 100, 15, false, Arrays.asList(this.createHttpClientContextForUser(httpClient, "test-user@localhost", "password")));
            HttpUriRequest request = this.handleLogin(this.getPageContent(this.oauth.getLoginFormUrl(), httpClient, HttpClientContext.create()), "test-user@localhost", "password");
            this.log.debug((Object)"Executing login request");
            Assert.assertTrue((boolean)this.parseAndCloseResponse(httpClient.execute(request)).contains("<title>AUTH_RESPONSE</title>"));
            this.run(4, 120, loginTask, new SwapDcAvailability());
            int clientSessionsCount = this.testingClient.testing().getClientSessionsCountInUserSession("test", userSessionId.get());
            Assert.assertEquals((long)121L, (long)clientSessionsCount);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis() - start;
            this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
            this.log.info((Object)("concurrentLoginWithRandomDcFailures took " + end / 1000L + "s"));
            this.log.info((Object)"*********************************************");
            throw throwable;
        }
        long end = System.currentTimeMillis() - start;
        this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
        this.log.info((Object)("concurrentLoginWithRandomDcFailures took " + end / 1000L + "s"));
        this.log.info((Object)"*********************************************");
    }

    private class SwapDcAvailability
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger invocationCounter = new AtomicInteger();

        private SwapDcAvailability() {
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            int currentInvocarion = this.invocationCounter.getAndIncrement();
            if (currentInvocarion % 10 == 0) {
                int failureIndex = currentInvocarion / 10;
                int dcToEnable = failureIndex % 2;
                int dcToDisable = (failureIndex + 1) % 2;
                ((List)ConcurrentLoginCrossDCTest.this.suiteContext.getDcAuthServerBackendsInfo().get(dcToEnable)).forEach(c -> ConcurrentLoginCrossDCTest.this.loadBalancerCtrl.enableBackendNodeByName(c.getQualifier()));
                ((List)ConcurrentLoginCrossDCTest.this.suiteContext.getDcAuthServerBackendsInfo().get(dcToDisable)).forEach(c -> ConcurrentLoginCrossDCTest.this.loadBalancerCtrl.disableBackendNodeByName(c.getQualifier()));
            }
        }
    }
}

