/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Before;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.CrossDCTestEnricher;
import org.keycloak.testsuite.arquillian.LoadBalancerController;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.InitialDcState;
import org.keycloak.testsuite.arquillian.annotation.LoadBalancer;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.crossdc.DC;

@InitialDcState
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public abstract class AbstractCrossDCTest
extends AbstractTestRealmKeycloakTest {
    public static final String QUALIFIER_NODE_BALANCER = "auth-server-balancer-cross-dc";
    public static final String QUALIFIER_AUTH_SERVER_DC_0_NODE_1 = "auth-server-${node.name}-cross-dc-0_1";
    public static final String QUALIFIER_AUTH_SERVER_DC_1_NODE_1 = "auth-server-${node.name}-cross-dc-1_1";
    @ArquillianResource
    @LoadBalancer(value="auth-server-balancer-cross-dc")
    protected LoadBalancerController loadBalancerCtrl;

    @Override
    @Before
    public void beforeAbstractKeycloakTest() throws Exception {
        this.enableOnlyFirstNodeInFirstDc();
        super.beforeAbstractKeycloakTest();
    }

    @Override
    @After
    public void afterAbstractKeycloakTest() throws Exception {
        this.log.debug((Object)"--DC: after AbstractCrossDCTest");
        CrossDCTestEnricher.startAuthServerBackendNode((DC)DC.FIRST, (int)0);
        this.enableOnlyFirstNodeInFirstDc();
        super.afterAbstractKeycloakTest();
        this.removeTestRealms();
        this.loadBalancerCtrl.disableAllBackendNodes();
    }

    private void enableOnlyFirstNodeInFirstDc() {
        this.log.debug((Object)"--DC: Enable only first node in first datacenter @ load balancer");
        this.loadBalancerCtrl.disableAllBackendNodes();
        if (!CrossDCTestEnricher.getBackendNode((DC)DC.FIRST, (int)0).isStarted()) {
            throw new IllegalStateException("--DC: Trying to enable not started node on load-balancer");
        }
        this.loadBalancerCtrl.enableBackendNodeByName(CrossDCTestEnricher.getBackendNode((DC)DC.FIRST, (int)0).getQualifier());
    }

    private void removeTestRealms() {
        this.testContext.getTestRealmReps().stream().forEach(realm -> this.deleteAllCookiesForRealm(realm.getRealm()));
        this.log.debug((Object)"--DC: removing rest realms");
        AuthServerTestEnricher.removeTestRealms((TestContext)this.testContext, (Keycloak)this.adminClient);
        this.testContext.setTestRealmReps(new ArrayList());
    }

    protected Keycloak getAdminClientForStartedNodeInDc(int dcIndex) {
        ContainerInfo firstStartedNode = ((List)this.suiteContext.getDcAuthServerBackendsInfo().get(dcIndex)).stream().filter(ContainerInfo::isStarted).findFirst().get();
        return this.getAdminClientFor(firstStartedNode);
    }

    protected Keycloak getAdminClientFor(ContainerInfo node) {
        Keycloak client = (Keycloak)CrossDCTestEnricher.getBackendAdminClients().get(node);
        if (client == null && node.equals((Object)this.suiteContext.getAuthServerInfo())) {
            client = this.adminClient;
        }
        return client;
    }

    protected KeycloakTestingClient getTestingClientForStartedNodeInDc(int dcIndex) {
        ContainerInfo firstStartedNode = ((List)this.suiteContext.getDcAuthServerBackendsInfo().get(dcIndex)).stream().filter(ContainerInfo::isStarted).findFirst().get();
        return this.getTestingClientFor(firstStartedNode);
    }

    protected KeycloakTestingClient getTestingClientFor(ContainerInfo node) {
        KeycloakTestingClient client = (KeycloakTestingClient)CrossDCTestEnricher.getBackendTestingClients().get(node);
        if (client == null && node.equals((Object)this.suiteContext.getAuthServerInfo())) {
            client = this.testingClient;
        }
        return client;
    }

    public void disableDcOnLoadBalancer(DC dc) {
        int dcIndex = dc.ordinal();
        this.log.infof("--DC: Disabling load balancer for dc=%d", (Object)dcIndex);
        ((List)this.suiteContext.getDcAuthServerBackendsInfo().get(dcIndex)).forEach(containerInfo -> this.loadBalancerCtrl.disableBackendNodeByName(containerInfo.getQualifier()));
    }

    public void enableDcOnLoadBalancer(DC dc) {
        int dcIndex = dc.ordinal();
        this.log.infof("--DC: Enabling load balancer for dc=%d", (Object)dcIndex);
        List dcNodes = (List)this.suiteContext.getDcAuthServerBackendsInfo().get(dcIndex);
        if (!dcNodes.stream().anyMatch(ContainerInfo::isStarted)) {
            this.log.warnf("--DC: No node is started in DC %d", (Object)dcIndex);
        } else {
            dcNodes.stream().filter(ContainerInfo::isStarted).forEach(containerInfo -> this.loadBalancerCtrl.enableBackendNodeByName(containerInfo.getQualifier()));
        }
    }

    public void disableLoadBalancerNode(DC dc, int nodeIndex) {
        int dcIndex = dc.ordinal();
        this.log.infof("--DC: Disabling load balancer for dc=%d, node=%d", (Object)dcIndex, (Object)nodeIndex);
        this.loadBalancerCtrl.disableBackendNodeByName(((ContainerInfo)((List)this.suiteContext.getDcAuthServerBackendsInfo().get(dcIndex)).get(nodeIndex)).getQualifier());
    }

    public void enableLoadBalancerNode(DC dc, int nodeIndex) {
        int dcIndex = dc.ordinal();
        this.log.infof("--DC: Enabling load balancer for dc=%d, node=%d", (Object)dcIndex, (Object)nodeIndex);
        ContainerInfo backendNode = (ContainerInfo)((List)this.suiteContext.getDcAuthServerBackendsInfo().get(dcIndex)).get(nodeIndex);
        if (backendNode == null) {
            throw new IllegalArgumentException("Invalid node with index " + nodeIndex + " for DC " + dcIndex);
        }
        if (!backendNode.isStarted()) {
            this.log.warnf("--DC: Node %s is not started in DC %d", (Object)backendNode.getQualifier(), (Object)dcIndex);
        }
        this.loadBalancerCtrl.enableBackendNodeByName(backendNode.getQualifier());
    }

    @Override
    public void setTimeOffset(int offset) {
        super.setTimeOffset(offset);
        this.setTimeOffsetOnAllStartedContainers(offset);
    }

    private void setTimeOffsetOnAllStartedContainers(int offset) {
        CrossDCTestEnricher.getBackendTestingClients().entrySet().stream().filter(testingClientEntry -> ((ContainerInfo)testingClientEntry.getKey()).isStarted()).map(testingClientEntry -> (KeycloakTestingClient)testingClientEntry.getValue()).forEach(testingClient -> testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(offset))));
    }

    @Override
    public void resetTimeOffset() {
        super.resetTimeOffset();
        this.setTimeOffsetOnAllStartedContainers(0);
    }

    protected void setInfinispanTestTimeServiceOnAllStartedAuthServers() {
        CrossDCTestEnricher.forAllBackendNodesStream().filter(ContainerInfo::isStarted).forEach(this::setInfinispanTestTimeServiceonAuthServer);
    }

    private void setInfinispanTestTimeServiceonAuthServer(ContainerInfo backendAuthServer) {
        this.log.infof("Set Infinispan Test Time Service for backend server %s", (Object)backendAuthServer.getQualifier());
        this.getTestingClientFor(backendAuthServer).testing().setTestingInfinispanTimeService();
    }

    protected void revertInfinispanTestTimeServiceOnAllStartedAuthServers() {
        CrossDCTestEnricher.forAllBackendNodesStream().filter(ContainerInfo::isStarted).forEach(this::revertInfinispanTestTimeServiceonAuthServer);
    }

    private void revertInfinispanTestTimeServiceonAuthServer(ContainerInfo backendAuthServer) {
        this.log.infof("Revert Infinispan Test Time Service for backend server %s", (Object)backendAuthServer.getQualifier());
        this.getTestingClientFor(backendAuthServer).testing().revertTestingInfinispanTimeService();
    }
}

