/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Retry;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.InfinispanStatistics;
import org.keycloak.testsuite.crossdc.AbstractCrossDCTest;
import org.keycloak.testsuite.util.TestCleanup;

public abstract class AbstractAdminCrossDCTest
extends AbstractCrossDCTest {
    protected static final String REALM_NAME = "admin-client-test";
    protected RealmResource realm;
    protected String realmId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        this.log.debug((Object)("Configuring test realm '" + testRealm.getRealm() + "'. Enabling direct access grant."));
        ClientRepresentation testApp = this.findTestApp(testRealm);
        if (testApp == null) {
            throw new IllegalStateException("Couldn't find the 'test-app' within the realm '" + testRealm.getRealm() + "'");
        }
        testApp.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.debug((Object)"--DC: AbstractAdminCrossDCTest.addTestRealms - adding realm: admin-client-test");
        super.addTestRealms(testRealms);
        RealmRepresentation adminRealmRep = new RealmRepresentation();
        adminRealmRep.setId(REALM_NAME);
        adminRealmRep.setRealm(REALM_NAME);
        adminRealmRep.setEnabled(Boolean.valueOf(true));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("from", "auto@keycloak.org");
        config.put("host", "localhost");
        config.put("port", "3025");
        adminRealmRep.setSmtpServer(config);
        ArrayList<String> eventListeners = new ArrayList<String>();
        eventListeners.add("jboss-logging");
        eventListeners.add("event-queue");
        adminRealmRep.setEventsListeners(eventListeners);
        testRealms.add(adminRealmRep);
    }

    @Before
    public void setRealm() {
        this.log.debug((Object)"--DC: AbstractAdminCrossDCTest.setRealm");
        this.realm = this.adminClient.realm(REALM_NAME);
        this.realmId = this.realm.toRepresentation().getId();
    }

    @Override
    protected TestCleanup getCleanup() {
        return this.getCleanup(REALM_NAME);
    }

    protected <T extends Comparable> void assertSingleStatistics(InfinispanStatistics stats, String key, Runnable testedCode, Function<T, Matcher<? super T>> matcherOnOldStat) {
        stats.reset();
        Comparable oldStat = stats.getSingleStatistics(key);
        testedCode.run();
        Retry.execute(() -> {
            Comparable newStat = stats.getSingleStatistics(key);
            Matcher matcherInstance = (Matcher)matcherOnOldStat.apply(oldStat);
            this.log.infof("assertSingleStatistics '%s' : oldStat: %s, newStat: %s", (Object)key, (Object)oldStat.toString(), (Object)newStat.toString());
            Assert.assertThat((Object)newStat, (Matcher)matcherInstance);
        }, (int)50, (long)200L);
    }

    protected void assertStatistics(InfinispanStatistics stats, Runnable testedCode, BiConsumer<Map<String, Object>, Map<String, Object>> assertionOnStats) {
        stats.reset();
        Map oldStat = stats.getStatistics();
        testedCode.run();
        Retry.execute(() -> {
            Map newStat = stats.getStatistics();
            assertionOnStats.accept(oldStat, newStat);
        }, (int)50, (long)200L);
    }
}

