/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cookies;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.models.AdminRoles;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.UserBuilder;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class CookiesPathTest
extends AbstractKeycloakTest {
    @Page
    protected LoginPage loginPage;
    public static final String AUTH_SESSION_VALUE = "1869c345-2f90-4724-936d-a1a1ef41dea7";
    public static final String AUTH_SESSION_VALUE_NODE = "1869c345-2f90-4724-936d-a1a1ef41dea7.host";
    public static final String OLD_COOKIE_PATH = "/auth/realms/foo";
    public static final String KC_RESTART = "KC_RESTART";
    private CloseableHttpClient httpClient = null;
    private static final List<String> KEYCLOAK_COOKIE_NAMES = Arrays.asList("KC_RESTART", "AUTH_SESSION_ID", "KEYCLOAK_IDENTITY", "KEYCLOAK_SESSION");

    @After
    public void closeHttpClient() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    @Test
    public void testCookiesPath() {
        URLUtils.navigateToUri((String)(OAuthClient.AUTH_SERVER_ROOT + "/realms/foo/account"));
        this.driver.manage().deleteAllCookies();
        Assert.assertTrue((String)"There shouldn't be any cookies sent!", (boolean)this.driver.manage().getCookies().isEmpty());
        this.driver.navigate().refresh();
        Set cookies = this.driver.manage().getCookies();
        Assert.assertTrue((String)"There should be cookies sent!", (cookies.size() > 0 ? 1 : 0) != 0);
        cookies.stream().filter(cookie -> KEYCLOAK_COOKIE_NAMES.contains(cookie.getName())).forEach(cookie -> Assert.assertThat((Object)cookie.getPath(), (Matcher)Matchers.endsWith((String)"/auth/realms/foo/")));
        URLUtils.navigateToUri((String)(OAuthClient.AUTH_SERVER_ROOT + "/realms/foobar/account"));
        this.driver.manage().deleteAllCookies();
        cookies = this.driver.manage().getCookies();
        Assert.assertTrue((String)"There shouldn't be any cookies sent!", (boolean)cookies.isEmpty());
        URLUtils.navigateToUri((String)(OAuthClient.AUTH_SERVER_ROOT + "/realms/foobar/account"));
        cookies = this.driver.manage().getCookies();
        Assert.assertTrue((String)"There should be cookies sent!", (cookies.size() > 0 ? 1 : 0) != 0);
        cookies.stream().filter(cookie -> KEYCLOAK_COOKIE_NAMES.contains(cookie.getName())).forEach(cookie -> Assert.assertThat((Object)cookie.getPath(), (Matcher)Matchers.endsWith((String)"/auth/realms/foobar/")));
        URLUtils.navigateToUri((String)(OAuthClient.AUTH_SERVER_ROOT + "/realms/foo/account"));
        cookies = this.driver.manage().getCookies();
        Assert.assertTrue((String)"There should be cookies sent!", (cookies.size() > 0 ? 1 : 0) != 0);
        cookies.stream().filter(cookie -> KEYCLOAK_COOKIE_NAMES.contains(cookie.getName())).forEach(cookie -> Assert.assertThat((Object)cookie.getPath(), (Matcher)Matchers.endsWith((String)"/auth/realms/foo/")));
    }

    @Test
    public void testMultipleCookies() throws IOException {
        String requestURI = OAuthClient.AUTH_SERVER_ROOT + "/realms/foo/account";
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        BasicClientCookie wrongCookie = new BasicClientCookie("AUTH_SESSION_ID", AUTH_SESSION_VALUE);
        wrongCookie.setDomain(ServerURLs.AUTH_SERVER_HOST);
        wrongCookie.setPath(OLD_COOKIE_PATH);
        wrongCookie.setExpiryDate(calendar.getTime());
        CookieStore cookieStore = this.getCorrectCookies(requestURI);
        cookieStore.addCookie((Cookie)wrongCookie);
        Assert.assertThat((Object)cookieStore.getCookies(), (Matcher)Matchers.hasSize((int)3));
        this.login(requestURI, cookieStore);
        Assert.assertThat(cookieStore.getCookies().stream().map(Cookie::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Object[])new String[]{"AUTH_SESSION_ID", "KEYCLOAK_IDENTITY", "KEYCLOAK_SESSION"}));
        cookieStore.getCookies().stream().filter(c -> !"OAuth_Token_Request_State".equals(c.getName())).map(Cookie::getPath).forEach(path -> Assert.assertThat((Object)path, (Matcher)Matchers.endsWith((String)"/")));
        String authSessionId = cookieStore.getCookies().stream().filter(c -> "AUTH_SESSION_ID".equals(c.getName())).findFirst().get().getValue();
        String KCSessionId = cookieStore.getCookies().stream().filter(c -> "KEYCLOAK_SESSION".equals(c.getName())).findFirst().get().getValue();
        String KCSessionSuffix = KCSessionId.split("/")[2];
        Assert.assertThat((Object)authSessionId, (Matcher)Matchers.containsString((String)KCSessionSuffix));
    }

    @Test
    public void testOldCookieWithWrongPath() {
        ContainerAssume.assumeAuthServerSSL();
        org.openqa.selenium.Cookie wrongCookie = new org.openqa.selenium.Cookie("AUTH_SESSION_ID", AUTH_SESSION_VALUE, null, OLD_COOKIE_PATH, null, false, true);
        URLUtils.navigateToUri((String)(OAuthClient.AUTH_SERVER_ROOT + "/realms/foo/account"));
        this.driver.manage().deleteAllCookies();
        this.driver.manage().addCookie(wrongCookie);
        Set cookies = this.driver.manage().getCookies();
        Assert.assertThat((Object)cookies, (Matcher)Matchers.hasSize((int)1));
        this.oauth.realm("foo").redirectUri(OAuthClient.AUTH_SERVER_ROOT + "/realms/foo/account").clientId("account").openLoginForm();
        this.loginPage.login("foo", "password");
        cookies = this.driver.manage().getCookies().stream().filter(cookie -> KEYCLOAK_COOKIE_NAMES.contains(cookie.getName())).collect(Collectors.toSet());
        Assert.assertThat(cookies, (Matcher)Matchers.hasSize((int)3));
        cookies.stream().map(org.openqa.selenium.Cookie::getPath).forEach(path -> Assert.assertThat((Object)path, (Matcher)Matchers.endsWith((String)"/")));
        String authSessionId = cookies.stream().filter(c -> "AUTH_SESSION_ID".equals(c.getName())).findFirst().get().getValue();
        String KCSessionId = cookies.stream().filter(c -> "KEYCLOAK_SESSION".equals(c.getName())).findFirst().get().getValue();
        String KCSessionSuffix = KCSessionId.split("/")[2];
        Assert.assertThat((Object)authSessionId, (Matcher)Matchers.containsString((String)KCSessionSuffix));
    }

    @Test
    public void testOldCookieWithNodeInValue() throws IOException {
        String requestURI = OAuthClient.AUTH_SERVER_ROOT + "/realms/foo/account";
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        BasicClientCookie wrongCookie = new BasicClientCookie("AUTH_SESSION_ID", AUTH_SESSION_VALUE_NODE);
        wrongCookie.setDomain(ServerURLs.AUTH_SERVER_HOST);
        wrongCookie.setPath(OLD_COOKIE_PATH);
        wrongCookie.setExpiryDate(calendar.getTime());
        CookieStore cookieStore = this.getCorrectCookies(requestURI);
        cookieStore.addCookie((Cookie)wrongCookie);
        Assert.assertThat((Object)cookieStore.getCookies(), (Matcher)Matchers.hasSize((int)3));
        this.login(requestURI, cookieStore);
        Assert.assertThat(cookieStore.getCookies().stream().map(Cookie::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Object[])new String[]{"AUTH_SESSION_ID", "KEYCLOAK_IDENTITY", "KEYCLOAK_SESSION"}));
        cookieStore.getCookies().stream().filter(c -> !"OAuth_Token_Request_State".equals(c.getName())).map(Cookie::getPath).forEach(path -> Assert.assertThat((Object)path, (Matcher)Matchers.endsWith((String)"/")));
        String authSessionId = cookieStore.getCookies().stream().filter(c -> "AUTH_SESSION_ID".equals(c.getName())).findFirst().get().getValue();
        String KCSessionId = cookieStore.getCookies().stream().filter(c -> "KEYCLOAK_SESSION".equals(c.getName())).findFirst().get().getValue();
        String KCSessionSuffix = KCSessionId.split("/")[2];
        Assert.assertThat((Object)authSessionId, (Matcher)Matchers.containsString((String)KCSessionSuffix));
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder foo = RealmBuilder.create().name("foo");
        foo.user(UserBuilder.create().username("foo").password("password").role("account", AdminRoles.ADMIN).role("account", "manage-account").role("account", "view-profile").role("account", "manage-account-links"));
        testRealms.add(foo.build());
        RealmBuilder foobar = RealmBuilder.create().name("foobar");
        foo.user(UserBuilder.create().username("foobar").password("password").role("account", AdminRoles.ADMIN).role("account", "manage-account").role("account", "view-profile").role("account", "manage-account-links"));
        testRealms.add(foobar.build());
    }

    private CloseableHttpResponse sendRequest(HttpRequestBase request, CookieStore cookieStore, HttpCoreContext localContext) throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        this.httpClient = HttpClientBuilder.create().setDefaultCookieStore(cookieStore).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        return this.httpClient.execute((HttpUriRequest)request, (HttpContext)localContext);
    }

    private CookieStore getCorrectCookies(String uri) throws IOException {
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpGet request = new HttpGet(uri);
        try (CloseableHttpResponse response = this.sendRequest((HttpRequestBase)request, (CookieStore)new BasicCookieStore(), new HttpCoreContext());){
            for (Header h : response.getHeaders("Set-Cookie")) {
                if (h.getValue().contains("AUTH_SESSION_ID")) {
                    cookieStore.addCookie((Cookie)this.parseCookie(h.getValue(), "AUTH_SESSION_ID"));
                    continue;
                }
                if (!h.getValue().contains(KC_RESTART)) continue;
                cookieStore.addCookie((Cookie)this.parseCookie(h.getValue(), KC_RESTART));
            }
        }
        return cookieStore;
    }

    private BasicClientCookie parseCookie(String line, String name) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        String path = "";
        String value = "";
        for (String s : line.split(";")) {
            String[] split;
            if (s.contains(name)) {
                split = s.split("=");
                value = split[1];
                continue;
            }
            if (!s.contains("Path")) continue;
            split = s.split("=");
            path = split[1];
        }
        BasicClientCookie c = new BasicClientCookie(name, value);
        c.setExpiryDate(calendar.getTime());
        c.setDomain(ServerURLs.AUTH_SERVER_HOST);
        c.setPath(path);
        return c;
    }

    private void login(String requestURI, CookieStore cookieStore) throws IOException {
        String entityContent;
        HttpCoreContext httpContext = new HttpCoreContext();
        HttpGet request = new HttpGet(requestURI);
        try (CloseableHttpResponse response = this.sendRequest((HttpRequestBase)request, cookieStore, httpContext);){
            entityContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        }
        HttpPost post = new HttpPost(ActionURIUtils.getActionURIFromPageSource((String)entityContent));
        LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("username", "foo"));
        params.add(new BasicNameValuePair("password", "password"));
        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        try (CloseableHttpResponse response = this.sendRequest((HttpRequestBase)post, cookieStore, httpContext);){
            Assert.assertThat((String)"Expected successful login.", (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
        }
    }
}

