/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.testsuite.cluster.AbstractFailoverClusterTest;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.Cookie;

public class SessionFailoverClusterTest
extends AbstractFailoverClusterTest {
    @Before
    public void beforeSessionFailover() {
        this.log.info((Object)"Initial node failure");
        this.failure();
        WaitUtils.pause((long)REBALANCE_WAIT.intValue());
    }

    @Test
    public void sessionFailover() {
        boolean expectSuccessfulFailover = SESSION_CACHE_OWNERS >= 2;
        this.log.info((Object)("SESSION FAILOVER TEST: cluster size = " + this.getClusterSize() + ", session-cache owners = " + SESSION_CACHE_OWNERS + " --> Testsing for " + (expectSuccessfulFailover ? "" : "UN") + "SUCCESSFUL session failover."));
        Assert.assertEquals((long)2L, (long)this.getClusterSize());
        this.sessionFailover(expectSuccessfulFailover);
    }

    protected void sessionFailover(boolean expectSuccessfulFailover) {
        Cookie sessionCookie = this.login();
        this.switchFailedNode();
        if (expectSuccessfulFailover) {
            this.verifyLoggedIn(sessionCookie);
        } else {
            this.verifyLoggedOut();
        }
        this.switchFailedNode();
        if (expectSuccessfulFailover) {
            this.verifyLoggedIn(sessionCookie);
        } else {
            this.verifyLoggedOut();
            this.login();
        }
        this.logout();
        this.verifyLoggedOut();
        this.switchFailedNode();
        this.verifyLoggedOut();
    }
}

