/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.admin.client.resource.ComponentsResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractInvalidationClusterTestWithTestRealm;
import org.keycloak.testsuite.components.amphibian.TestAmphibianProvider;

public class ComponentInvalidationClusterTest
extends AbstractInvalidationClusterTestWithTestRealm<ComponentRepresentation, ComponentResource> {
    @Before
    public void setExcludedComparisonFields() {
    }

    @Override
    protected ComponentRepresentation createTestEntityRepresentation() {
        ComponentRepresentation comp = new ComponentRepresentation();
        MultivaluedHashMap config = new MultivaluedHashMap();
        comp.setName("comp_" + RandomStringUtils.randomAlphabetic((int)5));
        comp.setProviderId("test");
        comp.setProviderType(TestAmphibianProvider.class.getName());
        config.putSingle((Object)"secret", (Object)"Secret");
        config.putSingle((Object)"required", (Object)"required-value");
        config.putSingle((Object)"number", (Object)"2");
        config.put((Object)"val1", Arrays.asList("val1 value"));
        config.put((Object)"val2", Arrays.asList("val2 value"));
        comp.setConfig(config);
        return comp;
    }

    protected ComponentsResource components(ContainerInfo node) {
        return this.getAdminClientFor(node).realm(this.testRealmName).components();
    }

    @Override
    protected ComponentResource entityResource(ComponentRepresentation comp, ContainerInfo node) {
        return this.entityResource(comp.getId(), node);
    }

    @Override
    protected ComponentResource entityResource(String id, ContainerInfo node) {
        return this.components(node).component(id);
    }

    @Override
    protected ComponentRepresentation createEntity(ComponentRepresentation comp, ContainerInfo node) {
        comp.setParentId(this.getAdminClientFor(node).realm(this.testRealmName).toRepresentation().getId());
        try (Response response = this.components(node).add(comp);){
            String id = ApiUtil.getCreatedId((Response)response);
            comp.setId(id);
        }
        return this.readEntity(comp, node);
    }

    @Override
    protected ComponentRepresentation readEntity(ComponentRepresentation comp, ContainerInfo node) {
        ComponentRepresentation u = null;
        try {
            u = this.entityResource(comp, node).toRepresentation();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return u;
    }

    @Override
    protected ComponentRepresentation updateEntity(ComponentRepresentation comp, ContainerInfo node) {
        this.entityResource(comp, node).update(comp);
        return this.readEntity(comp, node);
    }

    @Override
    protected void deleteEntity(ComponentRepresentation comp, ContainerInfo node) {
        this.entityResource(comp, node).remove();
        Assert.assertNull((Object)this.readEntity(comp, node));
    }

    @Override
    protected ComponentRepresentation testEntityUpdates(ComponentRepresentation comp, boolean backendFailover) {
        comp.setName(comp.getName() + "_updated");
        comp = this.updateEntityOnCurrentFailNode(comp, "name");
        this.verifyEntityUpdateDuringFailover(comp, backendFailover);
        comp.getConfig().putSingle((Object)"val3", (Object)"val3 value");
        comp = this.updateEntityOnCurrentFailNode(comp, "config - adding");
        this.verifyEntityUpdateDuringFailover(comp, backendFailover);
        comp.getConfig().remove((Object)"val3");
        comp = this.updateEntityOnCurrentFailNode(comp, "config - removing");
        this.verifyEntityUpdateDuringFailover(comp, backendFailover);
        ((List)comp.getConfig().get((Object)"val1")).set(0, (String)((List)comp.getConfig().get((Object)"val1")).get(0) + " - updated");
        comp = this.updateEntityOnCurrentFailNode(comp, "config");
        this.verifyEntityUpdateDuringFailover(comp, backendFailover);
        return comp;
    }

    @Test
    public void testComponentUpdating() {
        ComponentRepresentation testEntity = this.createTestEntityRepresentation();
        this.log.info((Object)"(1) createEntityOnCurrentFailNode");
        ComponentRepresentation comp = this.createEntityOnCurrentFailNode(testEntity);
        for (ContainerInfo ci : this.suiteContext.getAuthServerBackendsInfo()) {
            this.assertComponentHasCorrectConfig(comp, ci);
        }
        this.iterateCurrentFailNode();
        comp.getConfig().putSingle((Object)"val3", (Object)"val3 value");
        comp = this.updateEntityOnCurrentFailNode(comp, "config - adding");
        for (ContainerInfo ci : this.suiteContext.getAuthServerBackendsInfo()) {
            this.assertComponentHasCorrectConfig(comp, ci);
        }
        this.iterateCurrentFailNode();
        comp.getConfig().remove((Object)"val3");
        comp = this.updateEntityOnCurrentFailNode(comp, "config - removing");
        for (ContainerInfo ci : this.suiteContext.getAuthServerBackendsInfo()) {
            this.assertComponentHasCorrectConfig(comp, ci);
        }
        this.iterateCurrentFailNode();
        ((List)comp.getConfig().get((Object)"val1")).set(0, (String)((List)comp.getConfig().get((Object)"val1")).get(0) + " - updated");
        comp = this.updateEntityOnCurrentFailNode(comp, "config");
        for (ContainerInfo ci : this.suiteContext.getAuthServerBackendsInfo()) {
            this.assertComponentHasCorrectConfig(comp, ci);
        }
    }

    @Override
    protected void assertEntityOnSurvivorNodesEqualsTo(ComponentRepresentation testEntityOnFailNode) {
        super.assertEntityOnSurvivorNodesEqualsTo(testEntityOnFailNode);
        for (ContainerInfo survivorNode : this.getCurrentSurvivorNodes()) {
            this.assertComponentHasCorrectConfig(testEntityOnFailNode, survivorNode);
        }
    }

    protected void assertComponentHasCorrectConfig(ComponentRepresentation testEntityOnFailNode, ContainerInfo survivorNode) throws NumberFormatException {
        this.log.debug((Object)String.format("Attempt to verify %s component reinstantiation on %s (%s)", this.getEntityType(testEntityOnFailNode), survivorNode, survivorNode.getContextRoot()));
        Map config = this.getTestingClientFor(survivorNode).testing(this.testRealmName).getTestAmphibianComponentDetails();
        MatcherAssert.assertThat((Object)config, (Matcher)Matchers.hasKey((Object)testEntityOnFailNode.getName()));
        Map c = (Map)config.get(testEntityOnFailNode.getName());
        MatcherAssert.assertThat((Object)c, (Matcher)Matchers.hasEntry((Object)"number", (Object)Integer.valueOf((String)testEntityOnFailNode.getConfig().getFirst((Object)"number"))));
        MatcherAssert.assertThat((Object)c, (Matcher)Matchers.hasEntry((Object)"required", (Object)testEntityOnFailNode.getConfig().getFirst((Object)"required")));
        MatcherAssert.assertThat((Object)c, (Matcher)Matchers.hasEntry((Object)"val1", (Object)testEntityOnFailNode.getConfig().getFirst((Object)"val1")));
        MatcherAssert.assertThat((Object)c, (Matcher)Matchers.hasEntry((Object)"val2", (Object)testEntityOnFailNode.getConfig().getFirst((Object)"val2")));
        Object val3 = testEntityOnFailNode.getConfig().getFirst((Object)"val3");
        if (val3 == null) {
            MatcherAssert.assertThat((Object)c, (Matcher)Matchers.anyOf((Matcher)Matchers.hasEntry((Object)"val3", null), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"val3"))));
        } else {
            MatcherAssert.assertThat((Object)c, (Matcher)Matchers.hasEntry((Object)"val3", (Object)val3));
        }
    }
}

