/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractInvalidationClusterTestWithTestRealm;

public class ClientInvalidationClusterTest
extends AbstractInvalidationClusterTestWithTestRealm<ClientRepresentation, ClientResource> {
    @Before
    public void setExcludedComparisonFields() {
        this.excludedComparisonFields.add("protocolMappers");
    }

    @Override
    protected ClientRepresentation createTestEntityRepresentation() {
        ClientRepresentation client = new ClientRepresentation();
        String s = RandomStringUtils.randomAlphabetic((int)5);
        client.setClientId("client_" + s);
        client.setName("name_" + s);
        return client;
    }

    protected ClientsResource clients(ContainerInfo node) {
        return this.getAdminClientFor(node).realm(this.testRealmName).clients();
    }

    @Override
    protected ClientResource entityResource(ClientRepresentation client, ContainerInfo node) {
        return this.entityResource(client.getId(), node);
    }

    @Override
    protected ClientResource entityResource(String id, ContainerInfo node) {
        return this.clients(node).get(id);
    }

    @Override
    protected ClientRepresentation createEntity(ClientRepresentation client, ContainerInfo node) {
        Response response = this.clients(node).create(client);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        client.setId(id);
        return this.readEntity(client, node);
    }

    @Override
    protected ClientRepresentation readEntity(ClientRepresentation client, ContainerInfo node) {
        ClientRepresentation u = null;
        try {
            u = this.entityResource(client, node).toRepresentation();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return u;
    }

    @Override
    protected ClientRepresentation updateEntity(ClientRepresentation client, ContainerInfo node) {
        this.entityResource(client, node).update(client);
        return this.readEntity(client, node);
    }

    @Override
    protected void deleteEntity(ClientRepresentation client, ContainerInfo node) {
        this.entityResource(client, node).remove();
        Assert.assertNull((Object)this.readEntity(client, node));
    }

    @Override
    protected ClientRepresentation testEntityUpdates(ClientRepresentation client, boolean backendFailover) {
        client.setClientId(client.getClientId() + "_updated");
        client = this.updateEntityOnCurrentFailNode(client, "clientId");
        this.verifyEntityUpdateDuringFailover(client, backendFailover);
        client.setName(client.getName() + "_updated");
        client = this.updateEntityOnCurrentFailNode(client, "name");
        this.verifyEntityUpdateDuringFailover(client, backendFailover);
        return client;
    }
}

