/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.cluster.AbstractClusterTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.Cookie;

public abstract class AbstractFailoverClusterTest
extends AbstractClusterTest {
    public static final String KEYCLOAK_SESSION_COOKIE = "KEYCLOAK_SESSION";
    public static final Integer SESSION_CACHE_OWNERS = Integer.parseInt(System.getProperty("session.cache.owners", "1"));
    public static final Integer OFFLINE_SESSION_CACHE_OWNERS = Integer.parseInt(System.getProperty("offline.session.cache.owners", "1"));
    public static final Integer LOGIN_FAILURES_CACHE_OWNERS = Integer.parseInt(System.getProperty("login.failure.cache.owners", "1"));
    public static final Integer REBALANCE_WAIT = Integer.parseInt(System.getProperty("rebalance.wait", "5000"));
    @Page
    protected LoginPage loginPage;
    @Page
    protected AppPage appPage;

    @BeforeClass
    public static void modifyAppRoot() {
        OAuthClient.updateAppRootRealm((String)"test");
    }

    @AfterClass
    public static void restoreAppRoot() {
        OAuthClient.resetAppRootRealm();
    }

    @Before
    public void setup() {
        try {
            this.adminClient.realm("test").remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        this.adminClient.realms().create(testRealm);
        UserRepresentation user = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).requiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString()).requiredAction(UserModel.RequiredAction.UPDATE_PROFILE.toString()).password("password").build();
        String userId = ApiUtil.createUserWithAdminClient((RealmResource)this.adminClient.realm("test"), (UserRepresentation)user);
        this.getCleanup().addUserId(userId);
        this.oauth.clientId("test-app");
    }

    @After
    public void after() {
        this.adminClient.realm("test").remove();
    }

    protected void switchFailedNode() {
        Assert.assertFalse((boolean)this.controller.isStarted(this.getCurrentFailNode().getQualifier()));
        this.failback();
        WaitUtils.pause((long)REBALANCE_WAIT.intValue());
        this.iterateCurrentFailNode();
        this.failure();
        WaitUtils.pause((long)REBALANCE_WAIT.intValue());
        Assert.assertFalse((boolean)this.controller.isStarted(this.getCurrentFailNode().getQualifier()));
    }

    protected Cookie login() {
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        Cookie sessionCookie = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNotNull((Object)sessionCookie);
        return sessionCookie;
    }

    protected void logout() {
        this.appPage.logout();
    }

    protected Cookie verifyLoggedIn(Cookie sessionCookieForVerification) {
        URLUtils.navigateToUri((String)(OAuthClient.AUTH_SERVER_ROOT + "/realms/test"));
        Cookie sessionCookieOnRealmPath = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNotNull((Object)sessionCookieOnRealmPath);
        Assert.assertEquals((Object)sessionCookieOnRealmPath.getValue(), (Object)sessionCookieForVerification.getValue());
        this.appPage.open();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        Cookie sessionCookie = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNotNull((Object)sessionCookie);
        Assert.assertEquals((Object)sessionCookie.getValue(), (Object)sessionCookieForVerification.getValue());
        return sessionCookie;
    }

    protected void verifyLoggedOut() {
        this.oauth.openLoginForm();
        this.driver.navigate().refresh();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Cookie sessionCookie = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNull((Object)sessionCookie);
    }
}

