/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.tls.TLSUtils;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public abstract class AbstractClusterTest
extends AbstractKeycloakTest {
    public static final String QUALIFIER_AUTH_SERVER_NODE_1 = "auth-server-${auth.server}-backend1";
    public static final String QUALIFIER_AUTH_SERVER_NODE_2 = "auth-server-${auth.server}-backend2";
    @ArquillianResource
    protected ContainerController controller;
    protected static Map<ContainerInfo, Keycloak> backendAdminClients = new HashMap<ContainerInfo, Keycloak>();
    protected static Map<ContainerInfo, KeycloakTestingClient> backendTestingClients = new HashMap<ContainerInfo, KeycloakTestingClient>();
    private int currentFailNodeIndex = 0;

    public int getClusterSize() {
        return this.suiteContext.getAuthServerBackendsInfo().size();
    }

    protected void iterateCurrentFailNode() {
        ++this.currentFailNodeIndex;
        if (this.currentFailNodeIndex >= this.getClusterSize()) {
            this.currentFailNodeIndex = 0;
        }
        this.logFailoverSetup();
    }

    protected void setCurrentFailNodeForRoute(String nodeName) {
        String route = nodeName.substring(nodeName.lastIndexOf(46) + 1);
        int portSeparator = route.indexOf(45);
        String routeNumber = portSeparator == -1 ? route.substring(route.length() - 1) : route.substring(portSeparator - 1, portSeparator);
        this.currentFailNodeIndex = Integer.parseInt(routeNumber) - 1;
    }

    protected ContainerInfo getCurrentFailNode() {
        return this.backendNode(this.currentFailNodeIndex);
    }

    protected Set<ContainerInfo> getCurrentSurvivorNodes() {
        HashSet<ContainerInfo> survivors = new HashSet<ContainerInfo>(this.suiteContext.getAuthServerBackendsInfo());
        survivors.remove(this.getCurrentFailNode());
        return survivors;
    }

    protected void logFailoverSetup() {
        this.log.info((Object)"Current failover setup");
        boolean started = this.controller.isStarted(this.getCurrentFailNode().getQualifier());
        this.log.info((Object)("Fail node: " + this.getCurrentFailNode() + (started ? "" : " (stopped)")));
        for (ContainerInfo survivor : this.getCurrentSurvivorNodes()) {
            started = this.controller.isStarted(survivor.getQualifier());
            this.log.info((Object)("Survivor:  " + survivor + (started ? "" : " (stopped)")));
        }
    }

    public void failure() {
        this.log.info((Object)"Simulating failure");
        this.killBackendNode(this.getCurrentFailNode());
    }

    public void failback() {
        this.log.info((Object)"Bringing all backend nodes online");
        for (ContainerInfo node : this.suiteContext.getAuthServerBackendsInfo()) {
            this.startBackendNode(node);
        }
    }

    protected ContainerInfo frontendNode() {
        return this.suiteContext.getAuthServerInfo();
    }

    protected ContainerInfo backendNode(int i) {
        return (ContainerInfo)this.suiteContext.getAuthServerBackendsInfo().get(i);
    }

    protected void startBackendNode(ContainerInfo node) {
        if (!this.controller.isStarted(node.getQualifier())) {
            this.log.info((Object)("Starting backend node: " + node));
            this.controller.start(node.getQualifier());
            Assert.assertTrue((boolean)this.controller.isStarted(node.getQualifier()));
        }
        this.log.info((Object)("Backend node " + node + " is started"));
        AuthServerTestEnricher.initializeTLS((ContainerInfo)node);
        if (!backendAdminClients.containsKey(node)) {
            backendAdminClients.put(node, this.createAdminClientFor(node));
        }
        if (!backendTestingClients.containsKey(node)) {
            backendTestingClients.put(node, this.createTestingClientFor(node));
        }
    }

    protected Keycloak createAdminClientFor(ContainerInfo node) {
        this.log.info((Object)("Initializing admin client for " + node.getContextRoot() + "/auth"));
        return Keycloak.getInstance((String)(node.getContextRoot() + "/auth"), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
    }

    protected KeycloakTestingClient createTestingClientFor(ContainerInfo node) {
        this.log.info((Object)("Initializing testing client for " + node.getContextRoot() + "/auth"));
        return KeycloakTestingClient.getInstance((String)(node.getContextRoot() + "/auth"));
    }

    protected void killBackendNode(ContainerInfo node) {
        backendAdminClients.get(node).close();
        backendAdminClients.remove(node);
        backendTestingClients.get(node).close();
        backendTestingClients.remove(node);
        this.log.info((Object)("Killing backend node: " + node));
        this.controller.kill(node.getQualifier());
    }

    protected Keycloak getAdminClientFor(ContainerInfo node) {
        Keycloak adminClient = backendAdminClients.get(node);
        if (adminClient == null && node.equals((Object)this.suiteContext.getAuthServerInfo())) {
            adminClient = this.adminClient;
        }
        return adminClient;
    }

    protected KeycloakTestingClient getTestingClientFor(ContainerInfo node) {
        KeycloakTestingClient testingClient = backendTestingClients.get(node);
        if (testingClient == null && node.equals((Object)this.suiteContext.getAuthServerInfo())) {
            testingClient = this.testingClient;
        }
        return testingClient;
    }

    @BeforeClass
    public static void enabled() {
        ContainerAssume.assumeClusteredContainer();
    }

    @AfterClass
    public static void closeClients() {
        backendAdminClients.values().forEach(Keycloak::close);
        backendAdminClients.clear();
        backendTestingClients.values().forEach(KeycloakTestingClient::close);
        backendTestingClients.clear();
    }

    @Before
    public void beforeClusterTest() {
        this.failback();
        this.logFailoverSetup();
        WaitUtils.pause((long)3000L);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }
}

