/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.protocol.oidc.mappers.SHA256PairwiseSubMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.UserInfo;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserInfoClientUtil;
import org.keycloak.testsuite.util.UserManager;

public class OIDCPairwiseClientRegistrationTest
extends AbstractClientRegistrationTest {
    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ClientInitialAccessPresentation token = this.adminClient.realm("test").clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    private OIDCClientRepresentation createRep() {
        OIDCClientRepresentation client = new OIDCClientRepresentation();
        client.setClientName("RegistrationAccessTokenTest");
        client.setClientUri(OAuthClient.APP_ROOT);
        client.setRedirectUris(Collections.singletonList(this.oauth.getRedirectUri()));
        return client;
    }

    public OIDCClientRepresentation create() throws ClientRegistrationException {
        OIDCClientRepresentation client = this.createRep();
        OIDCClientRepresentation response = this.reg.oidc().create(client);
        return response;
    }

    public OIDCClientRepresentation createPairwise() throws ClientRegistrationException {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setSubjectType("pairwise");
        OIDCClientRepresentation pairwiseClient = this.reg.oidc().create(clientRep);
        return pairwiseClient;
    }

    private void assertCreateFail(OIDCClientRepresentation client, int expectedStatusCode, String expectedErrorContains) {
        block2: {
            try {
                this.reg.oidc().create(client);
                Assert.fail((String)"Not expected to successfuly register client");
            }
            catch (ClientRegistrationException expected) {
                HttpErrorException httpEx = (HttpErrorException)expected.getCause();
                Assert.assertEquals((long)expectedStatusCode, (long)httpEx.getStatusLine().getStatusCode());
                if (expectedErrorContains == null) break block2;
                org.junit.Assert.assertTrue((String)"Error response doesn't contain expected text", (boolean)httpEx.getErrorResponse().contains(expectedErrorContains));
            }
        }
    }

    @Test
    public void createPairwiseClient() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setSubjectType("pairwise");
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"pairwise", (Object)response.getSubjectType());
    }

    @Test
    public void updateClientToPairwise() throws Exception {
        OIDCClientRepresentation response = this.create();
        Assert.assertEquals((Object)"public", (Object)response.getSubjectType());
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        response.setSubjectType("pairwise");
        OIDCClientRepresentation updated = this.reg.oidc().update(response);
        Assert.assertEquals((Object)"pairwise", (Object)updated.getSubjectType());
    }

    @Test
    public void updateSectorIdentifierUri() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setSubjectType("pairwise");
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"pairwise", (Object)response.getSubjectType());
        Assert.assertNull((Object)response.getSectorIdentifierUri());
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        ArrayList sectorRedirects = new ArrayList();
        sectorRedirects.addAll(response.getRedirectUris());
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setSectorIdentifierRedirectUris(sectorRedirects);
        response.setSectorIdentifierUri(TestApplicationResourceUrls.pairwiseSectorIdentifierUri());
        OIDCClientRepresentation updated = this.reg.oidc().update(response);
        Assert.assertEquals((Object)"pairwise", (Object)updated.getSubjectType());
        Assert.assertEquals((Object)TestApplicationResourceUrls.pairwiseSectorIdentifierUri(), (Object)updated.getSectorIdentifierUri());
    }

    @Test
    public void updateToPairwiseThroughAdminRESTSuccess() throws Exception {
        OIDCClientRepresentation response = this.create();
        Assert.assertEquals((Object)"public", (Object)response.getSubjectType());
        Assert.assertNull((Object)response.getSectorIdentifierUri());
        ArrayList sectorRedirects = new ArrayList();
        sectorRedirects.addAll(response.getRedirectUris());
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setSectorIdentifierRedirectUris(sectorRedirects);
        String sectorIdentifierUri = TestApplicationResourceUrls.pairwiseSectorIdentifierUri();
        String clientId = response.getClientId();
        ProtocolMapperRepresentation pairwiseProtMapper = SHA256PairwiseSubMapper.createPairwiseMapper((String)sectorIdentifierUri, null);
        RealmResource realmResource = this.realmsResouce().realm("test");
        ClientManager.realm(realmResource).clientId(clientId).addProtocolMapper(pairwiseProtMapper);
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        OIDCClientRepresentation rep = this.reg.oidc().get(response.getClientId());
        Assert.assertEquals((Object)"pairwise", (Object)rep.getSubjectType());
        Assert.assertEquals((Object)sectorIdentifierUri, (Object)rep.getSectorIdentifierUri());
    }

    @Test
    public void updateToPairwiseThroughAdminRESTFailure() throws Exception {
        OIDCClientRepresentation response = this.create();
        Assert.assertEquals((Object)"public", (Object)response.getSubjectType());
        Assert.assertNull((Object)response.getSectorIdentifierUri());
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setSectorIdentifierRedirectUris(new ArrayList());
        String sectorIdentifierUri = TestApplicationResourceUrls.pairwiseSectorIdentifierUri();
        String clientId = response.getClientId();
        ProtocolMapperRepresentation pairwiseProtMapper = SHA256PairwiseSubMapper.createPairwiseMapper((String)sectorIdentifierUri, null);
        RealmResource realmResource = this.realmsResouce().realm("test");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.realmsResouce().realm("test"), (String)clientId);
        Response resp = clientResource.getProtocolMappers().createMapper(pairwiseProtMapper);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        OIDCClientRepresentation rep = this.reg.oidc().get(response.getClientId());
        Assert.assertEquals((Object)"public", (Object)rep.getSubjectType());
        Assert.assertNull((Object)rep.getSectorIdentifierUri());
    }

    @Test
    public void createPairwiseClientWithSectorIdentifierURI() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        ArrayList sectorRedirects = new ArrayList();
        sectorRedirects.addAll(clientRep.getRedirectUris());
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setSectorIdentifierRedirectUris(sectorRedirects);
        clientRep.setSubjectType("pairwise");
        clientRep.setSectorIdentifierUri(TestApplicationResourceUrls.pairwiseSectorIdentifierUri());
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"pairwise", (Object)response.getSubjectType());
        Assert.assertEquals((Object)TestApplicationResourceUrls.pairwiseSectorIdentifierUri(), (Object)response.getSectorIdentifierUri());
    }

    @Test
    public void createPairwiseClientWithRedirectsToMultipleHostsWithoutSectorIdentifierURI() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        ArrayList<String> redirects = new ArrayList<String>();
        redirects.add("http://redirect1");
        redirects.add("http://redirect2");
        clientRep.setSubjectType("pairwise");
        clientRep.setRedirectUris(redirects);
        this.assertCreateFail(clientRep, 400, "Without a configured Sector Identifier URI, client redirect URIs must not contain multiple host components.");
    }

    @Test
    public void createPairwiseClientWithRedirectsToMultipleHosts() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        ArrayList<String> redirects = new ArrayList<String>();
        redirects.add("http://redirect1");
        redirects.add("http://redirect2");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setSectorIdentifierRedirectUris(redirects);
        clientRep.setSubjectType("pairwise");
        clientRep.setSectorIdentifierUri(TestApplicationResourceUrls.pairwiseSectorIdentifierUri());
        clientRep.setRedirectUris(redirects);
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"pairwise", (Object)response.getSubjectType());
        Assert.assertEquals((Object)TestApplicationResourceUrls.pairwiseSectorIdentifierUri(), (Object)response.getSectorIdentifierUri());
        Assert.assertNames(response.getRedirectUris(), "http://redirect1", "http://redirect2");
    }

    @Test
    public void createPairwiseClientWithSectorIdentifierURIContainingMismatchedRedirects() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        ArrayList<String> sectorRedirects = new ArrayList<String>();
        sectorRedirects.add("http://someotherredirect");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setSectorIdentifierRedirectUris(sectorRedirects);
        clientRep.setSubjectType("pairwise");
        clientRep.setSectorIdentifierUri(TestApplicationResourceUrls.pairwiseSectorIdentifierUri());
        this.assertCreateFail(clientRep, 400, "Client redirect URIs does not match redirect URIs fetched from the Sector Identifier URI.");
    }

    @Test
    public void createPairwiseClientWithSectorIdentifierURIContainingMismatchedRedirectsPublicSubject() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        ArrayList<String> sectorRedirects = new ArrayList<String>();
        sectorRedirects.add("http://someotherredirect");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setSectorIdentifierRedirectUris(sectorRedirects);
        clientRep.setSubjectType("public");
        clientRep.setSectorIdentifierUri(TestApplicationResourceUrls.pairwiseSectorIdentifierUri());
        this.assertCreateFail(clientRep, 400, "Client redirect URIs does not match redirect URIs fetched from the Sector Identifier URI.");
    }

    @Test
    public void createPairwiseClientWithInvalidSectorIdentifierURI() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setSubjectType("pairwise");
        clientRep.setSectorIdentifierUri("malformed");
        this.assertCreateFail(clientRep, 400, "Invalid Sector Identifier URI.");
    }

    @Test
    public void createPairwiseClientWithUnreachableSectorIdentifierURI() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setSubjectType("pairwise");
        clientRep.setSectorIdentifierUri("http://localhost/dummy");
        this.assertCreateFail(clientRep, 400, "Failed to get redirect URIs from the Sector Identifier URI.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loginUserToPairwiseClient() throws Exception {
        OIDCClientRepresentation publicClient = this.create();
        this.oauth.clientId(publicClient.getClientId());
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin("test-user@localhost", "password");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(loginResponse.getCode(), publicClient.getClientSecret());
        AccessToken accessToken = this.oauth.verifyToken(accessTokenResponse.getAccessToken());
        Assert.assertEquals((Object)"test-user", (Object)accessToken.getPreferredUsername());
        Assert.assertEquals((Object)"test-user@localhost", (Object)accessToken.getEmail());
        String tokenUserId = accessToken.getSubject();
        UserRepresentation user = (UserRepresentation)this.realmsResouce().realm("test").users().search("test-user", Integer.valueOf(0), Integer.valueOf(1)).get(0);
        Assert.assertEquals((Object)user.getId(), (Object)tokenUserId);
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setSubjectType("pairwise");
        OIDCClientRepresentation pairwiseClient = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"pairwise", (Object)pairwiseClient.getSubjectType());
        this.oauth.clientId(pairwiseClient.getClientId());
        this.oauth.openLoginForm();
        loginResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        accessTokenResponse = this.oauth.doAccessTokenRequest(loginResponse.getCode(), pairwiseClient.getClientSecret());
        String accessTokenPayload = this.getPayload(accessTokenResponse.getAccessToken());
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((String)accessTokenPayload, (String)"\"sub\""));
        String idTokenPayload = this.getPayload(accessTokenResponse.getIdToken());
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((String)idTokenPayload, (String)"\"sub\""));
        String refreshTokenPayload = this.getPayload(accessTokenResponse.getRefreshToken());
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((String)refreshTokenPayload, (String)"\"sub\""));
        accessToken = this.oauth.verifyToken(accessTokenResponse.getAccessToken());
        Assert.assertEquals((Object)"test-user", (Object)accessToken.getPreferredUsername());
        Assert.assertEquals((Object)"test-user@localhost", (Object)accessToken.getEmail());
        String pairwiseUserId = accessToken.getSubject();
        Assert.assertNotEquals((Object)pairwiseUserId, (Object)user.getId());
        try (ResteasyClient jaxrsClient = AdminClientUtil.createResteasyClient();){
            Response userInfoResponse = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)jaxrsClient, (String)accessTokenResponse.getAccessToken());
            UserInfo userInfo = UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)userInfoResponse, (String)"test-user", (String)"test-user@localhost");
            String userInfoSubId = userInfo.getSubject();
            Assert.assertEquals((Object)pairwiseUserId, (Object)userInfoSubId);
        }
    }

    @Test
    public void refreshPairwiseToken() throws Exception {
        OIDCClientRepresentation pairwiseClient = this.createPairwise();
        OAuthClient.AccessTokenResponse accessTokenResponse = this.login(pairwiseClient, "test-user@localhost", "password");
        this.oauth.parseRefreshToken(accessTokenResponse.getAccessToken());
        IDToken idToken = this.oauth.verifyIDToken(accessTokenResponse.getIdToken());
        this.oauth.parseRefreshToken(accessTokenResponse.getRefreshToken());
        OAuthClient.AccessTokenResponse refreshTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), pairwiseClient.getClientSecret());
        this.oauth.verifyToken(refreshTokenResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshTokenResponse.getRefreshToken());
        IDToken refreshedIdToken = this.oauth.verifyIDToken(refreshTokenResponse.getIdToken());
        Assert.assertEquals((Object)idToken.getIssuer(), (Object)refreshedRefreshToken.getIssuer());
        Assert.assertEquals((Object)idToken.getSubject(), (Object)refreshedRefreshToken.getSubject());
        Assert.assertEquals((long)refreshedIdToken.getIssuedAt(), (long)refreshedRefreshToken.getIssuedAt());
        Assert.assertEquals((long)idToken.getAuthTime(), (long)refreshedIdToken.getAuthTime());
        Assert.assertEquals((Object)idToken.getIssuedFor(), (Object)refreshedIdToken.getIssuedFor());
    }

    @Test
    public void introspectPairwiseAccessToken() throws Exception {
        OIDCClientRepresentation pairwiseClient = this.createPairwise();
        OAuthClient.AccessTokenResponse accessTokenResponse = this.login(pairwiseClient, "test-user@localhost", "password");
        String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential(pairwiseClient.getClientId(), pairwiseClient.getClientSecret(), accessTokenResponse.getAccessToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(introspectionResponse);
        Assert.assertEquals((Object)true, (Object)jsonNode.get("active").asBoolean());
        Assert.assertEquals((Object)"test-user@localhost", (Object)jsonNode.get("email").asText());
    }

    @Test
    public void refreshPairwiseTokenDeletedUser() throws Exception {
        String userId = this.createUser("test", "delete-me@localhost", "password", new String[0]);
        OIDCClientRepresentation pairwiseClient = this.createPairwise();
        this.oauth.clientId(pairwiseClient.getClientId());
        this.oauth.clientId(pairwiseClient.getClientId());
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin("delete-me@localhost", "password");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(loginResponse.getCode(), pairwiseClient.getClientSecret());
        org.junit.Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        this.adminClient.realm("test").users().delete(userId);
        OAuthClient.AccessTokenResponse refreshTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), pairwiseClient.getClientSecret());
        org.junit.Assert.assertEquals((long)400L, (long)refreshTokenResponse.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)refreshTokenResponse.getError());
        org.junit.Assert.assertNull((Object)refreshTokenResponse.getAccessToken());
        org.junit.Assert.assertNull((Object)refreshTokenResponse.getIdToken());
        org.junit.Assert.assertNull((Object)refreshTokenResponse.getRefreshToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshPairwiseTokenDisabledUser() throws Exception {
        this.createUser("test", "disable-me@localhost", "password", new String[0]);
        OIDCClientRepresentation pairwiseClient = this.createPairwise();
        this.oauth.clientId(pairwiseClient.getClientId());
        this.oauth.clientId(pairwiseClient.getClientId());
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin("disable-me@localhost", "password");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(loginResponse.getCode(), pairwiseClient.getClientSecret());
        org.junit.Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        try {
            UserManager.realm(this.adminClient.realm("test")).username("disable-me@localhost").enabled(false);
            OAuthClient.AccessTokenResponse refreshTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), pairwiseClient.getClientSecret());
            org.junit.Assert.assertEquals((long)400L, (long)refreshTokenResponse.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)refreshTokenResponse.getError());
            org.junit.Assert.assertNull((Object)refreshTokenResponse.getAccessToken());
            org.junit.Assert.assertNull((Object)refreshTokenResponse.getIdToken());
            org.junit.Assert.assertNull((Object)refreshTokenResponse.getRefreshToken());
        }
        finally {
            UserManager.realm(this.adminClient.realm("test")).username("disable-me@localhost").enabled(true);
        }
    }

    private OAuthClient.AccessTokenResponse login(OIDCClientRepresentation client, String username, String password) {
        this.oauth.clientId(client.getClientId());
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(username, password);
        return this.oauth.doAccessTokenRequest(loginResponse.getCode(), client.getClientSecret());
    }

    private String getPayload(String token) {
        String payloadBase64 = token.split("\\.")[1];
        return new String(Base64.getDecoder().decode(payloadBase64));
    }
}

