/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;
import org.keycloak.testsuite.util.KeycloakModelUtils;

public class OIDCClientRegistrationTest
extends AbstractClientRegistrationTest {
    private static final String PRIVATE_KEY = "MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=";
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB";
    private static final String ERR_MSG_CLIENT_REG_FAIL = "Failed to send request";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        super.addTestRealms(testRealms);
        RealmRepresentation testRealm = testRealms.get(0);
        testRealm.setPrivateKey(PRIVATE_KEY);
        testRealm.setPublicKey(PUBLIC_KEY);
        ClientRepresentation samlApp = KeycloakModelUtils.createClient(testRealm, "saml-client");
        samlApp.setSecret("secret");
        samlApp.setServiceAccountsEnabled(Boolean.valueOf(true));
        samlApp.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ClientInitialAccessPresentation token = this.adminClient.realm("test").clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    private OIDCClientRepresentation createRep() {
        OIDCClientRepresentation client = new OIDCClientRepresentation();
        client.setClientName("RegistrationAccessTokenTest");
        client.setClientUri("http://root");
        client.setRedirectUris(Collections.singletonList("http://redirect"));
        client.setFrontChannelLogoutUri("http://frontchannel");
        return client;
    }

    public OIDCClientRepresentation create() throws ClientRegistrationException {
        OIDCClientRepresentation client = this.createRep();
        OIDCClientRepresentation response = this.reg.oidc().create(client);
        return response;
    }

    private void assertCreateFail(OIDCClientRepresentation client, int expectedStatusCode) {
        this.assertCreateFail(client, expectedStatusCode, null);
    }

    private void assertCreateFail(OIDCClientRepresentation client, int expectedStatusCode, String expectedErrorContains) {
        block2: {
            try {
                this.reg.oidc().create(client);
                Assert.fail((String)"Not expected to successfuly register client");
            }
            catch (ClientRegistrationException expected) {
                HttpErrorException httpEx = (HttpErrorException)expected.getCause();
                Assert.assertEquals((long)expectedStatusCode, (long)httpEx.getStatusLine().getStatusCode());
                if (expectedErrorContains == null) break block2;
                org.junit.Assert.assertTrue((String)"Error response doesn't contain expected text", (boolean)httpEx.getErrorResponse().contains(expectedErrorContains));
            }
        }
    }

    private void assertGetFail(String clientId, int expectedStatusCode, String expectedErrorContains) {
        block2: {
            try {
                this.reg.oidc().get(clientId);
                Assert.fail((String)"Not expected to successfully get client");
            }
            catch (ClientRegistrationException expected) {
                HttpErrorException httpEx = (HttpErrorException)expected.getCause();
                Assert.assertEquals((long)expectedStatusCode, (long)httpEx.getStatusLine().getStatusCode());
                if (expectedErrorContains == null) break block2;
                org.junit.Assert.assertTrue((String)"Error response doesn't contain expected text", (boolean)httpEx.getErrorResponse().contains(expectedErrorContains));
            }
        }
    }

    @Test
    public void createClientWithUriFragment() {
        OIDCClientRepresentation client = this.createRep();
        client.setRedirectUris(Arrays.asList("http://localhost/auth", "http://localhost/auth#fragment", "http://localhost/auth*"));
        this.assertCreateFail(client, 400, "URI fragment");
    }

    @Test
    public void createClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        org.junit.Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        org.junit.Assert.assertNotNull((Object)response.getClientIdIssuedAt());
        org.junit.Assert.assertNotNull((Object)response.getClientId());
        org.junit.Assert.assertNotNull((Object)response.getClientSecret());
        org.junit.Assert.assertEquals((long)0L, (long)response.getClientSecretExpiresAt().intValue());
        org.junit.Assert.assertNotNull((Object)response.getRegistrationClientUri());
        org.junit.Assert.assertEquals((Object)"RegistrationAccessTokenTest", (Object)response.getClientName());
        org.junit.Assert.assertEquals((Object)"http://root", (Object)response.getClientUri());
        org.junit.Assert.assertEquals((long)1L, (long)response.getRedirectUris().size());
        org.junit.Assert.assertEquals((Object)"http://redirect", response.getRedirectUris().get(0));
        org.junit.Assert.assertEquals(Arrays.asList("code", "none"), (Object)response.getResponseTypes());
        org.junit.Assert.assertEquals(Arrays.asList("authorization_code", "refresh_token"), (Object)response.getGrantTypes());
        org.junit.Assert.assertEquals((Object)"client_secret_basic", (Object)response.getTokenEndpointAuthMethod());
        Assert.assertNull((Object)response.getUserinfoSignedResponseAlg());
        org.junit.Assert.assertEquals((Object)"http://frontchannel", (Object)response.getFrontChannelLogoutUri());
    }

    @Test
    public void getClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        OIDCClientRepresentation rep = this.reg.oidc().get(response.getClientId());
        org.junit.Assert.assertNotNull((Object)rep);
        org.junit.Assert.assertEquals((Object)response.getRegistrationAccessToken(), (Object)rep.getRegistrationAccessToken());
        org.junit.Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("code", "none"), (Collection)response.getResponseTypes()));
        org.junit.Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("authorization_code", "refresh_token"), (Collection)response.getGrantTypes()));
        org.junit.Assert.assertNotNull((Object)response.getClientSecret());
        org.junit.Assert.assertEquals((long)0L, (long)response.getClientSecretExpiresAt().intValue());
        org.junit.Assert.assertEquals((Object)"client_secret_basic", (Object)response.getTokenEndpointAuthMethod());
    }

    @Test
    public void updateClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        response.setRedirectUris(Collections.singletonList("http://newredirect"));
        response.setResponseTypes(Arrays.asList("code", "id_token token", "code id_token token"));
        response.setGrantTypes(Arrays.asList("authorization_code", "refresh_token", "password"));
        OIDCClientRepresentation updated = this.reg.oidc().update(response);
        org.junit.Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Collections.singletonList("http://newredirect"), (Collection)updated.getRedirectUris()));
        org.junit.Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("authorization_code", "implicit", "refresh_token", "password"), (Collection)updated.getGrantTypes()));
        org.junit.Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("code", "none", "id_token", "id_token token", "code id_token", "code token", "code id_token token"), (Collection)updated.getResponseTypes()));
    }

    @Test
    public void updateClientError() throws ClientRegistrationException {
        try {
            OIDCClientRepresentation response = this.create();
            this.reg.auth(Auth.token((OIDCClientRepresentation)response));
            response.setResponseTypes(Arrays.asList("code", "tokenn"));
            this.reg.oidc().update(response);
            org.junit.Assert.fail((String)"Not expected to end with success");
        }
        catch (ClientRegistrationException clientRegistrationException) {
            // empty catch block
        }
    }

    @Test
    public void deleteClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        this.reg.oidc().delete(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignaturesRequired() throws Exception {
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        try {
            clientRep = this.createRep();
            clientRep.setUserinfoSignedResponseAlg(Algorithm.ES256.toString());
            clientRep.setRequestObjectSigningAlg(Algorithm.ES256.toString());
            response = this.reg.oidc().create(clientRep);
            Assert.assertEquals((Object)Algorithm.ES256.toString(), (Object)response.getUserinfoSignedResponseAlg());
            Assert.assertEquals((Object)Algorithm.ES256.toString(), (Object)response.getRequestObjectSigningAlg());
            Assert.assertNotNull((Object)response.getClientSecret());
            ClientRepresentation kcClient = this.getClient(response.getClientId());
            OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)config.getUserInfoSignedResponseAlg(), (Object)Algorithm.ES256);
            Assert.assertEquals((Object)config.getRequestObjectSignatureAlg(), (Object)Algorithm.ES256);
            clientRep.setUserinfoSignedResponseAlg(Algorithm.PS256.toString());
            clientRep.setRequestObjectSigningAlg(Algorithm.PS256.toString());
            response = this.reg.oidc().create(clientRep);
            Assert.assertEquals((Object)Algorithm.PS256.toString(), (Object)response.getUserinfoSignedResponseAlg());
            Assert.assertEquals((Object)Algorithm.PS256.toString(), (Object)response.getRequestObjectSigningAlg());
            kcClient = this.getClient(response.getClientId());
            config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)config.getUserInfoSignedResponseAlg(), (Object)Algorithm.PS256);
            Assert.assertEquals((Object)config.getRequestObjectSignatureAlg(), (Object)Algorithm.PS256);
        }
        finally {
            clientRep.setUserinfoSignedResponseAlg(Algorithm.RS256.toString());
            clientRep.setRequestObjectSigningAlg(Algorithm.RS256.toString());
            response = this.reg.oidc().create(clientRep);
        }
    }

    @Test
    public void createClientImplicitFlow() throws ClientRegistrationException {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setResponseTypes(Arrays.asList("id_token token"));
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        String clientId = response.getClientId();
        ClientRepresentation kcClientRep = this.getKeycloakClient(clientId);
        Assert.assertFalse((boolean)kcClientRep.isPublicClient());
        Assert.assertNull((Object)kcClientRep.getSecret());
    }

    @Test
    public void createPublicClient() throws ClientRegistrationException {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setTokenEndpointAuthMethod("none");
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"none", (Object)response.getTokenEndpointAuthMethod());
        String clientId = response.getClientId();
        ClientRepresentation kcClientRep = this.getKeycloakClient(clientId);
        Assert.assertTrue((boolean)kcClientRep.isPublicClient());
        Assert.assertNull((Object)kcClientRep.getSecret());
    }

    @Test
    public void testMtlsHoKTokenEnabled() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)response.getTlsClientCertificateBoundAccessTokens());
        Assert.assertNotNull((Object)response.getClientSecret());
        ClientRepresentation kcClient = this.getClient(response.getClientId());
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
        org.junit.Assert.assertTrue((!config.isUseMtlsHokToken() ? 1 : 0) != 0);
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        response.setTlsClientCertificateBoundAccessTokens(Boolean.TRUE);
        OIDCClientRepresentation updated = this.reg.oidc().update(response);
        org.junit.Assert.assertTrue((boolean)updated.getTlsClientCertificateBoundAccessTokens());
        kcClient = this.getClient(updated.getClientId());
        config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
        org.junit.Assert.assertTrue((boolean)config.isUseMtlsHokToken());
        this.reg.auth(Auth.token((OIDCClientRepresentation)updated));
        updated.setTlsClientCertificateBoundAccessTokens(Boolean.FALSE);
        OIDCClientRepresentation reUpdated = this.reg.oidc().update(updated);
        org.junit.Assert.assertTrue((reUpdated.getTlsClientCertificateBoundAccessTokens() == false ? 1 : 0) != 0);
        kcClient = this.getClient(reUpdated.getClientId());
        config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
        org.junit.Assert.assertTrue((!config.isUseMtlsHokToken() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdTokenEncryptedResponse() throws Exception {
        OIDCClientRepresentation response = null;
        OIDCClientRepresentation updated = null;
        try {
            OIDCClientRepresentation clientRep = this.createRep();
            response = this.reg.oidc().create(clientRep);
            Assert.assertEquals((Object)Boolean.FALSE, (Object)response.getTlsClientCertificateBoundAccessTokens());
            Assert.assertNotNull((Object)response.getClientSecret());
            ClientRepresentation kcClient = this.getClient(response.getClientId());
            OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertNull((Object)config.getIdTokenEncryptedResponseAlg());
            Assert.assertNull((Object)config.getIdTokenEncryptedResponseEnc());
            this.reg.auth(Auth.token((OIDCClientRepresentation)response));
            response.setIdTokenEncryptedResponseAlg("RSA1_5");
            response.setIdTokenEncryptedResponseEnc("A128CBC-HS256");
            updated = this.reg.oidc().update(response);
            Assert.assertEquals((Object)"RSA1_5", (Object)updated.getIdTokenEncryptedResponseAlg());
            Assert.assertEquals((Object)"A128CBC-HS256", (Object)updated.getIdTokenEncryptedResponseEnc());
            kcClient = this.getClient(updated.getClientId());
            config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)"RSA1_5", (Object)config.getIdTokenEncryptedResponseAlg());
            Assert.assertEquals((Object)"A128CBC-HS256", (Object)config.getIdTokenEncryptedResponseEnc());
        }
        catch (Throwable throwable) {
            this.reg.auth(Auth.token(updated));
            updated.setIdTokenEncryptedResponseAlg(null);
            updated.setIdTokenEncryptedResponseEnc(null);
            this.reg.oidc().update(updated);
            throw throwable;
        }
        this.reg.auth(Auth.token((OIDCClientRepresentation)updated));
        updated.setIdTokenEncryptedResponseAlg(null);
        updated.setIdTokenEncryptedResponseEnc(null);
        this.reg.oidc().update(updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenEndpointSigningAlg() throws Exception {
        OIDCClientRepresentation response = null;
        OIDCClientRepresentation updated = null;
        try {
            OIDCClientRepresentation clientRep = this.createRep();
            clientRep.setTokenEndpointAuthSigningAlg(Algorithm.ES256.toString());
            response = this.reg.oidc().create(clientRep);
            Assert.assertEquals((Object)Algorithm.ES256.toString(), (Object)response.getTokenEndpointAuthSigningAlg());
            ClientRepresentation kcClient = this.getClient(response.getClientId());
            OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)Algorithm.ES256.toString(), (Object)config.getTokenEndpointAuthSigningAlg());
            this.reg.auth(Auth.token((OIDCClientRepresentation)response));
            response.setTokenEndpointAuthSigningAlg(null);
            updated = this.reg.oidc().update(response);
            Assert.assertEquals(null, (Object)response.getTokenEndpointAuthSigningAlg());
            kcClient = this.getClient(updated.getClientId());
            config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals(null, (Object)config.getTokenEndpointAuthSigningAlg());
        }
        catch (Throwable throwable) {
            this.reg.auth(Auth.token(updated));
            updated.setTokenEndpointAuthSigningAlg(null);
            this.reg.oidc().update(updated);
            throw throwable;
        }
        this.reg.auth(Auth.token((OIDCClientRepresentation)updated));
        updated.setTokenEndpointAuthSigningAlg(null);
        this.reg.oidc().update(updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizationResponseSigningAlg() throws Exception {
        OIDCClientRepresentation response = null;
        OIDCClientRepresentation updated = null;
        try {
            OIDCClientRepresentation clientRep = this.createRep();
            clientRep.setAuthorizationSignedResponseAlg(Algorithm.PS256.toString());
            response = this.reg.oidc().create(clientRep);
            Assert.assertEquals((Object)Algorithm.PS256.toString(), (Object)response.getAuthorizationSignedResponseAlg());
            ClientRepresentation kcClient = this.getClient(response.getClientId());
            OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)Algorithm.PS256.toString(), (Object)config.getAuthorizationSignedResponseAlg());
            this.reg.auth(Auth.token((OIDCClientRepresentation)response));
            response.setAuthorizationSignedResponseAlg(null);
            updated = this.reg.oidc().update(response);
            Assert.assertEquals(null, (Object)response.getAuthorizationSignedResponseAlg());
            kcClient = this.getClient(updated.getClientId());
            config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals(null, (Object)config.getAuthorizationSignedResponseAlg());
        }
        catch (Throwable throwable) {
            this.reg.auth(Auth.token(updated));
            updated.setAuthorizationSignedResponseAlg(null);
            this.reg.oidc().update(updated);
            throw throwable;
        }
        this.reg.auth(Auth.token((OIDCClientRepresentation)updated));
        updated.setAuthorizationSignedResponseAlg(null);
        this.reg.oidc().update(updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizationEncryptedResponse() throws Exception {
        OIDCClientRepresentation response = null;
        OIDCClientRepresentation updated = null;
        try {
            OIDCClientRepresentation clientRep = this.createRep();
            clientRep.setAuthorizationEncryptedResponseAlg("RSA1_5");
            clientRep.setAuthorizationEncryptedResponseEnc("A128CBC-HS256");
            response = this.reg.oidc().create(clientRep);
            Assert.assertEquals((Object)"RSA1_5", (Object)response.getAuthorizationEncryptedResponseAlg());
            Assert.assertEquals((Object)"A128CBC-HS256", (Object)response.getAuthorizationEncryptedResponseEnc());
            ClientRepresentation kcClient = this.getClient(response.getClientId());
            OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)"RSA1_5", (Object)config.getAuthorizationEncryptedResponseAlg());
            Assert.assertEquals((Object)"A128CBC-HS256", (Object)config.getAuthorizationEncryptedResponseEnc());
            this.reg.auth(Auth.token((OIDCClientRepresentation)response));
            response.setAuthorizationEncryptedResponseAlg(null);
            response.setAuthorizationEncryptedResponseEnc(null);
            updated = this.reg.oidc().update(response);
            Assert.assertNull((Object)updated.getAuthorizationEncryptedResponseAlg());
            Assert.assertNull((Object)updated.getAuthorizationEncryptedResponseEnc());
            kcClient = this.getClient(updated.getClientId());
            config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertNull((Object)config.getAuthorizationEncryptedResponseAlg());
            Assert.assertNull((Object)config.getAuthorizationEncryptedResponseEnc());
        }
        catch (Throwable throwable) {
            this.reg.auth(Auth.token(updated));
            updated.setAuthorizationEncryptedResponseAlg(null);
            updated.setAuthorizationEncryptedResponseEnc(null);
            this.reg.oidc().update(updated);
            throw throwable;
        }
        this.reg.auth(Auth.token((OIDCClientRepresentation)updated));
        updated.setAuthorizationEncryptedResponseAlg(null);
        updated.setAuthorizationEncryptedResponseEnc(null);
        this.reg.oidc().update(updated);
    }

    @Test
    public void testCIBASettings() throws Exception {
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        clientRep = this.createRep();
        clientRep.setBackchannelTokenDeliveryMode("poll");
        response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"poll", (Object)response.getBackchannelTokenDeliveryMode());
        ClientRepresentation kcClient = this.getClient(response.getClientId());
        Assert.assertEquals((Object)"poll", kcClient.getAttributes().get("ciba.backchannel.token.delivery.mode"));
        clientRep.setBackchannelTokenDeliveryMode("ping");
        try {
            this.reg.oidc().create(clientRep);
            org.junit.Assert.fail();
        }
        catch (ClientRegistrationException e) {
            org.junit.Assert.assertEquals((Object)ERR_MSG_CLIENT_REG_FAIL, (Object)e.getMessage());
        }
        clientRep.setBackchannelClientNotificationEndpoint("https://foo/bar");
        response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"ping", (Object)response.getBackchannelTokenDeliveryMode());
        Assert.assertEquals((Object)"https://foo/bar", (Object)response.getBackchannelClientNotificationEndpoint());
        clientRep.setBackchannelTokenDeliveryMode("push");
        try {
            this.reg.oidc().create(clientRep);
            org.junit.Assert.fail();
        }
        catch (ClientRegistrationException e) {
            org.junit.Assert.assertEquals((Object)ERR_MSG_CLIENT_REG_FAIL, (Object)e.getMessage());
        }
    }

    @Test
    public void testOIDCEndpointCreateWithSamlClient() throws Exception {
        ClientsResource clientsResource = this.adminClient.realm("test").clients();
        ClientRepresentation samlClient = (ClientRepresentation)clientsResource.findByClientId("saml-client").get(0);
        String samlClientServiceId = clientsResource.get(samlClient.getId()).getServiceAccountUser().getId();
        String realmManagementId = ((ClientRepresentation)clientsResource.findByClientId("realm-management").get(0)).getId();
        RoleRepresentation role = clientsResource.get(realmManagementId).roles().get("create-client").toRepresentation();
        this.adminClient.realm("test").users().get(samlClientServiceId).roles().clientLevel(realmManagementId).add(Arrays.asList(role));
        String accessToken = this.oauth.clientId("saml-client").doClientCredentialsGrantAccessTokenRequest("secret").getAccessToken();
        this.reg.auth(Auth.token((String)accessToken));
        samlClient.setProtocol("saml");
        clientsResource.get(samlClient.getId()).update(samlClient);
        OIDCClientRepresentation client = this.createRep();
        this.assertCreateFail(client, 400, "invalid_client");
        samlClient.setProtocol("openid-connect");
        clientsResource.get(samlClient.getId()).update(samlClient);
    }

    @Test
    public void testOIDCEndpointGetWithSamlClient() throws Exception {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        org.junit.Assert.assertNotNull((Object)this.reg.oidc().get(response.getClientId()));
        ClientsResource clientsResource = this.adminClient.realm("test").clients();
        ClientRepresentation client = (ClientRepresentation)clientsResource.findByClientId(response.getClientId()).get(0);
        client.setProtocol("saml");
        clientsResource.get(client.getId()).update(client);
        this.assertGetFail(client.getClientId(), 400, "invalid_client");
    }

    @Test
    public void testOIDCEndpointGetWithToken() throws Exception {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        org.junit.Assert.assertNotNull((Object)this.reg.oidc().get(response.getClientId()));
    }

    @Test
    public void testOIDCEndpointGetWithoutToken() throws Exception {
        this.assertGetFail(this.create().getClientId(), 401, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTlsClientAuthSubjectDn() throws Exception {
        OIDCClientRepresentation response = null;
        OIDCClientRepresentation updated = null;
        try {
            OIDCClientRepresentation clientRep = this.createRep();
            clientRep.setTokenEndpointAuthMethod("tls_client_auth");
            clientRep.setTlsClientAuthSubjectDn("Ein");
            response = this.reg.oidc().create(clientRep);
            Assert.assertEquals((Object)"tls_client_auth", (Object)response.getTokenEndpointAuthMethod());
            Assert.assertEquals((Object)"Ein", (Object)response.getTlsClientAuthSubjectDn());
            ClientRepresentation kcClient = this.getClient(response.getClientId());
            OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)"client-x509", (Object)kcClient.getClientAuthenticatorType());
            Assert.assertEquals((Object)"Ein", (Object)config.getTlsClientAuthSubjectDn());
            Assert.assertFalse((boolean)config.getAllowRegexPatternComparison());
            this.reg.auth(Auth.token((OIDCClientRepresentation)response));
            response.setTlsClientAuthSubjectDn("(.*?)(?:$)");
            updated = this.reg.oidc().update(response);
            Assert.assertEquals((Object)"tls_client_auth", (Object)updated.getTokenEndpointAuthMethod());
            Assert.assertEquals((Object)"(.*?)(?:$)", (Object)updated.getTlsClientAuthSubjectDn());
            kcClient = this.getClient(updated.getClientId());
            config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
            Assert.assertEquals((Object)"client-x509", (Object)kcClient.getClientAuthenticatorType());
            Assert.assertEquals((Object)"(.*?)(?:$)", (Object)config.getTlsClientAuthSubjectDn());
        }
        catch (Throwable throwable) {
            this.reg.auth(Auth.token(updated));
            updated.setTokenEndpointAuthMethod(null);
            updated.setTlsClientAuthSubjectDn(null);
            this.reg.oidc().update(updated);
            throw throwable;
        }
        this.reg.auth(Auth.token((OIDCClientRepresentation)updated));
        updated.setTokenEndpointAuthMethod(null);
        updated.setTlsClientAuthSubjectDn(null);
        this.reg.oidc().update(updated);
    }

    private ClientRepresentation getKeycloakClient(String clientId) {
        return ApiUtil.findClientByClientId((RealmResource)this.adminClient.realms().realm("test"), (String)clientId).toRepresentation();
    }

    @Test
    public void testClientWithScope() throws Exception {
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        String clientScope = "phone address";
        clientRep = this.createRep();
        clientRep.setScope(clientScope);
        response = this.reg.oidc().create(clientRep);
        HashSet<String> clientScopes = new HashSet<String>(Arrays.asList(clientScope.split(" ")));
        HashSet<String> registeredClientScopes = new HashSet<String>(Arrays.asList(response.getScope().split(" ")));
        org.junit.Assert.assertTrue((boolean)clientScopes.equals(registeredClientScopes));
        ClientResource clientResource = this.adminClient.realm("test").clients().get(response.getClientId());
        org.junit.Assert.assertTrue((boolean)clientResource.toRepresentation().getDefaultClientScopes().isEmpty());
    }

    @Test
    public void testClientWithNotDefinedScope() throws Exception {
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        String clientScope = "notdefinedscope address";
        clientRep = this.createRep();
        clientRep.setScope(clientScope);
        try {
            response = this.reg.oidc().create(clientRep);
            org.junit.Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            org.junit.Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testClientWithoutScope() throws ClientRegistrationException {
        HashSet realmOptionalClientScopes = new HashSet(this.adminClient.realm("test").getDefaultOptionalClientScopes().stream().filter(scope -> Objects.equals(scope.getProtocol(), "openid-connect")).map(i -> i.getName()).collect(Collectors.toList()));
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        clientRep = this.createRep();
        response = this.reg.oidc().create(clientRep);
        HashSet<String> registeredClientScopes = new HashSet<String>(Arrays.asList(response.getScope().split(" ")));
        org.junit.Assert.assertTrue((boolean)realmOptionalClientScopes.equals(new HashSet<String>(registeredClientScopes)));
        ClientResource clientResource = this.adminClient.realm("test").clients().get(response.getClientId());
        ClientRepresentation rep = clientResource.toRepresentation();
        HashSet realmDefaultClientScopes = new HashSet(this.adminClient.realm("test").getDefaultDefaultClientScopes().stream().filter(scope -> Objects.equals(scope.getProtocol(), "openid-connect")).map(i -> i.getName()).collect(Collectors.toList()));
        HashSet registeredDefaultClientScopes = new HashSet(rep.getDefaultClientScopes());
        org.junit.Assert.assertTrue((boolean)realmDefaultClientScopes.equals(new HashSet(registeredDefaultClientScopes)));
    }

    @Test
    public void testRequestUris() throws Exception {
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        clientRep = this.createRep();
        clientRep.setRequestUris(Arrays.asList("http://host/foo", "https://host2/bar"));
        response = this.reg.oidc().create(clientRep);
        Assert.assertNames(response.getRequestUris(), "http://host/foo", "https://host2/bar");
        ClientRepresentation kcClient = this.getClient(response.getClientId());
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
        Assert.assertNames(config.getRequestUris(), "http://host/foo", "https://host2/bar");
    }

    @Test
    public void testClientWithoutRefreshToken() throws Exception {
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        clientRep = this.createRep();
        clientRep.setGrantTypes(Arrays.asList("authorization_code"));
        response = this.reg.oidc().create(clientRep);
        ClientRepresentation kcClient = this.getClient(response.getClientId());
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
        Assert.assertFalse((boolean)config.isUseRefreshToken());
    }

    @Test
    public void testClientWithRefreshToken() throws Exception {
        OIDCClientRepresentation clientRep = null;
        OIDCClientRepresentation response = null;
        clientRep = this.createRep();
        clientRep.setGrantTypes(Arrays.asList("authorization_code", "refresh_token"));
        response = this.reg.oidc().create(clientRep);
        ClientRepresentation kcClient = this.getClient(response.getClientId());
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
        Assert.assertTrue((boolean)config.isUseRefreshToken());
    }

    @Test
    public void testClientWithoutGrantTypes() throws Exception {
        OIDCClientRepresentation response = this.create();
        org.junit.Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("authorization_code", "refresh_token"), (Collection)response.getGrantTypes()));
        ClientRepresentation kcClient = this.getClient(response.getClientId());
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)kcClient);
        Assert.assertTrue((boolean)config.isUseRefreshToken());
    }
}

