/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelRequest;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelResponse;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientPoliciesTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.rest.representation.TestAuthenticationChannelRequest;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.util.ClientPoliciesUtil;
import org.keycloak.testsuite.util.MutualTLSUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class FAPICIBATest
extends AbstractClientPoliciesTest {
    private final String clientId = "foo";
    private final String bindingMessage = "bbbbmmmm";
    private final String username = "john";

    @BeforeClass
    public static void verifySSL() {
        Assume.assumeTrue((String)"The FAPI test requires SSL to be enabled.", (boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        List users = realm.getUsers();
        LinkedList<CredentialRepresentation> credentials = new LinkedList<CredentialRepresentation>();
        CredentialRepresentation password = new CredentialRepresentation();
        password.setType("password");
        password.setValue("password");
        credentials.add(password);
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername("john");
        user.setEmail("john@keycloak.org");
        user.setFirstName("Johny");
        user.setCredentials(credentials);
        user.setClientRoles(Collections.singletonMap("realm-management", Arrays.asList(AdminRoles.CREATE_CLIENT, AdminRoles.MANAGE_CLIENTS)));
        users.add(user);
        realm.setUsers(users);
        testRealms.add(realm);
    }

    @Test
    public void testFAPIAdvancedClientRegistration() throws Exception {
        this.setupPolicyFAPICIBAForAllClient();
        try {
            this.createClientByAdmin("invalid", clientRep -> clientRep.setClientAuthenticatorType("client-secret"));
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        try {
            this.createClientByAdmin("invalid", clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        try {
            this.createClientByAdmin("invalid", clientRep -> {
                clientRep.setClientAuthenticatorType("client-jwt");
                OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestUris(Collections.singletonList("http://foo"));
            });
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        String clientUUID = this.createClientByAdmin("client-jwt", clientRep -> clientRep.setClientAuthenticatorType("client-jwt"));
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        clientUUID = this.createClientByAdmin("client-x509", clientRep -> clientRep.setClientAuthenticatorType("client-x509"));
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        clientUUID = this.createClientByAdmin("client-jwt-2", clientRep -> {});
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        Assert.assertTrue((boolean)client.isConsentRequired());
        OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        Assert.assertTrue((boolean)clientConfig.isUseMtlsHokToken());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getRequestObjectSignatureAlg().toString());
        Assert.assertFalse((boolean)client.isFullScopeAllowed());
    }

    @Test
    public void testFAPICIBASignatureAlgorithms() throws Exception {
        this.setupPolicyFAPICIBAForAllClient();
        try {
            this.createClientByAdmin("invalid", clientRep -> {
                clientRep.setClientAuthenticatorType("client-jwt");
                OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
                clientConfig.setIdTokenSignedResponseAlg("RS256");
            });
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_request", (Object)e.getMessage());
        }
        String clientUUID = this.createClientByAdmin("client-jwt", clientRep -> {
            clientRep.setClientAuthenticatorType("client-jwt");
            OIDCAdvancedConfigWrapper clientCfg = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
            clientCfg.setIdTokenSignedResponseAlg("ES256");
            Map attr = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attr.put("ciba.backchannel.auth.request.signing.alg", "ES256");
            clientRep.setAttributes(attr);
        });
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        Assert.assertEquals((Object)"ES256", (Object)clientConfig.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getRequestObjectSignatureAlg().toString());
        Assert.assertEquals((Object)"ES256", client.getAttributes().get("ciba.backchannel.auth.request.signing.alg"));
        clientUUID = this.createClientByAdmin("client-jwt-default-alg", clientRep -> clientRep.setClientAuthenticatorType("client-jwt"));
        client = this.getClientByAdmin(clientUUID);
        clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getRequestObjectSignatureAlg().toString());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getUserInfoSignedResponseAlg().toString());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getTokenEndpointAuthSigningAlg());
        Assert.assertEquals((Object)"PS256", client.getAttributes().get("access.token.signed.response.alg"));
        Assert.assertEquals((Object)"PS256", client.getAttributes().get("ciba.backchannel.auth.request.signing.alg"));
    }

    @Test
    public void testFAPICIBALoginWithPrivateKeyJWT() throws Exception {
        this.setupPolicyFAPICIBAForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-jwt");
            this.setClientAuthMethodNeutralSettings((ClientRepresentation)clientRep);
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(clientUUID);
        ClientRepresentation client = clientResource.toRepresentation();
        org.junit.Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createFAPIValidAuthorizationEndpointRequestObject("john", "bbbbmmmm");
        String encodedRequestObject = this.registerSharedAuthenticationRequest(requestObject, "foo", "PS256");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        Map generatedKeys = oidcClientEndpointsResource.getKeysAsBase64();
        KeyPair keyPair = this.getKeyPairFromGeneratedBase64(generatedKeys, "PS256");
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String signedJwt = this.createSignedRequestToken("foo", privateKey, publicKey, "PS256");
        OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequestWithClientSignedJWT(signedJwt, encodedRequestObject, () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
        TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest("bbbbmmmm");
        AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
        MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bbbbmmmm")));
        MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)Matchers.is((Matcher)Matchers.containsString((String)"openid")));
        this.doAuthenticationChannelCallback(testRequest);
        String signedJwt2 = this.createSignedRequestToken("foo", privateKey, publicKey, "PS256");
        OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequestWithClientSignedJWT(signedJwt2, response.getAuthReqId(), () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        this.verifyBackchannelAuthenticationTokenRequest(tokenRes, "foo", "john");
        this.logoutUserAndRevokeConsent("foo", "john");
    }

    @Test
    public void testFAPICIBAUserAuthenticationCancelled() throws Exception {
        this.setupPolicyFAPICIBAForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-jwt");
            this.setClientAuthMethodNeutralSettings((ClientRepresentation)clientRep);
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(clientUUID);
        ClientRepresentation client = clientResource.toRepresentation();
        org.junit.Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createFAPIValidAuthorizationEndpointRequestObject("john", "bbbbmmmm");
        String encodedRequestObject = this.registerSharedAuthenticationRequest(requestObject, "foo", "PS256");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        Map generatedKeys = oidcClientEndpointsResource.getKeysAsBase64();
        KeyPair keyPair = this.getKeyPairFromGeneratedBase64(generatedKeys, "PS256");
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String signedJwt = this.createSignedRequestToken("foo", privateKey, publicKey, "PS256");
        OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequestWithClientSignedJWT(signedJwt, encodedRequestObject, () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
        TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest("bbbbmmmm");
        AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
        MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bbbbmmmm")));
        MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)Matchers.is((Matcher)Matchers.containsString((String)"openid")));
        this.doAuthenticationChannelCallbackCancelled(testRequest);
        String signedJwt2 = this.createSignedRequestToken("foo", privateKey, publicKey, "PS256");
        OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequestWithClientSignedJWT(signedJwt2, response.getAuthReqId(), () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"access_denied")));
        MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"not authorized")));
    }

    @Test
    public void testFAPICIBALoginWithMTLS() throws Exception {
        this.setupPolicyFAPICIBAForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-x509");
            OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
            clientConfig.setRequestUris(Collections.singletonList(TestApplicationResourceUrls.clientRequestUri()));
            clientConfig.setTlsClientAuthSubjectDn("EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
            this.setClientAuthMethodNeutralSettings((ClientRepresentation)clientRep);
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(clientUUID);
        ClientRepresentation client = clientResource.toRepresentation();
        org.junit.Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createFAPIValidAuthorizationEndpointRequestObject("john", "bbbbmmmm");
        String encodedRequestObject = this.registerSharedAuthenticationRequest(requestObject, "foo", "PS256");
        OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequestWithMTLS("foo", encodedRequestObject, () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
        TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest("bbbbmmmm");
        AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
        MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bbbbmmmm")));
        MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)Matchers.is((Matcher)Matchers.containsString((String)"openid")));
        this.doAuthenticationChannelCallback(testRequest);
        OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequestWithMTLS("foo", response.getAuthReqId(), () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        this.verifyBackchannelAuthenticationTokenRequest(tokenRes, "foo", "john");
        this.logoutUserAndRevokeConsent("foo", "john");
    }

    @Test
    public void testFAPICIBAWithoutBindingMessage() throws Exception {
        this.setupPolicyFAPICIBAForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-x509");
            OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
            clientConfig.setRequestUris(Collections.singletonList(TestApplicationResourceUrls.clientRequestUri()));
            clientConfig.setTlsClientAuthSubjectDn("EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
            this.setClientAuthMethodNeutralSettings((ClientRepresentation)clientRep);
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(clientUUID);
        ClientRepresentation client = clientResource.toRepresentation();
        org.junit.Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createFAPIValidAuthorizationEndpointRequestObject("john", null);
        String encodedRequestObject = this.registerSharedAuthenticationRequest(requestObject, "foo", "PS256");
        OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequestWithMTLS("foo", encodedRequestObject, () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response.getError(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_request")));
        MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing parameter: binding_message")));
    }

    @Test
    public void testFAPICIBAWithoutSignedAuthenticationRequest() throws Exception {
        this.setupPolicyFAPICIBAForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-x509");
            OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
            clientConfig.setRequestUris(Collections.singletonList(TestApplicationResourceUrls.clientRequestUri()));
            clientConfig.setTlsClientAuthSubjectDn("EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
            this.setClientAuthMethodNeutralSettings((ClientRepresentation)clientRep);
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(clientUUID);
        ClientRepresentation client = clientResource.toRepresentation();
        org.junit.Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        OAuthClient.AuthenticationRequestAcknowledgement response = this.doInvalidBackchannelAuthenticationRequestWithMTLS("foo", "john", "bbbbmmmm", () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response.getError(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_request")));
        MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing parameter: 'request' or 'request_uri'")));
    }

    private void setupPolicyFAPICIBAForAllClient() throws Exception {
        String json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Policy for enable FAPI CIBA for all clients", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("fapi-ciba").addProfile("fapi-1-advanced").toRepresentation()).toString();
        this.updatePolicies(json);
    }

    private void setClientAuthMethodNeutralSettings(ClientRepresentation clientRep) {
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
        String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(jwksUrl);
        Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
        attributes.put("ciba.backchannel.token.delivery.mode", "poll");
        attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
        clientRep.setAttributes(attributes);
    }

    private TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject createValidAuthorizationEndpointRequestObject(String username, String bindingMessage) throws Exception {
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
        requestObject.id(KeycloakModelUtils.generateId());
        requestObject.iat(Long.valueOf(Time.currentTime()));
        requestObject.setScope("openid");
        requestObject.setMax_age(Integer.valueOf(600));
        requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
        requestObject.setLoginHint(username);
        requestObject.setBindingMessage(bindingMessage);
        return requestObject;
    }

    private TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject createFAPIValidAuthorizationEndpointRequestObject(String username, String bindingMessage) throws Exception {
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createValidAuthorizationEndpointRequestObject(username, bindingMessage);
        requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
        requestObject.nbf(requestObject.getIat());
        requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test")});
        requestObject.issuer("foo");
        requestObject.id(KeycloakModelUtils.generateId());
        requestObject.iat(Long.valueOf(Time.currentTime()));
        return requestObject;
    }

    private String registerSharedAuthenticationRequest(TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject, String clientId, String sigAlg) throws URISyntaxException, IOException {
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
        String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
        oidcClientEndpointsResource.generateKeys(sigAlg);
        oidcClientEndpointsResource.registerOIDCRequest(encodedRequestObject, sigAlg);
        return oidcClientEndpointsResource.getOIDCRequest();
    }

    private OAuthClient.AuthenticationRequestAcknowledgement doBackchannelAuthenticationRequestWithClientSignedJWT(String signedJwt, String request, Supplier<CloseableHttpClient> httpClientSupplier) {
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "urn:openid:params:grant-type:ciba"));
            parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
            parameters.add((NameValuePair)new BasicNameValuePair("request", request));
            CloseableHttpResponse response = this.sendRequest(this.oauth.getBackchannelAuthenticationUrl(), parameters, httpClientSupplier);
            return new OAuthClient.AuthenticationRequestAcknowledgement(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private OAuthClient.AuthenticationRequestAcknowledgement doBackchannelAuthenticationRequestWithMTLS(String clientId, String request, Supplier<CloseableHttpClient> httpClientSupplier) {
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "urn:openid:params:grant-type:ciba"));
            parameters.add((NameValuePair)new BasicNameValuePair("request", request));
            parameters.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            CloseableHttpResponse response = this.sendRequest(this.oauth.getBackchannelAuthenticationUrl(), parameters, httpClientSupplier);
            return new OAuthClient.AuthenticationRequestAcknowledgement(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private OAuthClient.AuthenticationRequestAcknowledgement doInvalidBackchannelAuthenticationRequestWithMTLS(String clientId, String username, String bindingMessage, Supplier<CloseableHttpClient> httpClientSupplier) throws Exception {
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "urn:openid:params:grant-type:ciba"));
            parameters.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            parameters.add((NameValuePair)new BasicNameValuePair("login_hint", username));
            parameters.add((NameValuePair)new BasicNameValuePair("binding_message", bindingMessage));
            parameters.add((NameValuePair)new BasicNameValuePair("scope", "openid"));
            CloseableHttpResponse response = this.sendRequest(this.oauth.getBackchannelAuthenticationUrl(), parameters, httpClientSupplier);
            return new OAuthClient.AuthenticationRequestAcknowledgement(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TestAuthenticationChannelRequest doAuthenticationChannelRequest(String bindingMessage) {
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        TestAuthenticationChannelRequest authenticationChannelReq = oidcClientEndpointsResource.getAuthenticationChannel(bindingMessage);
        return authenticationChannelReq;
    }

    private EventRepresentation doAuthenticationChannelCallback(TestAuthenticationChannelRequest request) throws Exception {
        int statusCode = this.oauth.doAuthenticationChannelCallback(request.getBearerToken(), AuthenticationChannelResponse.Status.SUCCEED);
        MatcherAssert.assertThat((Object)statusCode, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
        EventRepresentation representation = new EventRepresentation();
        representation.setDetails(Collections.emptyMap());
        return representation;
    }

    private EventRepresentation doAuthenticationChannelCallbackCancelled(TestAuthenticationChannelRequest request) throws Exception {
        int statusCode = this.oauth.doAuthenticationChannelCallback(request.getBearerToken(), AuthenticationChannelResponse.Status.CANCELLED);
        MatcherAssert.assertThat((Object)statusCode, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
        EventRepresentation representation = new EventRepresentation();
        representation.setDetails(Collections.emptyMap());
        return representation;
    }

    private OAuthClient.AccessTokenResponse doBackchannelAuthenticationTokenRequestWithClientSignedJWT(String signedJwt, String authReqId, Supplier<CloseableHttpClient> httpClientSupplier) {
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "urn:openid:params:grant-type:ciba"));
            parameters.add((NameValuePair)new BasicNameValuePair("auth_req_id", authReqId));
            parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
            CloseableHttpResponse response = this.sendRequest(this.oauth.getBackchannelAuthenticationTokenRequestUrl(), parameters, httpClientSupplier);
            return new OAuthClient.AccessTokenResponse(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private OAuthClient.AccessTokenResponse doBackchannelAuthenticationTokenRequestWithMTLS(String clientId, String authReqId, Supplier<CloseableHttpClient> httpClientSupplier) {
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "urn:openid:params:grant-type:ciba"));
            parameters.add((NameValuePair)new BasicNameValuePair("auth_req_id", authReqId));
            parameters.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            CloseableHttpResponse response = this.sendRequest(this.oauth.getBackchannelAuthenticationTokenRequestUrl(), parameters, httpClientSupplier);
            return new OAuthClient.AccessTokenResponse(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyBackchannelAuthenticationTokenRequest(OAuthClient.AccessTokenResponse tokenRes, String clientId, String username) {
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
        this.events.expectAuthReqIdToToken(null, null).clearDetails().user(AssertEvents.isUUID()).client(clientId).assertEvent();
        AccessToken accessToken = this.oauth.verifyToken(tokenRes.getAccessToken());
        MatcherAssert.assertThat((Object)accessToken.getIssuedFor(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)clientId)));
        Assert.assertNotNull((Object)accessToken.getCertConf().getCertThumbprint());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(tokenRes.getRefreshToken());
        MatcherAssert.assertThat((Object)refreshToken.getIssuedFor(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)clientId)));
        MatcherAssert.assertThat((Object)refreshToken.getAudience()[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)refreshToken.getIssuer())));
        IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
        MatcherAssert.assertThat((Object)idToken.getPreferredUsername(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)username)));
        MatcherAssert.assertThat((Object)idToken.getIssuedFor(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)clientId)));
        MatcherAssert.assertThat((Object)idToken.getAudience()[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)idToken.getIssuedFor())));
    }

    private void logoutUserAndRevokeConsent(String clientId, String username) {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)username);
        user.logout();
        List consents = user.getConsents();
        org.junit.Assert.assertEquals((long)1L, (long)consents.size());
        user.revokeConsent(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpResponse sendRequest(String requestUrl, List<NameValuePair> parameters, Supplier<CloseableHttpClient> httpClientSupplier) throws Exception {
        CloseableHttpClient client = httpClientSupplier.get();
        try {
            HttpPost post = new HttpPost(requestUrl);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
        finally {
            this.oauth.closeClient(client);
        }
    }
}

