/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.adapters.authentication.JWTClientSecretCredentialsProvider;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.UriUtils;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.models.AdminRoles;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientPoliciesTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.util.ClientPoliciesUtil;
import org.keycloak.testsuite.util.MutualTLSUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class FAPI1Test
extends AbstractClientPoliciesTest {
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected AppPage appPage;

    @BeforeClass
    public static void verifySSL() {
        Assume.assumeTrue((String)"The FAPI test requires SSL to be enabled.", (boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        List users = realm.getUsers();
        LinkedList<CredentialRepresentation> credentials = new LinkedList<CredentialRepresentation>();
        CredentialRepresentation password = new CredentialRepresentation();
        password.setType("password");
        password.setValue("password");
        credentials.add(password);
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername("john");
        user.setEmail("john@keycloak.org");
        user.setFirstName("Johny");
        user.setCredentials(credentials);
        user.setClientRoles(Collections.singletonMap("realm-management", Arrays.asList(AdminRoles.CREATE_CLIENT, AdminRoles.MANAGE_CLIENTS)));
        users.add(user);
        realm.setUsers(users);
        testRealms.add(realm);
    }

    @Test
    public void testFAPIBaselineClientAuthenticator() throws Exception {
        this.setupPolicyFAPIBaselineForAllClient();
        try {
            this.createClientByAdmin("invalid", clientRep -> clientRep.setClientAuthenticatorType("client-secret"));
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        String clientUUID = this.createClientByAdmin("client-jwt", clientRep -> clientRep.setClientAuthenticatorType("client-jwt"));
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        clientUUID = this.createClientByAdmin("client-secret-jwt", clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-secret-jwt", (Object)client.getClientAuthenticatorType());
        clientUUID = this.createClientByAdmin("client-x509", clientRep -> clientRep.setClientAuthenticatorType("client-x509"));
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        clientUUID = this.createClientByAdmin("client-jwt-2", clientRep -> {});
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        Assert.assertTrue((boolean)client.isConsentRequired());
        Assert.assertEquals((Object)"S256", (Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client).getPkceCodeChallengeMethod());
    }

    @Test
    public void testFAPIBaselineSecureSettingsWhenUseAdminPolicy() throws Exception {
        this.setupPolicyFAPIBaselineForAdminRESTAndDynamicClientRegistrationRequests();
        String clientUUID = this.createClientByAdmin("client-jwt-3", clientRep -> {});
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        Assert.assertTrue((boolean)client.isConsentRequired());
        Assert.assertEquals((Object)"S256", (Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client).getPkceCodeChallengeMethod());
    }

    @Test
    public void testFAPIBaselineOIDCClientRegistration() throws Exception {
        this.setupPolicyFAPIBaselineForAllClient();
        try {
            this.createClientDynamically(this.generateSuffixedName("foo"), clientRep -> clientRep.setTokenEndpointAuthMethod("client_secret_basic"));
            org.junit.Assert.fail();
        }
        catch (ClientRegistrationException e) {
            org.junit.Assert.assertEquals((Object)"Failed to send request", (Object)e.getMessage());
        }
        String clientUUID = this.createClientDynamically("client-jwt", clientRep -> {
            clientRep.setTokenEndpointAuthMethod("private_key_jwt");
            clientRep.setJwksUri("https://foo");
        });
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        Assert.assertFalse((boolean)client.isFullScopeAllowed());
        this.setInitialAccessTokenForDynamicClientRegistration();
        clientUUID = this.createClientDynamically("client-secret-jwt", clientRep -> clientRep.setTokenEndpointAuthMethod("client_secret_jwt"));
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-secret-jwt", (Object)client.getClientAuthenticatorType());
        this.setInitialAccessTokenForDynamicClientRegistration();
        clientUUID = this.createClientDynamically("client-x509", clientRep -> clientRep.setTokenEndpointAuthMethod("tls_client_auth"));
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        Assert.assertTrue((boolean)client.isConsentRequired());
        Assert.assertEquals((Object)"S256", (Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client).getPkceCodeChallengeMethod());
    }

    @Test
    public void testFAPIBaselineRedirectUri() throws Exception {
        String clientUUID;
        this.setupPolicyFAPIBaselineForAllClient();
        try {
            clientUUID = this.createClientByAdmin("invalid", clientRep -> clientRep.setRedirectUris(Collections.singletonList("http://hostname.com")));
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        try {
            this.createClientByAdmin("invalid", clientRep -> clientRep.setRedirectUris(Collections.singletonList("https://hostname.com/foo/*")));
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        clientUUID = this.createClientByAdmin("invalid", clientRep -> clientRep.setRedirectUris(Collections.singletonList("https://hostname.com")));
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertNames(client.getRedirectUris(), "https://hostname.com");
        this.getCleanup().addClientUuid(clientUUID);
        String clientUUID2 = this.createClientByAdmin("invalid2", clientRep -> {
            clientRep.setRootUrl("https://hostname2.com");
            clientRep.setRedirectUris(null);
        });
        ClientRepresentation client2 = this.getClientByAdmin(clientUUID2);
        Assert.assertNames(client2.getRedirectUris(), "https://hostname2.com");
        this.getCleanup().addClientUuid(clientUUID2);
    }

    @Test
    public void testFAPIBaselineConfidentialClientLogin() throws Exception {
        this.setupPolicyFAPIBaselineForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-secret-jwt");
            clientRep.setSecret("secret");
        });
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertFalse((boolean)client.isPublicClient());
        Assert.assertEquals((Object)"client-secret-jwt", (Object)client.getClientAuthenticatorType());
        Assert.assertFalse((boolean)client.isFullScopeAllowed());
        this.checkPKCEWithS256RequiredDuringLogin("foo");
        String codeVerifier = "1234567890123456789012345678901234567890123";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.checkNonceAndStateForCurrentClientDuringLogin();
        this.checkRedirectUriForCurrentClientDuringLogin();
        this.successfulLoginAndLogout("foo", false, code -> {
            String signedJwt = this.getClientSecretSignedJWT("secret", "HS256");
            return this.doAccessTokenRequestWithClientSignedJWT((String)code, signedJwt, codeVerifier, DefaultHttpClient::new);
        });
    }

    @Test
    public void testFAPIBaselinePublicClientLogin() throws Exception {
        this.setupPolicyFAPIBaselineForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> clientRep.setPublicClient(Boolean.valueOf(true)));
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertTrue((boolean)client.isPublicClient());
        this.checkPKCEWithS256RequiredDuringLogin("foo");
        String codeVerifier = "1234567890123456789012345678901234567890123";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.checkNonceAndStateForCurrentClientDuringLogin();
        this.checkRedirectUriForCurrentClientDuringLogin();
        this.successfulLoginAndLogout("foo", false, code -> {
            this.oauth.codeVerifier(codeVerifier);
            return this.oauth.doAccessTokenRequest(code, null);
        });
    }

    @Test
    public void testFAPIAdvancedClientRegistration() throws Exception {
        this.setupPolicyFAPIAdvancedForAllClient();
        try {
            this.createClientByAdmin("invalid", clientRep -> clientRep.setClientAuthenticatorType("client-secret"));
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        try {
            this.createClientByAdmin("invalid", clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        try {
            this.createClientByAdmin("invalid", clientRep -> {
                clientRep.setClientAuthenticatorType("client-jwt");
                clientRep.setRedirectUris(Collections.singletonList("http://foo"));
            });
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        String clientUUID = this.createClientByAdmin("client-jwt", clientRep -> clientRep.setClientAuthenticatorType("client-jwt"));
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        clientUUID = this.createClientByAdmin("client-x509", clientRep -> clientRep.setClientAuthenticatorType("client-x509"));
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        clientUUID = this.createClientByAdmin("client-jwt-2", clientRep -> {});
        client = this.getClientByAdmin(clientUUID);
        Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        Assert.assertTrue((boolean)client.isConsentRequired());
        OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        Assert.assertTrue((boolean)clientConfig.isUseMtlsHokToken());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getRequestObjectSignatureAlg().toString());
        Assert.assertFalse((boolean)client.isFullScopeAllowed());
    }

    @Test
    public void testFAPIAdvancedPublicClientLoginNotPossible() throws Exception {
        this.setupPolicyFAPIBaselineForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> clientRep.setPublicClient(Boolean.valueOf(true)));
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        Assert.assertTrue((boolean)client.isPublicClient());
        this.oauth.nonce("123456");
        String codeVerifier = "1234567890123456789012345678901234567890123";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.successfulLoginAndLogout("foo", false, code -> {
            this.oauth.codeVerifier(codeVerifier);
            return this.oauth.doAccessTokenRequest(code, null);
        });
        this.setupPolicyFAPIAdvancedForAllClient();
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_client", false, "invalid client access type");
    }

    @Test
    public void testFAPIAdvancedSignatureAlgorithms() throws Exception {
        this.setupPolicyFAPIAdvancedForAllClient();
        try {
            this.createClientByAdmin("invalid", clientRep -> {
                clientRep.setClientAuthenticatorType("client-jwt");
                OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
                clientConfig.setIdTokenSignedResponseAlg("RS256");
            });
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_request", (Object)e.getMessage());
        }
        String clientUUID = this.createClientByAdmin("client-jwt", clientRep -> {
            clientRep.setClientAuthenticatorType("client-jwt");
            OIDCAdvancedConfigWrapper clientCfg = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
            clientCfg.setIdTokenSignedResponseAlg("ES256");
        });
        ClientRepresentation client = this.getClientByAdmin(clientUUID);
        OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        Assert.assertEquals((Object)"ES256", (Object)clientConfig.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getRequestObjectSignatureAlg().toString());
        clientUUID = this.createClientByAdmin("client-jwt-default-alg", clientRep -> clientRep.setClientAuthenticatorType("client-jwt"));
        client = this.getClientByAdmin(clientUUID);
        clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getRequestObjectSignatureAlg().toString());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getUserInfoSignedResponseAlg().toString());
        Assert.assertEquals((Object)"PS256", (Object)clientConfig.getTokenEndpointAuthSigningAlg());
        Assert.assertEquals((Object)"PS256", client.getAttributes().get("access.token.signed.response.alg"));
    }

    @Test
    public void testFAPIAdvancedLoginWithPrivateKeyJWT() throws Exception {
        this.setupPolicyFAPIAdvancedForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-jwt");
            clientRep.setImplicitFlowEnabled(Boolean.valueOf(true));
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestUris(Collections.singletonList(TestApplicationResourceUrls.clientRequestUri()));
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(clientUUID);
        ClientRepresentation client = clientResource.toRepresentation();
        org.junit.Assert.assertEquals((Object)"client-jwt", (Object)client.getClientAuthenticatorType());
        this.oauth.clientId("foo");
        this.checkNonceAndStateForCurrentClientDuringLogin();
        this.checkRedirectUriForCurrentClientDuringLogin();
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", false, "Missing parameter: 'request' or 'request_uri'");
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor("foo");
        requestObject.nbf(null);
        this.registerRequestObject(requestObject, "foo", Algorithm.PS256, true);
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request_uri", false, "Missing parameter in the 'request' object: nbf");
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor("foo");
        requestObject.setNonce("123456");
        this.registerRequestObject(requestObject, "foo", Algorithm.PS256, true);
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", false, "invalid response_type");
        this.oauth.responseType("code id_token token");
        requestObject.setResponseType("code id_token token");
        this.registerRequestObject(requestObject, "foo", Algorithm.PS256, true);
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", true, "invalid response_type");
        this.oauth.responseType("code id_token");
        requestObject.setResponseType("code id_token");
        this.registerRequestObject(requestObject, "foo", Algorithm.PS256, true);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        Map generatedKeys = oidcClientEndpointsResource.getKeysAsBase64();
        KeyPair keyPair = this.getKeyPairFromGeneratedBase64(generatedKeys, "PS256");
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String code = this.loginUserAndGetCode("foo", true);
        Assert.assertNull((Object)this.getParameterFromUrl("access_token", true));
        String idTokenParam = this.getParameterFromUrl("id_token", true);
        this.assertIDTokenAsDetachedSignature(idTokenParam, code);
        String signedJwt = this.createSignedRequestToken("foo", privateKey, publicKey, "PS256");
        OAuthClient.AccessTokenResponse tokenResponse = this.doAccessTokenRequestWithClientSignedJWT(code, signedJwt, null, DefaultHttpClient::new);
        Assert.assertEquals((Object)"invalid_grant", (Object)tokenResponse.getError());
        Assert.assertEquals((Object)"Client Certification missing for MTLS HoK Token Binding", (Object)tokenResponse.getErrorDescription());
        this.oauth.openLoginForm();
        code = (String)this.oauth.getCurrentFragment().get("code");
        Assert.assertNotNull((Object)code);
        String signedJwt2 = this.createSignedRequestToken("foo", privateKey, publicKey, "PS256");
        tokenResponse = this.doAccessTokenRequestWithClientSignedJWT(code, signedJwt2, null, () -> MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore());
        this.assertSuccessfulTokenResponse(tokenResponse);
        AccessToken accessToken = this.oauth.verifyToken(tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)accessToken.getCertConf().getCertThumbprint());
        this.logoutUserAndRevokeConsent("foo");
    }

    @Test
    public void testFAPIAdvancedLoginWithMTLS() throws Exception {
        this.setupPolicyFAPIAdvancedForAllClient();
        String clientUUID = this.createClientByAdmin("foo", clientRep -> {
            clientRep.setClientAuthenticatorType("client-x509");
            clientRep.setImplicitFlowEnabled(Boolean.valueOf(true));
            OIDCAdvancedConfigWrapper clientConfig = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
            clientConfig.setRequestUris(Collections.singletonList(TestApplicationResourceUrls.clientRequestUri()));
            clientConfig.setTlsClientAuthSubjectDn("EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(clientUUID);
        ClientRepresentation client = clientResource.toRepresentation();
        org.junit.Assert.assertEquals((Object)"client-x509", (Object)client.getClientAuthenticatorType());
        this.oauth.clientId("foo");
        this.checkNonceAndStateForCurrentClientDuringLogin();
        this.checkRedirectUriForCurrentClientDuringLogin();
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", false, "Missing parameter: 'request' or 'request_uri'");
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor("foo");
        requestObject.setNonce("123456");
        this.oauth.responseType("code id_token");
        requestObject.setResponseType("code id_token");
        this.registerRequestObject(requestObject, "foo", Algorithm.PS256, true);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        String code = this.loginUserAndGetCode("foo", true);
        Assert.assertNull((Object)this.getParameterFromUrl("access_token", true));
        String idTokenParam = this.getParameterFromUrl("id_token", true);
        this.assertIDTokenAsDetachedSignature(idTokenParam, code);
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, null);
        this.assertSuccessfulTokenResponse(tokenResponse);
        AccessToken accessToken = this.oauth.verifyToken(tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)accessToken.getCertConf().getCertThumbprint());
        this.logoutUserAndRevokeConsent("foo");
    }

    private void checkPKCEWithS256RequiredDuringLogin(String clientId) {
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", false, "Missing parameter: code_challenge_method");
        this.oauth.codeChallenge("234567890_234567890123");
        this.oauth.codeChallengeMethod("plain");
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", false, "Invalid parameter: code challenge method is not configured one");
    }

    private void checkNonceAndStateForCurrentClientDuringLogin() {
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", false, "Missing parameter: nonce");
        this.oauth.nonce("123456");
        this.oauth.stateParamHardcoded(null);
        this.oauth.openid(false);
        this.oauth.openLoginForm();
        this.assertRedirectedToClientWithError("invalid_request", false, "Missing parameter: state");
        this.oauth.stateParamRandom();
    }

    private void checkRedirectUriForCurrentClientDuringLogin() {
        String origRedirectUri = this.oauth.getRedirectUri();
        this.oauth.openid(true);
        this.oauth.redirectUri(null);
        this.oauth.openLoginForm();
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        this.oauth.redirectUri(origRedirectUri);
    }

    private void setupPolicyFAPIBaselineForAllClient() throws Exception {
        String json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Policy for enable FAPI Baseline for all clients", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("fapi-1-baseline").toRepresentation()).toString();
        this.updatePolicies(json);
    }

    private void setupPolicyFAPIBaselineForAdminRESTAndDynamicClientRegistrationRequests() throws Exception {
        String json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "MyClientUpdaterContextPolicy", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser", "ByInitialAccessToken", "ByRegistrationAccessToken"))).addProfile("fapi-1-baseline").toRepresentation()).toString();
        this.updatePolicies(json);
    }

    private void setupPolicyFAPIAdvancedForAllClient() throws Exception {
        String json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Policy for enable FAPI Advanced for all clients", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("fapi-1-advanced").toRepresentation()).toString();
        this.updatePolicies(json);
    }

    private void successfulLoginAndLogout(String clientId, boolean fragmentResponseModeExpected, Function<String, OAuthClient.AccessTokenResponse> codeToTokenExchanger) throws Exception {
        String code = this.loginUserAndGetCode(clientId, fragmentResponseModeExpected);
        OAuthClient.AccessTokenResponse tokenResponse = codeToTokenExchanger.apply(code);
        this.assertSuccessfulTokenResponse(tokenResponse);
        this.logoutUserAndRevokeConsent(clientId);
    }

    private String loginUserAndGetCode(String clientId, boolean fragmentResponseModeExpected) {
        this.oauth.clientId(clientId);
        this.oauth.doLogin("john", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        String code = this.getParameterFromUrl("code", fragmentResponseModeExpected);
        Assert.assertNotNull((Object)code);
        return code;
    }

    private void assertSuccessfulTokenResponse(OAuthClient.AccessTokenResponse tokenResponse) {
        org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        Assert.assertThat((Object)tokenResponse.getIdToken(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)tokenResponse.getAccessToken(), (Matcher)Matchers.notNullValue());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        FAPI1Test.assertScopes("openid profile email", tokenResponse.getScope());
        IDToken idToken = this.oauth.verifyIDToken(tokenResponse.getIdToken());
        Assert.assertNotNull((Object)idToken.getId());
        Assert.assertEquals((Object)"foo", (Object)idToken.getIssuedFor());
        Assert.assertEquals((Object)"john", (Object)idToken.getPreferredUsername());
        Assert.assertEquals((Object)"john@keycloak.org", (Object)idToken.getEmail());
        Assert.assertEquals((Object)"Johny", (Object)idToken.getGivenName());
        Assert.assertEquals((Object)idToken.getNonce(), (Object)"123456");
    }

    private void assertIDTokenAsDetachedSignature(String idTokenParam, String code) {
        Assert.assertNotNull((Object)idTokenParam);
        IDToken idToken = this.oauth.verifyIDToken(idTokenParam);
        Assert.assertNotNull((Object)idToken.getId());
        Assert.assertEquals((Object)"foo", (Object)idToken.getIssuedFor());
        Assert.assertNull((Object)idToken.getPreferredUsername());
        Assert.assertNull((Object)idToken.getEmail());
        Assert.assertNull((Object)idToken.getGivenName());
        Assert.assertNull((Object)idToken.getAccessTokenHash());
        Assert.assertEquals((Object)idToken.getNonce(), (Object)"123456");
        String state = this.getParameterFromUrl("state", true);
        Assert.assertEquals((Object)idToken.getStateHash(), (Object)HashUtils.oidcHash((String)"PS256", (String)state));
        Assert.assertEquals((Object)idToken.getCodeHash(), (Object)HashUtils.oidcHash((String)"PS256", (String)code));
    }

    private String getClientSecretSignedJWT(String secret, String algorithm) {
        JWTClientSecretCredentialsProvider jwtProvider = new JWTClientSecretCredentialsProvider();
        jwtProvider.setClientSecret(secret, algorithm);
        return jwtProvider.createSignedRequestToken(this.oauth.getClientId(), this.getRealmInfoUrl(), algorithm);
    }

    private String getRealmInfoUrl() {
        String authServerBaseUrl = UriUtils.getOrigin((String)this.oauth.getRedirectUri()) + "/auth";
        return KeycloakUriBuilder.fromUri((String)authServerBaseUrl).path("/realms/{realm-name}").build(new Object[]{"test"}).toString();
    }

    private OAuthClient.AccessTokenResponse doAccessTokenRequestWithClientSignedJWT(String code, String signedJwt, String codeVerifier, Supplier<CloseableHttpClient> httpClientSupplier) {
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
            parameters.add((NameValuePair)new BasicNameValuePair("code", code));
            parameters.add((NameValuePair)new BasicNameValuePair("code_verifier", codeVerifier));
            parameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
            parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
            CloseableHttpResponse response = this.sendRequest(this.oauth.getAccessTokenUrl(), parameters, httpClientSupplier);
            return new OAuthClient.AccessTokenResponse(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpResponse sendRequest(String requestUrl, List<NameValuePair> parameters, Supplier<CloseableHttpClient> httpClientSupplier) throws Exception {
        CloseableHttpClient client = httpClientSupplier.get();
        try {
            HttpPost post = new HttpPost(requestUrl);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
        finally {
            this.oauth.closeClient(client);
        }
    }

    public static void assertScopes(String expectedScope, String receivedScope) {
        List<String> expectedScopes = Arrays.asList(expectedScope.split(" "));
        List<String> receivedScopes = Arrays.asList(receivedScope.split(" "));
        Assert.assertTrue((String)("Not matched. expectedScope: " + expectedScope + ", receivedScope: " + receivedScope), (expectedScopes.containsAll(receivedScopes) && receivedScopes.containsAll(expectedScopes) ? 1 : 0) != 0);
    }

    private void assertRedirectedToClientWithError(String expectedError, boolean fragmentExpected, String expectedErrorDescription) {
        this.appPage.assertCurrent();
        org.junit.Assert.assertEquals((Object)expectedError, (Object)this.getParameterFromUrl("error", fragmentExpected));
        org.junit.Assert.assertEquals((Object)expectedErrorDescription, (Object)this.getParameterFromUrl("error_description", fragmentExpected));
    }

    private String getParameterFromUrl(String paramName, boolean fragmentExpected) {
        return fragmentExpected ? (String)this.oauth.getCurrentFragment().get(paramName) : (String)this.oauth.getCurrentQuery().get(paramName);
    }

    private void logoutUserAndRevokeConsent(String clientId) {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"john");
        user.logout();
        List consents = user.getConsents();
        org.junit.Assert.assertEquals((long)1L, (long)consents.size());
        user.revokeConsent(clientId);
    }
}

