/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientRegistrationTest
extends AbstractClientRegistrationTest {
    private static final String CLIENT_ID = "test-client";
    private static final String CLIENT_SECRET = "test-client-secret";

    private ClientRepresentation buildClient() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        return client;
    }

    private ClientRepresentation registerClient() throws ClientRegistrationException {
        return this.registerClient(this.buildClient());
    }

    private ClientRepresentation registerClient(ClientRepresentation client) throws ClientRegistrationException {
        ClientRepresentation createdClient = this.reg.create(client);
        Assert.assertEquals((Object)CLIENT_ID, (Object)createdClient.getClientId());
        client = this.adminClient.realm("test").clients().get(createdClient.getId()).toRepresentation();
        Assert.assertEquals((Object)CLIENT_ID, (Object)client.getClientId());
        this.getCleanup().addClientUuid(createdClient.getId());
        return createdClient;
    }

    @Test
    public void registerClientAsAdmin() throws ClientRegistrationException {
        this.authManageClients();
        this.registerClient();
    }

    @Test
    public void withServiceAccount() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation clientRep = this.buildClient();
        clientRep.setServiceAccountsEnabled(Boolean.valueOf(true));
        ClientRepresentation rep = this.registerClient(clientRep);
        UserRepresentation serviceAccountUser = this.adminClient.realm("test").clients().get(rep.getId()).getServiceAccountUser();
        Assert.assertNotNull((Object)serviceAccountUser);
        this.deleteClient(rep);
        try {
            this.adminClient.realm("test").users().get(serviceAccountUser.getId()).toRepresentation();
            Assert.fail((String)"Expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void registerClientInMasterRealm() throws Exception {
        ClientRegistration masterReg = ClientRegistration.create().url(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth", "master").build();
        String token = this.oauth.doGrantAccessTokenRequest("master", "admin", "admin", null, "admin-cli", null).getAccessToken();
        masterReg.auth(Auth.token((String)token));
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        ClientRepresentation createdClient = masterReg.create(client);
        Assert.assertNotNull((Object)createdClient);
        this.adminClient.realm("master").clients().get(createdClient.getId()).remove();
    }

    @Test
    public void registerClientWithoutProtocol() throws ClientRegistrationException {
        this.authCreateClients();
        ClientRepresentation clientRepresentation = this.registerClient();
        Assert.assertEquals((Object)"openid-connect", (Object)clientRepresentation.getProtocol());
    }

    @Test
    public void registerClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.authCreateClients();
        this.registerClient();
    }

    @Test
    public void registerClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.authNoAccess();
        try {
            this.registerClient();
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void registerClientWithNonAsciiChars() throws ClientRegistrationException {
        this.authCreateClients();
        ClientRepresentation client = this.buildClient();
        String name = "Cli\u00ebnt";
        client.setName(name);
        ClientRepresentation createdClient = this.registerClient(client);
        Assert.assertEquals((Object)name, (Object)createdClient.getName());
    }

    @Test
    public void clientWithDefaultRoles() throws ClientRegistrationException {
        this.authCreateClients();
        ClientRepresentation client = this.buildClient();
        client.setDefaultRoles(new String[]{"test-default-role"});
        ClientRepresentation createdClient = this.registerClient(client);
        MatcherAssert.assertThat((Object)createdClient.getDefaultRoles(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"test-default-role"}));
        this.authManageClients();
        ClientRepresentation obtainedClient = this.reg.get(CLIENT_ID);
        MatcherAssert.assertThat((Object)obtainedClient.getDefaultRoles(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"test-default-role"}));
        client.setDefaultRoles(new String[]{"test-default-role1", "test-default-role2"});
        ClientRepresentation updatedClient = this.reg.update(client);
        MatcherAssert.assertThat((Object)updatedClient.getDefaultRoles(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"test-default-role1", "test-default-role2"}));
    }

    @Test
    public void testInvalidUrlClientValidation() {
        this.testClientUriValidation("Root URL is not a valid URL", "Base URL is not a valid URL", "Backchannel logout URL is not a valid URL", null, "invalid", "myapp://some-fake-app");
    }

    @Test
    public void testIllegalSchemeClientValidation() {
        this.testClientUriValidation("Root URL uses an illegal scheme", "Base URL uses an illegal scheme", "Backchannel logout URL uses an illegal scheme", "A redirect URI uses an illegal scheme", "data:text/html;base64,PHNjcmlwdD5jb25maXJtKGRvY3VtZW50LmRvbWFpbik7PC9zY3JpcHQ+", "javascript:confirm(document.domain)/*");
    }

    @Test
    public void testFragmentProhibitedClientValidation() {
        this.testClientUriValidation("Root URL must not contain an URL fragment", null, null, "Redirect URIs must not contain an URI fragment", "http://redhat.com/abcd#someFragment");
    }

    private void testClientUriValidation(String expectedRootUrlError, String expectedBaseUrlError, String expectedBackchannelLogoutUrlError, String expectedRedirectUrisError, String ... testUrls) {
        this.testClientUriValidation(true, expectedRootUrlError, expectedBaseUrlError, expectedBackchannelLogoutUrlError, expectedRedirectUrisError, testUrls);
        this.testClientUriValidation(false, expectedRootUrlError, expectedBaseUrlError, expectedBackchannelLogoutUrlError, expectedRedirectUrisError, testUrls);
    }

    private void testClientUriValidation(boolean register, String expectedRootUrlError, String expectedBaseUrlError, String expectedBackchannelLogoutUrlError, String expectedRedirectUrisError, String ... testUrls) {
        ClientRepresentation rep;
        if (register) {
            this.authCreateClients();
            rep = this.buildClient();
        } else {
            try {
                this.registerClientAsAdmin();
                rep = this.reg.get(CLIENT_ID);
            }
            catch (ClientRegistrationException e) {
                throw new RuntimeException(e);
            }
        }
        for (String testUrl : testUrls) {
            if (expectedRootUrlError != null) {
                rep.setRootUrl(testUrl);
                this.registerOrUpdateClientExpectingValidationErrors(rep, register, false, expectedRootUrlError);
            }
            rep.setRootUrl(null);
            if (expectedBaseUrlError != null) {
                rep.setBaseUrl(testUrl);
                this.registerOrUpdateClientExpectingValidationErrors(rep, register, false, expectedBaseUrlError);
            }
            rep.setBaseUrl(null);
            if (expectedBackchannelLogoutUrlError != null) {
                OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)rep).setBackchannelLogoutUrl(testUrl);
                this.registerOrUpdateClientExpectingValidationErrors(rep, register, false, expectedBackchannelLogoutUrlError);
            }
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)rep).setBackchannelLogoutUrl(null);
            if (expectedRedirectUrisError != null) {
                rep.setRedirectUris(Collections.singletonList(testUrl));
                this.registerOrUpdateClientExpectingValidationErrors(rep, register, true, expectedRedirectUrisError);
            }
            rep.setRedirectUris(null);
            if (expectedRootUrlError != null) {
                rep.setRootUrl(testUrl);
            }
            if (expectedBaseUrlError != null) {
                rep.setBaseUrl(testUrl);
            }
            if (expectedRedirectUrisError != null) {
                rep.setRedirectUris(Collections.singletonList(testUrl));
            }
            this.registerOrUpdateClientExpectingValidationErrors(rep, register, expectedRedirectUrisError != null, expectedRootUrlError, expectedBaseUrlError, expectedRedirectUrisError);
            rep.setRootUrl(null);
            rep.setBaseUrl(null);
            rep.setRedirectUris(null);
        }
    }

    private void registerOrUpdateClientExpectingValidationErrors(ClientRepresentation rep, boolean register, boolean redirectUris, String ... expectedErrors) {
        OAuth2ErrorRepresentation errorRep;
        HttpErrorException errorException = null;
        try {
            if (register) {
                this.registerClient(rep);
            } else {
                this.reg.update(rep);
            }
            Assert.fail((String)"Expected exception");
        }
        catch (ClientRegistrationException e) {
            errorException = (HttpErrorException)e.getCause();
        }
        expectedErrors = (String[])Arrays.stream(expectedErrors).filter(Objects::nonNull).toArray(String[]::new);
        Assert.assertEquals((long)errorException.getStatusLine().getStatusCode(), (long)400L);
        try {
            errorRep = (OAuth2ErrorRepresentation)JsonSerialization.readValue((String)errorException.getErrorResponse(), OAuth2ErrorRepresentation.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<String> actualErrors = Arrays.asList(errorRep.getErrorDescription().split("; "));
        MatcherAssert.assertThat(actualErrors, (Matcher)Matchers.containsInAnyOrder((Object[])expectedErrors));
        Assert.assertEquals((Object)(redirectUris ? "invalid_redirect_uri" : "invalid_client_metadata"), (Object)errorRep.getError());
    }

    @Test
    public void getClientAsAdmin() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        ClientRepresentation rep = this.reg.get(CLIENT_ID);
        Assert.assertNotNull((Object)rep);
    }

    @Test
    public void getClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        this.authCreateClients();
        try {
            this.reg.get(CLIENT_ID);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        this.authNoAccess();
        try {
            this.reg.get(CLIENT_ID);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getClientNotFound() throws ClientRegistrationException {
        this.authManageClients();
        Assert.assertNull((Object)this.reg.get("invalid"));
    }

    @Test
    public void getClientNotFoundNoAccess() throws ClientRegistrationException {
        this.authNoAccess();
        try {
            this.reg.get("invalid");
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    private void updateClient() throws ClientRegistrationException {
        ClientRepresentation client = this.reg.get(CLIENT_ID);
        client.setRedirectUris(Collections.singletonList("http://localhost:8080/app"));
        this.reg.update(client);
        ClientRepresentation updatedClient = this.reg.get(CLIENT_ID);
        Assert.assertEquals((long)1L, (long)updatedClient.getRedirectUris().size());
        Assert.assertEquals((Object)"http://localhost:8080/app", updatedClient.getRedirectUris().get(0));
    }

    @Test
    public void updateClientAsAdmin() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        this.authManageClients();
        this.updateClient();
    }

    @Test
    public void updateClientSecret() throws ClientRegistrationException {
        this.authManageClients();
        this.registerClient();
        ClientRepresentation client = this.reg.get(CLIENT_ID);
        Assert.assertNotNull((Object)client.getSecret());
        client.setSecret("mysecret");
        this.reg.update(client);
        ClientRepresentation updatedClient = this.reg.get(CLIENT_ID);
        Assert.assertEquals((Object)"mysecret", (Object)updatedClient.getSecret());
    }

    @Test
    public void addClientProtcolMappers() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation initialClient = this.buildClient();
        this.registerClient(initialClient);
        ClientRepresentation client = this.reg.get(CLIENT_ID);
        this.addProtocolMapper(client, "mapperA");
        this.reg.update(client);
        ClientRepresentation updatedClient = this.reg.get(CLIENT_ID);
        MatcherAssert.assertThat((String)"Adding protocolMapper failed", (Object)updatedClient.getProtocolMappers().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void removeClientProtcolMappers() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation initialClient = this.buildClient();
        this.addProtocolMapper(initialClient, "mapperA");
        this.registerClient(initialClient);
        ClientRepresentation client = this.reg.get(CLIENT_ID);
        client.setProtocolMappers(new ArrayList());
        this.reg.update(client);
        ClientRepresentation updatedClient = this.reg.get(CLIENT_ID);
        MatcherAssert.assertThat((String)"Removing protocolMapper failed", (Object)updatedClient.getProtocolMappers(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void updateClientProtcolMappers() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation initialClient = this.buildClient();
        this.addProtocolMapper(initialClient, "mapperA");
        this.registerClient(initialClient);
        ClientRepresentation client = this.reg.get(CLIENT_ID);
        ((ProtocolMapperRepresentation)client.getProtocolMappers().get(0)).getConfig().put("claim.name", "updatedClaimName");
        this.reg.update(client);
        ClientRepresentation updatedClient = this.reg.get(CLIENT_ID);
        MatcherAssert.assertThat((String)"Updating protocolMapper failed", (Object)((String)((ProtocolMapperRepresentation)updatedClient.getProtocolMappers().get(0)).getConfig().get("claim.name")), (Matcher)Is.is((Object)"updatedClaimName"));
    }

    private void addProtocolMapper(ClientRepresentation client, String mapperName) {
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName(mapperName);
        mapper.setProtocol("openid-connect");
        mapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        mapper.getConfig().put("userinfo.token.claim", "true");
        mapper.getConfig().put("user.attribute", "someAttribute");
        mapper.getConfig().put("id.token.claim", "true");
        mapper.getConfig().put("access.token.claim", "true");
        mapper.getConfig().put("claim.name", "someClaimName");
        mapper.getConfig().put("jsonType.label", "long");
        client.setProtocolMappers(new ArrayList());
        client.getProtocolMappers().add(mapper);
    }

    @Test
    public void updateClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.authCreateClients();
        try {
            this.updateClient();
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void updateClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.authNoAccess();
        try {
            this.updateClient();
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void updateClientNotFound() throws ClientRegistrationException {
        this.authManageClients();
        try {
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId("invalid");
            this.reg.update(client);
            Assert.fail((String)"Expected 404");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)404L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void updateClientWithNonAsciiChars() throws ClientRegistrationException {
        this.authCreateClients();
        this.registerClient();
        this.authManageClients();
        ClientRepresentation client = this.reg.get(CLIENT_ID);
        String name = "Cli\u00ebnt";
        client.setName(name);
        ClientRepresentation updatedClient = this.reg.update(client);
        Assert.assertEquals((Object)name, (Object)updatedClient.getName());
    }

    private void deleteClient(ClientRepresentation client) throws ClientRegistrationException {
        this.reg.delete(CLIENT_ID);
        try {
            this.adminClient.realm("test").clients().get(client.getId()).toRepresentation();
            Assert.fail((String)"Expected 403");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void deleteClientAsAdmin() throws ClientRegistrationException {
        this.authCreateClients();
        ClientRepresentation client = this.registerClient();
        this.authManageClients();
        this.deleteClient(client);
    }

    @Test
    public void deleteClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation client = this.registerClient();
        try {
            this.authCreateClients();
            this.deleteClient(client);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void deleteClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation client = this.registerClient();
        try {
            this.authNoAccess();
            this.deleteClient(client);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void registerClientAsAdminWithScope() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        ArrayList<String> optionalClientScopes = new ArrayList<String>(Arrays.asList("address", "phone"));
        client.setOptionalClientScopes(optionalClientScopes);
        ClientRepresentation createdClient = this.reg.create(client);
        Assert.assertEquals((Object)CLIENT_ID, (Object)createdClient.getClientId());
        client = this.adminClient.realm("test").clients().get(createdClient.getId()).toRepresentation();
        Assert.assertEquals((Object)CLIENT_ID, (Object)client.getClientId());
        this.getCleanup().addClientUuid(createdClient.getId());
        HashSet<String> requestedClientScopes = new HashSet<String>(optionalClientScopes);
        HashSet registeredClientScopes = new HashSet(client.getOptionalClientScopes());
        Assert.assertTrue((boolean)requestedClientScopes.equals(registeredClientScopes));
        Assert.assertTrue((boolean)client.getDefaultClientScopes().isEmpty());
    }

    @Test
    public void registerClientAsAdminWithoutScope() throws ClientRegistrationException {
        HashSet realmDefaultClientScopes = new HashSet(this.adminClient.realm("test").getDefaultDefaultClientScopes().stream().filter(scope -> Objects.equals(scope.getProtocol(), "openid-connect")).map(i -> i.getName()).collect(Collectors.toList()));
        HashSet realmOptionalClientScopes = new HashSet(this.adminClient.realm("test").getDefaultOptionalClientScopes().stream().filter(scope -> Objects.equals(scope.getProtocol(), "openid-connect")).map(i -> i.getName()).collect(Collectors.toList()));
        this.authManageClients();
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        ClientRepresentation createdClient = this.reg.create(client);
        Assert.assertEquals((Object)CLIENT_ID, (Object)createdClient.getClientId());
        client = this.adminClient.realm("test").clients().get(createdClient.getId()).toRepresentation();
        Assert.assertEquals((Object)CLIENT_ID, (Object)client.getClientId());
        this.getCleanup().addClientUuid(createdClient.getId());
        Assert.assertTrue((boolean)realmDefaultClientScopes.equals(new HashSet(client.getDefaultClientScopes())));
        Assert.assertTrue((boolean)realmOptionalClientScopes.equals(new HashSet(client.getOptionalClientScopes())));
    }

    @Test
    public void registerClientAsAdminWithNotDefinedScope() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        client.setOptionalClientScopes(new ArrayList<String>(Arrays.asList("notdefinedscope", "phone")));
        try {
            this.registerClient(client);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }
}

